/* Copyright (C) 2005 Red Hat, Inc. */

#include <sepol/context_record.h>
#include <sepol/iface_record.h>

typedef sepol_context_t semanage_context_t;
typedef sepol_iface_t semanage_iface_t;
typedef sepol_iface_key_t semanage_iface_key_t;

#define _SEMANAGE_CONTEXT_DEFINED_
#define _SEMANAGE_IFACE_DEFINED_
#include "iface_internal.h"

typedef sepol_iface_t record_t;
typedef sepol_iface_key_t record_key_t;
#define DBASE_RECORD_DEFINED

#include "handle.h"
#include "database.h"

/* Key */
int semanage_iface_compare(
	semanage_iface_t* iface, 
	semanage_iface_key_t* key) {

	return sepol_iface_compare(iface, key);
}
hidden_def(semanage_iface_compare)

int semanage_iface_key_create(
	semanage_handle_t* handle,
	const char* name,
	semanage_iface_key_t** key_ptr) {

	return sepol_iface_key_create(handle->sepolh, name, key_ptr);
}

int semanage_iface_key_extract(
	semanage_handle_t* handle,
	semanage_iface_t* iface,
	semanage_iface_key_t** key_ptr) {

	return sepol_iface_key_extract(handle->sepolh, iface, key_ptr);
}
hidden_def(semanage_iface_key_extract)

void semanage_iface_key_free(
	semanage_iface_key_t* key) {

	sepol_iface_key_free(key);
}
hidden_def(semanage_iface_key_free)

/* Name */
const char* semanage_iface_get_name(
	semanage_iface_t* iface) {

        return sepol_iface_get_name(iface);
}
hidden_def(semanage_iface_get_name)

int semanage_iface_set_name(
	semanage_handle_t* handle,
	semanage_iface_t* iface, 
	const char* name) {

        return sepol_iface_set_name(handle->sepolh, iface, name);
}
hidden_def(semanage_iface_set_name)
	
/* Context */
semanage_context_t* semanage_iface_get_ifcon(
	semanage_iface_t* iface) {

	return sepol_iface_get_ifcon(iface);
}
hidden_def(semanage_iface_get_ifcon)

void semanage_iface_set_ifcon(
	semanage_iface_t* iface, 
	semanage_context_t* con) {

	sepol_iface_set_ifcon(iface, con);
}
hidden_def(semanage_iface_set_ifcon)

semanage_context_t* semanage_iface_get_msgcon(
	semanage_iface_t* iface) {

	return sepol_iface_get_msgcon(iface);	
}
hidden_def(semanage_iface_get_msgcon)

void semanage_iface_set_msgcon(
	semanage_iface_t* iface,
	semanage_context_t* con) {

	sepol_iface_set_msgcon(iface, con);
}
hidden_def(semanage_iface_set_msgcon)

/* Create/Clone/Destroy */
int semanage_iface_create(
	semanage_handle_t* handle,
	semanage_iface_t** iface_ptr) {

	return sepol_iface_create(handle->sepolh, iface_ptr);
}
hidden_def(semanage_iface_create)

int semanage_iface_clone(
	semanage_handle_t* handle,
	semanage_iface_t* iface, 
	semanage_iface_t** iface_ptr) {

	return sepol_iface_clone(handle->sepolh, iface, iface_ptr);
}
hidden_def(semanage_iface_clone)

void semanage_iface_free(
	semanage_iface_t* iface) {

	sepol_iface_free(iface);
}
hidden_def(semanage_iface_free)

/* Record base functions */
record_table_t SEMANAGE_IFACE_RTABLE = {
	.create      = semanage_iface_create,
	.key_extract = semanage_iface_key_extract,
	.key_free    = semanage_iface_key_free,
	.clone       = semanage_iface_clone,
	.compare     = semanage_iface_compare,
	.free        = semanage_iface_free,
};
