#!/usr/bin/python
import sys
import getopt
import semanage

usage = "\
Choose one of the following tests:\n\
-m for modules\n\
-u for users\n\n\
-U for add user (warning this will write!)\n\n\
-s for seusers\n\n\
-S for add seuser (warning this will write!)\n\n\
Other options:\n\
-h for this help\n\
-v for verbose output\
"

class Usage(Exception):
	def __init__(self, msg):
        	self.msg = msg

class Status(Exception):
	def __init__(self, msg):
		self.msg = msg

class Tests:
	def __init__(self):
        	self.all = False
		self.users = False
		self.writeuser = False
		self.seusers = False
		self.writeseuser = False
		self.modules = False
		self.verbose = False

	def selected(self):
		return (self.all or self.users or self.modules or self.seusers or self.writeuser or self.writeseuser)

	def run(self, handle):
		if (self.users or self.all): 
			self.test_users(handle)
			print ""
		if (self.seusers or self.all): 
			self.test_seusers(handle)
			print ""
		if (self.modules or self.all): 
			self.test_modules(handle)
			print ""
		if (self.writeuser or self.all): 
			self.test_writeuser(handle)
			print ""
		if (self.writeseuser or self.all): 
			self.test_writeseuser(handle)
			print ""

	def test_modules(self,sh):
		print "Testing modules..."
		(trans_cnt, list, list_size) = semanage.semanage_module_list(sh)
		
		print "Transaction number: ", trans_cnt
		print "Module list size: ", list_size
		if self.verbose: print "List reference: ",  list

		if (list_size == 0):
			print "No modules installed!"
			print "This is not necessarily a test failure."
			return
		for idx in range(list_size):
			module = semanage.semanage_module_list_nth(list, idx)
			if self.verbose: print "Module reference: ", module 
			print "Module name: ", semanage.semanage_module_get_name(module)
			print "   Module version: ", semanage.semanage_module_get_version(module)

	def test_seusers(self,sh):
		print "Testing seusers..."
		(status, list, list_size) = semanage.semanage_seuser_list(sh)

		print "Query status (0 is good): ", status
		print "SEUser list size: ", list_size
		if self.verbose: print "List reference: ",  list

		if (list_size == 0):
			print "No seusers found!"
			print "This is not necessarily a test failure."
			return
		for idx in range(list_size):
			seuser = semanage.semanage_seuser_by_idx(list, idx)
			if self.verbose: print "seseuser reference: ", seuser 
			print "seuser name: ", semanage.semanage_seuser_get_name(seuser)
			print "   seuser mls range: ", semanage.semanage_seuser_get_mlsrange(seuser)
			print "   seuser sename: ", semanage.semanage_seuser_get_sename(seuser)
		
	def test_users(self,sh):
		print "Testing users..."
		(status, list, list_size) = semanage.semanage_user_list(sh)

		print "Query status (0 is good): ", status
		print "User list size: ", list_size
		if self.verbose: print "List reference: ",  list


		if (list_size == 0):
			print "No users found!"
			print "This is not necessarily a test failure."
			return
		for idx in range(list_size):
			user = semanage.semanage_user_by_idx(list, idx)
			if self.verbose: print "User reference: ", user 
			print "User name: ", semanage.semanage_user_get_name(user)
			print "   User mls level: ", semanage.semanage_user_get_mlslevel(user)
			print "   User mls range: ", semanage.semanage_user_get_mlsrange(user)
			print "   User number of roles: ", semanage.semanage_user_get_num_roles(user)
			print "   User roles: "
			(status, rlist, rlist_size) = semanage.semanage_user_get_roles(sh, user)
			for ridx in range (rlist_size):
				print "      ", semanage.char_by_idx(rlist, ridx) 

	def test_writeuser(self,sh):
                print "Testing user write..."
                
		(status, user) = semanage.semanage_user_create(sh)
                if self.verbose: print "User object created."

		status = semanage.semanage_user_set_name(sh,user, "testPyUser")
               	if self.verbose: print "User name set: ", semanage.semanage_user_get_name(user)
                
		status = semanage.semanage_user_add_role(sh, user, "user_r")
		
		status = semanage.semanage_user_set_mlsrange(sh, user, "s0")
                if self.verbose: print "User mlsrange: ", semanage.semanage_user_get_mlsrange(user)

		status = semanage.semanage_user_set_mlslevel(sh, user, "s0")
                if self.verbose: print "User mlslevel: ", semanage.semanage_user_get_mlslevel(user)
                
		(status,key) = semanage.semanage_user_key_extract(sh,user)
                if self.verbose: print "User key extracted : ", key
		
		print "Starting transaction..."
                status = semanage.semanage_begin_transaction(sh)
                status = semanage.semanage_user_add_local(sh,key,user)
                status = semanage.semanage_commit(sh)
                print "Commit status (transaction number): ", status

		print "Removing user..."
                status = semanage.semanage_begin_transaction(sh)
		status = semanage.semanage_user_del_local(sh, key)
                if self.verbose: print "User delete: ", status
                status = semanage.semanage_commit(sh)
                print "Commit status (transaction number): ", status
			
	def test_writeseuser(self,sh):
                print "Testing seuser write..."
                
		(status, seuser) = semanage.semanage_seuser_create(sh)
                if self.verbose: print "SEUser object created."

		status = semanage.semanage_seuser_set_name(sh,seuser, "testPySEUser")
               	if self.verbose: print "SEUser name set: ", semanage.semanage_seuser_get_name(seuser)
                
		status = semanage.semanage_seuser_set_sename(sh, seuser, "root")
                if self.verbose: print "SEUser seuser: ", semanage.semanage_seuser_get_sename(seuser)
		
		status = semanage.semanage_seuser_set_mlsrange(sh, seuser, "s0:c0.c255")
                if self.verbose: print "SEUser mlsrange: ", semanage.semanage_seuser_get_mlsrange(seuser)
                
		(status,key) = semanage.semanage_seuser_key_extract(sh,seuser)
                if self.verbose: print "SEUser key extracted : ", key
		
		print "Starting transaction..."
                status = semanage.semanage_begin_transaction(sh)
                status = semanage.semanage_seuser_add(sh,key,seuser)
                status = semanage.semanage_commit(sh)
                print "Commit status (transaction number): ", status

		print "Removing seuser..."
                status = semanage.semanage_begin_transaction(sh)
		status = semanage.semanage_seuser_del(sh, key)
                if self.verbose: print "SEUser delete: ", status
                status = semanage.semanage_commit(sh)
                print "Commit status (transaction number): ", status
			
def main(argv=None):
	if argv is None:
		argv = sys.argv
	try:
        	try:
			opts, args = getopt.getopt(argv[1:], "hvmusUSa", ["help", "verbose", "modules", "users", "seusers", "writeuser", "writeseuser", "all"])
			tests = Tests()
			for o, a in opts:
        			if o == "-v":
            				tests.verbose = True
					print "Verbose output selected."
        			if o == "-a":
            				tests.all = True
        			if o == "-u":
            				tests.users = True
        			if o == "-U":
            				tests.writeuser = True
        			if o == "-s":
            				tests.seusers = True
        			if o == "-S":
            				tests.writeseuser = True
        			if o == "-m":
            				tests.modules = True
        			if o == "-h":
					raise Usage(usage)

			if not tests.selected():
				raise Usage("Please select a valid test.")

        	except getopt.error, msg:
             		raise Usage(msg)

		sh=semanage.semanage_handle_create()
		
		if (semanage.semanage_is_managed(sh) != 1):
			raise Status("Unmanaged!")
		
		semanage.semanage_connect(sh)
		
		tests.run(sh)

	except Usage, err:
        	print >>sys.stderr, err.msg
	except Status, err:
        	print >>sys.stderr, err.msg
        return 2

if __name__ == "__main__":
	sys.exit(main())

