/* Author: Spencer Shimko <sshimko@tresys.com>
 *
 * Copyright (C) 2004-2005 Tresys Technology, LLC
 * 
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */


%module semanage
%{
	#include "semanage/boolean_record.h"
	#include "semanage/debug.h"
	#include "semanage/interfaces_policy.h" 
	#include "semanage/ports_policy.h"      
	#include "semanage/booleans_local.h"     
	#include "semanage/handle.h"             
	#include "semanage/modules.h"            
	#include "semanage/semanage.h"           
	#include "semanage/user_record.h"
	#include "semanage/booleans_policy.h"    
	#include "semanage/iface_record.h"       
	#include "semanage/port_record.h"        
	#include "semanage/seuser_record.h"      
	#include "semanage/users_local.h"
	#include "semanage/context_record.h"     
	#include "semanage/interfaces_local.h"   
	#include "semanage/ports_local.h"        
	#include "semanage/seusers.h"            
	#include "semanage/users_policy.h"
	#include "semanage/port_record.h"
	#include "semanage/ports_local.h"
	#include "semanage/ports_policy.h"
%}

%inline {
	semanage_user_t *semanage_user_by_idx(semanage_user_t **list, int n) {
		return list[n];
	}	
	semanage_seuser_t *semanage_seuser_by_idx(semanage_seuser_t **list, int n) {
		return list[n];
	}	
	semanage_port_t *semanage_port_by_idx(semanage_port_t **list, int n) {
		return list[n];
	}	
	char *char_by_idx(char **list, int n) {
		return list[n];
	}
}


/** standard typemaps **/

/* a few helpful typemaps are available in this library */
%include <typemaps.i>
/* wrap all int*'s so they can be used for results 
   if it becomes necessary to send in data this should be changed to INOUT */
%apply int *OUTPUT { int * };
%apply int *OUTPUT { size_t * };

%typemap(in, numinputs=0) char ***(char **temp) {
	$1 = &temp;
}

%typemap(argout) char*** {
	$result = t_output_helper($result, SWIG_NewPointerObj(*$1, SWIGTYPE_p_p_char, 0));
}

/** module typemaps**/

/* the wrapper will setup this parameter for passing... the resulting python functions
   will not take the semanage_module_info_t ** parameter */
%typemap(in, numinputs=0) semanage_module_info_t **(semanage_module_info_t *temp) {
	$1 = &temp;
}

%typemap(argout) semanage_module_info_t ** {
	$result = t_output_helper($result, SWIG_NewPointerObj(*$1, SWIGTYPE_p_semanage_module_info, 0));
}

/** seuser typemaps **/

/* the wrapper will setup this parameter for passing... the resulting python functions
   will not take the semanage_seuser_t *** parameter */
%typemap(in, numinputs=0) semanage_seuser_t ***(semanage_seuser_t **temp) {
	$1 = &temp;
}

%typemap(argout) semanage_seuser_t *** {
	$result = t_output_helper($result, SWIG_NewPointerObj(*$1, SWIGTYPE_p_p_semanage_seuser, 0));
}

%typemap(in, numinputs=0) semanage_seuser_t **(semanage_seuser_t *temp) {
	$1 = &temp;
}

%typemap(argout) semanage_seuser_t ** {
	$result = t_output_helper($result, SWIG_NewPointerObj(*$1, SWIGTYPE_p_semanage_seuser, 0));
}

%typemap(argout) semanage_seuser_key_t ** {
	$result = t_output_helper($result, SWIG_NewPointerObj(*$1, SWIGTYPE_p_semanage_seuser_key, 0));
}

%typemap(in, numinputs=0) semanage_seuser_key_t **(semanage_seuser_key_t *temp) {
	$1 = &temp;
}

/** user typemaps **/

/* the wrapper will setup this parameter for passing... the resulting python functions
   will not take the semanage_user_t *** parameter */
%typemap(in, numinputs=0) semanage_user_t ***(semanage_user_t **temp) {
	$1 = &temp;
}

%typemap(argout) semanage_user_t *** {
	$result = t_output_helper($result, SWIG_NewPointerObj(*$1, SWIGTYPE_p_p_semanage_user, 0));
}

%typemap(in, numinputs=0) semanage_user_t **(semanage_user_t *temp) {
	$1 = &temp;
}

%typemap(argout) semanage_user_t ** {
	$result = t_output_helper($result, SWIG_NewPointerObj(*$1, SWIGTYPE_p_semanage_user, 0));
}

%typemap(argout) semanage_user_key_t ** {
	$result = t_output_helper($result, SWIG_NewPointerObj(*$1, SWIGTYPE_p_semanage_user_key, 0));
}

%typemap(in, numinputs=0) semanage_user_key_t **(semanage_user_key_t *temp) {
	$1 = &temp;
}

/** port typemaps **/

/* the wrapper will setup this parameter for passing... the resulting python functions
   will not take the semanage_port_t *** parameter */
/*
%typemap(in, numinputs=0) semanage_port_t ***(semanage_port_t **temp) {
	$1 = &temp;
}

%typemap(argout) semanage_port_t *** {
	$result = t_output_helper($result, SWIG_NewPointerObj(*$1, SWIGTYPE_p_p_semanage_port, 0));
}

%typemap(in, numinputs=0) semanage_port_t **(semanage_port_t *temp) {
	$1 = &temp;
}

%typemap(argout) semanage_port_t ** {
	$result = t_output_helper($result, SWIG_NewPointerObj(*$1, SWIGTYPE_p_semanage_port, 0));
}

%typemap(argout) semanage_port_key_t ** {
	$result = t_output_helper($result, SWIG_NewPointerObj(*$1, SWIGTYPE_p_semanage_port_key, 0));
}

%typemap(in, numinputs=0) semanage_port_key_t **(semanage_port_key_t *temp) {
	$1 = &temp;
}
*/

/* pull in the headers */
%include "../include/semanage/boolean_record.h"
%include "../include/semanage/debug.h"
%include "../include/semanage/interfaces_policy.h" 
%include "../include/semanage/booleans_local.h"     
%include "../include/semanage/handle.h"             
%include "../include/semanage/modules.h"            
%include "../include/semanage/semanage.h"           
%include "../include/semanage/user_record.h"
%include "../include/semanage/booleans_policy.h"    
%include "../include/semanage/iface_record.h"       
%include "../include/semanage/seuser_record.h"      
%include "../include/semanage/users_local.h"
%include "../include/semanage/context_record.h"     
%include "../include/semanage/interfaces_local.h"   
%include "../include/semanage/seusers.h"            
%include "../include/semanage/users_policy.h"
/*
%include "../include/semanage/port_record.h"
%include "../include/semanage/ports_local.h"
%include "../include/semanage/ports_policy.h"
*/
