/* Copyright (C) 2005 Red Hat, Inc. */

#include <sepol/user_record.h>

typedef sepol_user_t semanage_user_t;
typedef sepol_user_key_t semanage_user_key_t;

#define _SEMANAGE_USER_DEFINED_
#include "user_internal.h"

typedef semanage_user_t record_t;
typedef semanage_user_key_t record_key_t;
#define DBASE_RECORD_DEFINED

#include <stdlib.h>
#include <stddef.h>
#include "handle.h"
#include "database.h"
#include "debug.h"

/* Key */
int semanage_user_key_create(
	semanage_handle_t* handle,
	const char* name, 
	semanage_user_key_t** key) {

	return sepol_user_key_create(handle->sepolh, name, key);
}
hidden_def(semanage_user_key_create)

int semanage_user_key_extract(
	semanage_handle_t* handle,
	semanage_user_t* user, 
	semanage_user_key_t** key) {

	return sepol_user_key_extract(handle->sepolh, user, key);
}
hidden_def(semanage_user_key_extract)

void semanage_user_key_free(
	semanage_user_key_t* key) {

	sepol_user_key_free(key);
}
hidden_def(semanage_user_key_free)

int semanage_user_compare(
	semanage_user_t* user, 
	semanage_user_key_t* key) {

	return sepol_user_compare(user, key);
}
hidden_def(semanage_user_compare)
	
/* Name */
const char* semanage_user_get_name(
	semanage_user_t* user) {

	return sepol_user_get_name(user);
}
hidden_def(semanage_user_get_name)

int semanage_user_set_name(
	semanage_handle_t* handle,
	semanage_user_t* user, 
	const char* name) {

	return sepol_user_set_name(handle->sepolh, user, name);
}
hidden_def(semanage_user_set_name)

/* MLS */
const char* semanage_user_get_mlslevel(
	semanage_user_t* user) {

	return sepol_user_get_mlslevel(user);
}
hidden_def(semanage_user_get_mlslevel)

int semanage_user_set_mlslevel(
	semanage_handle_t* handle,
	semanage_user_t* user, 
	const char* mls_level) {

	return sepol_user_set_mlslevel(handle->sepolh, user, mls_level);
}
hidden_def(semanage_user_set_mlslevel)

const char* semanage_user_get_mlsrange(
	semanage_user_t* user) {

	return sepol_user_get_mlsrange(user);
}
hidden_def(semanage_user_get_mlsrange)

int semanage_user_set_mlsrange(
	semanage_handle_t* handle,
	semanage_user_t* user, 
	const char* mls_range) {

	return sepol_user_set_mlsrange(handle->sepolh, user, mls_range);
}
hidden_def(semanage_user_set_mlsrange)

/* Role management */
int semanage_user_get_num_roles(
	semanage_user_t* user) {

	return sepol_user_get_num_roles(user);
}

int semanage_user_add_role(
	semanage_handle_t* handle,
	semanage_user_t* user, 
	const char* role) {

	return sepol_user_add_role(handle->sepolh, user, role);
}
hidden_def(semanage_user_add_role)

void semanage_user_del_role(
	semanage_user_t* user, 
	const char* role) {

	sepol_user_del_role(user, role);
}

int semanage_user_has_role(
	semanage_user_t* user, 
	const char* role) {

	return sepol_user_has_role(user, role);
}

int semanage_user_get_roles(
	semanage_handle_t* handle,
	semanage_user_t* user,
	const char*** roles_arr, 
	size_t* num_roles) {

	return sepol_user_get_roles(handle->sepolh, user, roles_arr, num_roles);
}
hidden_def(semanage_user_get_roles)

int semanage_user_set_roles(
	semanage_handle_t* handle,
	semanage_user_t* user,
	const char** roles_arr,
	size_t num_roles) {

	return sepol_user_set_roles(handle->sepolh, user, roles_arr, num_roles);
}

/* Create/Clone/Destroy */
int semanage_user_create(
	semanage_handle_t* handle,
	semanage_user_t** user_ptr) {

	return sepol_user_create(handle->sepolh, user_ptr);
}
hidden_def(semanage_user_create)

int semanage_user_clone(
	semanage_handle_t* handle,
	semanage_user_t* user, 
	semanage_user_t** user_ptr) {

	return sepol_user_clone(handle->sepolh, user, user_ptr);
}
hidden_def(semanage_user_clone)

void semanage_user_free(
	semanage_user_t* user) {

	sepol_user_free(user);
}
hidden_def(semanage_user_free)

/* Record base functions */
record_table_t SEMANAGE_USER_RTABLE = {
	.create      = semanage_user_create,
	.key_extract = semanage_user_key_extract,
	.key_free    = semanage_user_key_free,
	.clone       = semanage_user_clone,
	.compare     = semanage_user_compare,
	.free        = semanage_user_free,
};
