#include <gtkmm/image.h>
#include <gtkmm/label.h>
#include <gtkmm/main.h>
#include <gtkmm/stock.h>
#include <gtkmm/table.h>
#include <gtkmm/window.h>
#include <libsexymm/icon-entry.h>

class AppWindow
	: public Gtk::Window
{
public:
	AppWindow(void);

private:
	Sexy::IconEntry mOpenFileEntry;
	Sexy::IconEntry mSaveFileEntry;
	Sexy::IconEntry mSearchEntry;
	Sexy::IconEntry mPasswordEntry;
};

AppWindow::AppWindow(void)
{
	set_title("Sexy Icon Entry Test");
	show();
	set_border_width(12);

	Gtk::Table *table = Gtk::manage(new Gtk::Table());
	table->show();
	add(*table);
	table->set_row_spacings(6);
	table->set_col_spacings(6);

	/*
	 * Open File
	 */
	Gtk::Label *label = Gtk::manage(new Gtk::Label("Open File:"));
	label->show();
	table->attach(*label, 0, 1, 0, 1, Gtk::FILL, Gtk::FILL, 0, 0);
	label->set_alignment(0, 0.5);

	mOpenFileEntry.show();
	table->attach(mOpenFileEntry, 1, 2, 0, 1,
				  Gtk::FILL | Gtk::EXPAND, Gtk::FILL, 0, 0);

	Gtk::Image *icon = Gtk::manage(new Gtk::Image(Gtk::Stock::OPEN,
												  Gtk::ICON_SIZE_MENU));
	icon->show();
	mOpenFileEntry.set_icon(Sexy::ICON_ENTRY_PRIMARY, icon);
	mOpenFileEntry.set_icon_highlight(Sexy::ICON_ENTRY_PRIMARY, true);

	/*
	 * Save File
	 */
	label = Gtk::manage(new Gtk::Label("Save File:"));
	label->show();
	table->attach(*label, 0, 1, 1, 2, Gtk::FILL, Gtk::FILL, 0, 0);
	label->set_alignment(0, 0.5);

	mSaveFileEntry.show();
	table->attach(mSaveFileEntry, 1, 2, 1, 2,
				  Gtk::FILL | Gtk::EXPAND, Gtk::FILL, 0, 0);
	mSaveFileEntry.set_direction(Gtk::TEXT_DIR_RTL);
	mSaveFileEntry.set_text("‏Right-to-left");

	icon = Gtk::manage(new Gtk::Image(Gtk::Stock::SAVE, Gtk::ICON_SIZE_MENU));
	icon->show();
	mSaveFileEntry.set_icon(Sexy::ICON_ENTRY_PRIMARY, icon);
	mSaveFileEntry.set_icon_highlight(Sexy::ICON_ENTRY_PRIMARY, true);

	/*
	 * Search
	 */
	label = Gtk::manage(new Gtk::Label("Search:"));
	label->show();
	table->attach(*label, 0, 1, 2, 3, Gtk::FILL, Gtk::FILL, 0, 0);
	label->set_alignment(0, 0.5);

	mSearchEntry.show();
	table->attach(mSearchEntry, 1, 2, 2, 3,
				  Gtk::FILL | Gtk::EXPAND, Gtk::FILL, 0, 0);
	mSearchEntry.add_clear_button();

	icon = Gtk::manage(new Gtk::Image(Gtk::Stock::FIND, Gtk::ICON_SIZE_MENU));
	icon->show();
	mSearchEntry.set_icon(Sexy::ICON_ENTRY_PRIMARY, icon);

	/*
	 * Password
	 */
	label = Gtk::manage(new Gtk::Label("Password:"));
	label->show();
	table->attach(*label, 0, 1, 3, 4, Gtk::FILL, Gtk::FILL, 0, 0);
	label->set_alignment(0, 0.5);

	mPasswordEntry.show();
	table->attach(mPasswordEntry, 1, 2, 3, 4,
				  Gtk::FILL | Gtk::EXPAND, Gtk::FILL, 0, 0);
	mPasswordEntry.set_visibility(false);

	icon = Gtk::manage(new Gtk::Image(Gtk::Stock::DIALOG_AUTHENTICATION,
									  Gtk::ICON_SIZE_MENU));
	icon->show();
	mPasswordEntry.set_icon(Sexy::ICON_ENTRY_PRIMARY, icon);
}

int
main(int argc, char **argv)
{
	Gtk::Main kit(&argc, &argv);
	AppWindow app;
	Gtk::Main::run(app);

	return 0;
}
