////////////////////////////////////////////////////////////
//
// SFML - Simple and Fast Multimedia Library
// Copyright (C) 2007 Laurent Gomila (laurent.gom@gmail.com)
//
// This software is provided 'as-is', without any express or implied warranty.
// In no event will the authors be held liable for any damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it freely,
// subject to the following restrictions:
//
// 1. The origin of this software must not be misrepresented;
//    you must not claim that you wrote the original software.
//    If you use this software in a product, an acknowledgment
//    in the product documentation would be appreciated but is not required.
//
// 2. Altered source versions must be plainly marked as such,
//    and must not be misrepresented as being the original software.
//
// 3. This notice may not be removed or altered from any source distribution.
//
////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////
// Headers
////////////////////////////////////////////////////////////
#include <SFML/Graphics/GraphicsDevice.hpp>
#include <SFML/Graphics/VideoResource.hpp>
#include <algorithm>


namespace sf
{
namespace priv
{
////////////////////////////////////////////////////////////
/// Default constructor
////////////////////////////////////////////////////////////
GraphicsDevice::GraphicsDevice()
{
    // Nothing to do
}


////////////////////////////////////////////////////////////
/// Destructor
////////////////////////////////////////////////////////////
GraphicsDevice::~GraphicsDevice()
{
    // Notify resources
    std::for_each(myResources.begin(), myResources.end(), std::mem_fun(&VideoResource::DestroyVideoResources));
}


////////////////////////////////////////////////////////////
/// Get the unique instance of the class
////////////////////////////////////////////////////////////
GraphicsDevice& GraphicsDevice::GetInstance()
{
    static GraphicsDevice Instance;

    return Instance;
}


////////////////////////////////////////////////////////////
/// Add a video resource
////////////////////////////////////////////////////////////
void GraphicsDevice::AddVideoResource(VideoResource* Resource)
{
    if (Resource)
        myResources.insert(Resource);
}


////////////////////////////////////////////////////////////
/// Remove a video resource
////////////////////////////////////////////////////////////
void GraphicsDevice::RemoveVideoResource(VideoResource* Resource)
{
    if (Resource)
        myResources.erase(Resource);
}

} // namespace priv

} // namespace sf
