/*  
  Copyright 2002, Andreas Rottmann
*/
#include <signal.h>

#include <iostream>

#include <sigc++/object_slot.h>
#include <sigc++/bind.h>
#include <sigcx/dispatch.h>

using namespace std;
using namespace SigC;
using namespace SigCX;

void print_signal(int signum)
{
      cout << "received signal: " << signum << endl;
};

int main()
{
  StandardDispatcher disp;
  
  disp.add_signal_handler(bind(slot(&print_signal), SIGINT), SIGINT);
  disp.add_signal_handler(bind(slot(&print_signal), SIGTERM), SIGTERM);
  disp.add_signal_handler(slot(disp, &Dispatcher::exit), SIGTERM);
  
  disp.run();

  return 0;
}

