/*
 * libSpiff - XSPF playlist handling library
 *
 * Copyright (C) 2007, Sebastian Pipping / Xiph.Org Foundation
 * All rights reserved.
 *
 * Redistribution  and use in source and binary forms, with or without
 * modification,  are permitted provided that the following conditions
 * are met:
 *
 *     * Redistributions   of  source  code  must  retain  the   above
 *       copyright  notice, this list of conditions and the  following
 *       disclaimer.
 *
 *     * Redistributions  in  binary  form must  reproduce  the  above
 *       copyright  notice, this list of conditions and the  following
 *       disclaimer   in  the  documentation  and/or  other  materials
 *       provided with the distribution.
 *
 *     * Neither  the name of the Xiph.Org Foundation nor the names of
 *       its  contributors may be used to endorse or promote  products
 *       derived  from  this software without specific  prior  written
 *       permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT  NOT
 * LIMITED  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS
 * FOR  A  PARTICULAR  PURPOSE ARE DISCLAIMED. IN NO EVENT  SHALL  THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL,    SPECIAL,   EXEMPLARY,   OR   CONSEQUENTIAL   DAMAGES
 * (INCLUDING,  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES;  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT  LIABILITY,  OR  TORT (INCLUDING  NEGLIGENCE  OR  OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Sebastian Pipping, sping@xiph.org
 */

/**
 * @file SpiffStack.h
 * Interface of SpiffStack.
 */

#ifndef SPIFF_STACK_H
#define SPIFF_STACK_H



#include "SpiffDefines.h"

namespace Spiff {



class SpiffStackPrivate;



/**
 * A simple stack of non-negative integers.
 */
class SpiffStack {

private:
	/// @cond DOXYGEN_NON_API
	SpiffStackPrivate * const d; ///< D pointer
	/// @endcond

public:
	/**
	 * Creates a new stack.
	 */
	SpiffStack();

	/**
	 * Copy constructor.
	 *
	 * @param source  Source to copy from
	 */
	SpiffStack(const SpiffStack & source);

	/**
	 * Assignment operator.
	 *
	 * @param source  Source to copy from
	 */
	SpiffStack & operator=(const SpiffStack & source);

	/**
	 * Destroys this stack.
	 */
	~SpiffStack();

	/**
	 * Pushes <c>tag</c> onto the stack.
	 */
	void push(unsigned int tag);

	/**
	 * Returns the topmost element on
	 * the stack.
	 *
	 * @return Topmost element
	 */
	unsigned int top() const;

	/**
	 * Deletes the topmost element.
	 */
	void pop();

	/**
	 * Returns the number of elements on the stack.
	 *
	 * @return Size of the stack
	 */
	int getSize() const;

	/**
	 * Clears the stack.
	 */
	void clear();

};



}

#endif // SPIFF_STACK_H
