/*
 * libSpiff - XSPF playlist handling library
 *
 * Copyright (C) 2007, Sebastian Pipping / Xiph.Org Foundation
 * All rights reserved.
 *
 * Redistribution  and use in source and binary forms, with or without
 * modification,  are permitted provided that the following conditions
 * are met:
 *
 *     * Redistributions   of  source  code  must  retain  the   above
 *       copyright  notice, this list of conditions and the  following
 *       disclaimer.
 *
 *     * Redistributions  in  binary  form must  reproduce  the  above
 *       copyright  notice, this list of conditions and the  following
 *       disclaimer   in  the  documentation  and/or  other  materials
 *       provided with the distribution.
 *
 *     * Neither  the name of the Xiph.Org Foundation nor the names of
 *       its  contributors may be used to endorse or promote  products
 *       derived  from  this software without specific  prior  written
 *       permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT  NOT
 * LIMITED  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS
 * FOR  A  PARTICULAR  PURPOSE ARE DISCLAIMED. IN NO EVENT  SHALL  THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL,    SPECIAL,   EXEMPLARY,   OR   CONSEQUENTIAL   DAMAGES
 * (INCLUDING,  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES;  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT  LIABILITY,  OR  TORT (INCLUDING  NEGLIGENCE  OR  OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Sebastian Pipping, sping@xiph.org
 */

/**
 * @file SpiffExtensionWriter.cpp
 * Implementation of SpiffExtensionWriter.
 */

#include <spiff/SpiffExtensionWriter.h>
#include <spiff/SpiffExtension.h>
#include <spiff/SpiffXmlFormatter.h>

namespace Spiff {



/// @cond DOXYGEN_NON_API

/**
 * D object for SpiffExtensionWriter.
 */
class SpiffExtensionWriterPrivate {

	friend class SpiffExtensionWriter;

	/**
	 * Creates a new D object.
	 */
	SpiffExtensionWriterPrivate() {

	}

	/**
	 * Destroys this D object.
	 */
	~SpiffExtensionWriterPrivate() {

	}

};

/// @endcond



SpiffExtensionWriter::SpiffExtensionWriter(
		const SpiffExtension * extension, SpiffXmlFormatter * output)
		: d(new SpiffExtensionWriterPrivate()),
		extension(extension), output(output) {

}



SpiffExtensionWriter::SpiffExtensionWriter(
		const SpiffExtensionWriter & source)
		: d(new SpiffExtensionWriterPrivate(*(source.d))),
		extension(source.extension), output(source.output) {

}



SpiffExtensionWriter & SpiffExtensionWriter::operator=(const SpiffExtensionWriter & source) {
	if (this != &source) {
		*(this->d) = *(source.d);
		this->extension = source.extension;
		this->output = source.output;
	}
	return *this;
}



SpiffExtensionWriter::~SpiffExtensionWriter() {
	delete this->d;
}



void SpiffExtensionWriter::writeExtensionStart(const XML_Char ** nsRegs) {
	// Open <extension>, register namespaces
	const XML_Char * atts[3] = {_PT("application"),
			this->extension->getApplicationUri(), NULL};
	this->output->writeHomeStart(_PT("extension"), atts, nsRegs);
}



void SpiffExtensionWriter::writeExtensionStop() {
	// Close <extension>
	this->output->writeHomeEnd(_PT("extension"));
}



const XML_Char ** SpiffExtensionWriter::getNamespaceRegs() {
	// Note "static"!
	static const XML_Char * nsRegs[1] = { NULL };
	return nsRegs;
}



void SpiffExtensionWriter::write() {
	writeExtensionStart(getNamespaceRegs());
	writeExtensionBody();
	writeExtensionStop();
}



}
