/*
 * $Id: CalendarCellContext.java,v 1.3 2008/10/14 22:31:44 rah003 Exp $
 *
 * Copyright 2007 Sun Microsystems, Inc., 4150 Network Circle,
 * Santa Clara, California 95054, U.S.A. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.Border;

import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.border.IconBorder;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.renderer.CellContext;

/**
 * CellContext internally used by BasisMonthViewUI rendering.
 * 
 * @author Jeanette Winzenburg
 */
class CalendarCellContext extends CellContext<JXMonthView> {

    private CalendarState dayState;

    public void installMonthContext(JXMonthView component, Object value, 
            boolean selected, boolean focused,
             CalendarState dayState) {
        super.installContext(component, value, -1, -1, selected, focused,
                true, true);
        this.dayState = dayState;
    }

    public CalendarState getCalendarState() {
        return dayState;
    }
    
    @Override
    protected Color getForeground() {
        if (CalendarState.LEADING == dayState) {
            return UIManagerExt.getColor(getUIPrefix() + "leadingDayForeground");
        }
        if (CalendarState.TRAILING == dayState) {
            return UIManagerExt.getColor(getUIPrefix() + "trailingDayForeground");
        }
        if ((CalendarState.TITLE == dayState) && (getComponent() != null)) {
            return getComponent().getMonthStringForeground();
        }
        return super.getForeground();
    }

    

    @Override
    protected Color getBackground() {
        if ((CalendarState.TITLE == dayState) && (getComponent() != null)) {
            return getComponent().getMonthStringBackground();
        }
        return super.getBackground();
    }

    @Override
    protected Color getSelectionBackground() {
        if (CalendarState.LEADING == dayState || CalendarState.TRAILING == dayState) return getBackground();
        return getComponent() != null ? getComponent().getSelectionBackground() : null;
    }

    @Override
    protected Color getSelectionForeground() {
        if (CalendarState.LEADING == dayState || CalendarState.TRAILING == dayState) return getForeground();
        return getComponent() != null ? getComponent().getSelectionForeground() : null;
    }

    
    
    @Override
    protected Border getBorder() {
        if (getComponent() == null) {
            return super.getBorder();
        }
        if (CalendarState.TITLE == dayState) {
            return getTitleBorder();
        }
        if (isToday()) {
            int x = getComponent().getBoxPaddingX();
            int y = getComponent().getBoxPaddingY();
           Border todayBorder = BorderFactory.createLineBorder(getComponent().getTodayBackground());
           Border empty = BorderFactory.createEmptyBorder(y - 1, x - 1, y - 1, x -1);
           return BorderFactory.createCompoundBorder(todayBorder, empty);
        }
        return BorderFactory.createEmptyBorder(getComponent().getBoxPaddingY(), getComponent().getBoxPaddingX(), getComponent().getBoxPaddingY(), getComponent().getBoxPaddingX());
    }

    /**
     * @return
     */
    private Border getTitleBorder() {
        if (getComponent().isTraversable()) {
            Icon downIcon = UIManager.getIcon("JXMonthView.monthDownFileName");
            Icon upIcon = UIManager.getIcon("JXMonthView.monthUpFileName");

            IconBorder up = new IconBorder(upIcon, SwingConstants.EAST, getComponent().getBoxPaddingX());
            IconBorder down = new IconBorder(downIcon, SwingConstants.WEST, getComponent().getBoxPaddingX());
            Border compound = BorderFactory.createCompoundBorder(up, down);
            Border empty = BorderFactory.createEmptyBorder(2* getComponent().getBoxPaddingY(), 0, 2*getComponent().getBoxPaddingY(), 0);
            return BorderFactory.createCompoundBorder(compound, empty);
        }
        
        return BorderFactory.createEmptyBorder(getComponent().getBoxPaddingY(), getComponent().getBoxPaddingX(), getComponent().getBoxPaddingY(), getComponent().getBoxPaddingX());
    }

    /**
     * @return
     */
    protected boolean isToday() {
        return CalendarState.TODAY == dayState;
    }

    @Override
    protected String getUIPrefix() {
        return "JXMonthView.";
    }

    
}
