/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */
 
#ifndef _SML_XML_ASSM_INTERNALS_H_
#define _SML_XML_ASSM_INTERNALS_H_

#include <libxml/xmlwriter.h>

#define XML_NODE_START 1
#define XML_NODE_TEXT 3
#define XML_NODE_CLOSE 15
#define XML_NODE_CDATA 4

typedef enum {
	SML_ASSEMBLER_NODE_OPEN,
	SML_ASSEMBLER_NODE_CLOSE
} SmlXmlAssemblerNodeType;

typedef struct SmlXmlAssemblerCommand {
	/** The type of the command. Used the make the opening and closing tags */
	SmlCommandType cmdType;
	/** The buffer that holds the assembled data of this command */
	xmlBuffer *buffer;
	/** The type of the node. Either a opening or a closing node */
	SmlXmlAssemblerNodeType nodeType;
	/** The command id. Needed if you want to add children */
	unsigned int cmdID;
	GList *children;
} SmlXmlAssemblerCommand;

typedef struct SmlXmlAssemblerStatus {
	/** The type of the command. Used the make the opening and closing tags */
	unsigned int cmdRef;
	
	unsigned int msgRef;
	/** The buffer that holds the assembled data of this status */
	xmlBuffer *buffer;
	/** The command id.*/
	unsigned int cmdID;
} SmlXmlAssemblerStatus;

struct SmlXmlAssembler {
	xmlTextWriter *writer;
	xmlBuffer *header_buffer;
	GList *statuses;
	GList *commands;
	GList *parent_commands;
	GList *parent_buffers;
	SmlSession *session;
	SmlAssembler *assembler;
	GMutex *mutex;
	
	unsigned int reserved_statuses;
	unsigned int added_statuses;
	
	SmlBool moreDataSet;
};

SmlBool smlAssemblerStartNode(SmlAssembler *assm, const char *name, SmlError **error);
SmlBool smlAssemblerStartNodeNS(SmlAssembler *assm, const char *prefix, const char *name, const char *uri, SmlError **error);
SmlBool smlAssemblerEndNode(SmlAssembler *assm, SmlError **error);
SmlBool smlAssemblerAddString(SmlAssembler *assm, const char *name, const char *value, SmlError **error);
SmlBool smlAssemblerAddStringNS(SmlAssembler *assm, const char *prefix, const char *name, const char *uri, const char *value, SmlError **error);
SmlBool smlAssemblerAddID(SmlAssembler *assm, const char *name, unsigned int id, SmlError **error);
SmlBool smlAssemblerAddData(SmlAssembler *assm, const char *name, const char *value, SmlError **error);

#endif //_SML_XML_ASSM_INTERNALS_H_
