/*
 * Represent a list of tag substitutions to apply as a TagcollFilter
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma implementation

#include "Changes.h"

using namespace std;

void ChangeList::consume(const string& item, const OpSet<string>& tags) throw ()
{
	for (set<string>::const_iterator i = tags.begin();
			i != tags.end(); i++)
		changes.insert(make_pair(*i, item));
}

// Change a single tag
string ChangeList::change(const string& tag) const throw ()
{
	changes_t::const_iterator i = changes.find(tag);

	return (i == changes.end()) ? tag : i->second;
}

// Change all the tags in a tag set
OpSet<string> ChangeList::change(const OpSet<string>& tags) const throw ()
{
	OpSet<string> res;
	for (OpSet<string>::const_iterator t = tags.begin();
			t != tags.end(); t++)
		res.insert(change(*t));
	return res;
}

// vim:set ts=4 sw=4:
