/*
 * Chain more TagcollFilters together
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma implementation

#include "FilterChain.h"

using namespace std;

template class FilterChain<string>;
template class FilterChain<int>;

namespace Debtags { class Package; }
template class FilterChain<Debtags::Package*>;


// Set the consumer at the end of the chain
template<class T>
void FilterChain<T>::setConsumer(TagcollConsumer<T>* c) throw ()
{
	if (last)
		last->setConsumer(c);
	else
		consumer = c;
}

// Add a filter at the end of the chain
template<class T>
void FilterChain<T>::appendFilter(TagcollFilter<T>* f) throw ()
{
	if (last)
	{
		f->setConsumer(last->getConsumer());
		last->setConsumer(f);
		last = f;
	} else {
		f->setConsumer(consumer);
		consumer = last = f;
	}
}

// Delete the filters in the chain (but not the consumer at the end)
// This is a convenience method, since the FilterChain destructor does not
// delete the filters in the chain
template<class T>
void FilterChain<T>::deleteFilters() throw ()
{
	if (!last)
		return;

	// If there is a last, then `consumer' is the first filter in the chain
	TagcollFilter<T>* cursor = (TagcollFilter<T>*)consumer;
	while (cursor != last)
	{
		TagcollConsumer<T>* next = cursor->getConsumer();
		delete cursor;
		cursor = (TagcollFilter<T>*)next;
	}
}

template<class T>
void FilterChain<T>::consume(const T& item) throw ()
{
	consumer->consume(item);
}
template<class T>
void FilterChain<T>::consume(const T& item, const OpSet<string>& tags) throw ()
{
	consumer->consume(item, tags);
}

// vim:set ts=4 sw=4:
