#ifndef ITEM_GROUPER_H
#define ITEM_GROUPER_H

/*
 * Group items having the same tagset
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma interface

#include <TagcollConsumer.h>
#include <OpSet.h>

#include <map>
#include <string>

template<class T>
class ItemGrouper : public TagcollConsumer<T>
{
protected:
	// tagset -> item group
	std::map<OpSet<std::string>, OpSet<T> > groups;
	
public:
	virtual ~ItemGrouper() throw () {}

	virtual void consume(const T& item) throw ()
	{
		groups[OpSet<std::string>()] += item;
	}

	virtual void consume(const T& item, const OpSet<std::string>& tags) throw ()
	{
		groups[tags] += item;
	}

	virtual void consume(const OpSet<T>& items) throw ()
	{
		groups[OpSet<std::string>()] += items;
	}

	virtual void consume(const OpSet<T>& items, const OpSet<std::string>& tags) throw ()
	{
		groups[tags] += items;
	}

	// Send the reversed data to a consumer
	void output(TagcollConsumer<T>& consumer) throw ();
};

// vim:set ts=4 sw=4:
#endif
