#ifndef PATCHES_H
#define PATCHES_H

/*
 * Classes handling tag patches
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma interface

#include "TagcollConsumer.h"
#include "TagcollFilter.h"
#include "InputMerger.h"

#include <map>
#include <string>

// List of explicit implications that can be used to expand a tagged collection
// while it's being parsed
class PatchList : public TagcollConsumer<std::string>
{
protected:
	typedef std::map< std::string, OpSet<std::string> > patch_t;
	patch_t patches;

	void addAllEquals(const std::string& item, char prefix, const OpSet<std::string>& tags) throw ();

public:
	virtual ~PatchList() throw () {}

	void generate(const InputMerger<std::string>& im1, const InputMerger<std::string>& im2) throw ();

	virtual void consume(const std::string& item) throw () {}
	virtual void consume(const std::string& item, const OpSet<std::string>& tags) throw ();
	
	// Patch a tagged item: return the new set of tags
	OpSet<std::string> patch(std::string item, const OpSet<std::string>& tagset) const throw ();

	// Output the patch list to a TagcollConsumer
	void output(TagcollConsumer<std::string>& consumer) const throw ();
};

class ApplyPatches : public TagcollFilter<std::string>
{
protected:
	PatchList& patches;
	
public:
	ApplyPatches(PatchList& patches) throw ()
		: patches(patches) {}

	virtual void consume(const std::string& item) throw ();
	virtual void consume(const std::string& item, const OpSet<std::string>& tags) throw ();
};

// vim:set ts=4 sw=4:
#endif
