#ifndef TAGEXPR_PARSER_H
#define TAGEXPR_PARSER_H

/*
 * Parser for tag expressions
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include "Tagexpr.h"
#include <string>

class TagexprParser
{
protected:
	static TagexprParser* _instance;

	Tagexpr* result;
	std::string errorMessage;
	
public:
	// For use by the bison+yacc code
	void setResult(Tagexpr* result) throw () { this->result = result; }
	void addError(const std::string& message) throw () { errorMessage += message; }

	// For use by the wide public
	Tagexpr* parse(const std::string& buffer) throw ();

	// Get the error message for a failed parse
	const std::string& getErrorMessage() const throw () { return errorMessage; }
	std::string getErrorMessage() throw () { return errorMessage; }

	static TagexprParser* instance() throw ();
};

// vim:set ts=4 sw=4:
#endif
