/*
 * Chain more TagcollFilters together
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma implementation

#include <tagcoll/FilterChain.h>

using namespace std;
using namespace Tagcoll;

//template class FilterChain<string>;
//template class FilterChain<int>;
//
//namespace Debtags { class Package; }
//template class FilterChain<Debtags::Package*>;


// Set the consumer at the end of the chain
template<class ITEM, class TAG>
void FilterChain<ITEM, TAG>::setConsumer(TagcollConsumer<ITEM, TAG>* c) throw ()
{
	if (last)
		last->setConsumer(c);
	else
		consumer = c;
}

// Add a filter at the end of the chain
template<class ITEM, class TAG>
void FilterChain<ITEM, TAG>::appendFilter(TagcollFilter<ITEM, TAG>* f) throw ()
{
	if (last)
	{
		f->setConsumer(last->getConsumer());
		last->setConsumer(f);
		last = f;
	} else {
		f->setConsumer(consumer);
		consumer = last = f;
	}
}

// Delete the filters in the chain (but not the consumer at the end)
// This is a convenience method, since the FilterChain destructor does not
// delete the filters in the chain
template<class ITEM, class TAG>
void FilterChain<ITEM, TAG>::deleteFilters() throw ()
{
	if (!last)
		return;

	// If there is a last, then `consumer' is the first filter in the chain
	TagcollFilter<ITEM, TAG>* cursor = (TagcollFilter<ITEM, TAG>*)consumer;
	while (cursor != last)
	{
		TagcollConsumer<ITEM, TAG>* next = cursor->getConsumer();
		delete cursor;
		cursor = (TagcollFilter<ITEM, TAG>*)next;
	}
}

template<class ITEM, class TAG>
void FilterChain<ITEM, TAG>::consume(const ITEM& item) throw ()
{
	consumer->consume(item);
}
template<class ITEM, class TAG>
void FilterChain<ITEM, TAG>::consume(const ITEM& item, const OpSet<TAG>& tags) throw ()
{
	consumer->consume(item, tags);
}

template<class ITEM, class TAG>
void FilterChain<ITEM, TAG>::consume(const OpSet<ITEM>& items) throw ()
{
	consumer->consume(items);
}
template<class ITEM, class TAG>
void FilterChain<ITEM, TAG>::consume(const OpSet<ITEM>& items, const OpSet<TAG>& tags) throw ()
{
	consumer->consume(items, tags);
}

// vim:set ts=4 sw=4:
