/*
 * Group items having the same tagset
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma implementation

#include <tagcoll/ItemGrouper.h>

using namespace std;
using namespace Tagcoll;

// Send the reversed data to a consumer
template<class ITEM, class TAG>
void ItemGrouper<ITEM, TAG>::output(TagcollConsumer<ITEM, TAG>& consumer) throw ()
{
	for (typename map<OpSet<TAG>, OpSet<ITEM> >::const_iterator i = groups.begin();
			i != groups.end(); i++)
		if (i->first.empty())
			consumer.consume(i->second);
		else
			consumer.consume(i->second, i->first);
}

// vim:set ts=4 sw=4:
