#ifndef TAGCOLL_TAGCONSUMER_H
#define TAGCOLL_TAGCONSUMER_H

/*
 * Package stream consumer and filter interfaces
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//#pragma interface

namespace Tagcoll
{

template<class ITEM>
class Consumer
{
public:
	virtual void consume(const ITEM&) throw () = 0;
};

template<class ITEM>
class Matcher
{
public:
	virtual bool match(const ITEM& item) const throw ()
	{
		return true;
	}
};

template<class ITEM>
class Filter : public Consumer<ITEM>
{
protected:
	Consumer<ITEM>& next;
public:
	Filter<ITEM>(Consumer<ITEM>& next) throw () : next(next) {}

	virtual void consume(const ITEM& item) throw ()
	{
		next.consume(item);
	}
};

template<class ITEM>
class MatcherFilter : public Filter<ITEM>
{
protected:
	Matcher<ITEM>& matcher;

public:
	MatcherFilter<ITEM>(Matcher<ITEM>& matcher, Consumer<ITEM>& next) throw ()
		: Filter<ITEM>(next), matcher(matcher) {}

	virtual void consume(const ITEM& item) throw ()
	{
		if (matcher.match(item))
			next.consume(item);
	}
};


class Facet;
class Tag;

class FacetConsumer : public Consumer<Facet> {};
class TagConsumer : public Consumer<Tag> {};

class FacetMatcher : public Matcher<Facet> {};
class TagMatcher : public Matcher<Tag> {};

class FacetFilter : public Filter<Facet>
{
public:
	FacetFilter(FacetConsumer& next) throw () : Filter<Facet>(next) {}
};
class TagFilter : public Filter<Tag>
{
public:
	TagFilter(TagConsumer& next) throw () : Filter<Tag>(next) {}
};

class FacetMatcherFilter : public MatcherFilter<Facet>
{
public:
	FacetMatcherFilter(FacetMatcher& matcher, FacetConsumer& next) throw ()
		: MatcherFilter<Facet>(matcher, next) {}
};

class TagMatcherFilter : public MatcherFilter<Tag>
{
public:
	TagMatcherFilter(TagMatcher& matcher, TagConsumer& next) throw ()
		: MatcherFilter<Tag>(matcher, next) {}
};

};

// vim:set ts=4 sw=4:
#endif
