#ifndef TAGCOLL_TAGCOLLFILTER_H
#define TAGCOLL_TAGCOLLFILTER_H

/*
 * Filter interface for a stream of tagged items
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma interface

#include <tagcoll/TagcollConsumer.h>

namespace Tagcoll
{

// Interface for filters to be used to filter the results of a tagged
// collection file parser
template<class ITEM, class TAG = std::string>
class TagcollFilter : public TagcollConsumer<ITEM, TAG>
{
protected:
	TagcollConsumer<ITEM, TAG>* consumer;

public:
	TagcollFilter() throw () : consumer(0) {}
	TagcollFilter(TagcollConsumer<ITEM, TAG>* consumer) throw () : consumer(consumer) {}

	TagcollConsumer<ITEM, TAG>* getConsumer() const throw () { return consumer; }
	void setConsumer(TagcollConsumer<ITEM, TAG>* consumer) throw () { this->consumer = consumer; }
};

};

// vim:set ts=4 sw=4:
#endif
