/*
TerraLib - a library for developing GIS applications.
Copyright  2001, 2002, 2003 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular
purpose. The library provided hereunder is on an "as is" basis, and the
authors have no obligation to provide maintenance, support, updates,
enhancements, or modifications.
In no event shall INPE be held liable to any party
for direct, indirect, special, incidental, or consequential damages arising
out of the use of this library and its documentation.
*/

#ifndef TEPDITYPES_HPP
  #define TEPDITYPES_HPP

  #include "TePDIRgbPalette.hpp"

  #include "TePDISharedPtr.cpp"

  #include <TeRaster.h>

  #include <map>
  #include <vector>


  /**
   *  This namespace contains the global types used by all PDI classes.
   */
  namespace TePDITypes
  {
    /**
     * Histogram alias definition.
     *
     * @param double level.
     * @param int Pixel count.
     */
    typedef map< double, int > TePDIHistogramType;

    /**
     * Histograms vector alias definition.
     */
    typedef std::vector< TePDIHistogramType > TePDIHistogramsVectorType;

    /**
     * Histograms map alias definition.
     *
     * @param int Channel ( band ) number;
     * @param TePDIHistogramType Related histogram.
     */
    typedef std::map< int, TePDIHistogramType > TePDIHistogramsMapType;

    /**
     * Type definition for a simple LUT - Look-Up Table.
     *
     * @param double (First) input level.
     * @param double (Second) output level.
     */
    typedef map< double, double > TePDILutType;

    /**
     * Look-Up Table vector alias definition.
     */
    typedef std::vector< TePDILutType > TePDILutsVectorType;

    /**
     * TeRaster pointer definition.
     */
    typedef TePDISharedPtr< TeRaster > TePDIRasterPtrType;

  };

#endif //TEPDITYPES_HPP
