/************************************************************************************
TerraView - visualization and exploration of geographical databases
using TerraLib.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.
This file is part of TerraView. TerraView is free software; you can redistribute it 
and/or modify it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

You should have received a copy of the GNU General Public License
along with TerraView.
The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The software provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use of
this program and its documentation.
*************************************************************************************/

#include <TeQtThemeItem.h>
#include <TeQtViewsListView.h>
#include <TeQtLegendItem.h>
#include <TeQtChartItem.h>
#include <TeDatabase.h>
#include <qpixmap.h>
#include <images/theme.xpm>
#include <qimage.h>

//Database item constructor
TeQtThemeItem::TeQtThemeItem(QListViewItem *parent,
	QString text, TeTheme *theme)
	: TeQtCheckListItem(parent,text,CheckBox), theme_(theme)
{
	type_ = THEME;
	QPixmap p(theme_xpm);
	setPixmap(0,p);
	setRenameEnabled(0,true);
	setSelected(false);
	setEnabled(true);

	order_ = theme->priority();
}


void TeQtThemeItem::stateChange(bool visible)
{
	TeQtViewsListView *lView = (TeQtViewsListView*)listView();
	lView->checkItemStateChanged(this, visible);
}


void TeQtThemeItem::removeLegends()
{
	vector<QListViewItem*> legendVector = getChildren();
	unsigned int i;
	for (i = 0; i < legendVector.size(); ++i)
	{
		TeQtCheckListItem *checkItem = (TeQtCheckListItem*)legendVector[i];
		if (checkItem->getType() == TeQtCheckListItem::LEGEND ||
			checkItem->getType() == TeQtCheckListItem::LEGENDTITLE)
			delete checkItem;
	}
}


void TeQtThemeItem::removeCharts()
{
	vector<QListViewItem*> legendVector = getChildren();
	unsigned int i;
	for (i = 0; i < legendVector.size(); ++i)
	{
		TeQtCheckListItem *checkItem = (TeQtCheckListItem*)legendVector[i];
		if (checkItem->getType() == TeQtCheckListItem::CHART ||
			checkItem->getType() == TeQtCheckListItem::CHARTTITLE)
			delete checkItem;
	}
}


void TeQtThemeItem::getLegends(vector<const QPixmap*>& pixmapVector, vector<string>& labelVector, string& title)
{
	vector<QListViewItem*> legendVector = getChildren();
	unsigned int i;
	for (i = 0; i < legendVector.size(); ++i)
	{
		TeQtCheckListItem *checkItem = (TeQtCheckListItem*)legendVector[i];

		if (checkItem->getType() == TeQtCheckListItem::LEGENDTITLE)
		{
			title = checkItem->text().latin1();
		}
		else if (checkItem->getType() == TeQtCheckListItem::LEGEND)
		{
			TeQtLegendItem *legendItem = (TeQtLegendItem*)checkItem;
			pixmapVector.push_back(legendItem->pixmap(0));
			labelVector.push_back(legendItem->text().latin1());
		}
	}
}
				
TeQtCheckListItem* TeQtThemeItem::getLegendItem(TeLegendEntry* leg)
{
	vector<QListViewItem*> legendVector = getChildren();
	unsigned int i;
	for (i = 0; i < legendVector.size(); ++i)
	{
		TeQtCheckListItem *checkItem = (TeQtCheckListItem*)legendVector[i];

		if (checkItem->getType() == TeQtCheckListItem::LEGEND)
		{
			TeQtLegendItem *legendItem = (TeQtLegendItem*)checkItem;
			if(legendItem->legendEntry()->id() == leg->id())
				return legendItem;
		}
	}
	return (TeQtCheckListItem*)0;
}

void TeQtThemeItem::updateAlias()
{
	TeDatabase* db = theme_->layer()->database();
	map<int, map<string, string> >& mapThemeAlias = db->mapThemeAlias();
	map<string, string>& mapAA = mapThemeAlias[theme_->id()];

	vector<QListViewItem*> itemVec = getChildren();

	unsigned int i;
	for (i = 0; i < itemVec.size(); ++i)
	{
		TeQtCheckListItem *checkItem = (TeQtCheckListItem*)itemVec[i];

		if (checkItem->getType() == TeQtCheckListItem::LEGENDTITLE)
		{
			string attr, nattr;
			if(theme_->grouping())
			{
				attr = theme_->grouping()->groupAttribute_.name_;
				nattr = theme_->grouping()->groupNormAttribute_;
			}

			if(nattr.empty() || nattr == "NONE")
			{
				map<string, string>::iterator it = mapAA.find(attr);
				if(it != mapAA.end())
				{
					string alias = it->second;
					if(alias.empty())
						checkItem->setText(0, attr.c_str());
					else
						checkItem->setText(0, alias.c_str());
				}
				else
					checkItem->setText(0, attr.c_str());
			}
			else
			{
				string alias = attr;
				map<string, string>::iterator it = mapAA.find(attr);
				if(it != mapAA.end())
					alias = it->second;

				it = mapAA.find(nattr);
				if(it != mapAA.end())
					alias += "/" + it->second;
				else
					alias += "/" + nattr;

				checkItem->setText(0, alias.c_str());
			}
		}
		else if (checkItem->getType() == TeQtCheckListItem::CHART)
		{
			string attr = ((TeQtChartItem*)checkItem)->name();
			map<string, string>::iterator it = mapAA.find(attr);
			if(it != mapAA.end())
			{
				string alias = it->second;
				checkItem->setText(0, alias.c_str());
			}
			else
				checkItem->setText(0, attr.c_str());
		}
	}
}

