/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/

#ifndef  __TERRALIB_INTERNAL_QUERIER_DBSTR3_H
#define  __TERRALIB_INTERNAL_QUERIER_DBSTR3_H

#include "TeQuerierDB.h"
#include "TeTemporalSeries.h"

//! A class that implement a strategy to build STOs (Spatial Temporal Objects) from a TerraLib database (Strategy 3)
//! Strategy 3: simple chronon, with geometry (points or cells), theme with collection table, operator exist in the database  
class TeQuerierDBStr3: public TeQuerierDB
{
	
private:
	int				timeFramePortal_;	// the time frame appointed by the portal 
	TeTSEntry		TSEntry_;
	TeGeomRep		rep_;
		
	/* @name Internal functions to initialize portals */
	//@{
	bool initPortal(TeTSEntry* ent=0); 
	//@}

	//! Internal function to fill STO
	bool fillSTO(TeSTInstance& sto); 
	
public:
	
	//! Constructor
	TeQuerierDBStr3(TeQuerierParams& params): 
		TeQuerierDB(params), 
		timeFramePortal_(-1)
	{} 

	//! Loads the instances
	bool loadInstances(TeTSEntry* ent=0); 

	//! Returns each loaded STO
	bool fetchInstance(TeSTInstance&  sto); 
};

//! A class that define a factory to build a querier strategy from database(strategy 3)
class TeQuerierDBStr3Factory : public TeQuerierImplFactory
{
public:

	//! Constructor
	TeQuerierDBStr3Factory(const string& name) : TeQuerierImplFactory(name) {}

	//! Builds a database querier
	virtual TeQuerierImpl* build (const TeQuerierParams& arg)
	{  
		TeQuerierParams tempArg = arg;
		return new TeQuerierDBStr3(tempArg); 
	}
};

#endif
