#!/usr/bin/perl

# -----------------------------------------------------
# | Parser dla plikow przykadowych                   |
# |                                                   |
# | Wyciaga odpowiednie rzeczy z komentarzy i wypluwa |
# | w postaci pliku docbook'a                         |
# |                                                   |
# | Komentarze do skryptu:                            |
# |                                                   |
# |	na stdin wyrzucane sa dane docbook            |
# |	na stderr wyrzucane sa dane informacyjne      |
# |                                                   |
# | Wywolujemy ./eparser.pl plik1 plik2 ... plikN     |
# -----------------------------------------------------

print stderr "E parser | Przeparsowane pliki: \n";

# // docbook wstep
print stdout "<chapter>\n";
print stdout "<title>Omwienie programw przykadowych</title>\n";
print stdout "<para>\n";
print stdout "Automatycznie wygenerowane na podstawie kodu rdowego omwienie programw przykadowych libtlen\n";
print stdout "</para>\n";
# // docbook wstep

while (<>)
{
    $filename = $ARGV;                                                          
    $filename =~ s/\.\.\/\.\.\///;   
    
    $_ =~ s/\&/\&amp\;/g;
    $_ =~ s/\</\&lt\;/g;
    $_ =~ s/\>/\&gt\;/g;
    $_ =~ s/[\t]//g;
	                                                                                    
    if ($. == 1)                                                                
    {                                                                           
        # // docbook rozdzial                                                   
        print stdout "<sect1>\n";                                               
        print stdout "<title>$filename</title>\n";                              
        print stdout "<para>Omwienie programu $filename</para>\n"; 
	print stdout "<para><screen>\n";
        # // docbook rozdzial                                                   
	
	print stderr "E parser |	- $filename\n";
    }  

    if (/\/\*/../\*\//) 
    {
	push @c, $_;
    }	 
    else
    {
        # obcinamy poczatek i koniec, bo to start i koniec komentarza       
        $txt = $_;
	
	pop @c;                                                             
        shift @c;                                                           
				                                                                                    
        # usuwamy gwiazdki i spacje z pocztkw linii                       
        @c = map{s/^[ \t]*\*[ \t]*//;$_}@c;                                 
        # laczymy liste @c spowrotem w jednosc do zmiennej $_               
        $_ = join'',@c;	
	
	if (/^(.*?)\n/s)
	{
	    print stdout "</screen></para>\n";
	    print stdout "<para>$_</para>\n";
	    print stdout "<para><screen>\n";
	}

        # czyscimy liste
	@c=();

	print $txt;
    }
}
continue                                                                        
{                                                                               
    close ARGV if eof;                                                          
    # // docbook koniec rozdzialu                                               
    print stdout "</screen></para></sect1>\n" if eof;                                           
    # // docbook koniec rozdzialu                                               
}   

print stdout "</chapter>\n\n";