/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2009-2012 Canonical Ltd.
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 3 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <libubuntuoneui/u1-music-store.h>

static void
preview_mp3_cb (U1MusicStore *music_store, const gchar *url, const gchar *title, gpointer user_data)
{
	GtkWidget *dialog;

	dialog = gtk_message_dialog_new (GTK_WINDOW (gtk_widget_get_toplevel (GTK_WIDGET (music_store))),
					 0,
					 GTK_MESSAGE_INFO,
					 GTK_BUTTONS_OK,
					 "Requested preview of file %s with title %s", url, title);
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);

	u1_music_store_load_store_link (music_store, "http://stores.7digital.com/corporate_1/artists/govt-mule/the-deepest-end-live-in-concert-1/");
}

static void
url_loaded_cb (U1MusicStore *music_store, const gchar *url, gpointer user_data)
{
	g_debug ("URL loaded: %s\n", url);
}

static void
download_finished_cb (U1MusicStore *music_store, const gchar *path, gpointer user_data)
{
	g_debug ("File %s finished downloading\n", path);
}

int
main (int argc, char *argv[])
{
	GtkWidget *window, *music_store;

	gtk_init (&argc, &argv);
	g_type_init ();

	/* Create the main window */
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_default_size (GTK_WINDOW (window), 640, 480);
	g_signal_connect (G_OBJECT (window), "destroy", G_CALLBACK (gtk_main_quit), NULL);

	music_store = u1_music_store_new ();
	g_signal_connect (G_OBJECT (music_store), "preview-mp3", G_CALLBACK (preview_mp3_cb), NULL);
	g_signal_connect (G_OBJECT (music_store), "url-loaded", G_CALLBACK (url_loaded_cb), NULL);
	g_signal_connect (G_OBJECT (music_store), "download-finished", G_CALLBACK (download_finished_cb), NULL);
	gtk_widget_show (music_store);
	gtk_container_add (GTK_CONTAINER (window), music_store);

	g_print ("Music library location: %s\n", u1_music_store_get_library_location (U1_MUSIC_STORE (music_store)));
	
	/* Run the application */
	gtk_widget_show (window);
	gtk_main ();

	return 0;
}
