'\" t
.\" Manual page created with latex2man on Tue Mar 30 23:28:14 PST 2004
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "UNW\\_RESUME" "3" "30 March 2004" "Programming Library " "Programming Library "
.SH NAME
unw_resume
\-\- resume execution in a particular stack frame 
.PP
.SH SYNOPSIS

.PP
#include <libunwind.h>
.br
.PP
int
unw_resume(unw_cursor_t *cp);
.br
.PP
.SH DESCRIPTION

.PP
The unw_resume()
routine resumes execution at the stack frame 
identified by cp\&.
The behavior of this routine differs 
slightly for local and remote unwinding. 
.PP
For local unwinding, unw_resume()
restores the machine state 
and then directly resumes execution in the target stack frame. Thus 
unw_resume()
does not return in this case. Restoring the 
machine state normally involves restoring the ``preserved\&'' 
(callee\-saved) registers. However, if execution in any of the stack 
frames younger (more deeply nested) than the one identified by 
cp
was interrupted by a signal, then unw_resume()
will 
restore all registers as well as the signal mask. Attempting to call 
unw_resume()
on a cursor which identifies the stack frame of 
another thread results in undefined behavior (e.g., the program may 
crash). 
.PP
For remote unwinding, unw_resume()
installs the machine state 
identified by the cursor by calling the access_reg
and 
access_fpreg
accessor callbacks as needed. Once that is 
accomplished, the resume
accessor callback is invoked. The 
unw_resume
routine then returns normally (that is, unlikely 
for local unwinding, unw_resume
will always return for remote 
unwinding). 
.PP
Most platforms reserve some registers to pass arguments to exception 
handlers (e.g., IA\-64 uses r15\-r18
for this 
purpose). These registers are normally treated like ``scratch\&'' 
registers. However, if libunwind
is used to set an exception 
argument register to a particular value (e.g., via 
unw_set_reg()),
then unw_resume()
will install this 
value as the contents of the register. In other words, the exception 
handling arguments are installed even in cases where normally only the 
``preserved\&'' registers are restored. 
.PP
Note that unw_resume()
does \fInot\fP
invoke any unwind 
handlers (aka, ``personality routines\&''). If a program needs this, it 
will have to do so on its own by obtaining the unw_proc_info_t
of each unwound frame and appropriately processing its unwind handler 
and language\-specific data area (lsda). These steps are generally 
dependent on the target\-platform and are regulated by the 
processor\-specific ABI (application\-binary interface). 
.PP
.SH RETURN VALUE

.PP
For local unwinding, unw_resume()
does not return on success. 
For remote unwinding, it returns 0 on success. On failure, the 
negative value of one of the errors below is returned. 
.PP
.SH THREAD AND SIGNAL SAFETY

.PP
unw_resume()
is thread\-safe. If cursor cp
is in the 
local address\-space, this routine is also safe to use from a signal 
handler. 
.PP
.SH ERRORS

.PP
.TP
UNW_EUNSPEC
 An unspecified error occurred. 
.TP
UNW_EBADREG
 A register needed by unw_resume()
wasn\&'t 
accessible. 
.TP
UNW_EINVALIDIP
 The instruction pointer identified by 
cp
is not valid. 
.TP
UNW_BADFRAME
 The stack frame identified by 
cp
is not valid. 
.PP
.SH SEE ALSO

.PP
libunwind(3),
unw_set_reg(3),
sigprocmask(2) 
.PP
.SH AUTHOR

.PP
David Mosberger\-Tang
.br 
Hewlett\-Packard Labs
.br 
Palo\-Alto, CA 94304
.br 
Email: \fBdavidm@hpl.hp.com\fP
.br
WWW: \fBhttp://www.hpl.hp.com/research/linux/libunwind/\fP\&.
.\" NOTE: This file is generated, DO NOT EDIT.
