/****************************************************************************

COPYRIGHT NOTICE:

  The source code in this file is provided free of charge
  to the author's consulting clients.  It is in the
  public domain and therefore may be used by anybody for
  any purpose.

AUTHOR:

  Will Naylor

****************************************************************************/
#ifndef wnbllH
#define wnbllH

#include "wnlib.h"
#include "wnsll.h"


typedef struct wn_bll_struct *wn_bll;

struct wn_bll_struct
{
  ptr contents;
  wn_bll next,*plist;
};


void wn_mkbll(wn_bll *pll);
void wn_freebll_list(wn_bll ll);
void wn_freebll(wn_bll ll);

void wn_bllins(wn_bll *plist,ptr e);
void wn_blleins(wn_bll *plist,wn_bll el);

void wn_bllrev(wn_bll *plist);

void wn_bllrepatch(wn_bll *plist);

bool wn_blldel(wn_bll list,ptr e);
void wn_blledel(wn_bll el);
void wn_blleunlink(wn_bll el);

void wn_bllcpy(wn_bll *pout,wn_bll in);

void wn_bllins_bll(wn_bll *pout,wn_bll in);

void wn_bllcat(wn_bll *pout,wn_bll in);

void wn_bllend(wn_bll **ppend,wn_bll *plist);

void wn_bllindex
(
  ptr *pcontents,
  wn_bll list,
  int index
);
 
void wn_blleindex(wn_bll *pel,wn_bll list,int index);

bool wn_bllget
(
  ptr *pe,
  wn_bll list,
  bool (*ppredicate)(ptr entry)
);
bool wn_blleget
(
  wn_bll *pel,
  wn_bll list,
  bool (*ppredicate)(ptr entry)
);

void wn_bllgetmin
(
  ptr *pe,
  wn_bll list,
  int (*pcompare_func)(ptr e1,ptr e2)
);

bool wn_bllempty(wn_bll list);

int wn_bllcount(wn_bll list);



#endif

