//
// Include da aggiungere in tutti i programmi
// 
#include "finestre.h"
//
struct vars
{
    //
    CmdInfo *Cmd;
    CmdInfo *EventType;
    CmdInfo *EventString;
    //
};

int myfunction(CmdInfo *Cmd, int EventType, struct vars *myvars)
{
    char tmp[16];

    sprintf (tmp,"0x%x",Cmd);
    WX11_CmdLabelChange (myvars->Cmd,tmp);

    sprintf (tmp,"%d",EventType);
    WX11_CmdLabelChange (myvars->EventType,tmp);
	
    switch (EventType)
    {
        case EnterNotify:
            WX11_CmdLabelChange (myvars->EventString,"EnterNotify");
            break;
        case LeaveNotify:
            WX11_CmdLabelChange (myvars->EventString,"LeaveNotify");
            break;
        case Button1Press:
            WX11_CmdLabelChange (myvars->EventString,"Button1Press");
            break;
        case Button2Press:
            WX11_CmdLabelChange (myvars->EventString,"Button2Press");
            break;
        case Button3Press:
            WX11_CmdLabelChange (myvars->EventString,"Button3Press");
            break;
        case Button1Release:
            WX11_CmdLabelChange (myvars->EventString,"Button1Release");
            break;
        case Button2Release:
            WX11_CmdLabelChange (myvars->EventString,"Button2Release");
            break;
        case Button3Release:
            WX11_CmdLabelChange (myvars->EventString,"Button3Release");
            break;
        case KeyPress:
            WX11_CmdLabelChange (myvars->EventString,"KeyPress");
            break;
        default:
            WX11_CmdLabelChange (myvars->EventString,"Not Defined");
	}

	return (0);
}

int main (int argc, char **argv)
{
    //
    struct vars myvars;

    CmdInfo *my,*area1,*area2;
    int Bordo=4;

    InitFinestre (argc, argv);

    my=ApreFinestraCentrale ("Example Signals", 290, 200);

    WX11_Say (my,"Cmd         :");
    myvars.Cmd=WX11_Say (my,"\n");

    WX11_Say (my,"EventType   :");
    myvars.EventType=WX11_Say (my,"\n");

    WX11_Say (my,"EventString :");
    myvars.EventString=WX11_Say (my,"\n");

    area1=ApreArea (my, 20,60,100,100,
        WX11_ColorGet(WINBG),WX11_ColorGet(WINFG),Bordo);

    area2=ApreArea (my,150,60,100,100,
        WX11_ColorGet(WINBG),WX11_ColorGet(WINFG),Bordo);

    WX11_SetSignalCallBack (area1,EnterNotify,myfunction,&myvars);
    WX11_SetSignalCallBack (area1,LeaveNotify,myfunction,&myvars);
    WX11_SetSignalCallBack (area1,KeyPress,myfunction,&myvars);
    WX11_SetSignalCallBack (area1,Button1Press,myfunction,&myvars);
    WX11_SetSignalCallBack (area1,Button1Release,myfunction,&myvars);
    WX11_SetSignalCallBack (area1,Button2Press,myfunction,&myvars);
    WX11_SetSignalCallBack (area1,Button2Release,myfunction,&myvars);
    WX11_SetSignalCallBack (area1,Button3Press,myfunction,&myvars);
    WX11_SetSignalCallBack (area1,Button3Release,myfunction,&myvars);

    WX11_SetSignalCallBack (area2,EnterNotify,myfunction,&myvars);
    WX11_SetSignalCallBack (area2,LeaveNotify,myfunction,&myvars);
    WX11_SetSignalCallBack (area2,KeyPress,myfunction,&myvars);
    WX11_SetSignalCallBack (area2,Button1Press,myfunction,&myvars);
    WX11_SetSignalCallBack (area2,Button1Release,myfunction,&myvars);
    WX11_SetSignalCallBack (area2,Button2Press,myfunction,&myvars);
    WX11_SetSignalCallBack (area2,Button2Release,myfunction,&myvars);
    WX11_SetSignalCallBack (area2,Button3Press,myfunction,&myvars);
    WX11_SetSignalCallBack (area2,Button3Release,myfunction,&myvars);

    WX11_Events (my);	

    WX11_CloseDisplay ();

    return (0);
}

