/* 
-------------------------------------------------------------- 
Copyright 2007-2008 Max Cavallo ixamit@gmail.com - All Rights Reserved

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,USA; either version 2 of the License, or (at your option) any later version; incorporated herein by reference.
-------------------------------------------------------------- 
*/

#include "finestre.h"
extern int WX11_INTERLINE_SPACE;
extern int WX11_SPACE_BETWEEN_BORDERS;

int WX11_IsShift (int State) { return (State & ShiftMask); }
int WX11_IsCtrl  (int State) { return (State & ControlMask); } 
int WX11_IsAlt (int State)	{ return (State & Mod1Mask); }
int WX11_IsCapsLock (int State)	{ return (State & LockMask); }
int WX11_IsNumLock  (int State)	{ return (State & Mod2Mask);}

//CmdInfo * WX11_CursorInputPosition (int Mode,CmdInfo *cmd,int *pos)
int WX11_CursorInputPosition (int Mode,CmdInfo *cmd,int pos)
{
    //
    // Get or Set Cursor Position (pos)
    // return cmd or NULL
    //
    //static int Last_Pos=0;
    //static CmdInfo* Last_Cmd=NULL;
    if (Mode)
    {
	cmd->input_x=pos;
        //Last_Pos=*pos;
        //Last_Cmd=cmd;
    }
    pos=cmd->input_x;
    //*pos=Last_Pos;
    //printf ("mode=%d cmd=%p pos=%d\n",Mode,cmd,Last_Pos);
    //return (Last_Cmd);
    return (pos);

}

void WX11_CursorInput (CmdInfo *cmd, int mode, int pos)
{
    // ReDraw Cursor Input
    //
    // cmd          =  cmd
    // mode         == 0 Get
    //              == 1 Set
    // pos          = string position
    //
    Display *dsp=WX11_GetDisplay();
    //CmdInfo *Last_Cmd=NULL;
    GC Last_gc,gc;
    int Last_Pos=0;
    //
    int height=cmd->Height;
    int posx;
    //
    //
    gc=Last_gc=WX11_GCGet();
    if (mode==1)
    {

        Last_Pos=WX11_CursorInputPosition(0,cmd,0);
        if (Last_Pos)
        {
            XSetForeground(dsp,Last_gc,WX11_RGB(WX11_ColorGet(INPUTBG)));
            posx=XTextWidth(cmd->Font,cmd->Label,Last_Pos);
            XDrawLine(dsp, cmd->win, Last_gc, posx+WX11_SPACE_BETWEEN_BORDERS,1,posx+WX11_SPACE_BETWEEN_BORDERS,height-2);

        }

        XSetForeground(dsp,gc,WX11_RGB(WX11_ColorGet(INPUTFG)));
        posx=XTextWidth(cmd->Font,cmd->Label,pos);

        XDrawLine(dsp, cmd->win, gc, posx+WX11_SPACE_BETWEEN_BORDERS,1,posx+WX11_SPACE_BETWEEN_BORDERS,height-2);

    }

    WX11_CursorInputPosition (1,cmd,pos);
}

int WX11_CursorInputScroll (CmdInfo *cmd,int pos)
{
    //
    // Scrolling (if necessary) and
    // call CursorInput
    //
    int posx,diff,ret=0;
    int width=((cmd->Prev)->Width)-((cmd->Bordo)*2);

    posx=XTextWidth(cmd->Font,cmd->Label,pos);

    if (posx < cmd->scroll_x * (-1))
    {
        // Scroll sx
        diff=(cmd->scroll_x * (-1)) - posx;
        cmd->scroll_x=cmd->scroll_x+diff;
	XMoveWindow(WX11_GetDisplay(), 
            cmd->win, 
            cmd->scroll_x, 
            cmd->y);

        ret=1;
    }
    if (posx+cmd->scroll_x >= width)
    {
        // Scroll dx
        diff=(cmd->scroll_x+posx)-(width);
        cmd->scroll_x=cmd->scroll_x-diff;
	XMoveWindow(WX11_GetDisplay(), 
            cmd->win, 
            cmd->scroll_x, 
            cmd->y);

        ret=1;
    }

    WX11_CursorInput (cmd, 1, pos);
    return (ret);
}

int WX11_InputKey (CmdInfo *Comando,int State, unsigned int xsym, char Key)
{
	//CmdInfo *Comando=NULL;
	char *Buff=NULL;
	int pos=0;     // Cursor position Label (0 to Size)
	int Size=0;    // Larghezza Buffer Label
	int Len=0;     // Larghezza campo visivo
	
	int x;

        pos=WX11_CursorInputPosition (0,Comando,0);

	// debug
	//if (WX11_IsShift(State)) printf ("<SHIFT> ");
	//if (WX11_IsCtrl (State)) printf ("<CTRL> ");
	//if (WX11_IsAlt(State)) printf ("<ALT> ");
	//printf ("Il KeyCode e' %d - ",KeyCode);
	//printf ("Il Key e' %d\n",Key);

	///////////////////////////////
	// Setting...
	Buff=Comando->Label;
	Size=strlen(Buff);
	Len=Comando->Prev->Width;	// Bordo obbigatorio!!!

	///////////////////////////////
	// Home
	if (xsym==XK_Home)
	{
                pos=0;
                // 
                // Scrolling?
                WX11_CursorInputScroll (Comando,pos);
                //

	}
	///////////////////////////////
	// End
	if (xsym==XK_End)
	{
		for (pos=Size-1;pos && *(Buff+pos)==' ';pos--);
		if (pos || Buff[0]!=' ') pos++;
                //
                // Scrolling?
                WX11_CursorInputScroll (Comando,pos);
	}
	///////////////////////////////
	// <----
        if (xsym==XK_Left)
	{
		if (WX11_IsCtrl(State) && pos) 
		{
			pos--;
			while (pos && *(Buff+pos)==' ') pos--;
			while (pos && *(Buff+pos)!=' ') pos--;
			if (pos) pos++;
                        //
                        // Scrolling?
                        WX11_CursorInputScroll (Comando,pos);
		}
		if (!WX11_IsCtrl(State) && pos)
		{
                        pos--;
                        //
                        // Scrolling?
                        WX11_CursorInputScroll (Comando,pos);
		}
	}
	///////////////////////////////
	// ---->
	if (xsym==XK_Right) 
	{
		if (WX11_IsCtrl(State)) 
		{
			while (pos<Size && *(Buff+pos)!=' ') pos++;
			while (pos<Size && *(Buff+pos)==' ') pos++;
                        //
                        // Scrolling?
                        WX11_CursorInputScroll (Comando,pos);

		}
		if (!WX11_IsCtrl(State) && pos<Size)
		{ 
                        pos++;
                        //
                        // Scrolling?
                        WX11_CursorInputScroll (Comando,pos);
                }
	}
	///////////////////////////////
	// Canc
	if (xsym==XK_Delete)
	{	
		for (x=pos;x<Size-1;x++)
			*(Buff+x)=*(Buff+x+1);
		*(Buff+x)=' ';
	}
	///////////////////////////////
	// BackSpace
	if (xsym==XK_BackSpace)
	{
		if (pos)
		{

                        pos--;
                        //
                        // Scrolling?
                        WX11_CursorInputScroll (Comando,pos);

			for (x=pos;x<Size-1;x++)
				*(Buff+x)=*(Buff+x+1);
			*(Buff+x)=' ';
		}
	}
	///////////////////////////////
	// Tasto Speciale <TAB>
	// salta sull'input successivo
	if (xsym==XK_Tab)
	{
		// Scrolling Reset?
		if (Comando->scroll_x)
		{
                        pos=0;
                        WX11_CursorInputScroll (Comando,pos);
/*
			Comando->scroll_x=0;
			XMoveWindow(WX11_GetDisplay(), 
				Comando->win, 
				Comando->scroll_x, 
				Comando->y);
*/
		}

		Comando->Focus=0;
		do
		{
			Comando=WX11_IsShift(State) ? Comando->Prev : Comando->Next;
			if (Comando==NULL)
			{ 
				if(WX11_IsShift(State)) 
					Comando=UltimoComando (0,NULL); 
				else 
					Comando=PrimoComando(0,NULL);
			}
		}
		while (Comando->Tipo!=INPUT); 

		UltimoComandoSelezionato(1,Comando);
		Comando->Focus=1;
		pos=0;
		Buff=Comando->Label;
		//
	}

	//if (Key==(char) 0) return(0); // Trattalo poi 

	///////////////////////////////
	// Key
	if (Key >=(char) 32 && Key <=(char) 122 && pos<Size)
	{
		///////////////////////////
		// Modalita inserimento
		for (x=Size-2;x>=pos;x--)
			*(Buff+x+1)=*(Buff+x);
		*(Buff+pos)=Key ; 

                if (pos<Size) pos++;
                //
                // Scrolling?
                WX11_CursorInputScroll (Comando,pos);

	}

	XClearWindow (WX11_GetDisplay(),Comando->win);

	WX11_PrintFlush(Comando);

        WX11_CursorInput (Comando, 1, pos);

	return (0);
}
