#ifndef XFFM_ACTIONS_LIB_H
#define XFFM_ACTIONS_LIB_H
#include "run.h"
#include "remove.h"
#include "cpy.h"
#include "rcp.h"
#include "countfiles.h"
#include "password_dialog.h"

const gchar *xffm_new_name(const gchar *in_path, const gchar *base);

int xffm_print(widgets_t *widgets_p, const gchar *cmd, const gchar *file);
int xffm_touch(widgets_t *widgets_p, const gchar *path);
int xffm_rename(widgets_t *widgets_p, const gchar *nfile, const gchar *ofile);
int xffm_duplicate (widgets_t *widgets_p, const gchar *nfile, const gchar *ofile);
int xffm_symlink(widgets_t *widgets_p, const gchar *nfile, const gchar *ofile);
int xffm_new(widgets_t *widgets_p, const char *path, const gchar *in_name, gboolean directory);
int xffm_diff(widgets_t *widgets_p, const gchar *file1, const gchar *file2);
int xffm_scramble(widgets_t *widgets_p, const gchar *file, gboolean cypher);

int xffm_refresh(widgets_t *widgets_p);
int xffm_refresh_parent(widgets_t *widgets_p);
void xffm_open_with(widgets_t *widgets_p, record_entry_t *en);
record_entry_t	*xffm_get_selected_entry(struct widgets_t *widgets_p);
record_entry_t	*xffm_get_selected_parent_entry(struct widgets_t *widgets_p);

GtkWidget* xffm_create_remove (widgets_t *widgets_p);
#endif
