/*
 * Copyright (C) 2002-5 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define PIXBUF_HASH
#ifdef PIXBUF_HASH
static GHashTable *pixbuf_hash=NULL;
typedef struct pixbuf_hash_t {
    GdkPixbuf *pixbuf;
    int size;
    struct pixbuf_hash_t *next;
}pixbuf_hash_t;
#endif

static GtkStyle *style;
static const gchar *composite_type_id(const gchar *path,int type,int subtype,const gchar *id){
	static gchar *composite_type=NULL;
	gboolean greenball=FALSE,redball=FALSE;
	gchar *p;
	g_free(composite_type);
	composite_type=g_strdup(id);
	if (path && IS_DIR(type)){
	    gboolean mounted=(FSTAB_is_mounted(path)!=NULL);
	    if (mounted) greenball=TRUE;
	    else {
		if(FSTAB_is_in_fstab(path)) redball=TRUE;
		/*if (FSTAB_is_in_fstab(path) && !IS_XF_FSTAB(type)) redball=TRUE;*/
	    }
	}
	/*if (IS_NOWRITE(type)||IS_XF_LNK(type)||HAS_HIDDEN(type)||greenball||redball||IS_NETREADONLY(subtype)||IS_XF_NETSHARE(subtype)){*/
	if (IS_NOWRITE(type)||IS_XF_LNK(type)||HAS_HIDDEN(type)||greenball||redball||IS_NETREADONLY(subtype)||IS_NOACCESS(type)||IS_CHANGED(type)){
	    p=composite_type;
	    composite_type = g_strconcat(p,"/composite",NULL);
	    g_free(p);	
	}
	if(HAS_HIDDEN(type)){
	    p=composite_type;
	    if(SHOWS_HIDDEN(type)) composite_type = g_strconcat(p,"/shows_hidden",NULL);
	    else composite_type = g_strconcat(p,"/has_hidden",NULL);
	    g_free(p);
	}
	
	if (IS_NOACCESS(type)){
	    p=composite_type;
	    composite_type = g_strconcat(p,"/noread",NULL);
	    g_free(p);	
	}
	else if (IS_NOWRITE(type)||IS_NETREADONLY(subtype)){
	    p=composite_type;
	    composite_type = g_strconcat(p,"/nowrite",NULL);
	    g_free(p);	
	}
	/*if (IS_XF_LNK(type)||IS_XF_NETSHARE(subtype)){*/
	if (IS_XF_LNK(type)){
	    p=composite_type;
	    composite_type = g_strconcat(p,"/link",NULL);
	    g_free(p);	
	}
	/*if (path && IS_FSTAB_TYPE(type) && IS_XF_FSTAB(type)){*/
	if (path && greenball){
	    p=composite_type;
	    composite_type = g_strconcat(p,"/fstab_mounted",NULL);
	    g_free(p);	
	} else if (path && redball){
	    p=composite_type;
	    composite_type = g_strconcat(p,"/fstab_unmounted",NULL);
	    g_free(p);	
	} else if (IS_CHANGED(type)){
	    p=composite_type;
	    composite_type = g_strconcat(p,"/urgent",NULL);
	    g_free(p);	
	}

	TRACE("TRACE 1 s:%s composite type=%s type=0x%x (link=%d)\n",path,composite_type,type,IS_XF_LNK(type));

	return composite_type;
}


static
const gchar *get_thumbnail_path(char *file, int size){
    gchar *cache_dir,*filename;
    static gchar *thumbnail_path=NULL;
    GString *gs;
    gchar key[11];

    cache_dir = g_build_filename(xdg_cache_dir(),"xffm","thumbnails",NULL);  
    mkdir(cache_dir, 0770);
    if (!g_file_test(cache_dir,G_FILE_TEST_IS_DIR)) {
	g_free(cache_dir);
	return NULL;
    }

    /* thumbnails are not subject to thumbnailization: */
    filename=g_path_get_dirname(file);
    if (strcmp(cache_dir,filename)==0){
	TRACE("thumbnails cannot be thumbnailed:%s",file);
	g_free(cache_dir);
	g_free(filename);
	return NULL;
    }
    g_free(filename);
    
    
    gs = g_string_new(file);
    sprintf(key, "%10u", g_string_hash(gs));
    g_string_free(gs, TRUE);

    filename=g_strdup_printf("%s-%d.png",key,size);
    thumbnail_path = g_build_filename(cache_dir,filename,NULL);
    g_free(filename);
    g_free(cache_dir);
    
    return (const gchar *)thumbnail_path;
 }

/* some of the code in this function contributed by Thomas Leonard: */
static
void save_thumbnail(const gchar *thumbnail_path, const gchar *original_path, GdkPixbuf *tgt){
	int original_width, original_height;
	char *swidth, *sheight, *ssize, *smtime;
	struct stat st;
	GError *error=NULL;
	
	if (!thumbnail_path || !original_path) return;
	TRACE("creating thumbnail for %s (%s)",original_path,thumbnail_path);
	
	original_width = gdk_pixbuf_get_width(tgt);
	original_height = gdk_pixbuf_get_height(tgt);

	if (stat(original_path, &st) != 0) return;

	swidth = g_strdup_printf("%d", original_width);
	sheight = g_strdup_printf("%d", original_height);
	ssize = g_strdup_printf("%ld", (long int)st.st_size);
	smtime = g_strdup_printf("%ld", st.st_mtime);
	
	gdk_pixbuf_save(tgt,
			thumbnail_path,
			"png",
			&error,
			"tEXt::Thumb::Image::Width", swidth,
			"tEXt::Thumb::Image::Height", sheight,
			"tEXt::Thumb::Size", ssize,
			"tEXt::Thumb::MTime", smtime,
			"tEXt::Software", "Xfce4",
			NULL);
	if (error) g_error_free (error);
	g_free(swidth);
	g_free(sheight);
	g_free(ssize);
	g_free(smtime);
}


static GdkPixbuf *icon_tell_cut(widgets_t *widgets_p,int size, const gchar *id, gboolean cut)
{
    GtkIconSet *iconset;
    int gtksize;
    GdkPixbuf *pixbuf;
    
    TRACE("icon_tell_cut: %s",id);
    if (!id || !strlen(id)) return NULL;
#ifdef PIXBUF_HASH
    if (pixbuf_hash && !cut){
	pixbuf_hash_t *pixbuf_hash_p = g_hash_table_lookup(pixbuf_hash,id);
	if (pixbuf_hash_p){
	    TRACE("pixbuf found for %s",id);
	    for (;pixbuf_hash_p; pixbuf_hash_p= pixbuf_hash_p->next){
		if (pixbuf_hash_p->size==size) break;
	    }
	    if (pixbuf_hash_p){
		pixbuf=pixbuf_hash_p->pixbuf;
		g_object_ref(pixbuf);
		TRACE("pixbuf size found for %s",id);
		return pixbuf;
	    } else TRACE("pixbuf size %d not found",size);
	}
	
    }
#endif

    TRACE("icon_tell_cut2: %s",id);
    if (strncmp(id,"gtk-",strlen("gtk-"))==0){
	pixbuf=load_stock_icon(widgets_p, id ,size);
	goto pixbuf_done;
    } 	
    

    if (strstr(id,"/composite")) {
	gchar *basic_type=g_strdup(id);
	
	GdkPixbuf *folder,*ofolder;

	TRACE("icon_tell_cut composite: %s",id);
	*(strstr(basic_type,"/composite"))=0;
	
	
	ofolder = icon_tell(widgets_p,size,basic_type);
	g_free(basic_type);
	if (ofolder) {
	  folder=gdk_pixbuf_copy(ofolder);
	  g_object_unref(G_OBJECT(ofolder));
	} else folder=NULL;
	
	
	if (strstr(id,"/shows_hidden")){
	    insert_pixbuf_tag(widgets_p, "gtk-zoom-fit",&folder,size,2,"NE",TRUE);
	}
	/*
	else if (strstr(id,"/has_hidden")) {
	    insert_pixbuf_tag(widgets_p, "gtk-dialog-warning",&folder,size,2,"NE",TRUE);
	}*/	
	
	if (strstr(id,"/link")){
	    insert_pixbuf_tag(widgets_p, "emblem-symbolic-link",&folder,size,2,"SW",TRUE);
	}
	else if(strstr(id,"/noread")){
	    insert_pixbuf_tag(widgets_p, "emblem-noread",&folder,size,2,"SE",TRUE);
	}
	else if (strstr(id,"/nowrite")){
	    insert_pixbuf_tag(widgets_p, "emblem-nowrite",&folder,size,2,"SE",TRUE);
	}
		
	if (strstr(id,"/fstab_mounted")){
	    insert_pixbuf_tag(widgets_p, "gtk-yes",&folder,size,3,"NW",TRUE);
	}
	else if (strstr(id,"/fstab_unmounted")){
	    insert_pixbuf_tag(widgets_p, "gtk-no",&folder,size,3,"NW",TRUE);
	}
	else if (strstr(id,"/urgent")){
	    insert_pixbuf_tag(widgets_p, "emblem-urgent",&folder,size,1.5,"SE",TRUE);
	}

	if (cut && folder){   
	    iconset=gtk_icon_set_new_from_pixbuf(folder);
	    g_object_unref(G_OBJECT(folder));
	} 
	else {
	    pixbuf=folder;
	    goto pixbuf_done;
	}
    }
    TRACE("icon_tell_cut3: %s",id);
    iconset = ICON_get_iconset(id,widgets_p->window);
    TRACE("icon_tell_cut4: %s",id);

    TRACE("icon_tell_cut5: %s",id);
    
    if(!iconset) 
    {
        iconset = ICON_get_iconset(GTK_STOCK_MISSING_IMAGE,widgets_p->window);
    }
    

    if(!style) style = gtk_style_new();
    switch (size)
    {
	case REAL_BIG:
	    gtksize = GTK_ICON_SIZE_DIALOG;
	    break;
	case BIG:
	    gtksize = GTK_ICON_SIZE_DND;
	    break;
	case MEDIUM:
	default:
	    gtksize = GTK_ICON_SIZE_LARGE_TOOLBAR;
	    break;
	case SMALL:
	    /*gtksize = GTK_ICON_SIZE_BUTTON;*/
	    gtksize = GTK_ICON_SIZE_MENU;
	    break;
	    /*gtksize=GTK_ICON_SIZE_SMALL_TOOLBAR; break;*/
    }
    if(!iconset) return NULL;
    TRACE("icon_tell_cut6: %s",id);
    pixbuf = gtk_icon_set_render_icon(iconset, style, GTK_TEXT_DIR_LTR, (cut) ? GTK_STATE_INSENSITIVE : GTK_STATE_NORMAL, gtksize, NULL, NULL);
pixbuf_done:
#ifdef PIXBUF_HASH
    if (!cut) {
	pixbuf_hash_t *pixbuf_hash_p,*p;
	g_object_ref(pixbuf);
	if (!pixbuf_hash){
	    pixbuf_hash = g_hash_table_new(g_str_hash, g_str_equal);
	}
	pixbuf_hash_p = g_hash_table_lookup(pixbuf_hash,id);
	if (!pixbuf_hash_p) {
	    TRACE("new pixbuf for %s",id);
	    pixbuf_hash_p=(pixbuf_hash_t *)malloc(sizeof(pixbuf_hash_t));
	    pixbuf_hash_p->size=size;
	    pixbuf_hash_p->pixbuf=pixbuf;
	    pixbuf_hash_p->next=NULL;
	    g_object_ref(pixbuf);	    
	    g_hash_table_insert(pixbuf_hash, g_strdup(id), (gpointer) pixbuf_hash_p);
	    return pixbuf;
	}
	for (p=pixbuf_hash_p; p && p->next; p=p->next);
	
	/*if (p->size==size) g_warning("this does not happen");*/
	
	pixbuf_hash_p = p->next = (pixbuf_hash_t *)malloc(sizeof(pixbuf_hash_t));
	pixbuf_hash_p->size=size;
	pixbuf_hash_p->pixbuf=pixbuf;
	pixbuf_hash_p->next=NULL;
	g_object_ref(pixbuf);	    
	return pixbuf;    
    }
#endif
    return pixbuf;
}

static 
GdkPixbuf *
combine_pixbufs(	GdkPixbuf **tgt,
			GdkPixbuf **src,
			int x_tgt, 
			int y_tgt,
			int src_width, 
			int src_height)
{
	/* Approach 2... not used in 4.2 */
	GdkBitmap *mask_return;
	GdkPixmap *sandbox,*pixmap;
	static GdkGC *penGC=NULL;
	GdkColormap *cmap=gdk_colormap_get_system();

	/* create sandbox */
	GdkPixbuf *pb;
	if (!GDK_IS_PIXBUF (*src)) {
	    g_warning("calling combine_pixbufs with !GDK_IS_PIXBUF (*src)");
	    return gdk_pixbuf_copy(*tgt);
	}
	
	pb=gdk_pixbuf_new_subpixbuf (*tgt,
		x_tgt,y_tgt,
		src_width,src_height);
	if (!GDK_IS_PIXBUF (pb)) return gdk_pixbuf_copy(*tgt);
	
	gdk_pixbuf_render_pixmap_and_mask_for_colormap (pb, 
		cmap, 
		&pixmap, NULL, 128);
	
	sandbox = gdk_pixmap_new((GdkDrawable *)pixmap, src_width,src_height,-1);
	g_object_unref(pixmap);

	if (!penGC) {
	    //GdkColor pen_color= {0,65535,65535,65535};
	    GdkColor pen_color= {0,1*256,2*256,3*256};
	    gdk_colormap_alloc_color(cmap,&pen_color,TRUE,TRUE);
	    penGC = gdk_gc_new ((GdkDrawable *)sandbox);
	    gdk_gc_set_colormap (penGC,cmap);
	    gdk_gc_set_foreground (penGC, &pen_color);
	}
	gdk_draw_rectangle (sandbox, penGC, TRUE, 0,0,src_width,src_height);
	
	/* get sandbox background */
	gdk_draw_pixbuf ((GdkDrawable *)sandbox,
                         penGC,
                         *tgt,x_tgt,y_tgt,
			 0,0, /* dest */
			 src_width,src_height,
                         GDK_RGB_DITHER_NONE,0,0);
	
	
	/* merge src pixmap with clipmask */	
	gdk_pixbuf_render_pixmap_and_mask_for_colormap (*src, 
		cmap, NULL, &mask_return, 128);	
	gdk_gc_set_clip_mask   (penGC,mask_return);
	gdk_draw_pixbuf ((GdkDrawable *)sandbox,
                         penGC,
                         *src,
                         0,0, /* src */
			 0,0, /* dest */
			 src_width,src_height,
                         GDK_RGB_DITHER_NONE,0,0);
	gdk_gc_set_clip_mask   (penGC,NULL);
	
	/* convert sandbox to pixbuf */
	gdk_pixbuf_get_from_drawable (*src,
		(GdkDrawable *)sandbox,
                cmap,
                0,0,0,0,
		src_width,src_height);

	/* unref unused objects */
	g_object_unref(G_OBJECT(sandbox));
	g_object_unref(G_OBJECT(pb));
	if (mask_return) g_object_unref(G_OBJECT(mask_return));

	gdk_pixbuf_copy_area (*src,0,0,src_width,src_height,*tgt,x_tgt,y_tgt);
	/* update alpha channel */
	/* replacing alpha channel will eliminate the shadows but will
	 * also make other parts of the icon transparent) */
	//pb=gdk_pixbuf_add_alpha (*tgt,TRUE,255,255,255);
	pb=gdk_pixbuf_add_alpha (*tgt,TRUE,1,2,3);
	
	return pb;
}


 
  
