/*
 * Copyright (C) 2003 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define __MODULES_C__
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

/*#define USE_SHMEM*/
#ifdef USE_SHMEM
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <fcntl.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gmodule.h>

#include "primary.h"
G_MODULE_EXPORT
void xffm_sanity_check(int argc, char **argv, int libxffm_serial){
    if (libxffm_serial != LIBXFFM_SERIAL){
	GtkWidget *dialog;
	gchar *p=g_strdup_printf(_("%s needs to be recompiled \n(has obsolete library headers)"),argv[0]);
	gtk_init(&argc,&argv);
	dialog = gtk_message_dialog_new (NULL,
				     0,
				     GTK_MESSAGE_QUESTION, GTK_BUTTONS_OK,
				     p);
	gtk_dialog_run(GTK_DIALOG(dialog));
	exit(0);
    }
    return;
}

typedef  xfdir_t *(xfdir_f)(record_entry_t *en,widgets_t *widgets_p);

G_MODULE_EXPORT
xfdir_t *
module_xfdir(		widgets_t *widgets_p,
			const gchar *module_name,
			record_entry_t *en)
{
    static xfdir_t *xfdir_p;
    xfdir_f *get_xfdir;

    TRACE("module_name=%s",module_name);
    
    get_xfdir = (xfdir_f *)get_xfdir_p("plugins",module_name);

    TRACE("module_xfdir: get_xfdir=0x%x",(unsigned)get_xfdir);

    if (!get_xfdir) return NULL;

    xfdir_p = (*get_xfdir)(en,widgets_p);
    return xfdir_p;
}

static 
gint compare_strings (gconstpointer a, gconstpointer b){
    return (strcmp((char *)a,(char *)b));
}


G_MODULE_EXPORT
GSList *
find_root_plugins(void)
{
    GDir *dir;
    /* FIXME: should avoid this: */
    gchar *native[]={
	"xffm_book",
	"xffm_smb_wg",
	"xffm_smb_ws",
	"xffm_smb_list",
	NULL
    };
    static GSList *plugin_list=NULL;
    GError *error=NULL;
    gchar *full_libdir=g_build_filename (LIBDIR, "xffm", "plugins",NULL);
    
    if ((dir = g_dir_open  (full_libdir, 0, &error))!=NULL)
    {
	const gchar* name;
	while ((name = g_dir_read_name (dir)) != NULL) {
	    gchar *plugin;
	    int i;
	    if (strncmp(name,"lib",strlen("lib"))) plugin=g_strdup(name);
	    else plugin=g_strdup(name+strlen("lib"));
	    if (strchr(plugin,'.')) plugin=strtok(plugin,".");
	    /* skip tests of native subplugins.
	     * third party should be queried.*/
	    for (i=0; native[i]; i++) {
		TRACE("native? %s == %s",native[i],plugin);
		if (strcmp(native[i],plugin)==0){ 
		    TRACE("yes");
		    g_free(plugin); 
		    goto endwhile;
		}
	    }
	    
	    if (g_slist_find_custom (plugin_list,plugin,compare_strings)){
		g_free(plugin);
	    } else {
		TRACE("g_slist_append %s",plugin);
		plugin_list=g_slist_append(plugin_list,plugin);
	    }
	    endwhile:;
	}
	g_dir_close(dir); 	
    }

    g_free(full_libdir);

    return plugin_list; 
}

/*************************************************************/

void unload_module(const gchar *module_name);


G_MODULE_EXPORT
GHashTable *module_hash=NULL;
typedef struct module_info_t {
    void *module_functions;
    GModule *module_cm;
} module_info_t;
    

G_MODULE_EXPORT
module_info_t  *get_module_info(const gchar *librarydir,const gchar *module_name){
    module_info_t *module_info;
    void *(*module_init)(void);
    void *(*module_sanity)(void);
    int init_version;
    
    DBG("getting module info for %s (LIBDIR=%s)",module_name,LIBDIR);
    
    if (!module_hash){
	 TRACE("creating module hash");
	 module_hash = g_hash_table_new(g_str_hash, g_str_equal);
	 if (!module_hash) g_assert_not_reached();
    }
    TRACE("looking for module in hash: %s",module_name);
    module_info=g_hash_table_lookup(module_hash,module_name);
    if (module_info) {
	 TRACE("module info found (already loaded) 0x%x",(unsigned)module_info);
	return module_info;
    } else {
	gchar *full_libdir;
	gchar *module;
	
	if (librarydir) full_libdir=g_build_filename (LIBDIR, "xffm", librarydir,NULL);
	else full_libdir=g_strdup(LIBDIR);
	module = g_module_build_path(full_libdir, module_name);
	g_free(full_libdir);
	if (!g_file_test(module,G_FILE_TEST_EXISTS)) {
	    DBG("Module %s does not exist!",module);
	    g_free(module);
	    return NULL;
	}

	DBG("loading %s",module);
	module_info=(module_info_t *)malloc(sizeof(module_info_t));
	if (!module_info) g_assert_not_reached();
	module_info->module_cm=g_module_open (module, 0);
	if (!module_info->module_cm) {
	    DBG("g_module_open(%s) == NULL",module);
	    DBG("Module cannot be opened:\n Check if correctly installed or unresolved symbols within...\n****\n");
	    g_free(module);
	    g_free(module_info);
	    return NULL;
	}
	/* module sanity */
	if (!g_module_symbol (module_info->module_cm, "module_sanity",(gpointer) &(module_sanity)) ) {
	    g_warning("Module %s is not sane!\nDoes module specify: \"LIBXFFM_MODULE\"?",module);
	    g_free(module);
	    g_free(module_info);
	    return NULL;
	} else {
	    init_version = GPOINTER_TO_INT( (*module_sanity)() );
	    if (init_version != LIBXFFM_SERIAL) {
		g_warning("Module %s is compiled with obsolete headers (not loaded)",module);
		g_free(module);
		g_free(module_info);
		return NULL;
	    }
	}
	if (!g_module_symbol (module_info->module_cm, "module_init",(gpointer) &(module_init)) ) {
	    DBG("g_module_symbol(module_init) != FALSE\n");
	    g_free(module);
	    g_free(module_info);
	    return NULL;
	}
	
	TRACE("adding module to module hash: %s (0x%x)",module_name,(unsigned)module_info);
	module_info->module_functions = (*module_init)();
	g_hash_table_insert (module_hash,(gpointer)module_name,module_info);
	TRACE("xffm: module %s successfully loaded", module);	    
	g_free(module);
	return module_info;                                      
    }
}

G_MODULE_EXPORT
void *get_xfdir_p(const gchar *librarydir,const gchar *module_name){
    xfdir_t *(*get_xfdir)(record_entry_t *);
    module_info_t *module_info;
    module_info=get_module_info(librarydir, module_name);
    if (!module_info) return NULL;
    if (!g_module_symbol (module_info->module_cm, "get_xfdir",(gpointer) &(get_xfdir)) ) 
    {
	 g_warning("g_module_symbol(get_xfdir) != FALSE in module %s\n",module_name);
	    return NULL;
    }
    return (void *)get_xfdir;
}


G_MODULE_EXPORT
 void *
function_void(		const gchar *librarydir,
			const gchar *module_name, 
			const gchar *function_id)
{
    gchar *(*function)(void);
    module_info_t *module_info;
    if (!librarydir || !module_name || !function_id) return NULL;
    module_info=get_module_info(librarydir, module_name);
    if (!module_info) return NULL;
#if 0
#ifdef USE_SHMEM
    {
     int shm;
     gchar *shm_name=g_strconcat("/",module_name,NULL);
     shm=shm_open(shm_name, O_CREAT | O_RDWR, 0700);
     if (shm) {
      void *m;
      ftruncate(shm,4*1024);
      if (fork()==0){
	m=mmap(0, 4*1024, PROT_READ | PROT_WRITE , MAP_SHARED, shm, 0);
	if (m != MAP_FAILED) {
	    strcpy((char *)m,"whatever");
	    msync(m, strlen("whatever")+1, MS_SYNC);
	} else g_warning("child mmap failed");
	TRACE("child exiting");
	_exit(123);
      } else {
	int status;
	TRACE("parent waiting");
	wait(&status);
      }
      TRACE("parent continues");
      m=mmap(0, 4*1024, PROT_READ | PROT_WRITE , MAP_SHARED, shm, 0);
      if (m != MAP_FAILED) {
	  TRACE("parent mapped value=%s",(char *)m);
	  munmap(m, 4*1024);
      } else g_warning("parent mmap failed");
      shm_unlink(shm_name);
      TRACE("parent all done");
      
     } else g_warning("shm_open failed");
     g_free(shm_name);
    }
#endif
#endif
    

    
    if (!g_module_symbol (module_info->module_cm, function_id,(gpointer) &(function)) ) 
    {
	 /*if (strcmp(function_id,"submodule_name")!=0 && strcmp(function_id,"submodule_dir")!=0)*/
	 {
	   DBG("g_module_symbol(%s) != FALSE in module %s\n",
		 function_id,module_name);
	 }
	 /*unload_module(module_name);*/
	 return NULL;
    }
    return (*function)();
}

G_MODULE_EXPORT
 void *
function_natural(		const gchar *librarydir,
			const gchar *module_name, 
			void *n,
			const gchar *function_id)
{
    gchar *(*function)(void *n);
    module_info_t *module_info;
    if (!librarydir || !module_name || !function_id) return NULL;
    module_info=get_module_info(librarydir, module_name);
    if (!module_info) return NULL;
    if (!g_module_symbol (module_info->module_cm, function_id,(gpointer) &(function)) ) 
    {
	 if (strcmp(function_id,"submodule_name")!=0 && strcmp(function_id,"submodule_dir")!=0){
	   TRACE("g_module_symbol(%s) != FALSE in module %s\n",
		 function_id,module_name);
	 }
	 /*unload_module(module_name);*/
	 return NULL;
    }
    return (*function)(n);
}


G_MODULE_EXPORT
 void *
function_rational(		const gchar *librarydir,
			const gchar *module_name, 
			void *p,
			void *q,
			const gchar *function_id)
{
    gchar *(*function)(void *p, void *q);
    module_info_t *module_info;
    if (!librarydir || !module_name || !function_id) return NULL;
    module_info=get_module_info(librarydir, module_name);
    if (!module_info) return NULL;
    if (!g_module_symbol (module_info->module_cm, function_id,(gpointer) &(function)) ) 
    {
	 if (strcmp(function_id,"submodule_name")!=0 && strcmp(function_id,"submodule_dir")!=0){
	   TRACE("g_module_symbol(%s) != FALSE in module %s\n",
		 function_id,module_name);
	 }
	 /*unload_module(module_name);*/
	 return NULL;
    }
    return (*function)(p,q);
}


G_MODULE_EXPORT
void *load_module(const gchar *librarydir,const gchar *module_name){
    module_info_t *module_info;
    module_info=get_module_info(librarydir, module_name);
    TRACE("finished load attempt of module %s (%s)",module_name,librarydir);
    if (!module_info) {
        g_warning("Show stopper: cannot get module info for %s",
    	    module_name);
        exit(0);
    }
    return module_info->module_functions;                                      
}

G_MODULE_EXPORT
void unload_module(const gchar *module_name){
    module_info_t *module_info;

    if (!module_hash) return;
    module_info = g_hash_table_lookup(module_hash,module_name);
    if (!module_info){
	   TRACE("module %s is not loaded\n",module_name);
	   return;
    }

    if (!g_module_close(module_info->module_cm)){
	   g_warning("g_module_close (%s) failed\n",module_name);
    }
    else {
	   if (!g_hash_table_remove (module_hash,module_name)){
	      g_warning ("could not remove %s from module hash",module_name);
	   }	   
	   g_free(module_info);
           TRACE ("module %s unloaded",module_name);
    }	   
}

G_MODULE_EXPORT
xfc_combo_functions *load_xfc(void){
    xfc_combo_functions *xfc_fun = (xfc_combo_functions *)load_module(NULL,"xffm_combo");
    return xfc_fun;
}

G_MODULE_EXPORT
xfmime_icon_functions *load_mime_icon_module(void){
    xfmime_icon_functions *xfmime_icon_fun=(xfmime_icon_functions *)load_module(NULL,"xffm_icons");
    return xfmime_icon_fun;
}

G_MODULE_EXPORT
xfmime_functions *load_mime_module(void){
    xfmime_functions *xfmime_fun=(xfmime_functions *)load_module(NULL,"xffm_applications");
    return xfmime_fun;
}

/*********************************************************************************************/

/* properties */
static xfprop_functions *xfprop_fun=NULL;
G_MODULE_EXPORT
void unload_prop_module(void){
    unload_module("xffm_prop");
    g_free(xfprop_fun);
    xfprop_fun=NULL;
    return;
}
G_MODULE_EXPORT
xfprop_functions *load_prop_module(void){
    xfprop_functions *xfprop_fun = (xfprop_functions *)load_module(NULL,"xffm_prop");
    return xfprop_fun;
}

/* find */
static xffind_functions *xffind_fun=NULL;
G_MODULE_EXPORT
void unload_find_module(void){
    unload_module("xffm_find");
    g_free(xffind_fun);
    xffind_fun=NULL;
    return;
}
G_MODULE_EXPORT
xffind_functions *load_find_module(void){
    if (!xffind_fun) xffind_fun=(xffind_functions *)load_module(NULL,"xffm_find");
    return xffind_fun;
}



/* trash */
static xftrash_functions *xftrash_fun=NULL;
G_MODULE_EXPORT
void unload_trash_module(void){
    unload_module("xffm_trash");
    g_free(xftrash_fun);
    xftrash_fun=NULL;
    return;
}
G_MODULE_EXPORT
xftrash_functions *load_trash_module(void){
    if (!xftrash_fun) 
	xftrash_fun=(xftrash_functions *)load_module("plugins","xffm_trash");
    return xftrash_fun;
}

