/*
 * Copyright (C) 2003-2004 Edscott Wilson Garcia
 * EMail: edscott@xfce.org
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define __COMBO_C__
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <gtk/gtksignal.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gmodule.h>

#include "constants.h"

#include <dbh.h>

#include "combo-module.h"
/* this should be first 2 lines after headers: */
G_MODULE_EXPORT
LIBXFFM_MODULE

gboolean xfc_is_in_history(char *path2dbh_file,char *path2find);
gboolean xfc_set_combo(xfc_combo_info_t *combo_info, char *token);
void xfc_set_blank(xfc_combo_info_t *combo_info);
void xfc_set_entry(xfc_combo_info_t *combo_info,char *entry_string);
const gchar *xfc_get_entry(xfc_combo_info_t *combo_info);
void xfc_save_to_history(char *path2dbh_file,char *path2save);
void xfc_remove_from_history(char *path2dbh_file,char *path2remove);
void xfc_read_history(xfc_combo_info_t *combo_info, gchar *path2dbh_file);
void xfc_clear_history(xfc_combo_info_t *combo_info);
xfc_combo_info_t *xfc_init_combo(GtkCombo *combo);
xfc_combo_info_t *xfc_destroy_combo(xfc_combo_info_t *combo_info);
/************** private ***************/

#define MAX_COMBO_ELEMENTS 13

#define HISTORY_ITEMS MAX_COMBO_ELEMENTS


#define CURSOR_KEYSTROKE(x) (								\
				x == GDK_Right || x == GDK_Left	||			\
				x == GDK_KP_Right || x == GDK_KP_Left			\
		)
		
#define BASIC_KEYSTROKE(x) (	x == GDK_KP_Divide || x == GDK_KP_Multiply ||		\
				x == GDK_KP_Subtract || x == GDK_KP_Add	||		\
				x == GDK_BackSpace || x == GDK_Delete ||		\
				x == GDK_KP_Delete || x == GDK_KP_Space ||		\
				(x >= GDK_KP_0 && x <= GDK_KP_9) ||			\
     				(x >= GDK_space && x <= GDK_asciitilde)	||		\
				(x >= GDK_Agrave && x <= GDK_Greek_switch)		\
		)

#define ENTRY_KEYSTROKE(x) (								\
				x == GDK_Escape || x == GDK_KP_Enter ||			\
				x == GDK_Return || x == GDK_Tab ||			\
				CURSOR_KEYSTROKE(x) ||					\
				BASIC_KEYSTROKE(x)					\
		)


#include "combo-module.i"

/*************************************************************************/
/*************** public *****************/

G_MODULE_EXPORT
const gchar *combo_check_init(GModule *module){
    if (xfc_fun) return NULL;
    xfc_fun = g_new0 (xfc_combo_functions,1);
    if (!xfc_fun) return ("Cannot create function structure");
    xfc_fun->extra_key_completion = NULL;
    xfc_fun->extra_key_data = NULL; 
    xfc_fun->xfc_is_in_history = xfc_is_in_history;
    xfc_fun->xfc_set_combo = xfc_set_combo;
    xfc_fun->xfc_set_blank = xfc_set_blank;
    xfc_fun->xfc_set_entry = xfc_set_entry;
    xfc_fun->xfc_get_entry = xfc_get_entry;
    xfc_fun->xfc_save_to_history = xfc_save_to_history;
    xfc_fun->xfc_remove_from_history = xfc_remove_from_history;
    xfc_fun->xfc_read_history = xfc_read_history;
    xfc_fun->xfc_clear_history = xfc_clear_history;
    xfc_fun->xfc_init_combo = xfc_init_combo;
    xfc_fun->xfc_destroy_combo = xfc_destroy_combo;
    return NULL;
}

G_MODULE_EXPORT
const gchar *g_module_check_init(GModule *module){
    return combo_check_init(NULL);
}

G_MODULE_EXPORT
void g_module_unload(GModule *module){
    if (xfc_fun) g_free(xfc_fun);
    xfc_fun=NULL;
}
G_MODULE_EXPORT gboolean 
xfc_is_in_history(char *dbh_file,char *path2save)
{
    	GString *gs;
	DBHashTable *d;
	history_dbh_t *history_dbh;
	gboolean found=FALSE;
	
	if (!path2save) return FALSE;
	if (strlen(path2save) > 255) return FALSE;
	if ((d=DBH_open(dbh_file))==NULL) return FALSE;
	gs = g_string_new(path2save);
    	sprintf((char *)DBH_KEY(d), "%10u", g_string_hash(gs));
   	g_string_free(gs, TRUE);

	history_dbh = (history_dbh_t *)DBH_DATA(d);
	if (DBH_load(d)) found=TRUE;
    	DBH_close(d);
	return found;
}


static 
void 
clear_association_hash(gpointer key, gpointer value, gpointer user_data)
{
    g_free(key);
    if (!value) return;
    g_free(value);
    return;
}



G_MODULE_EXPORT
gboolean xfc_set_combo(xfc_combo_info_t *combo_info, char *token){
    int count;
    GList *tmp,**limited_list;
    gboolean match=FALSE;
    
    /*if (!combo_info->list || !combo_info->active_dbh_file) {*/
    if (!combo_info->list) return match;
    
    combo_info->old_list = combo_info->limited_list;
    combo_info->limited_list = NULL;
    limited_list = &(combo_info->limited_list);
    TRACE("token=%s",((token) ? token: "null"));

    for (tmp=combo_info->list,count=0;tmp;tmp=tmp->next){
	gchar *p=(gchar *)tmp->data;
	if (!p) continue;
        /* if (token) TRACE("token=%s <-->%s",token,p);*/
	if (!token || strncmp(token,p,strlen(token))==0){
		if (token) match=TRUE;
		*limited_list=g_list_append(*limited_list,g_strdup(p));
		if (++count >= MAX_COMBO_ELEMENTS) break;
	}
    }

    if (*limited_list) {
	/* make sure we have utf-8 in combo. This may not match
	 * character set of actual system, such as euc-jp, so
	 * we better keep correct value in an association hash. */
	if (combo_info->association_hash){
	    /* clean old hash */
	    g_hash_table_foreach(combo_info->association_hash, clear_association_hash, NULL);
	    g_hash_table_destroy(combo_info->association_hash);
	    combo_info->association_hash = NULL;
	}
	    
	combo_info->association_hash = g_hash_table_new(g_str_hash, g_str_equal);

	if (combo_info->association_hash){
	    GList *tmp;
	    /* create new hash */
	    for (tmp=*limited_list; tmp; tmp=tmp->next){
		const gchar *utf_string;
		utf_string=combo_valid_utf_pathstring((gchar *)(tmp->data));
		/*printf("utf_string=%s\n",utf_string);*/
		if (strcmp(utf_string,(gchar *)(tmp->data))) {
		    TRACE("combo hash table %s ---> %s",(gchar *)(tmp->data),utf_string);
		    g_hash_table_insert(combo_info->association_hash,g_strdup(utf_string),tmp->data);
		    tmp->data=g_strdup(utf_string);
		}
	    }
	}
	    
	gtk_combo_set_popdown_strings(combo_info->combo,*limited_list);
	clean_history_list(&(combo_info->old_list));
    }
    else {
	    combo_info->limited_list = combo_info->old_list;
    }
   return match;
}

G_MODULE_EXPORT
void xfc_set_blank(xfc_combo_info_t *combo_info){
    char *p;
    GList **limited_list;
    xfc_set_combo(combo_info, NULL);
    limited_list = &(combo_info->limited_list);
    if (!(*limited_list)) return;
    
    p=(char *)((*limited_list)->data);
    if (strcmp(p,"")) {
	    *limited_list=g_list_prepend(*limited_list,g_strdup(""));
	    gtk_combo_set_popdown_strings(GTK_COMBO(combo_info->combo),*limited_list);
    }
}

G_MODULE_EXPORT
void xfc_set_entry(xfc_combo_info_t *combo_info,char *top){
    char *p;
    GList **limited_list;
    xfc_set_combo(combo_info, NULL);
    limited_list = &(combo_info->limited_list);
    if (!(*limited_list)) return;
    if (!top) return;
    
    p=(char *)((*limited_list)->data);
    if (strcmp(p,top)) {
	    *limited_list=g_list_prepend(*limited_list,g_strdup(top));
	    gtk_combo_set_popdown_strings(GTK_COMBO(combo_info->combo),*limited_list);
    }
}

G_MODULE_EXPORT
const gchar *xfc_get_entry(xfc_combo_info_t *combo_info){
    const gchar *choice = gtk_entry_get_text(GTK_ENTRY(combo_info->entry));
    
    if (choice && strlen(choice) && combo_info->association_hash) {
        gchar *local_choice = g_hash_table_lookup(combo_info->association_hash,choice);
	TRACE("converting back to non utf8 value %s ---> %s",
		choice,local_choice);
	if (local_choice) choice=local_choice;
    }
    if (choice) return choice;
    return "";
}

G_MODULE_EXPORT
void xfc_save_to_history(char *dbh_file,char *path2save){
    	GString *gs;
	DBHashTable *d;
	history_dbh_t *history_dbh;
	int size;
	gchar *p,*g,*h;

	if (!path2save) return;
	if (strlen(path2save) > 255) return;

	/* directory test */
	
	g=p=g_strdup(dbh_file);
	h=g_path_get_basename(dbh_file);
	p=strtok(p,G_DIR_SEPARATOR_S);
	chdir (G_DIR_SEPARATOR_S);
	if (p) do {
	    mkdir(p, 0770);
	    chdir(p);
	    p=strtok(NULL,G_DIR_SEPARATOR_S);
	} while (p != NULL && strcmp(h,p)!=0);
	chdir (g_get_home_dir());
        g_free(g);
        g_free(h);

	if ((d=DBH_open(dbh_file))==NULL){
		if ((d=DBH_create(dbh_file, 11))==NULL) {
			unlink(dbh_file);
			if ((d=DBH_create(dbh_file, 11))==NULL)	return;
		}
	}
	gs = g_string_new(path2save);
    	sprintf((char *)DBH_KEY(d), "%10u", g_string_hash(gs));
   	g_string_free(gs, TRUE);

	history_dbh = (history_dbh_t *)DBH_DATA(d);
	if (DBH_load(d)){
		history_dbh->hits++;
	} else {
		strncpy(history_dbh->path,path2save,255);
		history_dbh->hits=1;
	}
	history_dbh->last_hit=time(NULL);
	/*printf("updating %s to %d\n",history_dbh->path,history_dbh->last_hit);*/
	/* don't write more to disk than that which is necessary: */
	size= sizeof(history_dbh_t) + strlen(history_dbh->path) - 255;
	DBH_set_recordsize(d, size);
	DBH_update(d);
    	DBH_close(d);
}


G_MODULE_EXPORT
void xfc_remove_from_history(char *dbh_file,char *path2save){
    	GString *gs;
	DBHashTable *d;
	history_dbh_t *history_dbh;
	
	if (strlen(path2save) > 255) return;
	if ((d=DBH_open(dbh_file))==NULL){
		if ((d=DBH_create(dbh_file, 11))==NULL) {
			unlink(dbh_file);
			if ((d=DBH_create(dbh_file, 11))==NULL)	return;
		}
	}
	gs = g_string_new(path2save);
    	sprintf((char *)DBH_KEY(d), "%10u", g_string_hash(gs));
   	g_string_free(gs, TRUE);

	history_dbh = (history_dbh_t *)DBH_DATA(d);
	if (DBH_load(d)){
		DBH_erase(d);
	} else return;
    	DBH_close(d);
}

G_MODULE_EXPORT
xfc_combo_info_t *xfc_init_combo(GtkCombo *combo){

	
    xfc_combo_info_t *combo_info;
    
    /* XXX history for entries without combos not yet available through this module yet */ 
    if (!combo) return NULL;
    combo_check_init(NULL);
    combo_info=(xfc_combo_info_t *)malloc(sizeof(xfc_combo_info_t));
    if (!combo_info) return NULL;
    
    g_signal_connect(G_OBJECT(combo->entry), "key_press_event", 
	    G_CALLBACK(on_key_press), (gpointer) combo_info);
    g_signal_connect(G_OBJECT(combo->entry), "key_press_event", 
	    G_CALLBACK(on_key_press_history), (gpointer) combo_info);	
    g_signal_connect(G_OBJECT(combo->popwin), "key_press_event", 
	    G_CALLBACK(on_combo_history_key_press), (gpointer) combo_info);
    g_signal_connect(G_OBJECT(combo->list), "select_child",
	     G_CALLBACK(on_select_child), NULL);

#if 0
    /* nope, cant be done on button press or release...*/
    g_signal_connect(G_OBJECT(combo->popwin), "button_press_event", 
	    G_CALLBACK(button_release), (gpointer) combo_info);
#endif

    combo_info->combo = combo;
    combo_info->entry = (GtkEntry *)combo->entry;
    combo_info->active_dbh_file = NULL;
    combo_info->list = NULL;
    combo_info->cancel_user_data = NULL;
    combo_info->activate_user_data = NULL;
    combo_info->cancel_func = NULL;
    combo_info->activate_func = NULL;
    
    combo_info->limited_list = NULL;
    combo_info->association_hash = NULL;
    
    return combo_info; 
    /*g_signal_connect(G_OBJECT(GTK_COMBO (combo_info->combo)->list), "select_child",
	     G_CALLBACK(on_select_child), NULL);*/
}


G_MODULE_EXPORT
xfc_combo_info_t *xfc_destroy_combo(xfc_combo_info_t *combo_info){
	if (!combo_info) return NULL;
	g_free(combo_info->active_dbh_file);
	g_free(combo_info);
	return NULL;
}


G_MODULE_EXPORT
void xfc_read_history(xfc_combo_info_t *combo_info, gchar *dbh_file)
{

/*	printf("TRACE:at read_history_list with %s \n",dbh_file);*/
    g_return_if_fail (combo_info != NULL);
    g_return_if_fail (dbh_file != NULL);
    g_free(combo_info->active_dbh_file);
    combo_info->active_dbh_file = g_strdup(dbh_file);
    if (access(combo_info->active_dbh_file,F_OK)!=0){
   	clean_history_list(&(combo_info->list));	
	combo_info->list=NULL;
    }
    get_history_list(&(combo_info->list),combo_info->active_dbh_file,"");
    /* turn asian off to start with. If the combo object does not
     * do a read_history to start, then it has no business being a combo
     * object */
    asian=FALSE;
    return;
}


G_MODULE_EXPORT
void xfc_clear_history(xfc_combo_info_t *combo_info)
{

/*	printf("TRACE:at read_history_list with %s \n",dbh_file);*/
    g_return_if_fail (combo_info != NULL);
    clean_history_list(&(combo_info->list));	
    combo_info->list=NULL;
    return;
}

G_MODULE_EXPORT
xfc_combo_functions *module_init(void){
    combo_check_init(NULL);
    return xfc_fun;
}



