/*
 * libyahoo2 - originally from gaim patches by Amatus
 *
 * Copyright (C) 2003-2004
 *
 * Some code copyright (C) 1998-1999, Mark Spencer <markster@marko.net>
 * libfaim code copyright 1998, 1999 Adam Fritzler <afritz@auk.cx>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "yahoo_fn.h"

unsigned char table_0[256] = {
   0x5A, 0x41, 0x11, 0x77, 0x29, 0x9C, 0x31, 0xAD,
   0x4A, 0x32, 0x1A, 0x6D, 0x56, 0x9F, 0x39, 0xA6,
   0x0C, 0xE8, 0x49, 0x40, 0xA4, 0x21, 0xE9, 0x01,
   0x91, 0x86, 0x2F, 0xB9, 0xED, 0x80, 0x51, 0xAB,
   0x7F, 0x92, 0xF2, 0x73, 0xCD, 0xD9, 0x75, 0x2A,
   0x70, 0x34, 0x35, 0x8D, 0xA8, 0x72, 0x7D, 0x9B,
   0x2E, 0xC5, 0x2D, 0x76, 0x1E, 0xBB, 0xE7, 0x37,
   0xBA, 0xB7, 0xB2, 0x03, 0x20, 0x17, 0x8A, 0x07,
   0xD6, 0x96, 0x13, 0x95, 0xE5, 0xF1, 0x18, 0x3B,
   0xA5, 0x62, 0x33, 0xC1, 0x44, 0x3D, 0x6C, 0xA7,
   0xBF, 0x1C, 0x60, 0xFF, 0x5B, 0xF5, 0x8E, 0xE6,
   0x5C, 0xCC, 0xF7, 0x69, 0x15, 0x0F, 0x0B, 0xBD,
   0x12, 0x9D, 0xB3, 0x65, 0x53, 0xB1, 0x14, 0xF4,
   0x19, 0x3E, 0xB6, 0x45, 0xCB, 0xA2, 0x7A, 0xD3,
   0xF8, 0xD1, 0x61, 0xEE, 0xBC, 0xC6, 0xB0, 0x5D,
   0x4B, 0x09, 0x26, 0xE1, 0x1D, 0x6E, 0xC3, 0xFB,
   0x68, 0x4C, 0x42, 0x52, 0x5F, 0xDE, 0xFD, 0xEF,
   0x81, 0x04, 0x6F, 0xE0, 0xF0, 0x1F, 0x0D, 0x7C,
   0x58, 0x4F, 0x1B, 0x30, 0xCF, 0x9A, 0x2B, 0x05,
   0xF6, 0x3F, 0x78, 0xAC, 0xD8, 0xEC, 0xE2, 0x25,
   0x93, 0xDA, 0x84, 0x8C, 0x4E, 0xD5, 0x38, 0x0A,
   0x06, 0x7E, 0xD4, 0x59, 0x98, 0xE3, 0x36, 0xC2,
   0xD2, 0xA3, 0x10, 0x79, 0xFA, 0xC9, 0x16, 0x27,
   0x66, 0x89, 0xFE, 0x57, 0xF3, 0x83, 0xB8, 0x28,
   0x3C, 0xC7, 0xCE, 0x71, 0xC8, 0xDB, 0x22, 0xE4,
   0xDD, 0xDF, 0x02, 0x8F, 0x5E, 0xEB, 0x48, 0x2C,
   0x08, 0xC4, 0x43, 0xEA, 0x50, 0x55, 0x90, 0x54,
   0x87, 0xCA, 0x00, 0x24, 0x6B, 0x85, 0x97, 0xD7,
   0xDC, 0x6A, 0x67, 0xD0, 0x88, 0xA1, 0x9E, 0xC0,
   0x46, 0xAE, 0x64, 0x74, 0x4D, 0xA0, 0x99, 0xB5,
   0x0E, 0x8B, 0xAA, 0x3A, 0xB4, 0xFC, 0xA9, 0x94,
   0x7B, 0xBE, 0xF9, 0xAF, 0x82, 0x63, 0x47, 0x23 };

unsigned char table_1[256] = {
   0x08, 0xCB, 0x54, 0xCF, 0x97, 0x53, 0x59, 0xF1,
   0x66, 0xEC, 0xDB, 0x1B, 0xB1, 0xE2, 0x36, 0xEB,
   0xB3, 0x8F, 0x71, 0xA8, 0x90, 0x7D, 0xDA, 0xDC,
   0x2C, 0x2F, 0xE8, 0x6A, 0x73, 0x37, 0xAE, 0xCC,
   0xA1, 0x16, 0xE6, 0xFC, 0x9C, 0xA9, 0x2A, 0x3F,
   0x58, 0xFD, 0x56, 0x4C, 0xA5, 0xF2, 0x33, 0x99,
   0x1A, 0xB7, 0xFE, 0xA6, 0x1E, 0x32, 0x9E, 0x48,
   0x03, 0x4A, 0x78, 0xEE, 0xCA, 0xC3, 0x88, 0x7A,
   0xAC, 0x23, 0xAA, 0xBD, 0xDE, 0xD3, 0x67, 0x43,
   0xFF, 0x64, 0x8A, 0xF9, 0x04, 0xD0, 0x7B, 0xC2,
   0xBC, 0xF3, 0x89, 0x0E, 0xDD, 0xAB, 0x9D, 0x84,
   0x5A, 0x62, 0x7F, 0x6D, 0x82, 0x68, 0xA3, 0xED,
   0x2E, 0x07, 0x41, 0xEF, 0x2D, 0x70, 0x4F, 0x69,
   0x8E, 0xE7, 0x0F, 0x11, 0x19, 0xAF, 0x31, 0xFB,
   0x8D, 0x4B, 0x5F, 0x96, 0x75, 0x42, 0x6C, 0x46,
   0xE4, 0x55, 0xD6, 0x3B, 0xE1, 0xD1, 0xB0, 0xB5,
   0x45, 0x29, 0xC0, 0x94, 0x9F, 0xD4, 0x15, 0x17,
   0x3C, 0x47, 0xC8, 0xD9, 0xC6, 0x76, 0xB9, 0x02,
   0xE0, 0xC9, 0xB2, 0x01, 0xC1, 0x5D, 0x4E, 0x14,
   0xF4, 0xAD, 0xB6, 0x00, 0x72, 0xF0, 0x49, 0x0D,
   0xD8, 0x5E, 0x6F, 0x2B, 0x8C, 0x51, 0x83, 0xC5,
   0x0A, 0x85, 0xE5, 0x38, 0x7E, 0x26, 0xEA, 0x22,
   0x6B, 0x06, 0xD5, 0x8B, 0xBF, 0xC7, 0x35, 0x1D,
   0xF6, 0x24, 0x28, 0xCE, 0x9B, 0x77, 0x20, 0x60,
   0xF5, 0x87, 0x3D, 0x65, 0x86, 0x0C, 0xDF, 0xBA,
   0x12, 0xA4, 0x3A, 0x34, 0xD7, 0xA0, 0xF8, 0x63,
   0x52, 0x27, 0xB8, 0x18, 0xA7, 0x13, 0x91, 0x09,
   0x93, 0x5C, 0x10, 0x9A, 0xB4, 0xE9, 0x44, 0xC4,
   0x21, 0x57, 0x1C, 0x0B, 0xA2, 0x74, 0x4D, 0xBE,
   0xD2, 0x1F, 0xCD, 0xE3, 0x6E, 0x7C, 0x40, 0x50,
   0x39, 0x80, 0x98, 0xFA, 0x25, 0x92, 0x30, 0x5B,
   0x05, 0x95, 0xBB, 0x79, 0x61, 0x3E, 0x81, 0xF7 };

unsigned char table_2[32] = {
   0x19, 0x05, 0x09, 0x1C, 0x0B, 0x1A, 0x12, 0x03,
   0x06, 0x04, 0x0D, 0x1D, 0x15, 0x0E, 0x1B, 0x18,
   0x00, 0x07, 0x08, 0x02, 0x13, 0x1F, 0x0C, 0x1E,
   0x16, 0x0A, 0x10, 0x0F, 0x01, 0x14, 0x11, 0x17 };

unsigned char table_3[256] = {
   0xBC, 0x1B, 0xCC, 0x1E, 0x5B, 0x59, 0x4F, 0xA8,
   0x62, 0xC6, 0xC1, 0xBB, 0x83, 0x2D, 0xA3, 0xA6,
   0x5A, 0xDC, 0xE5, 0x93, 0xFB, 0x5C, 0xD6, 0x2A,
   0x97, 0xC7, 0x1C, 0x73, 0x08, 0x45, 0xD2, 0x89,
   0x4A, 0xD4, 0xCF, 0x0C, 0x1D, 0xD8, 0xCD, 0x26,
   0x8F, 0x11, 0x55, 0x8B, 0xD3, 0x53, 0xCE, 0x00,
   0xB5, 0x3B, 0x2E, 0x39, 0x88, 0x7B, 0x85, 0x46,
   0x54, 0xA5, 0x31, 0x40, 0x3E, 0x0A, 0x4C, 0x68,
   0x70, 0x0F, 0xBA, 0x0E, 0x75, 0x8A, 0xEB, 0x44,
   0x60, 0x6C, 0x05, 0xC9, 0xF0, 0xDD, 0x0D, 0x66,
   0xAB, 0xA1, 0xAD, 0xF2, 0x12, 0x6A, 0xE6, 0x27,
   0xF6, 0x9F, 0xDB, 0xB8, 0xF4, 0x56, 0x5E, 0x2C,
   0xDA, 0xFE, 0x34, 0x86, 0xF5, 0xC2, 0xB0, 0xF1,
   0xCB, 0xF3, 0x78, 0x9B, 0x7F, 0xB4, 0xD7, 0x58,
   0x74, 0x07, 0x72, 0x96, 0x02, 0xCA, 0xAC, 0xE8,
   0x5D, 0xA7, 0x32, 0xBD, 0x81, 0x43, 0x18, 0xF8,
   0x15, 0x0B, 0xE9, 0x76, 0x30, 0xBF, 0x3A, 0x22,
   0x9E, 0xD1, 0x79, 0x37, 0xBE, 0x8C, 0x7A, 0x98,
   0x21, 0x95, 0x10, 0x8D, 0xDF, 0xC0, 0x69, 0xC8,
   0x03, 0x6E, 0x4B, 0x36, 0xFC, 0x6F, 0xA9, 0x48,
   0x63, 0xE1, 0xB9, 0x24, 0x87, 0x13, 0xB2, 0xA4,
   0x84, 0x06, 0x14, 0x61, 0x3D, 0x92, 0xB1, 0x41,
   0xE2, 0x71, 0xAF, 0x16, 0xDE, 0x25, 0x82, 0xD9,
   0x2B, 0x33, 0x51, 0xA2, 0x4E, 0x7D, 0x94, 0xFF,
   0xFD, 0x5F, 0x80, 0xED, 0x64, 0xE7, 0x50, 0x6D,
   0xD0, 0x3C, 0x6B, 0x65, 0x77, 0x17, 0x1A, 0xEC,
   0xD5, 0xAA, 0xF9, 0xC4, 0x9C, 0x35, 0xE3, 0x42,
   0xE4, 0x19, 0x52, 0x67, 0xB7, 0x9D, 0x28, 0xC5,
   0x47, 0x38, 0x91, 0x57, 0xAE, 0x3F, 0x29, 0x9A,
   0x2F, 0xF7, 0x90, 0x04, 0xEE, 0xFA, 0x20, 0xB6,
   0xEA, 0x49, 0x23, 0x4D, 0xB3, 0x8E, 0xC3, 0x1F,
   0x7C, 0xEF, 0xE0, 0x99, 0x09, 0xA0, 0x01, 0x7E };

unsigned char table_4[32] = {
   0x1F, 0x0B, 0x00, 0x1E, 0x03, 0x0E, 0x15, 0x01,
   0x1A, 0x17, 0x1D, 0x1B, 0x11, 0x0F, 0x0A, 0x12,
   0x13, 0x18, 0x02, 0x04, 0x09, 0x06, 0x0D, 0x07,
   0x08, 0x05, 0x10, 0x19, 0x0C, 0x14, 0x16, 0x1C };

unsigned char table_5[256] = {
   0x9A, 0xAB, 0x61, 0x28, 0x0A, 0x23, 0xFC, 0xBA,
   0x90, 0x22, 0xB7, 0x62, 0xD9, 0x09, 0x91, 0xF4,
   0x7B, 0x5D, 0x6B, 0x80, 0xAC, 0x9E, 0x21, 0x72,
   0x64, 0x2D, 0xFF, 0x66, 0xEB, 0x5B, 0x05, 0xC8,
   0x1B, 0xD1, 0x55, 0xF5, 0x97, 0x08, 0xAE, 0xC7,
   0x00, 0xDE, 0xE1, 0x78, 0xD8, 0xB6, 0xF0, 0x17,
   0xE4, 0x32, 0xCD, 0x76, 0x07, 0x14, 0x7F, 0x7A,
   0xBF, 0xB4, 0x1D, 0x94, 0x48, 0x75, 0xFA, 0xA7,
   0x99, 0x7E, 0x65, 0x38, 0x29, 0x51, 0xC3, 0x83,
   0x7C, 0x0D, 0xA0, 0xCC, 0xF1, 0xDD, 0xE2, 0x49,
   0xF8, 0xD2, 0x25, 0x54, 0x9B, 0x0E, 0xB9, 0xFE,
   0x67, 0xC4, 0xCE, 0x13, 0xD4, 0xE7, 0xB8, 0x41,
   0x77, 0xDB, 0xA6, 0xB0, 0x11, 0x6A, 0x5E, 0x68,
   0x8D, 0xF9, 0x36, 0xD3, 0xC2, 0x3A, 0xAA, 0x59,
   0x03, 0xE0, 0xE3, 0xF3, 0x42, 0x2C, 0x04, 0x47,
   0xE6, 0x93, 0xCB, 0x6E, 0x20, 0xCA, 0x01, 0xA1,
   0x40, 0x2B, 0x2F, 0x5F, 0x87, 0xD0, 0xEC, 0x88,
   0x27, 0x58, 0xC6, 0x3E, 0xDF, 0x26, 0x5C, 0xE9,
   0x1F, 0x0F, 0x95, 0x1C, 0xFB, 0xA5, 0x12, 0x39,
   0x1E, 0x3C, 0x33, 0x43, 0x56, 0xE8, 0x82, 0xF7,
   0x7D, 0x89, 0xF2, 0xD7, 0x50, 0x92, 0x60, 0x4C,
   0x2A, 0x86, 0x16, 0x6C, 0x37, 0xC0, 0xAD, 0xB3,
   0x24, 0x45, 0xB1, 0xA2, 0x71, 0xA4, 0xA3, 0xED,
   0xC9, 0x5A, 0x4D, 0x84, 0x0C, 0x3F, 0xC5, 0x9D,
   0x63, 0x19, 0x79, 0x57, 0x96, 0x30, 0x74, 0xBB,
   0xDA, 0x1A, 0x9F, 0x44, 0xC1, 0x98, 0xE5, 0x81,
   0xD6, 0x18, 0x8F, 0xFD, 0x8E, 0x06, 0x6F, 0xF6,
   0x2E, 0x3B, 0xB5, 0x85, 0x8A, 0x9C, 0x53, 0x4A,
   0xA9, 0x52, 0x3D, 0x4E, 0xBE, 0xAF, 0xBC, 0xA8,
   0x4F, 0x6D, 0x15, 0x35, 0x8C, 0xBD, 0x34, 0x8B,
   0xDC, 0x0B, 0xCF, 0x31, 0xEA, 0xB2, 0x70, 0x4B,
   0x46, 0x73, 0x69, 0xD5, 0x10, 0xEE, 0x02, 0xEF };

unsigned char table_6[32] = {
   0x1A, 0x1C, 0x0F, 0x0C, 0x00, 0x02, 0x13, 0x09,
   0x11, 0x05, 0x0D, 0x12, 0x18, 0x0B, 0x04, 0x10,
   0x14, 0x1B, 0x1E, 0x16, 0x07, 0x08, 0x03, 0x17,
   0x19, 0x1F, 0x01, 0x0E, 0x15, 0x06, 0x0A, 0x1D };

unsigned char table_7[256] = {
   0x52, 0x11, 0x72, 0xD0, 0x76, 0xD7, 0xAE, 0x03,
   0x7F, 0x19, 0xF4, 0xB8, 0xB3, 0x5D, 0xCA, 0x2D,
   0x5C, 0x30, 0x53, 0x1A, 0x57, 0xF6, 0xAD, 0x83,
   0x29, 0x79, 0xD5, 0xF0, 0x0F, 0xC3, 0x8B, 0xD3,
   0x8E, 0x37, 0x01, 0xA6, 0xF1, 0x10, 0x04, 0x71,
   0xCC, 0xC6, 0xE7, 0xC2, 0x85, 0x94, 0xBD, 0x6F,
   0xCB, 0xEA, 0xFC, 0xA1, 0x38, 0x5E, 0x08, 0x2E,
   0x35, 0x42, 0x67, 0xD4, 0x56, 0x6D, 0x7C, 0xE5,
   0x0E, 0x7D, 0x12, 0x65, 0xF5, 0x33, 0x82, 0xC4,
   0x1D, 0xD2, 0x16, 0x58, 0xEC, 0xCD, 0xA8, 0xBF,
   0xAB, 0x07, 0x45, 0x55, 0xB7, 0x6A, 0x70, 0xF2,
   0xBE, 0x05, 0x6B, 0x9D, 0xEB, 0x13, 0x0D, 0x9F,
   0xE8, 0xA7, 0xC8, 0x31, 0x3C, 0xB6, 0x21, 0xC0,
   0x20, 0x60, 0x6C, 0xE2, 0xCE, 0x8C, 0xFD, 0x95,
   0xE3, 0x4A, 0xB5, 0xB2, 0x40, 0xB1, 0xF3, 0x17,
   0xF9, 0x24, 0x06, 0x22, 0x2F, 0x25, 0x93, 0x8A,
   0x2A, 0x7E, 0x28, 0x3D, 0x47, 0xF8, 0x89, 0xA5,
   0x7B, 0x9B, 0xC5, 0x84, 0x59, 0x46, 0x90, 0x74,
   0x69, 0xC7, 0xAA, 0xEE, 0x6E, 0xD6, 0xB0, 0x18,
   0x66, 0xA0, 0x7A, 0x1E, 0xFB, 0xDB, 0x4E, 0x51,
   0x92, 0xE4, 0xE0, 0x3E, 0xB4, 0xD8, 0x23, 0x3B,
   0xC1, 0x5F, 0xFE, 0x98, 0x99, 0x73, 0x09, 0xA9,
   0xA3, 0xDF, 0x14, 0x5A, 0x26, 0x8F, 0x0B, 0xAF,
   0x4C, 0x97, 0x54, 0xE1, 0x63, 0x48, 0xED, 0xBA,
   0xCF, 0xBB, 0x1F, 0xDC, 0xA4, 0xFA, 0x64, 0x75,
   0xDE, 0x81, 0x9A, 0xFF, 0x49, 0x41, 0x27, 0x62,
   0x02, 0x15, 0xD9, 0x86, 0xAC, 0x3F, 0x0C, 0x61,
   0xD1, 0x77, 0x2B, 0x1B, 0x96, 0xDA, 0x68, 0x1C,
   0x44, 0x32, 0xBC, 0xA2, 0x87, 0xF7, 0x91, 0x8D,
   0x80, 0xDD, 0x0A, 0x50, 0x34, 0x4B, 0x00, 0xB9,
   0x36, 0xE6, 0x78, 0x4F, 0xC9, 0xE9, 0x2C, 0x43,
   0x88, 0x9E, 0x9C, 0x5B, 0x4D, 0x3A, 0x39, 0xEF };

unsigned char table_8[32] = {
   0x13, 0x08, 0x1E, 0x1D, 0x17, 0x16, 0x07, 0x1F,
   0x0E, 0x03, 0x1A, 0x19, 0x01, 0x12, 0x11, 0x10,
   0x09, 0x0C, 0x0F, 0x14, 0x0B, 0x05, 0x00, 0x04,
   0x1C, 0x18, 0x0A, 0x15, 0x02, 0x1B, 0x06, 0x0D };

unsigned char table_9[256] = {
   0x20, 0x2A, 0xDA, 0xFE, 0x76, 0x0D, 0xED, 0x39,
   0x51, 0x4C, 0x46, 0x9A, 0xF1, 0xB0, 0x10, 0xC7,
   0xD1, 0x6F, 0x18, 0x24, 0xB9, 0x7A, 0x4F, 0x47,
   0xE0, 0x4E, 0x88, 0x09, 0x8A, 0xBA, 0x60, 0xBD,
   0xC2, 0x27, 0x93, 0x7D, 0x94, 0x40, 0xCB, 0x80,
   0xB8, 0x41, 0x84, 0x5D, 0xC1, 0x0F, 0x5E, 0x78,
   0x2B, 0x48, 0x28, 0x29, 0xEE, 0x81, 0x90, 0x86,
   0x50, 0x9C, 0xF3, 0xB2, 0x35, 0x52, 0x0C, 0x9D,
   0xFC, 0x69, 0xD6, 0xA6, 0x06, 0xD7, 0xC6, 0xFF,
   0x1C, 0x14, 0x57, 0x33, 0xE2, 0x1F, 0x83, 0xA8,
   0xF7, 0x99, 0xC5, 0xDC, 0x70, 0x9E, 0xF4, 0x6B,
   0x0A, 0x77, 0x95, 0x4A, 0x2E, 0x53, 0xF2, 0x62,
   0x98, 0xF8, 0x96, 0xDB, 0xE6, 0x32, 0x3C, 0x58,
   0xD5, 0x6D, 0xE7, 0x4B, 0xCE, 0x91, 0x43, 0xD8,
   0xFA, 0xE3, 0x4D, 0xD9, 0x68, 0xDE, 0xEC, 0x01,
   0x08, 0xD3, 0x8F, 0x19, 0xC4, 0xA7, 0x6E, 0x3E,
   0x63, 0x12, 0x72, 0x42, 0x9F, 0xB4, 0x04, 0x1B,
   0x7E, 0x11, 0x17, 0x73, 0xB5, 0x22, 0x56, 0xA1,
   0x89, 0xDD, 0xF5, 0x3F, 0x49, 0x26, 0x8D, 0x15,
   0x85, 0x75, 0x5F, 0x65, 0x82, 0xB6, 0xF6, 0xD2,
   0xA4, 0x55, 0x37, 0xC8, 0xA0, 0xCC, 0x66, 0x5C,
   0xC9, 0x25, 0x36, 0x67, 0x7C, 0xE1, 0xA3, 0xCF,
   0xA9, 0x59, 0x2F, 0xFB, 0xBB, 0x07, 0x87, 0xA2,
   0x44, 0x92, 0x13, 0x00, 0x16, 0x61, 0x38, 0xEB,
   0xAE, 0xD4, 0x1E, 0x64, 0x6A, 0xE4, 0xCA, 0x1D,
   0x6C, 0xDF, 0xAB, 0x5B, 0x03, 0x7B, 0x9B, 0x8C,
   0x5A, 0xFD, 0xC3, 0xB3, 0x0B, 0xAA, 0xAC, 0x8B,
   0xBE, 0xBC, 0x3D, 0x97, 0xCD, 0x05, 0x21, 0x8E,
   0xAD, 0xEA, 0x54, 0x30, 0xAF, 0x02, 0xB1, 0x34,
   0x0E, 0xA5, 0x3B, 0x45, 0x1A, 0x23, 0xE8, 0x7F,
   0xEF, 0xB7, 0x31, 0xD0, 0xBF, 0x3A, 0x79, 0xE5,
   0xF9, 0xF0, 0x2C, 0x74, 0xE9, 0x71, 0xC0, 0x2D };

unsigned char table_10[32] = {
   0x1D, 0x12, 0x11, 0x0D, 0x1E, 0x19, 0x16, 0x1B,
   0x18, 0x13, 0x07, 0x17, 0x0C, 0x02, 0x00, 0x15,
   0x0E, 0x08, 0x05, 0x01, 0x10, 0x06, 0x04, 0x0F,
   0x1F, 0x1A, 0x0B, 0x09, 0x0A, 0x14, 0x1C, 0x03 };

unsigned char table_11[256] = {
   0x6B, 0x1D, 0xC6, 0x0A, 0xB7, 0xAC, 0xB2, 0x11,
   0x29, 0xD3, 0xA2, 0x4D, 0xCB, 0x03, 0xEF, 0xA6,
   0xC1, 0x5D, 0x75, 0x48, 0x35, 0x6C, 0xE2, 0x84,
   0xAB, 0xAA, 0xD8, 0x2C, 0x0E, 0x95, 0x25, 0x27,
   0x7D, 0x0B, 0xD0, 0xFB, 0x14, 0xE5, 0xF2, 0x4E,
   0x7F, 0x2A, 0x63, 0x3C, 0xC9, 0xF6, 0xDC, 0x07,
   0x26, 0x55, 0xCF, 0x2B, 0xCD, 0xA7, 0x17, 0xD2,
   0x9A, 0x7B, 0x93, 0x78, 0x9E, 0xE6, 0x2F, 0x49,
   0x1E, 0xFD, 0xF0, 0xFE, 0x7C, 0x33, 0x92, 0xA3,
   0xC8, 0xA0, 0xA9, 0xC4, 0xA1, 0x94, 0x6D, 0x44,
   0x0C, 0x90, 0x3A, 0x8C, 0x8E, 0x85, 0xAF, 0x40,
   0x36, 0xA4, 0xD1, 0xB9, 0x19, 0x6F, 0xF4, 0xBA,
   0x1A, 0x73, 0xD9, 0xB5, 0xB4, 0x7A, 0xF9, 0x83,
   0x58, 0xAD, 0xCE, 0x60, 0x98, 0xDB, 0x1C, 0x1B,
   0x52, 0xB8, 0xF3, 0x96, 0xED, 0xDE, 0xB3, 0xEE,
   0x4F, 0xBD, 0x10, 0xD4, 0x43, 0xEA, 0xE7, 0x37,
   0x12, 0x3D, 0xA8, 0x22, 0x65, 0xEC, 0x5B, 0x08,
   0x9D, 0x0D, 0x5C, 0xB6, 0x8A, 0x79, 0x3F, 0x04,
   0xD6, 0x01, 0xE1, 0xBE, 0xDD, 0x50, 0xFA, 0x41,
   0x13, 0x91, 0xF7, 0xDA, 0x18, 0xB0, 0x45, 0x81,
   0x4C, 0xF5, 0x32, 0x23, 0x56, 0x5A, 0xEB, 0x97,
   0x34, 0x00, 0x77, 0x71, 0x4B, 0x70, 0xD5, 0x31,
   0x72, 0x05, 0xDF, 0xE8, 0x15, 0x3B, 0x54, 0x16,
   0x89, 0xE4, 0xF1, 0xD7, 0x80, 0x82, 0x4A, 0xE3,
   0x39, 0x06, 0x47, 0x28, 0xC2, 0x86, 0x87, 0xB1,
   0x62, 0x74, 0x53, 0x21, 0x67, 0x38, 0x42, 0xCA,
   0x9B, 0xC3, 0x51, 0x99, 0x8B, 0x1F, 0x24, 0x8D,
   0xF8, 0x68, 0x3E, 0x59, 0xBB, 0x61, 0x5F, 0xBC,
   0x09, 0x6E, 0x8F, 0x0F, 0x2D, 0xC0, 0xE0, 0x46,
   0x66, 0x69, 0xA5, 0xE9, 0x30, 0x9C, 0x5E, 0xAE,
   0xBF, 0xC7, 0x20, 0x7E, 0x6A, 0xC5, 0x88, 0xFC,
   0x64, 0x76, 0xFF, 0x9F, 0x2E, 0x02, 0xCC, 0x57 };

unsigned char table_12[32] = {
   0x14, 0x1B, 0x18, 0x00, 0x1F, 0x15, 0x17, 0x07,
   0x11, 0x1A, 0x0E, 0x13, 0x12, 0x06, 0x01, 0x03,
   0x1C, 0x0C, 0x0B, 0x1D, 0x10, 0x0F, 0x09, 0x19,
   0x0D, 0x1E, 0x04, 0x05, 0x08, 0x16, 0x0A, 0x02 };

unsigned char table_13[256] = {
   0x37, 0x8A, 0x1B, 0x91, 0xA5, 0x2B, 0x2D, 0x88,
   0x8E, 0xFE, 0x0E, 0xD3, 0xF3, 0xE9, 0x7D, 0xD1,
   0x24, 0xEA, 0xB1, 0x8B, 0x5C, 0xA4, 0x44, 0x7E,
   0x8C, 0x2C, 0x73, 0xD5, 0x50, 0x3E, 0xD7, 0x18,
   0xB9, 0xD6, 0xBA, 0x94, 0x0C, 0xFC, 0xCB, 0xB4,
   0x0D, 0x63, 0x4C, 0xDE, 0x77, 0x16, 0xFD, 0x81,
   0x3C, 0x11, 0x45, 0x36, 0xF6, 0x67, 0x95, 0x6D,
   0x6A, 0x1A, 0xA3, 0xC5, 0x92, 0x10, 0x28, 0x84,
   0x48, 0xA6, 0x23, 0xE3, 0x4B, 0xE1, 0xF5, 0x19,
   0xE0, 0x2E, 0x00, 0x61, 0x74, 0xCC, 0xF7, 0xB0,
   0x68, 0xC8, 0x40, 0x6F, 0x59, 0x52, 0x26, 0x99,
   0xC9, 0xF9, 0xC4, 0x53, 0x9B, 0xEC, 0x03, 0x17,
   0xE2, 0x06, 0x30, 0x7B, 0xBE, 0xCD, 0x1D, 0x3B,
   0xD2, 0x5B, 0x65, 0x21, 0x49, 0xB7, 0x79, 0xCF,
   0x82, 0x86, 0xC7, 0x62, 0xEE, 0x8D, 0xFF, 0xD4,
   0xC3, 0x85, 0xA7, 0xFA, 0xA9, 0x6B, 0xF2, 0x69,
   0x9C, 0x38, 0x78, 0xBD, 0x7F, 0xDD, 0xCE, 0xA1,
   0x33, 0xC2, 0x43, 0xEB, 0xD8, 0xE6, 0x2A, 0xE4,
   0x76, 0x6C, 0xAA, 0x46, 0x05, 0xE7, 0xA0, 0x0A,
   0x71, 0x98, 0x41, 0x5F, 0x0F, 0xEF, 0x51, 0xAD,
   0xF0, 0xED, 0x96, 0x5A, 0x42, 0x3F, 0xBF, 0x6E,
   0xBC, 0x5D, 0xC1, 0x15, 0x70, 0x54, 0x4D, 0x14,
   0xB5, 0xCA, 0x27, 0x80, 0x87, 0x39, 0x60, 0x47,
   0x9D, 0x2F, 0x56, 0x1F, 0xBB, 0x31, 0xF1, 0xE8,
   0xB3, 0x9E, 0x5E, 0x7C, 0xD0, 0xC6, 0xB2, 0x57,
   0x83, 0xAC, 0x09, 0x8F, 0xA2, 0x90, 0x13, 0x25,
   0x01, 0x08, 0x64, 0xB6, 0x02, 0xDB, 0x55, 0x32,
   0xAF, 0x9A, 0xC0, 0x1C, 0x12, 0x29, 0x0B, 0x72,
   0x4F, 0xDA, 0xAB, 0x35, 0xF8, 0x22, 0xD9, 0x4E,
   0x3D, 0x1E, 0xDC, 0x58, 0x20, 0x34, 0xAE, 0x66,
   0x75, 0x93, 0x9F, 0x3A, 0x07, 0xE5, 0x89, 0xDF,
   0x97, 0x4A, 0xB8, 0x7A, 0xF4, 0xFB, 0x04, 0xA8 };

unsigned char table_14[32] = {
   0x04, 0x14, 0x13, 0x15, 0x1A, 0x1B, 0x0F, 0x16,
   0x02, 0x0D, 0x0C, 0x06, 0x10, 0x17, 0x01, 0x0B,
   0x1E, 0x08, 0x1C, 0x18, 0x19, 0x0A, 0x1F, 0x05,
   0x11, 0x09, 0x1D, 0x07, 0x0E, 0x12, 0x03, 0x00 };

unsigned char table_15[256] = {
   0x61, 0x48, 0x58, 0x41, 0x7F, 0x88, 0x43, 0x42,
   0xD9, 0x80, 0x81, 0xFE, 0xC6, 0x49, 0xD7, 0x2C,
   0xE6, 0x5B, 0xEE, 0xFF, 0x2A, 0x6F, 0xBF, 0x98,
   0xD6, 0x20, 0xB9, 0xB1, 0x5D, 0x95, 0x72, 0x1E,
   0x82, 0x96, 0xDE, 0xC1, 0x40, 0xD8, 0x70, 0xA3,
   0xD1, 0x1F, 0xF0, 0x9F, 0x2D, 0xDC, 0x3F, 0xF9,
   0x5E, 0x0D, 0x15, 0x2F, 0x67, 0x31, 0x9D, 0x84,
   0x97, 0x0C, 0xF6, 0x79, 0xC2, 0xA7, 0xC0, 0x32,
   0xB3, 0xEB, 0xED, 0x71, 0x30, 0xCC, 0x4B, 0xA0,
   0xF5, 0xC4, 0xCD, 0x27, 0xFA, 0x11, 0x25, 0xDB,
   0x4F, 0xE2, 0x7E, 0xA6, 0xAF, 0x34, 0x69, 0x63,
   0x8F, 0x08, 0x1C, 0x85, 0xF1, 0x57, 0x78, 0xC8,
   0xA2, 0x83, 0xB5, 0x68, 0xF7, 0x64, 0x45, 0x26,
   0x3B, 0x03, 0xAD, 0x3C, 0x50, 0xD5, 0x77, 0xFC,
   0xFB, 0x18, 0xC9, 0xD2, 0x9C, 0xBB, 0xBA, 0x76,
   0x23, 0x55, 0xD3, 0x5A, 0x01, 0xE9, 0x87, 0x07,
   0x19, 0x09, 0x39, 0x8A, 0x91, 0x93, 0x12, 0xDF,
   0x22, 0xA8, 0xCF, 0x4E, 0x4D, 0x65, 0xB0, 0x0F,
   0x13, 0x53, 0x21, 0x8C, 0xE5, 0xB7, 0x0B, 0x0E,
   0x6C, 0x44, 0xCA, 0x7B, 0xC5, 0x6E, 0xCE, 0xE3,
   0x14, 0x29, 0xAC, 0x2E, 0xE7, 0x59, 0xE8, 0x0A,
   0xEA, 0x66, 0x7C, 0x94, 0x6D, 0x05, 0x9E, 0x9A,
   0x2B, 0x38, 0x6A, 0xCB, 0x51, 0xEF, 0x06, 0xDA,
   0xFD, 0x47, 0x92, 0x1D, 0xA5, 0x37, 0x33, 0xEC,
   0xB4, 0x52, 0x56, 0xC3, 0xF4, 0xF8, 0x8B, 0xD0,
   0xA4, 0x5F, 0x28, 0x89, 0x75, 0xC7, 0x04, 0x00,
   0xE4, 0x86, 0x36, 0x3A, 0x99, 0x16, 0x7D, 0xE0,
   0x7A, 0x4C, 0x54, 0x46, 0x73, 0xB2, 0xF3, 0xE1,
   0x62, 0xBE, 0x90, 0x4A, 0x24, 0x6B, 0x3E, 0xAA,
   0x1B, 0xF2, 0x60, 0xD4, 0xA9, 0x9B, 0x1A, 0xB8,
   0xA1, 0x35, 0xAE, 0xB6, 0x10, 0x5C, 0x17, 0xBC,
   0xAB, 0x8D, 0x02, 0x74, 0xBD, 0x3D, 0x8E, 0xDD };

unsigned char table_16[256] = {
   0x3F, 0x9C, 0x17, 0xC1, 0x59, 0xC6, 0x23, 0x93,
   0x4B, 0xDF, 0xCB, 0x55, 0x2B, 0xDE, 0xCD, 0xAD,
   0xB3, 0xE7, 0x42, 0x2F, 0x02, 0x5A, 0x7B, 0x5C,
   0x8F, 0xD1, 0x11, 0xCE, 0xEC, 0xF6, 0xA4, 0xE6,
   0x58, 0x98, 0x6A, 0x99, 0xFB, 0x9B, 0x53, 0x21,
   0x8A, 0x09, 0x2E, 0x3C, 0x22, 0x38, 0xAC, 0x07,
   0x91, 0x46, 0xA9, 0x95, 0xC3, 0x14, 0x84, 0xDB,
   0x36, 0x68, 0x1D, 0xDD, 0xF9, 0x12, 0xE0, 0x3D,
   0x8D, 0x4D, 0x05, 0x86, 0x69, 0xC0, 0xD3, 0xD5,
   0xA5, 0xC9, 0xE5, 0x67, 0x6D, 0xE2, 0x7F, 0xFE,
   0xB2, 0x0F, 0x62, 0xCF, 0x37, 0x35, 0xF3, 0x28,
   0x16, 0xA6, 0x50, 0x76, 0x80, 0x00, 0x31, 0x97,
   0x39, 0x7C, 0x25, 0x0C, 0x64, 0xF2, 0x52, 0x1A,
   0x92, 0x4F, 0x2A, 0x56, 0x03, 0x4C, 0xBD, 0x10,
   0xB7, 0x2C, 0x8C, 0xAE, 0x73, 0xB9, 0xE9, 0xF7,
   0xA7, 0xE1, 0x75, 0xBC, 0xC5, 0x1C, 0x3A, 0x63,
   0x7A, 0x4A, 0x29, 0xD2, 0x71, 0xE8, 0x08, 0xA1,
   0xD4, 0xFD, 0x13, 0xFA, 0xA0, 0x27, 0x41, 0x72,
   0x82, 0x18, 0x51, 0x60, 0x5E, 0x66, 0x0D, 0xAA,
   0xD8, 0x1F, 0xAF, 0x45, 0xD0, 0xF1, 0x9F, 0x6B,
   0xE4, 0x44, 0x89, 0xEE, 0xC4, 0x0B, 0x6C, 0xCC,
   0x83, 0x77, 0xA2, 0x87, 0x0A, 0xA8, 0xED, 0x90,
   0x74, 0x6E, 0xF5, 0xAB, 0xA3, 0xB6, 0x5F, 0x0E,
   0x04, 0x9A, 0xB4, 0x8E, 0xF0, 0xFF, 0x88, 0xB5,
   0xF8, 0xBF, 0x8B, 0x6F, 0x4E, 0x79, 0x40, 0xCA,
   0x24, 0x26, 0xDC, 0x33, 0xEB, 0x2D, 0x5B, 0x1B,
   0x9D, 0xC7, 0x49, 0x48, 0x54, 0x85, 0xEF, 0xD7,
   0xC2, 0xB8, 0xC8, 0x5D, 0xD9, 0x3B, 0x15, 0xBB,
   0x65, 0xE3, 0xD6, 0x30, 0x3E, 0x1E, 0x32, 0x9E,
   0x57, 0x81, 0x34, 0x06, 0xFC, 0xBA, 0x7D, 0x20,
   0x70, 0xDA, 0x7E, 0x47, 0x94, 0x61, 0xB0, 0x78,
   0xF4, 0xBE, 0xEA, 0x19, 0x43, 0x01, 0xB1, 0x96 };

unsigned char table_17[256] = {
   0x7E, 0xF1, 0xD3, 0x75, 0x87, 0xA6, 0xED, 0x9E,
   0xA9, 0xD5, 0xC6, 0xBF, 0xE6, 0x6A, 0xEE, 0x4B,
   0x34, 0xDF, 0x4C, 0x7D, 0xDD, 0xFE, 0x3F, 0xAF,
   0x66, 0x2D, 0x74, 0x6F, 0xFC, 0x4F, 0x5F, 0x88,
   0x29, 0x7B, 0xC7, 0x2A, 0x70, 0xE8, 0x1D, 0xDE,
   0xD0, 0x55, 0x71, 0x81, 0xC4, 0x0D, 0x50, 0x4E,
   0x58, 0x00, 0x96, 0x97, 0xBB, 0xD7, 0x53, 0x15,
   0x6C, 0x40, 0x17, 0xC9, 0xFF, 0x8F, 0x94, 0xFB,
   0x19, 0x9A, 0x3E, 0xB5, 0x5A, 0x5E, 0x86, 0x24,
   0xB8, 0x77, 0xBA, 0x85, 0x51, 0x18, 0xBE, 0x59,
   0x79, 0xF3, 0xD4, 0xC3, 0xAB, 0x28, 0xFD, 0x25,
   0x41, 0x91, 0x07, 0x8D, 0xAE, 0x49, 0xF5, 0x80,
   0x35, 0xA1, 0x9C, 0x3C, 0xE2, 0x65, 0xB3, 0xE0,
   0x16, 0xCB, 0x12, 0x6B, 0xF7, 0xB1, 0x93, 0x8A,
   0xCE, 0x54, 0x4D, 0xF8, 0x13, 0xA2, 0x95, 0x46,
   0xEA, 0x61, 0x57, 0x9D, 0x27, 0x8B, 0x3D, 0x60,
   0x36, 0x68, 0x06, 0x56, 0xB6, 0x1B, 0xD2, 0x89,
   0x10, 0xA7, 0xC5, 0x1A, 0x0B, 0x2C, 0xBD, 0x14,
   0x0A, 0xDC, 0x23, 0xA8, 0xE1, 0x04, 0x02, 0xC0,
   0xB2, 0x9B, 0xE3, 0x2E, 0x33, 0x7C, 0x32, 0xAC,
   0x7A, 0x39, 0xB0, 0xF9, 0x98, 0x5B, 0x3A, 0x48,
   0x21, 0x90, 0xB9, 0x20, 0xF0, 0xA0, 0x09, 0x1F,
   0x2F, 0xEF, 0xEB, 0x22, 0x78, 0x82, 0x37, 0xD6,
   0xD1, 0x84, 0x76, 0x01, 0xDB, 0x43, 0xC2, 0xB7,
   0x7F, 0xA4, 0xE5, 0xC1, 0x1C, 0x69, 0x05, 0xEC,
   0xD8, 0x38, 0x67, 0x42, 0x72, 0xBC, 0x73, 0xAD,
   0xA3, 0xE9, 0x4A, 0x8E, 0x47, 0x1E, 0xC8, 0x6E,
   0xDA, 0x5D, 0x2B, 0xF6, 0x30, 0x63, 0xCC, 0xF4,
   0xCD, 0x8C, 0x0F, 0x3B, 0xE7, 0xD9, 0xCF, 0xB4,
   0x03, 0x92, 0x0E, 0x31, 0xE4, 0x08, 0xF2, 0x45,
   0xCA, 0x83, 0x26, 0x5C, 0xA5, 0x44, 0x64, 0x6D,
   0x9F, 0x99, 0x62, 0xAA, 0xFA, 0x11, 0x0C, 0x52 };

unsigned char table_18[256] = {
   0x0F, 0x42, 0x3D, 0x86, 0x3E, 0x66, 0xFE, 0x5C,
   0x52, 0xE2, 0xA3, 0xB3, 0xCE, 0x16, 0xCC, 0x95,
   0xB0, 0x8B, 0x82, 0x3B, 0x93, 0x7D, 0x62, 0x08,
   0x1C, 0x6E, 0xBB, 0xCB, 0x1D, 0x88, 0x69, 0xD4,
   0xC9, 0x40, 0x1F, 0xBE, 0x27, 0xBC, 0xDB, 0x38,
   0xE5, 0xA1, 0x71, 0xBA, 0x8A, 0x5E, 0xFD, 0x36,
   0x8F, 0x26, 0x6B, 0xE4, 0x20, 0x6D, 0xC5, 0xDE,
   0xE0, 0x83, 0x7C, 0xD5, 0xD9, 0x4D, 0xDC, 0xE3,
   0x0D, 0x32, 0xED, 0x0E, 0x2F, 0x21, 0xA7, 0x79,
   0xA0, 0xD3, 0x8C, 0x14, 0x6F, 0xB7, 0xF8, 0x85,
   0x5D, 0x37, 0x24, 0xD6, 0x25, 0xD2, 0x8E, 0xA5,
   0xB8, 0xCD, 0x5A, 0x9F, 0x05, 0xAD, 0x65, 0x9E,
   0x4F, 0x5B, 0x56, 0xF0, 0xAA, 0xC2, 0x28, 0xA8,
   0x6A, 0x01, 0x99, 0x2E, 0xA6, 0x77, 0x74, 0x64,
   0x76, 0x15, 0x90, 0x75, 0xAF, 0xE8, 0x39, 0x48,
   0x09, 0x11, 0xE1, 0x2D, 0xEC, 0xB5, 0x7A, 0xB1,
   0x94, 0x13, 0x41, 0x4C, 0x02, 0xA9, 0x97, 0xDF,
   0xC3, 0x8D, 0xEA, 0x3A, 0x9C, 0xD1, 0xA2, 0x9A,
   0xD7, 0x59, 0xD8, 0x18, 0xDA, 0x47, 0x89, 0x81,
   0xC7, 0xF5, 0xFC, 0x98, 0xCA, 0x91, 0x06, 0x68,
   0xC8, 0x07, 0x4A, 0x84, 0x0A, 0xE7, 0x33, 0x2C,
   0xEB, 0xDD, 0x5F, 0xAC, 0x23, 0x1A, 0x35, 0x70,
   0x43, 0x80, 0x61, 0xAE, 0xC1, 0xD0, 0x7B, 0x92,
   0x49, 0x51, 0x53, 0xC4, 0x34, 0x30, 0x0C, 0x4B,
   0x00, 0x04, 0x10, 0xFF, 0x63, 0x44, 0xB4, 0x0B,
   0x57, 0x72, 0xF1, 0x9D, 0x19, 0xF6, 0xB2, 0x87,
   0x1B, 0xEE, 0x46, 0x2A, 0xF3, 0xBF, 0x12, 0x96,
   0x58, 0x2B, 0xF9, 0xB6, 0xCF, 0x22, 0x3C, 0xAB,
   0x1E, 0x6C, 0x31, 0xC6, 0xF7, 0x78, 0x45, 0x17,
   0xE9, 0x7E, 0x73, 0xF2, 0x55, 0xFB, 0x3F, 0x9B,
   0xF4, 0xBD, 0xA4, 0x29, 0x60, 0x03, 0xB9, 0x50,
   0xFA, 0x4E, 0xEF, 0x54, 0xE6, 0x7F, 0xC0, 0x67 };

unsigned char table_19[256] = {
   0xEA, 0xE7, 0x13, 0x14, 0xB9, 0xC0, 0xC4, 0x42,
   0x49, 0x6E, 0x2A, 0xA6, 0x65, 0x3C, 0x6A, 0x40,
   0x07, 0xCD, 0x4F, 0xFE, 0xF2, 0x2D, 0xC8, 0x30,
   0x9D, 0xBE, 0x1B, 0x9B, 0x4A, 0x7E, 0x9F, 0xA7,
   0x78, 0xAB, 0x4D, 0x1D, 0xF1, 0x96, 0x32, 0x84,
   0xFB, 0x80, 0x88, 0xE8, 0x41, 0x97, 0xDC, 0xD0,
   0x4E, 0x33, 0xA4, 0x3B, 0xE0, 0xDD, 0x36, 0xC9,
   0x72, 0x48, 0x8A, 0x2F, 0x35, 0xF0, 0xDF, 0x21,
   0xE1, 0xE5, 0x6C, 0x9A, 0x60, 0x8F, 0xB7, 0x24,
   0xE4, 0x9E, 0x8C, 0x0F, 0x3D, 0x28, 0xBB, 0xD6,
   0x69, 0xA0, 0x66, 0xC7, 0xE3, 0xD8, 0x11, 0x27,
   0xD9, 0x37, 0xF4, 0xF5, 0x8E, 0xD4, 0x76, 0xE2,
   0xDB, 0x15, 0xA2, 0x5C, 0x9C, 0xEE, 0x44, 0xED,
   0x2B, 0xB3, 0x75, 0x74, 0x71, 0x8B, 0x3A, 0x91,
   0x06, 0x19, 0xC1, 0x57, 0x89, 0xCC, 0x82, 0x10,
   0x17, 0xB2, 0x08, 0x70, 0x39, 0xCA, 0xBA, 0xB5,
   0xAA, 0xBF, 0x02, 0xBD, 0x26, 0x58, 0x04, 0x54,
   0x23, 0x4B, 0x90, 0x51, 0x6D, 0x98, 0xD5, 0xB0,
   0xAF, 0x22, 0xDA, 0xB4, 0x87, 0xFC, 0x7D, 0x18,
   0x6F, 0x64, 0x59, 0x09, 0x0C, 0xA5, 0x5D, 0x03,
   0x0A, 0xD3, 0xCE, 0x99, 0x8D, 0xC2, 0xC3, 0x62,
   0xD2, 0x83, 0x1A, 0xAC, 0x7C, 0x93, 0xD7, 0xA9,
   0x16, 0xF7, 0x77, 0xE6, 0x3E, 0x05, 0x73, 0x55,
   0x43, 0x95, 0x7A, 0x6B, 0x38, 0x67, 0x3F, 0xC6,
   0xAD, 0x0E, 0x29, 0x46, 0x45, 0xFA, 0xBC, 0xEC,
   0x5B, 0x7F, 0x0B, 0x1C, 0x01, 0x12, 0x85, 0x50,
   0xF9, 0xEF, 0x25, 0x34, 0x79, 0x2E, 0xEB, 0x00,
   0x5F, 0x86, 0xF8, 0x4C, 0xA8, 0x56, 0xB6, 0x5A,
   0xF3, 0x31, 0x94, 0x92, 0xB1, 0xB8, 0x52, 0xD1,
   0xCF, 0xCB, 0xA1, 0x81, 0x68, 0x47, 0xFF, 0xC5,
   0xFD, 0x1F, 0xDE, 0x53, 0xA3, 0x2C, 0x20, 0xF6,
   0x1E, 0x0D, 0xAE, 0x7B, 0x5E, 0x61, 0xE9, 0x63 };

unsigned char table_20[32] = {
   0x0D, 0x0B, 0x11, 0x02, 0x05, 0x1B, 0x08, 0x1D,
   0x04, 0x14, 0x01, 0x09, 0x00, 0x19, 0x1E, 0x15,
   0x1F, 0x0A, 0x0F, 0x1C, 0x10, 0x16, 0x0C, 0x07,
   0x13, 0x1A, 0x06, 0x17, 0x0E, 0x12, 0x18, 0x03 };

unsigned char table_21[256] = {
   0x4C, 0x94, 0xAD, 0x66, 0x9E, 0x69, 0x04, 0xA8,
   0x61, 0xE0, 0xE1, 0x3D, 0xFD, 0x9C, 0xFB, 0x19,
   0x1E, 0x80, 0x8C, 0xA0, 0xFC, 0x27, 0x26, 0x3B,
   0x48, 0x6D, 0x07, 0xE4, 0xEA, 0x17, 0x64, 0x9B,
   0xD0, 0xE2, 0xD1, 0x13, 0x39, 0xF5, 0x73, 0xD3,
   0x0C, 0x3A, 0x6E, 0x77, 0xFA, 0xE3, 0x2F, 0x44,
   0x7E, 0x72, 0x30, 0x43, 0xD4, 0x7F, 0x36, 0xD9,
   0xBD, 0x3E, 0x3F, 0x91, 0xBE, 0x54, 0x79, 0xA6,
   0x7C, 0x0E, 0xC5, 0x7A, 0x70, 0xC4, 0xD7, 0xCE,
   0xDA, 0xAA, 0x68, 0x8F, 0xBC, 0x96, 0x1B, 0x16,
   0xA2, 0xC6, 0x67, 0x09, 0x45, 0x9F, 0xCF, 0x41,
   0xC8, 0x60, 0x74, 0x99, 0x5D, 0x85, 0x5F, 0x50,
   0x33, 0x52, 0x22, 0xA9, 0xB5, 0x2D, 0x98, 0x87,
   0x15, 0x9A, 0xAC, 0x2C, 0xDE, 0xC0, 0xB8, 0x37,
   0x88, 0x1F, 0xC1, 0x4F, 0x65, 0x0F, 0x3C, 0x84,
   0x4B, 0x1A, 0xAB, 0xA4, 0x23, 0xCB, 0xB1, 0xC7,
   0xDB, 0xEF, 0x40, 0x0D, 0x46, 0xE8, 0xF4, 0x71,
   0x38, 0x01, 0x5C, 0x0B, 0x5E, 0xC9, 0xAF, 0xC3,
   0xF6, 0xB6, 0x10, 0x1D, 0xE5, 0x8A, 0x90, 0xA7,
   0xA3, 0x05, 0x4E, 0x14, 0x63, 0x25, 0x34, 0xEC,
   0x6B, 0x95, 0x21, 0x55, 0xF2, 0xF0, 0x47, 0x9D,
   0xF8, 0x8E, 0x02, 0x0A, 0xED, 0x97, 0xAE, 0x00,
   0x2A, 0xEB, 0xB2, 0xA5, 0x32, 0x06, 0x2E, 0xFE,
   0x8D, 0x7B, 0x7D, 0x35, 0x5A, 0xD2, 0xF1, 0xE9,
   0xF9, 0x62, 0xB7, 0xB9, 0x53, 0x75, 0x5B, 0x8B,
   0xCC, 0x6C, 0x18, 0x49, 0x89, 0x31, 0xB0, 0x92,
   0x6F, 0xDF, 0x03, 0x57, 0xF3, 0x58, 0xCA, 0x2B,
   0x93, 0xA1, 0xD6, 0x24, 0x29, 0xCD, 0x59, 0x1C,
   0x83, 0xB3, 0x42, 0xBF, 0x82, 0xB4, 0x11, 0x4A,
   0x08, 0xEE, 0x76, 0x4D, 0x12, 0xDC, 0xE6, 0xC2,
   0x56, 0xBA, 0x86, 0x28, 0x6A, 0x20, 0x51, 0xF7,
   0xFF, 0xD8, 0xE7, 0xDD, 0xBB, 0x78, 0xD5, 0x81 };

unsigned char table_22[32] = {
   0x0B, 0x15, 0x1C, 0x0C, 0x06, 0x0A, 0x1D, 0x16,
   0x12, 0x0E, 0x04, 0x11, 0x1F, 0x0F, 0x07, 0x02,
   0x17, 0x13, 0x19, 0x18, 0x0D, 0x10, 0x1A, 0x05,
   0x03, 0x00, 0x01, 0x08, 0x09, 0x14, 0x1B, 0x1E };

unsigned char table_23[256] = {
   0x36, 0x53, 0x2D, 0xD0, 0x7A, 0xF0, 0xD5, 0x1C,
   0x50, 0x61, 0x9A, 0x90, 0x0B, 0x29, 0x20, 0x77,
   0xF1, 0x82, 0xFE, 0xC1, 0xA7, 0xB6, 0x78, 0x87,
   0x02, 0x05, 0xCB, 0x28, 0xAE, 0xD6, 0x17, 0x1A,
   0x91, 0x5D, 0xB9, 0xE2, 0xDE, 0x6A, 0x4E, 0x07,
   0xAC, 0x38, 0x13, 0x3B, 0x46, 0xFD, 0xB7, 0xD1,
   0x79, 0xFB, 0x58, 0x76, 0x08, 0x47, 0x95, 0xA6,
   0x99, 0x9E, 0x12, 0x67, 0xC2, 0xED, 0x9C, 0x1B,
   0x89, 0x71, 0xB5, 0x4A, 0xAA, 0x5F, 0x34, 0x85,
   0x40, 0x2B, 0x9F, 0x37, 0x7C, 0x0F, 0xD4, 0x75,
   0x48, 0x27, 0x2E, 0xC9, 0xEB, 0x06, 0xDF, 0x8C,
   0x14, 0xAF, 0xEE, 0xA2, 0x74, 0x45, 0x8D, 0x70,
   0x6B, 0xD7, 0x56, 0xCF, 0xBC, 0x7B, 0x01, 0xC8,
   0x54, 0xB0, 0x3C, 0x39, 0xFA, 0x81, 0xDC, 0xBB,
   0x0D, 0xB2, 0xAD, 0x93, 0xC7, 0x8A, 0x73, 0x6C,
   0xC3, 0x04, 0x2F, 0xEF, 0x52, 0x33, 0x9D, 0x1E,
   0xC5, 0x65, 0x23, 0xD8, 0xB1, 0xD2, 0xE5, 0x25,
   0x2C, 0xE6, 0x92, 0xB4, 0xF7, 0xF4, 0x8F, 0x6E,
   0xE8, 0x5A, 0x8E, 0x7D, 0x4C, 0xB3, 0xFF, 0x41,
   0x26, 0xE3, 0x30, 0x69, 0xF8, 0x80, 0x57, 0x4F,
   0xA0, 0x7F, 0x66, 0x68, 0xE1, 0x7E, 0x0E, 0x31,
   0xE7, 0xEA, 0x3E, 0x8B, 0x4B, 0x94, 0xE9, 0xCD,
   0x19, 0x35, 0xA3, 0x98, 0xD9, 0x5B, 0x44, 0x2A,
   0xE0, 0x6D, 0xF3, 0xE4, 0x72, 0x18, 0x03, 0x59,
   0x84, 0x09, 0xA1, 0x9B, 0xBD, 0xDA, 0x4D, 0x63,
   0xCC, 0x3A, 0x10, 0xFC, 0x3F, 0x0A, 0x88, 0x24,
   0xF5, 0x21, 0xC4, 0x6F, 0x1F, 0x42, 0x62, 0x64,
   0x51, 0xDD, 0xCA, 0xF9, 0x22, 0xCE, 0xA8, 0x86,
   0xBA, 0xB8, 0x5C, 0xAB, 0x32, 0x00, 0x0C, 0xF2,
   0x83, 0xDB, 0xF6, 0x60, 0x3D, 0x16, 0xEC, 0x11,
   0xA4, 0xBE, 0x96, 0x5E, 0x97, 0xD3, 0xA5, 0x55,
   0x1D, 0x15, 0xC6, 0xBF, 0xA9, 0x43, 0xC0, 0x49 };

unsigned char table_24[256] = {
   0xDC, 0x5A, 0xE6, 0x59, 0x64, 0xDA, 0x58, 0x40,
   0x95, 0xF8, 0x2A, 0xE0, 0x39, 0x7E, 0x32, 0x89,
   0x09, 0x93, 0xED, 0x55, 0xC3, 0x5B, 0x1A, 0xD1,
   0xA5, 0x8B, 0x0F, 0x13, 0xC9, 0xE1, 0x34, 0xD0,
   0xB6, 0xA2, 0xD9, 0x52, 0x57, 0x83, 0xFD, 0xE9,
   0xAC, 0x73, 0x6E, 0x21, 0xF1, 0x0E, 0x25, 0xCC,
   0x36, 0xFB, 0xF7, 0x92, 0x15, 0x30, 0x54, 0x91,
   0xD6, 0x9E, 0xAA, 0x35, 0x70, 0xB2, 0xC0, 0x27,
   0xFE, 0x04, 0xBC, 0xC7, 0x02, 0xFA, 0x7D, 0xE3,
   0xBE, 0x62, 0x79, 0x2B, 0x31, 0x6A, 0x8F, 0x7F,
   0x56, 0xF0, 0xB4, 0x0C, 0x1F, 0x68, 0xB7, 0xB9,
   0x0B, 0x14, 0x3E, 0xA9, 0x4B, 0x03, 0x10, 0xEE,
   0x2C, 0xAB, 0x8A, 0x77, 0xB1, 0xE7, 0xCA, 0xD4,
   0x98, 0x01, 0xAD, 0x1E, 0x50, 0x26, 0x82, 0x44,
   0xF3, 0xBF, 0xD3, 0x6B, 0x33, 0x0A, 0x3C, 0x5D,
   0xCE, 0x81, 0xC5, 0x78, 0x9F, 0xB8, 0x23, 0xDB,
   0x4E, 0xA1, 0x41, 0x76, 0xAE, 0x51, 0x86, 0x06,
   0x7A, 0x66, 0xA0, 0x5E, 0x29, 0x17, 0x84, 0x4A,
   0xB0, 0x3B, 0x3D, 0x71, 0x07, 0x7B, 0x0D, 0x9A,
   0x6F, 0x9B, 0x5C, 0x88, 0xB3, 0xD7, 0x24, 0xD5,
   0x48, 0xF5, 0xE8, 0xE4, 0xCF, 0x16, 0xA4, 0xC8,
   0xEF, 0x42, 0x22, 0xEC, 0x47, 0x69, 0x90, 0x63,
   0xE2, 0x1B, 0x87, 0x85, 0x3F, 0xDE, 0x8C, 0x60,
   0x99, 0xE5, 0x8E, 0x4F, 0xF4, 0xBA, 0xB5, 0x9C,
   0x37, 0x67, 0xBD, 0xA6, 0x97, 0xDD, 0xCB, 0x43,
   0x45, 0x19, 0x49, 0x1C, 0x75, 0xC1, 0xBB, 0xF2,
   0x46, 0xFC, 0x53, 0x9D, 0xD8, 0xA3, 0xDF, 0x2F,
   0xEB, 0x72, 0x94, 0xA8, 0x6D, 0xC6, 0x28, 0x4C,
   0x00, 0x38, 0xC2, 0x65, 0x05, 0x2E, 0xD2, 0x12,
   0xFF, 0x18, 0x61, 0x6C, 0x7C, 0x11, 0xAF, 0x96,
   0xCD, 0x20, 0x74, 0x08, 0x1D, 0xC4, 0xF9, 0x4D,
   0xEA, 0x8D, 0x2D, 0x5F, 0xF6, 0xA7, 0x80, 0x3A };

unsigned char table_25[32] = {
   0x0A, 0x11, 0x17, 0x03, 0x05, 0x0B, 0x18, 0x13,
   0x09, 0x02, 0x00, 0x1C, 0x0C, 0x08, 0x1B, 0x14,
   0x06, 0x0E, 0x01, 0x0D, 0x16, 0x1E, 0x1D, 0x19,
   0x0F, 0x1A, 0x10, 0x04, 0x12, 0x15, 0x07, 0x1F };

unsigned char table_26[32] = {
   0x19, 0x13, 0x1B, 0x01, 0x1C, 0x0D, 0x0C, 0x15,
   0x0B, 0x00, 0x1A, 0x0F, 0x12, 0x16, 0x08, 0x0A,
   0x03, 0x06, 0x14, 0x10, 0x18, 0x04, 0x11, 0x1D,
   0x1F, 0x07, 0x17, 0x05, 0x02, 0x0E, 0x1E, 0x09 };

unsigned char table_27[256] = {
   0x72, 0xF0, 0x14, 0xCB, 0x61, 0xA5, 0xB2, 0x02,
   0x75, 0x22, 0xC3, 0x9D, 0x5A, 0x63, 0xFA, 0x5F,
   0xD9, 0x55, 0x58, 0x43, 0x24, 0x7D, 0x77, 0x93,
   0xBA, 0x50, 0x1D, 0xF7, 0x49, 0x18, 0xB0, 0x42,
   0xBB, 0xEC, 0x52, 0x38, 0xDC, 0xC8, 0x16, 0x54,
   0x17, 0x19, 0x89, 0x67, 0x33, 0x3C, 0x0A, 0xAD,
   0xC9, 0xDE, 0x81, 0xED, 0xBD, 0x0E, 0x0B, 0x6D,
   0x46, 0x30, 0x35, 0x2B, 0x8C, 0xA0, 0x1C, 0x0D,
   0xFD, 0xA1, 0x70, 0xC6, 0xD8, 0x41, 0xB3, 0xC0,
   0x44, 0xEB, 0x92, 0xBE, 0x6B, 0x98, 0x1A, 0x76,
   0x71, 0xC5, 0x51, 0x56, 0x80, 0xFC, 0x01, 0x53,
   0x4B, 0xD0, 0x8B, 0xD2, 0x7B, 0xE7, 0x15, 0x5D,
   0xE5, 0xA6, 0x8A, 0xD3, 0x9B, 0xF4, 0x69, 0x23,
   0xE8, 0xB6, 0xC7, 0xE2, 0x73, 0x9F, 0x88, 0xDF,
   0xB4, 0x28, 0xEE, 0xC2, 0x94, 0xB8, 0xF9, 0x7F,
   0x4A, 0x57, 0x06, 0xF6, 0xBF, 0xC1, 0xAB, 0xFB,
   0xA4, 0x8E, 0xD1, 0xD7, 0xF5, 0x7C, 0xA3, 0x1E,
   0x3B, 0x32, 0x03, 0xAA, 0x90, 0x5C, 0x48, 0xE0,
   0xE3, 0xCF, 0xD4, 0xEF, 0x59, 0xD5, 0x1B, 0x34,
   0x1F, 0x95, 0xCE, 0x7A, 0x20, 0x26, 0x87, 0xB7,
   0x78, 0x9C, 0x4F, 0xA2, 0x12, 0x97, 0x27, 0x3F,
   0xFF, 0x07, 0x84, 0x96, 0x04, 0xAF, 0xA8, 0xEA,
   0x2C, 0x6C, 0xAE, 0x37, 0x91, 0xA9, 0x10, 0xDB,
   0xCD, 0xDA, 0x08, 0x99, 0xF1, 0x4D, 0xCC, 0x68,
   0x79, 0x2E, 0xB1, 0x39, 0x9E, 0xE9, 0x2F, 0x6A,
   0x3D, 0x0F, 0x85, 0x8D, 0xCA, 0x29, 0x86, 0xD6,
   0xDD, 0x05, 0x25, 0x3A, 0x40, 0x21, 0x45, 0xAC,
   0x11, 0xF3, 0xA7, 0x09, 0x2A, 0x31, 0xE4, 0x0C,
   0xF8, 0x6E, 0x3E, 0xB5, 0x82, 0xFE, 0x74, 0x13,
   0x65, 0xE1, 0x2D, 0x8F, 0xE6, 0xC4, 0x00, 0x5B,
   0x4E, 0xB9, 0x66, 0xF2, 0x62, 0x36, 0x4C, 0x83,
   0x5E, 0x6F, 0x47, 0x64, 0xBC, 0x9A, 0x60, 0x7E };

unsigned char table_28[32] = {
   0x15, 0x05, 0x08, 0x19, 0x02, 0x18, 0x1E, 0x07,
   0x0D, 0x0C, 0x1A, 0x06, 0x17, 0x03, 0x10, 0x09,
   0x01, 0x11, 0x1C, 0x04, 0x0F, 0x1F, 0x12, 0x0B,
   0x1B, 0x13, 0x0A, 0x16, 0x0E, 0x00, 0x1D, 0x14 };

unsigned char table_29[256] = {
   0x34, 0x59, 0x05, 0x13, 0x09, 0x1D, 0xDF, 0x77,
   0x11, 0xA5, 0x92, 0x27, 0xCD, 0x7B, 0x5E, 0x80,
   0xF9, 0x50, 0x18, 0x24, 0xD4, 0x70, 0x4A, 0x39,
   0x66, 0xA4, 0xDB, 0xE9, 0xED, 0x48, 0xD9, 0xE7,
   0x32, 0xDA, 0x53, 0x8F, 0x72, 0xE1, 0xF6, 0xFE,
   0xD3, 0xAD, 0xA6, 0x1F, 0xB9, 0xD1, 0x0F, 0x4C,
   0x23, 0x90, 0x68, 0xBC, 0x4B, 0x9B, 0x3D, 0xAB,
   0xF0, 0x94, 0x4F, 0x1C, 0x07, 0x65, 0x7F, 0x01,
   0x5C, 0xD7, 0x21, 0x8C, 0xBF, 0x8E, 0xB8, 0x86,
   0x6C, 0x33, 0x36, 0xC1, 0x06, 0x74, 0x37, 0x84,
   0x41, 0xAE, 0x67, 0x29, 0xB4, 0x85, 0xCE, 0x2A,
   0xCB, 0x1E, 0x61, 0x9E, 0x7A, 0x44, 0x3E, 0x89,
   0x14, 0x20, 0x19, 0xBB, 0xE0, 0xAA, 0xCF, 0x83,
   0xA8, 0x93, 0x43, 0xF2, 0xAC, 0x0E, 0xD2, 0xCC,
   0xDD, 0x47, 0x58, 0xC9, 0xCA, 0x1B, 0x54, 0x6E,
   0x8A, 0x79, 0xF8, 0xC4, 0xFB, 0xD5, 0x91, 0xDE,
   0x12, 0x31, 0x99, 0xFA, 0x6D, 0xC8, 0x57, 0xEC,
   0xB7, 0x28, 0x0C, 0x52, 0xF1, 0x0D, 0xB1, 0x9A,
   0x26, 0x98, 0x16, 0x7D, 0xD0, 0x2E, 0x8B, 0xD8,
   0xE6, 0xE8, 0x30, 0xFD, 0x7C, 0x64, 0x5A, 0xBD,
   0x87, 0xE2, 0xA1, 0x3F, 0xC3, 0x38, 0x96, 0xA3,
   0x2D, 0xF3, 0x3A, 0xEE, 0xC0, 0x10, 0xEA, 0x6F,
   0x8D, 0x03, 0xF4, 0x51, 0x97, 0x7E, 0x56, 0x42,
   0x3C, 0x5D, 0x5F, 0xF5, 0x6A, 0xAF, 0xE4, 0xBE,
   0xBA, 0x78, 0xA0, 0x5B, 0x49, 0xA7, 0xC7, 0x9C,
   0x63, 0x6B, 0x00, 0x17, 0x69, 0x75, 0x3B, 0x40,
   0xEF, 0x45, 0xB5, 0x2B, 0x2F, 0x02, 0xC6, 0x22,
   0x9F, 0xFC, 0x73, 0x08, 0x81, 0xB2, 0x2C, 0x71,
   0x35, 0xA2, 0xE3, 0xB3, 0x9D, 0xC5, 0x0A, 0xC2,
   0x25, 0x82, 0xDC, 0x88, 0xA9, 0xE5, 0xF7, 0xEB,
   0xD6, 0x60, 0x76, 0x55, 0x0B, 0x4E, 0xFF, 0x1A,
   0x46, 0x62, 0xB6, 0xB0, 0x15, 0x04, 0x95, 0x4D };

unsigned char table_30[32] = {
   0x00, 0x1C, 0x0E, 0x0C, 0x06, 0x16, 0x09, 0x12,
   0x01, 0x13, 0x0B, 0x14, 0x11, 0x08, 0x04, 0x18,
   0x10, 0x1B, 0x15, 0x03, 0x02, 0x19, 0x1A, 0x17,
   0x1E, 0x1F, 0x0F, 0x07, 0x0D, 0x05, 0x1D, 0x0A };

unsigned char table_31[256] = {
   0xDF, 0xD8, 0x3F, 0xBC, 0x5F, 0xC9, 0x8E, 0x4C,
   0x0B, 0x3C, 0xE5, 0xBF, 0x39, 0xD5, 0x30, 0xDD,
   0x23, 0xC7, 0x72, 0x63, 0x1F, 0xF8, 0x96, 0x31,
   0x70, 0xD6, 0x9E, 0xE8, 0x9D, 0xF5, 0xEF, 0x65,
   0xC2, 0x50, 0x62, 0x77, 0xD3, 0x6C, 0x1A, 0x91,
   0xBB, 0xFF, 0xCD, 0x9B, 0xB6, 0xBA, 0xB8, 0x7A,
   0x14, 0xA7, 0x74, 0x89, 0xD4, 0x6E, 0x19, 0x69,
   0xAB, 0x01, 0x15, 0x0E, 0x87, 0x55, 0x79, 0x1C,
   0x18, 0xBE, 0xA8, 0xDB, 0x52, 0xD2, 0x8F, 0x7E,
   0x81, 0xAF, 0xFD, 0x5C, 0x3E, 0x1B, 0xB9, 0xB2,
   0xB7, 0x51, 0x57, 0x8C, 0xCF, 0x5B, 0xA4, 0x75,
   0xDE, 0x22, 0x8B, 0x10, 0x12, 0xC8, 0x35, 0x2D,
   0x45, 0xB5, 0xF0, 0x47, 0x88, 0x16, 0xEB, 0x67,
   0xD9, 0x0C, 0xF1, 0xC1, 0x34, 0x33, 0xC6, 0x78,
   0xB3, 0x26, 0xE3, 0xBD, 0x5D, 0x4E, 0x66, 0xE4,
   0xD7, 0xC4, 0xE6, 0xA1, 0xB0, 0x95, 0x2B, 0x9A,
   0x4A, 0x3A, 0xCB, 0x40, 0xE1, 0x60, 0x49, 0xCC,
   0x03, 0xAC, 0xF4, 0x97, 0x32, 0x0F, 0x38, 0x17,
   0xF9, 0xE0, 0xD1, 0xFB, 0x04, 0x5E, 0x68, 0x06,
   0xAE, 0xFA, 0xAA, 0xED, 0x24, 0x0D, 0x00, 0x61,
   0x20, 0xA3, 0x7B, 0x6B, 0x76, 0x27, 0xEA, 0xCE,
   0x6A, 0x82, 0x9F, 0x6D, 0x9C, 0x64, 0xA2, 0x11,
   0x37, 0x2A, 0xCA, 0x84, 0x25, 0x7C, 0x2F, 0x8D,
   0x90, 0xE7, 0x09, 0x93, 0xF3, 0x43, 0x71, 0xEC,
   0xA9, 0x7D, 0x94, 0xA6, 0x3D, 0x7F, 0x54, 0x44,
   0x99, 0x80, 0x41, 0xC0, 0xA0, 0x8A, 0x1E, 0xDC,
   0x08, 0xD0, 0x2E, 0x42, 0x05, 0x85, 0x86, 0xFE,
   0x3B, 0x59, 0xC3, 0x58, 0x13, 0xB4, 0x36, 0xA5,
   0x73, 0x28, 0x29, 0xDA, 0x4F, 0x1D, 0xB1, 0x53,
   0x46, 0x2C, 0xF2, 0x4D, 0xAD, 0xFC, 0x83, 0x02,
   0x6F, 0x07, 0xE9, 0xEE, 0x21, 0x98, 0x5A, 0xC5,
   0x92, 0x48, 0xF7, 0x0A, 0xF6, 0xE2, 0x4B, 0x56 };

unsigned char table_32[256] = {
   0x7B, 0x0F, 0x56, 0x2F, 0x1E, 0x2A, 0x7A, 0xD1,
   0x02, 0x91, 0x4E, 0x37, 0x6C, 0x10, 0xA7, 0xF2,
   0x38, 0xAC, 0x9E, 0x2B, 0x5E, 0x23, 0xE3, 0x19,
   0x9B, 0xF6, 0xB0, 0x59, 0x14, 0xB9, 0xA9, 0x46,
   0x84, 0x1D, 0xC0, 0x98, 0xF3, 0xE1, 0xE8, 0x94,
   0x52, 0x35, 0xBA, 0xD8, 0x07, 0xEF, 0x31, 0xF8,
   0x03, 0x76, 0x9C, 0xD7, 0xE4, 0x8B, 0xAF, 0x60,
   0xDD, 0x51, 0x00, 0xDF, 0x11, 0x7F, 0x1C, 0xED,
   0x49, 0xC9, 0xF4, 0x87, 0x64, 0xFC, 0x5D, 0xAD,
   0x88, 0x85, 0xF7, 0x5A, 0x92, 0xDB, 0x72, 0x1A,
   0x83, 0x15, 0x30, 0x24, 0x9F, 0xFF, 0x5B, 0xF1,
   0xD2, 0xFD, 0xC2, 0xB5, 0x25, 0x22, 0x18, 0x3D,
   0xCD, 0x97, 0x8C, 0xCC, 0x78, 0x90, 0xAA, 0x5F,
   0x0A, 0x57, 0x05, 0x61, 0xD4, 0xA0, 0x3A, 0xDE,
   0x3B, 0xF9, 0x65, 0x68, 0x4F, 0x28, 0xFA, 0xEB,
   0x63, 0x2D, 0x8D, 0xD0, 0xA1, 0xFE, 0x12, 0x96,
   0x3C, 0x42, 0x29, 0xD6, 0xA4, 0x34, 0xBD, 0x70,
   0x89, 0xBE, 0xF5, 0x79, 0xAB, 0x8F, 0x32, 0xB4,
   0xEE, 0xE7, 0x2C, 0x04, 0x4B, 0xD5, 0xB1, 0x54,
   0xF0, 0xDA, 0x16, 0x77, 0xA6, 0x53, 0xB2, 0xE2,
   0x73, 0xBF, 0x17, 0xA8, 0x75, 0x26, 0xE0, 0xBC,
   0x0C, 0x71, 0xFB, 0x6D, 0x7E, 0xC5, 0xEA, 0x21,
   0x9D, 0x95, 0x8E, 0xA5, 0x48, 0xB8, 0x7D, 0xCB,
   0x01, 0x99, 0xE5, 0xBB, 0x82, 0xC4, 0xCA, 0xC1,
   0x58, 0x6E, 0x5C, 0x7C, 0xDC, 0x33, 0xB6, 0xC3,
   0x09, 0xC7, 0x1F, 0x0D, 0x43, 0x6F, 0xE9, 0x86,
   0x27, 0xC8, 0x44, 0xB3, 0xD3, 0xCF, 0x08, 0x66,
   0x1B, 0x20, 0x4D, 0xD9, 0xC6, 0x36, 0x40, 0x74,
   0x62, 0x6A, 0x55, 0xEC, 0x06, 0x2E, 0xE6, 0x80,
   0x13, 0x93, 0x50, 0xCE, 0x69, 0x3E, 0x67, 0x4A,
   0x81, 0x4C, 0x0B, 0x3F, 0xB7, 0x0E, 0x39, 0xAE,
   0x47, 0x6B, 0x8A, 0xA2, 0x9A, 0xA3, 0x45, 0x41 };

unsigned char table_33[256] = {
   0xDE, 0xD3, 0x79, 0x67, 0x13, 0x5C, 0x04, 0xF2,
   0xD9, 0x9F, 0x65, 0x56, 0xCC, 0x3B, 0xA4, 0x9A,
   0x08, 0xBF, 0x26, 0xB2, 0xA7, 0x5E, 0xAA, 0xCA,
   0xBB, 0x2B, 0x38, 0x3F, 0xD8, 0x87, 0xFA, 0x5D,
   0x73, 0x8E, 0x1E, 0x93, 0x05, 0xAF, 0x3E, 0x4E,
   0x90, 0xDB, 0x0B, 0x33, 0x0D, 0x2F, 0x86, 0x4F,
   0xFD, 0xD0, 0x39, 0xB1, 0x8A, 0x1A, 0x20, 0xE6,
   0xCF, 0xA2, 0x82, 0xDF, 0x42, 0x9C, 0x30, 0x40,
   0xE3, 0xB0, 0x88, 0x5A, 0xEC, 0x25, 0xE2, 0xC4,
   0x12, 0x54, 0x50, 0x97, 0x96, 0x21, 0x23, 0x7B,
   0x1D, 0x61, 0x52, 0x34, 0x7D, 0x69, 0x16, 0xC3,
   0x31, 0xF8, 0x48, 0x19, 0x95, 0x01, 0x29, 0x8C,
   0x15, 0xAC, 0x84, 0x74, 0xAB, 0x70, 0xDA, 0x36,
   0xD6, 0x8F, 0xFE, 0x35, 0xD7, 0x2E, 0x89, 0x07,
   0x62, 0x17, 0xDC, 0x92, 0x45, 0x83, 0xB5, 0xE5,
   0x8B, 0xC0, 0x27, 0x85, 0x7C, 0x9D, 0x55, 0x81,
   0x71, 0xCD, 0xC9, 0x00, 0x02, 0xC1, 0x0A, 0x37,
   0xED, 0xEA, 0xC2, 0x98, 0x49, 0x06, 0x1C, 0x78,
   0x64, 0xCE, 0x9E, 0x4C, 0x7A, 0xB4, 0x43, 0x0F,
   0xE0, 0x7E, 0xBC, 0x5B, 0x51, 0xE7, 0x18, 0xF9,
   0x11, 0xA1, 0xF5, 0xC7, 0xCB, 0x4D, 0x6A, 0x0E,
   0x57, 0xF1, 0xFB, 0xB3, 0x99, 0xF0, 0x32, 0xD5,
   0xA9, 0x4B, 0x6F, 0x6D, 0xA8, 0xC5, 0xDD, 0x7F,
   0xEB, 0xBE, 0xFC, 0x2C, 0x22, 0x58, 0x03, 0x9B,
   0x77, 0xF7, 0xBD, 0xBA, 0xD2, 0x6B, 0xAD, 0x5F,
   0x10, 0x6E, 0x09, 0xD1, 0x1B, 0x24, 0xEF, 0x72,
   0x3D, 0x59, 0x28, 0xE1, 0xB7, 0x44, 0x8D, 0xB8,
   0xAE, 0x2D, 0x60, 0xA6, 0xC8, 0x0C, 0xF4, 0x41,
   0xA3, 0x68, 0x46, 0x6C, 0x76, 0xA0, 0xB6, 0x66,
   0xE4, 0x1F, 0x75, 0x4A, 0xFF, 0x2A, 0x94, 0xD4,
   0xF3, 0xE9, 0x91, 0x63, 0xA5, 0xB9, 0xE8, 0x14,
   0x80, 0x3C, 0xEE, 0x47, 0xC6, 0x3A, 0x53, 0xF6 };

unsigned char table_34[256] = {
   0xF0, 0xE9, 0x3E, 0xD6, 0x89, 0xC8, 0xC7, 0x23,
   0x75, 0x26, 0x5F, 0x9C, 0x57, 0xB8, 0x2A, 0x29,
   0xE5, 0xB5, 0x68, 0xA4, 0x92, 0x46, 0x40, 0x7F,
   0xF2, 0xBC, 0x6A, 0xE0, 0x8F, 0x0F, 0xE4, 0x3A,
   0xE1, 0x30, 0x84, 0x6E, 0x82, 0x8E, 0x56, 0xC5,
   0x32, 0x85, 0xFB, 0x59, 0x43, 0x41, 0xC2, 0xF6,
   0x67, 0x5A, 0x7C, 0x34, 0xA1, 0xD0, 0x4B, 0xAC,
   0x61, 0x72, 0x6B, 0xAF, 0xC4, 0x20, 0x9A, 0xD4,
   0x74, 0x8D, 0x87, 0x83, 0xE2, 0x62, 0x6D, 0xE6,
   0xE7, 0xF9, 0x76, 0xCB, 0x18, 0x90, 0x4F, 0xFF,
   0xD3, 0x3C, 0x08, 0x79, 0x93, 0x2D, 0x95, 0xA3,
   0xDD, 0x5B, 0xDA, 0x7A, 0x39, 0x4D, 0xC1, 0x2E,
   0xCC, 0x53, 0xE8, 0xA2, 0xCF, 0x15, 0x78, 0x1C,
   0xEB, 0x9B, 0x7B, 0xAD, 0x31, 0x2F, 0xE3, 0xC9,
   0x3B, 0xEC, 0x2C, 0x49, 0x02, 0x52, 0x28, 0xBA,
   0x0C, 0x19, 0x24, 0xF7, 0x97, 0x09, 0xA6, 0xA0,
   0xDF, 0xD1, 0xD2, 0xDC, 0x51, 0xA5, 0x94, 0xFD,
   0x71, 0xF5, 0x50, 0x0A, 0x69, 0x25, 0x88, 0x5C,
   0x91, 0xD5, 0x47, 0x0B, 0x27, 0x13, 0x96, 0xD9,
   0xF1, 0xA9, 0x70, 0xC3, 0xBE, 0x42, 0x4E, 0x4A,
   0xB1, 0x07, 0xA7, 0x54, 0xFE, 0x48, 0x9F, 0x63,
   0x17, 0xAE, 0xB9, 0x58, 0x21, 0x35, 0xED, 0x5D,
   0x9D, 0x3D, 0xB4, 0xFC, 0xEA, 0x8C, 0x80, 0xA8,
   0x1E, 0xB0, 0xDE, 0x0D, 0x11, 0x6F, 0x04, 0x12,
   0xF4, 0x10, 0x64, 0x0E, 0xD7, 0x2B, 0xB3, 0x8B,
   0xB7, 0x01, 0x86, 0xCA, 0xFA, 0x9E, 0xEE, 0x66,
   0x37, 0x65, 0x81, 0x38, 0x1F, 0xAA, 0x73, 0xAB,
   0xBD, 0xDB, 0x14, 0xCD, 0x00, 0xBB, 0x98, 0x44,
   0x45, 0xB6, 0x99, 0x5E, 0xD8, 0x1D, 0x36, 0xF8,
   0x55, 0x6C, 0x16, 0x7E, 0x77, 0x3F, 0x22, 0xEF,
   0xF3, 0x7D, 0xC6, 0xCE, 0x8A, 0xB2, 0x33, 0x4C,
   0x03, 0x05, 0xBF, 0x06, 0x1B, 0xC0, 0x1A, 0x60 };

unsigned char table_35[256] = {
   0xCC, 0x40, 0xEF, 0x1F, 0xDB, 0xE5, 0x71, 0x51,
   0x3B, 0x0F, 0x7D, 0x9C, 0x83, 0x17, 0x6F, 0x8F,
   0x13, 0xDC, 0x7F, 0xA9, 0xA5, 0xA2, 0x9D, 0xDF,
   0xE7, 0x97, 0x2A, 0x30, 0xF2, 0x73, 0xCF, 0x87,
   0x29, 0xB3, 0x86, 0x43, 0x09, 0xB0, 0x2E, 0x10,
   0x8E, 0xBC, 0x57, 0xBA, 0x68, 0xF5, 0xCB, 0x89,
   0x32, 0xC1, 0x6B, 0x1E, 0xAC, 0xB2, 0x2D, 0x6A,
   0x50, 0xEB, 0x18, 0x06, 0xD8, 0xC7, 0x36, 0x31,
   0xC5, 0xAF, 0x12, 0x15, 0xB7, 0x37, 0x4E, 0x01,
   0x14, 0x21, 0x44, 0x5E, 0xF4, 0xB4, 0xE4, 0x65,
   0xFE, 0x8A, 0xEA, 0x0D, 0xBB, 0x45, 0x8B, 0x25,
   0x80, 0x35, 0x61, 0xA8, 0x4A, 0x47, 0xAB, 0x91,
   0x1B, 0x1C, 0x05, 0x4D, 0x5A, 0xD4, 0xF1, 0x9B,
   0x0E, 0x98, 0xCA, 0x96, 0x42, 0x7E, 0x03, 0x5F,
   0xE2, 0x90, 0xBF, 0x82, 0xC9, 0x3D, 0xE0, 0x5C,
   0xFA, 0x3E, 0x41, 0x11, 0x79, 0x58, 0x24, 0x2C,
   0xC0, 0x28, 0x5D, 0xA3, 0xDE, 0x67, 0xFF, 0xA4,
   0x63, 0xB1, 0x22, 0x04, 0xFD, 0x70, 0x39, 0x46,
   0xAA, 0x0A, 0x34, 0x6C, 0xD7, 0x92, 0xA1, 0x3C,
   0x19, 0xD5, 0xFC, 0xAD, 0x85, 0x07, 0x00, 0x23,
   0xF8, 0x69, 0x56, 0x53, 0x55, 0x7A, 0xB8, 0xC8,
   0xDA, 0xCE, 0xF3, 0x5B, 0x49, 0xE1, 0xBE, 0xEC,
   0x1A, 0x88, 0x02, 0xBD, 0xF7, 0x1D, 0x64, 0xA0,
   0x4F, 0xD9, 0xE3, 0x95, 0xC6, 0x48, 0x2B, 0xED,
   0x9A, 0x9E, 0x26, 0x6E, 0xD1, 0x94, 0xB9, 0x93,
   0xDD, 0xF6, 0xA6, 0xFB, 0xC2, 0xB6, 0x0C, 0xE9,
   0x77, 0xF9, 0xCD, 0x08, 0xEE, 0x3F, 0xE6, 0x75,
   0xD6, 0x84, 0x76, 0x8C, 0xF0, 0xAE, 0xD2, 0x78,
   0x2F, 0x4B, 0x16, 0x4C, 0x27, 0x81, 0x6D, 0x99,
   0x38, 0xD3, 0x54, 0x62, 0x74, 0x20, 0x60, 0xC3,
   0x7C, 0x8D, 0x72, 0x0B, 0x52, 0xE8, 0xA7, 0x3A,
   0x59, 0xC4, 0x9F, 0xD0, 0x66, 0x7B, 0x33, 0xB5 };

unsigned char table_36[256] = {
   0xDB, 0x6F, 0xFE, 0xB3, 0x5C, 0x1F, 0xB8, 0xBF,
   0xA3, 0x71, 0x11, 0x56, 0x90, 0xE2, 0x63, 0x18,
   0x83, 0x51, 0x21, 0xEB, 0x66, 0x08, 0xA6, 0xA5,
   0x1C, 0xF5, 0x14, 0x24, 0x41, 0x33, 0xA7, 0xB5,
   0xC7, 0x79, 0x57, 0x50, 0x85, 0xE1, 0x6D, 0xF7,
   0x0E, 0xDE, 0x67, 0xAB, 0xA1, 0x0B, 0xD9, 0x4A,
   0xCA, 0x36, 0xEA, 0xDA, 0x16, 0xEF, 0x9F, 0x0A,
   0x09, 0x9A, 0x1D, 0xC5, 0xD7, 0x5F, 0x19, 0xDC,
   0x15, 0x06, 0xE8, 0x94, 0x0C, 0x0D, 0xC9, 0x7C,
   0xD6, 0x62, 0xBB, 0x49, 0xF9, 0x61, 0x07, 0x9B,
   0x28, 0xC3, 0x9E, 0xF4, 0x38, 0x78, 0x20, 0x03,
   0xA2, 0x7F, 0xC2, 0x9D, 0x5E, 0x65, 0x52, 0x17,
   0x2E, 0x1B, 0xB0, 0x42, 0xBC, 0xFD, 0xF1, 0xD2,
   0xF6, 0x60, 0xD3, 0x29, 0x97, 0x3D, 0x0F, 0xB1,
   0x2F, 0x22, 0xDD, 0x80, 0x32, 0xF8, 0xAD, 0x70,
   0xB9, 0x8F, 0x37, 0xCE, 0x46, 0x58, 0xB7, 0x30,
   0xED, 0x7A, 0xE9, 0xC0, 0x7D, 0x13, 0x64, 0x23,
   0x4E, 0xC8, 0xF0, 0xCC, 0x3B, 0x45, 0x68, 0x8D,
   0xBE, 0x8B, 0xD8, 0x43, 0x02, 0x27, 0xE4, 0xAA,
   0x10, 0xF2, 0x59, 0x72, 0x40, 0x26, 0x69, 0xE5,
   0x05, 0x84, 0x4F, 0xE0, 0x6B, 0xC1, 0xAC, 0x4C,
   0xFB, 0x31, 0x77, 0x8E, 0xD4, 0x12, 0xA9, 0xB4,
   0xEC, 0x00, 0x76, 0x1E, 0x25, 0xAE, 0xE7, 0x3C,
   0x35, 0x93, 0x9C, 0xC4, 0xFC, 0x2D, 0x91, 0x04,
   0xAF, 0x53, 0x3F, 0xE6, 0xA4, 0xD0, 0x1A, 0xDF,
   0x3A, 0x55, 0x99, 0x01, 0xCB, 0x6C, 0x82, 0x3E,
   0x5D, 0xA8, 0x88, 0x54, 0x5B, 0x95, 0xCD, 0x8C,
   0x81, 0x34, 0xD1, 0x39, 0xFF, 0xEE, 0xFA, 0x8A,
   0x6E, 0x86, 0x92, 0x89, 0xF3, 0x6A, 0xBA, 0x2C,
   0xD5, 0x44, 0xC6, 0x96, 0xBD, 0xB2, 0x2B, 0x87,
   0x74, 0xA0, 0x73, 0x5A, 0x2A, 0x98, 0x75, 0x47,
   0x4B, 0xB6, 0x7B, 0x4D, 0xCF, 0x7E, 0x48, 0xE3 };

unsigned char table_37[256] = {
   0x1F, 0xD6, 0xB1, 0xB3, 0x40, 0xAD, 0xDE, 0xB7,
   0x19, 0xB4, 0xE7, 0x0B, 0x9C, 0x2D, 0xE0, 0xF5,
   0xCF, 0x2C, 0x30, 0x65, 0x2F, 0xCD, 0x02, 0x91,
   0xCE, 0x2B, 0xBF, 0x78, 0xE6, 0xFA, 0x51, 0x48,
   0xFB, 0x4D, 0xBE, 0x71, 0x1A, 0x56, 0xFD, 0x81,
   0x33, 0x75, 0x89, 0x96, 0x37, 0x82, 0x9E, 0x93,
   0x41, 0x18, 0x5B, 0x2E, 0x22, 0x0F, 0xAF, 0x4B,
   0xB9, 0xD5, 0xEE, 0x6C, 0xE4, 0x05, 0xCC, 0x99,
   0xE5, 0x3B, 0x62, 0xBD, 0x7B, 0xAA, 0x4A, 0xE2,
   0x34, 0x43, 0xF7, 0x39, 0xFE, 0x14, 0x1D, 0xE3,
   0xF0, 0xA7, 0x77, 0xDF, 0xA0, 0xD3, 0xAC, 0xD9,
   0xEA, 0x76, 0xDD, 0xA4, 0xC5, 0xC9, 0x61, 0xF3,
   0xA8, 0xB0, 0x35, 0xE8, 0x68, 0xD4, 0x15, 0xF9,
   0x97, 0xED, 0x25, 0x0A, 0x88, 0x8F, 0x06, 0xA3,
   0x16, 0x36, 0x32, 0xA2, 0xC6, 0x64, 0xD7, 0x94,
   0xD2, 0x6D, 0x74, 0xFC, 0x44, 0x27, 0x5C, 0xFF,
   0x60, 0x1E, 0x58, 0x8B, 0x5E, 0xC7, 0x90, 0x17,
   0x63, 0xAE, 0xC3, 0x12, 0x13, 0x84, 0xEC, 0x49,
   0xA5, 0x9B, 0x31, 0x8D, 0xE1, 0x79, 0xF1, 0x00,
   0x28, 0x3D, 0xC2, 0x55, 0x20, 0x52, 0x95, 0x7E,
   0x42, 0x1C, 0x66, 0x92, 0x7D, 0xB6, 0xC4, 0xF4,
   0x80, 0xB2, 0x72, 0x6E, 0x11, 0xF6, 0x0D, 0x5A,
   0xEF, 0x9D, 0x69, 0x9A, 0x45, 0x67, 0x3F, 0xDA,
   0x8E, 0x57, 0x09, 0x7C, 0x38, 0xA6, 0x83, 0x87,
   0x7A, 0x08, 0x4C, 0x5F, 0x85, 0x7F, 0xD0, 0x04,
   0x50, 0xCB, 0xB8, 0x07, 0x24, 0x26, 0x29, 0x46,
   0x01, 0x03, 0xC1, 0xD8, 0xDC, 0x0E, 0x3C, 0x4F,
   0x53, 0x4E, 0xB5, 0xF8, 0xC0, 0x8A, 0xF2, 0xBB,
   0xE9, 0x5D, 0x2A, 0xBA, 0x0C, 0x1B, 0x3A, 0xA9,
   0x21, 0x6A, 0x70, 0xBC, 0xEB, 0xA1, 0x54, 0x10,
   0x98, 0x9F, 0x23, 0xD1, 0x6B, 0x59, 0x3E, 0xCA,
   0x73, 0xC8, 0x86, 0x47, 0xDB, 0xAB, 0x6F, 0x8C };

unsigned char table_38[256] = {
   0xAA, 0x8D, 0x37, 0x94, 0x99, 0xDD, 0x70, 0x77,
   0x78, 0xC9, 0x0F, 0xFA, 0xE2, 0x05, 0xC2, 0x16,
   0x02, 0x4D, 0x44, 0x65, 0xAC, 0xB0, 0x39, 0xF8,
   0x06, 0x60, 0xD8, 0xE1, 0x19, 0xB4, 0x36, 0x20,
   0x59, 0x1D, 0xAD, 0xE4, 0xE8, 0xFF, 0x9D, 0x0D,
   0x51, 0x28, 0xE7, 0x8C, 0x0E, 0x97, 0xE3, 0xAE,
   0x6A, 0x27, 0x98, 0xDB, 0x26, 0xF6, 0xEC, 0xC6,
   0xC0, 0xBD, 0x68, 0x61, 0x83, 0x86, 0xE0, 0x2C,
   0xEE, 0x47, 0xF9, 0x5F, 0x6D, 0xBA, 0xE9, 0x72,
   0x8A, 0xBB, 0x08, 0x29, 0xAF, 0x1C, 0xD3, 0x5D,
   0xF7, 0x87, 0x6F, 0x9A, 0x2F, 0x11, 0xD9, 0x90,
   0x66, 0x8E, 0xEB, 0xB1, 0x2E, 0xEA, 0xA3, 0x55,
   0x2B, 0xCC, 0x4C, 0x4B, 0x48, 0x71, 0x3B, 0xFC,
   0xA4, 0x45, 0x0A, 0x8F, 0x7A, 0x13, 0x01, 0x22,
   0xC1, 0xF1, 0xA2, 0xB8, 0x7C, 0xF4, 0xB3, 0xB7,
   0x5B, 0xE5, 0x07, 0x50, 0x7E, 0x18, 0xEF, 0x91,
   0x5C, 0x15, 0x69, 0xBE, 0x0C, 0x93, 0x56, 0x35,
   0x7B, 0xCF, 0x34, 0x74, 0x3E, 0x5E, 0x31, 0x21,
   0x12, 0x63, 0x7F, 0x2A, 0x9B, 0xD4, 0x6B, 0xBC,
   0x33, 0x62, 0x30, 0x75, 0x17, 0x23, 0xB2, 0xF0,
   0x57, 0x67, 0x95, 0x3D, 0xCD, 0x10, 0xE6, 0xC8,
   0x8B, 0xA9, 0x73, 0xC4, 0x43, 0xBF, 0xA7, 0xCA,
   0xB5, 0xD5, 0xD6, 0x3F, 0x1A, 0x7D, 0x82, 0xA8,
   0x40, 0x64, 0xAB, 0x04, 0xC3, 0x1F, 0xA0, 0x5A,
   0x85, 0xF3, 0xDE, 0xFE, 0xDA, 0x1E, 0x81, 0x92,
   0x9C, 0x2D, 0x9F, 0x32, 0xB9, 0xA1, 0x96, 0xD0,
   0x4F, 0x38, 0x80, 0xCB, 0x6C, 0x14, 0x84, 0x1B,
   0xD7, 0xC5, 0xED, 0xD2, 0x3A, 0x0B, 0x88, 0xFD,
   0xDC, 0x49, 0x9E, 0xF5, 0xF2, 0x52, 0xA6, 0x24,
   0xC7, 0xB6, 0x03, 0x3C, 0xD1, 0x54, 0x41, 0xDF,
   0x89, 0x58, 0x79, 0xFB, 0x6E, 0xA5, 0x42, 0x25,
   0x09, 0x76, 0x00, 0x46, 0x4E, 0x53, 0xCE, 0x4A };

unsigned char table_39[32] = {
   0x12, 0x18, 0x0E, 0x08, 0x16, 0x05, 0x06, 0x00,
   0x11, 0x17, 0x15, 0x1B, 0x14, 0x01, 0x1F, 0x19,
   0x04, 0x0D, 0x0A, 0x0F, 0x10, 0x07, 0x1D, 0x03,
   0x0B, 0x13, 0x0C, 0x09, 0x1E, 0x02, 0x1A, 0x1C };

unsigned char table_40[32] = {
   0x16, 0x02, 0x06, 0x0E, 0x0D, 0x1C, 0x08, 0x0A,
   0x0F, 0x13, 0x0B, 0x18, 0x07, 0x04, 0x14, 0x01,
   0x1B, 0x05, 0x17, 0x1E, 0x11, 0x1A, 0x10, 0x1F,
   0x12, 0x19, 0x1D, 0x03, 0x0C, 0x00, 0x09, 0x15 };

unsigned char table_41[32] = {
   0x13, 0x18, 0x04, 0x1F, 0x1D, 0x11, 0x03, 0x00,
   0x10, 0x12, 0x06, 0x0A, 0x1C, 0x07, 0x15, 0x0E,
   0x08, 0x05, 0x0C, 0x09, 0x01, 0x02, 0x16, 0x0B,
   0x1A, 0x17, 0x14, 0x1E, 0x0D, 0x0F, 0x19, 0x1B };

unsigned char table_42[32] = {
   0x00, 0x08, 0x15, 0x1D, 0x05, 0x18, 0x06, 0x07,
   0x1F, 0x01, 0x0B, 0x03, 0x19, 0x13, 0x02, 0x1C,
   0x17, 0x11, 0x0E, 0x1E, 0x0C, 0x0F, 0x09, 0x1A,
   0x1B, 0x16, 0x10, 0x0D, 0x0A, 0x14, 0x12, 0x04 };

unsigned char table_43[256] = {
   0x34, 0xB7, 0x36, 0x85, 0x5F, 0x93, 0x98, 0x70,
   0x1E, 0x59, 0x83, 0x60, 0x6F, 0xBF, 0xF9, 0xD0,
   0xB3, 0x22, 0x12, 0x38, 0xF5, 0x01, 0xC9, 0x5B,
   0xEF, 0x1D, 0x81, 0x64, 0xFA, 0x8F, 0x7F, 0xBC,
   0x05, 0x08, 0xE0, 0x8B, 0xE8, 0x86, 0x95, 0xCB,
   0xCA, 0x5A, 0xEB, 0x10, 0x92, 0xE2, 0x7E, 0x28,
   0xD9, 0xC7, 0x0D, 0x24, 0xA7, 0x02, 0x0B, 0xF1,
   0x7B, 0xD3, 0xFE, 0x2B, 0x89, 0x0E, 0xAE, 0xAD,
   0xC8, 0x82, 0x79, 0x43, 0x96, 0xDE, 0x0C, 0x9A,
   0x57, 0x84, 0xB4, 0x19, 0xF8, 0xF0, 0xAF, 0xBE,
   0x99, 0x9F, 0x46, 0xE4, 0x31, 0xDF, 0x30, 0x51,
   0xD4, 0xE5, 0xFC, 0x32, 0x04, 0x56, 0x7D, 0x33,
   0xF7, 0x18, 0x23, 0x4E, 0xC2, 0x7C, 0x6C, 0xD2,
   0xB1, 0x9B, 0x40, 0xA2, 0x88, 0x00, 0xA1, 0xAB,
   0xC6, 0x5C, 0x87, 0x3B, 0xD7, 0x27, 0x2E, 0x45,
   0xDA, 0x8E, 0x61, 0x5E, 0xFB, 0x09, 0x5D, 0x6B,
   0xA3, 0x29, 0x4F, 0xAC, 0xD1, 0x77, 0x4A, 0xA9,
   0xC4, 0x7A, 0x15, 0xD8, 0xAA, 0x17, 0xB9, 0x2D,
   0xE7, 0xBD, 0x2C, 0x62, 0x2F, 0xB2, 0xED, 0x3F,
   0x48, 0x26, 0x1B, 0x35, 0x20, 0x72, 0x4D, 0xFF,
   0xBB, 0x78, 0x1F, 0xCC, 0xEC, 0xA8, 0x9D, 0x90,
   0x4B, 0x13, 0xE1, 0xBA, 0xF3, 0x3C, 0x42, 0x65,
   0x14, 0xDD, 0x75, 0xE3, 0x4C, 0x74, 0x94, 0xCD,
   0xF2, 0x66, 0x06, 0xE9, 0x49, 0xB8, 0x71, 0x41,
   0xA0, 0x25, 0x55, 0x47, 0x97, 0x9E, 0x11, 0x54,
   0x1A, 0xB0, 0x3E, 0x37, 0x39, 0x1C, 0x8D, 0x03,
   0x6E, 0xF6, 0x80, 0x6D, 0x8C, 0x9C, 0xB6, 0xCF,
   0xC3, 0x91, 0x63, 0xC0, 0x07, 0x67, 0xE6, 0xF4,
   0xCE, 0x3D, 0xDB, 0x16, 0xFD, 0xEA, 0xD6, 0x68,
   0xD5, 0xA6, 0x0F, 0x58, 0x44, 0x52, 0xB5, 0xDC,
   0x0A, 0x69, 0xC5, 0xA5, 0xC1, 0x8A, 0x2A, 0xEE,
   0x73, 0x76, 0x3A, 0x21, 0x53, 0xA4, 0x50, 0x6A };

unsigned char table_44[32] = {
   0x1A, 0x0E, 0x0A, 0x17, 0x1F, 0x08, 0x10, 0x14,
   0x0C, 0x0F, 0x09, 0x1C, 0x06, 0x18, 0x1E, 0x12,
   0x15, 0x00, 0x11, 0x13, 0x0D, 0x01, 0x0B, 0x03,
   0x16, 0x19, 0x05, 0x1D, 0x02, 0x07, 0x04, 0x1B };

unsigned char table_45[256] = {
   0x5E, 0xD6, 0xE2, 0x54, 0x35, 0xC2, 0xAC, 0x9D,
   0x92, 0x64, 0x57, 0x65, 0xC8, 0xAE, 0x21, 0xA9,
   0x89, 0x48, 0x12, 0x59, 0xEC, 0xEF, 0x9F, 0xF7,
   0x19, 0x03, 0x83, 0xC0, 0x79, 0x5D, 0x4A, 0x10,
   0x8C, 0xEB, 0xFF, 0xB5, 0x3B, 0x51, 0x2D, 0xD1,
   0x6B, 0xC5, 0x24, 0x5C, 0xE6, 0x11, 0x94, 0x3F,
   0xD0, 0x2F, 0x0E, 0x95, 0x3C, 0xFE, 0x5B, 0x20,
   0x23, 0xE0, 0x91, 0x6F, 0xCA, 0x56, 0x0C, 0x73,
   0xDA, 0x67, 0x37, 0xA3, 0xA5, 0x70, 0x93, 0x1C,
   0x18, 0xD9, 0x42, 0x5F, 0x44, 0xF0, 0xF2, 0x14,
   0x58, 0x8A, 0x1D, 0x40, 0x4E, 0x0B, 0x74, 0x84,
   0x52, 0xCB, 0x60, 0xED, 0xAD, 0x66, 0x43, 0x6C,
   0x81, 0xA1, 0x27, 0xB9, 0xBA, 0x4D, 0xF5, 0x04,
   0xB8, 0x96, 0xA6, 0xA2, 0x7D, 0xD4, 0xEA, 0x45,
   0x4F, 0x55, 0xD3, 0x3E, 0x8E, 0x4C, 0xBF, 0x8B,
   0x9A, 0x06, 0x7A, 0xF4, 0x02, 0x88, 0x80, 0x22,
   0xF3, 0xBD, 0x78, 0xEE, 0xAF, 0xF8, 0x15, 0x09,
   0x0F, 0xB0, 0xDD, 0x99, 0x72, 0xE7, 0x90, 0xE1,
   0x25, 0x62, 0x8D, 0x9C, 0x13, 0x08, 0xC9, 0x28,
   0x2A, 0x47, 0x69, 0xDE, 0x77, 0x87, 0xBB, 0xE9,
   0xAA, 0x33, 0x05, 0x29, 0x34, 0x97, 0xFD, 0xA0,
   0x1E, 0xFC, 0xBE, 0xB1, 0x71, 0x9B, 0x50, 0xDC,
   0xB7, 0x31, 0x63, 0x3A, 0xDF, 0xC3, 0x1B, 0x7C,
   0x0A, 0xD7, 0xF6, 0xDB, 0x49, 0x53, 0x7F, 0xD2,
   0x30, 0xA4, 0xB3, 0x6E, 0xB2, 0x6D, 0xCD, 0x7E,
   0x26, 0xE8, 0x76, 0xCF, 0xE5, 0xCE, 0x16, 0xF1,
   0xC6, 0x68, 0x36, 0x46, 0x1F, 0x38, 0x0D, 0x41,
   0x17, 0xBC, 0x86, 0x9E, 0x6A, 0x7B, 0xB4, 0x01,
   0xCC, 0x2C, 0xE3, 0x5A, 0xB6, 0xFA, 0x00, 0x75,
   0x39, 0xA7, 0xC1, 0xD5, 0x98, 0xAB, 0x1A, 0x85,
   0xD8, 0xE4, 0xC4, 0xA8, 0x4B, 0x61, 0x2E, 0x3D,
   0xF9, 0x2B, 0x32, 0x8F, 0xFB, 0xC7, 0x07, 0x82 };

unsigned char table_46[256] = {
   0x85, 0x78, 0xFE, 0x6C, 0x61, 0xA0, 0x71, 0xCC,
   0x45, 0x54, 0x7A, 0xE6, 0x82, 0x1D, 0xA6, 0x02,
   0x47, 0xD0, 0x23, 0x55, 0x62, 0xFA, 0x76, 0x3E,
   0xE3, 0x66, 0x74, 0x10, 0x5D, 0x49, 0x69, 0x0B,
   0x75, 0x12, 0x8D, 0x9F, 0xEE, 0x93, 0x50, 0x70,
   0x32, 0xBC, 0x1E, 0xD3, 0xEF, 0x7B, 0xB4, 0x92,
   0xFD, 0x16, 0xC2, 0xD8, 0xDE, 0x68, 0xD1, 0x64,
   0xC3, 0xA3, 0xB3, 0xC9, 0x08, 0xFB, 0x84, 0xC1,
   0x28, 0x53, 0xCF, 0xD2, 0x35, 0xD7, 0x4A, 0x01,
   0x44, 0xA4, 0x07, 0xAC, 0x98, 0xF1, 0xB2, 0x9A,
   0x94, 0x2D, 0xD4, 0x34, 0x27, 0x60, 0x1A, 0xB9,
   0xAF, 0x89, 0xEB, 0x8F, 0x6A, 0x13, 0x05, 0xF0,
   0x77, 0x5F, 0x4F, 0x58, 0x2C, 0xE7, 0xCE, 0xED,
   0xC0, 0x0D, 0x3A, 0xA7, 0xE2, 0x38, 0x5B, 0xE9,
   0x3D, 0xF2, 0xDF, 0x86, 0xE0, 0x72, 0xF7, 0x88,
   0xAD, 0xB7, 0x11, 0xDB, 0x73, 0x87, 0xC5, 0x22,
   0xE1, 0x5C, 0xD6, 0x57, 0x7E, 0x7D, 0xA2, 0xF9,
   0xF5, 0x9C, 0x25, 0x6F, 0x26, 0x51, 0xC8, 0x80,
   0x2B, 0xA8, 0x19, 0xD9, 0x65, 0xCD, 0x97, 0xEA,
   0xFF, 0x5E, 0x24, 0x3B, 0x4D, 0xB1, 0x1C, 0x79,
   0x39, 0x6B, 0xA5, 0x2A, 0x09, 0xCA, 0x04, 0xEC,
   0xBA, 0x18, 0x31, 0x46, 0x20, 0xBE, 0x1F, 0x3C,
   0x6D, 0xAA, 0xF6, 0xDD, 0xF4, 0x96, 0x03, 0x0A,
   0x9E, 0x83, 0xA1, 0x9D, 0xD5, 0xB0, 0x17, 0xBF,
   0x56, 0xAB, 0xAE, 0x1B, 0x52, 0xC6, 0x81, 0x4B,
   0xDC, 0x90, 0x5A, 0x9B, 0xB6, 0x0F, 0xF3, 0x67,
   0x30, 0x63, 0x7C, 0x40, 0x0E, 0x7F, 0x95, 0x36,
   0xC4, 0x4E, 0x43, 0xCB, 0x15, 0xB8, 0x00, 0x91,
   0x8A, 0x4C, 0x8E, 0x14, 0x06, 0x6E, 0xA9, 0x2E,
   0x3F, 0x48, 0x2F, 0x0C, 0xB5, 0x21, 0xBB, 0xDA,
   0x8B, 0x42, 0x29, 0x8C, 0x33, 0x59, 0xE8, 0xF8,
   0xC7, 0xE4, 0x37, 0xE5, 0xFC, 0xBD, 0x99, 0x41 };

unsigned char table_47[32] = {
   0x18, 0x1D, 0x16, 0x10, 0x11, 0x04, 0x1E, 0x08,
   0x19, 0x0E, 0x0F, 0x02, 0x14, 0x1C, 0x07, 0x17,
   0x0D, 0x09, 0x12, 0x1A, 0x05, 0x01, 0x0B, 0x0A,
   0x13, 0x15, 0x0C, 0x00, 0x06, 0x1F, 0x03, 0x1B };

unsigned char table_48[32] = {
   0x13, 0x08, 0x15, 0x01, 0x17, 0x10, 0x0F, 0x1F,
   0x1D, 0x0D, 0x12, 0x03, 0x06, 0x0A, 0x1C, 0x19,
   0x1A, 0x04, 0x1B, 0x02, 0x16, 0x1E, 0x11, 0x00,
   0x14, 0x09, 0x0C, 0x18, 0x05, 0x07, 0x0E, 0x0B };

unsigned char table_49[32] = {
   0x1F, 0x0F, 0x19, 0x07, 0x18, 0x05, 0x1E, 0x1D,
   0x15, 0x08, 0x17, 0x10, 0x0A, 0x0E, 0x0C, 0x1B,
   0x02, 0x13, 0x03, 0x0D, 0x04, 0x1A, 0x06, 0x09,
   0x12, 0x1C, 0x0B, 0x16, 0x14, 0x01, 0x11, 0x00 };

unsigned char table_50[32] = {
   0x16, 0x18, 0x1C, 0x0E, 0x12, 0x00, 0x04, 0x1B,
   0x1F, 0x13, 0x17, 0x0A, 0x1E, 0x03, 0x0C, 0x01,
   0x0F, 0x10, 0x02, 0x08, 0x14, 0x09, 0x19, 0x15,
   0x06, 0x0D, 0x0B, 0x1D, 0x05, 0x07, 0x11, 0x1A };

unsigned char table_51[32] = {
   0x1C, 0x0D, 0x1B, 0x07, 0x17, 0x0E, 0x06, 0x01,
   0x12, 0x19, 0x03, 0x0B, 0x10, 0x08, 0x00, 0x1E,
   0x0A, 0x04, 0x1A, 0x1D, 0x0C, 0x18, 0x02, 0x13,
   0x0F, 0x11, 0x05, 0x09, 0x15, 0x16, 0x1F, 0x14 };

unsigned char table_52[256] = {
   0x34, 0x0B, 0x47, 0xA3, 0x56, 0x30, 0x73, 0xD4,
   0x4B, 0xF6, 0xA6, 0x80, 0x22, 0x95, 0xA5, 0xBB,
   0xFE, 0xCD, 0x27, 0x88, 0x87, 0x18, 0x86, 0x6E,
   0xB9, 0x07, 0x37, 0x52, 0x0A, 0x28, 0x2C, 0xC4,
   0x75, 0xA1, 0x29, 0x54, 0x84, 0x08, 0x72, 0x51,
   0xDD, 0xF1, 0x4E, 0x1A, 0x90, 0x57, 0x20, 0xAD,
   0x68, 0x61, 0xAF, 0x50, 0x6B, 0x1B, 0x71, 0xEB,
   0x63, 0xC9, 0xB0, 0x58, 0x26, 0x40, 0xC7, 0xD9,
   0x70, 0xA2, 0x9A, 0x09, 0x3F, 0x92, 0x0D, 0x8C,
   0xC1, 0x96, 0x9F, 0x77, 0x4D, 0x5A, 0xEA, 0x11,
   0xD7, 0xF3, 0x33, 0x93, 0x10, 0xF2, 0x9D, 0x83,
   0xFF, 0x7E, 0xD2, 0x41, 0x24, 0xB4, 0x8D, 0x5C,
   0xCF, 0xEF, 0xE9, 0x64, 0x76, 0xD1, 0xDE, 0xE4,
   0x91, 0x35, 0x89, 0x19, 0x02, 0x0E, 0xF4, 0x2A,
   0x0F, 0xE1, 0xA8, 0x2D, 0x21, 0x23, 0xAA, 0x7C,
   0x78, 0x45, 0xA9, 0xDC, 0x06, 0xF9, 0xDF, 0xF7,
   0x03, 0xAB, 0xB5, 0x1C, 0x36, 0x7B, 0x97, 0xFA,
   0xE5, 0x3B, 0x2F, 0x1F, 0x9E, 0xED, 0xA7, 0x55,
   0x42, 0x6F, 0x1E, 0xB7, 0xE6, 0xFB, 0x12, 0xD5,
   0x99, 0xC6, 0x66, 0x4A, 0xE8, 0x48, 0x60, 0xB1,
   0x05, 0x53, 0x8A, 0xB6, 0x25, 0x8F, 0xA4, 0xD8,
   0x9C, 0xC0, 0x59, 0x3A, 0xBD, 0xDB, 0x44, 0x5E,
   0xE3, 0xDA, 0x1D, 0x32, 0xF5, 0xBA, 0x43, 0x13,
   0x82, 0x4C, 0xE7, 0x17, 0x15, 0x3E, 0x69, 0x2E,
   0xC3, 0xF0, 0x5F, 0xFD, 0xCE, 0xD3, 0xCA, 0x39,
   0xD6, 0x79, 0x3D, 0xC8, 0x67, 0x8B, 0x31, 0x4F,
   0xB3, 0xBC, 0x65, 0x00, 0x7A, 0x98, 0xC5, 0x6C,
   0x2B, 0x94, 0x6D, 0x74, 0x14, 0xAC, 0xCC, 0xA0,
   0x5B, 0xF8, 0xCB, 0x7F, 0xB2, 0xEC, 0xBF, 0x3C,
   0xE0, 0xAE, 0xFC, 0x62, 0x04, 0x8E, 0x85, 0x49,
   0x9B, 0xC2, 0x38, 0xD0, 0xEE, 0x81, 0x46, 0xE2,
   0x01, 0x0C, 0x5D, 0x7D, 0xB8, 0xBE, 0x6A, 0x16 };

unsigned char table_53[256] = {
   0xE3, 0xF4, 0x8D, 0x72, 0x45, 0x32, 0x9D, 0xCE,
   0x1F, 0x6B, 0xBC, 0xDC, 0xF1, 0xEC, 0x5A, 0x3B,
   0xA5, 0xA2, 0x2B, 0xDD, 0x8A, 0xA3, 0x76, 0xE4,
   0xAF, 0xE9, 0xE1, 0x21, 0xDB, 0x9F, 0x19, 0xD3,
   0x26, 0x80, 0x15, 0xC2, 0x46, 0xB8, 0x17, 0x56,
   0x99, 0x81, 0x08, 0xD7, 0xEF, 0x8E, 0x04, 0x05,
   0x97, 0x2F, 0x78, 0xAD, 0xA1, 0x52, 0x36, 0x58,
   0x53, 0x68, 0x22, 0x70, 0x0B, 0x79, 0xE6, 0xFA,
   0xC3, 0x91, 0xE2, 0xF7, 0xF6, 0x75, 0x2D, 0x0A,
   0x90, 0xEB, 0xA6, 0x35, 0xA7, 0x10, 0xB5, 0xFB,
   0xE7, 0xAA, 0x1E, 0x43, 0xBB, 0x3C, 0x65, 0x25,
   0x2C, 0x59, 0x62, 0x2A, 0xF9, 0x4B, 0x95, 0x5E,
   0x20, 0x11, 0x42, 0x27, 0x44, 0xE8, 0x14, 0x6F,
   0xD1, 0xD8, 0x00, 0x3A, 0x5B, 0x18, 0x89, 0x02,
   0x61, 0xD6, 0xC5, 0x98, 0xD0, 0x5F, 0x34, 0x29,
   0xFD, 0x31, 0x1A, 0xCD, 0x0F, 0x9E, 0xCA, 0x7B,
   0xEA, 0x93, 0x71, 0x5C, 0x0E, 0x57, 0x33, 0xC4,
   0x37, 0xF5, 0x83, 0xB0, 0xDF, 0x49, 0x74, 0x54,
   0x1D, 0x24, 0xB9, 0x16, 0x1C, 0x28, 0xDE, 0x4A,
   0xF0, 0x01, 0x86, 0x82, 0xCC, 0x12, 0x8C, 0x06,
   0x30, 0xA8, 0x7A, 0x73, 0x66, 0x7C, 0xC6, 0xB6,
   0xF2, 0x13, 0xBF, 0x40, 0x85, 0x77, 0x09, 0x3D,
   0x67, 0x63, 0x3F, 0x7F, 0xF3, 0x87, 0x8F, 0xFF,
   0x92, 0xC7, 0x4C, 0x23, 0xBA, 0xCB, 0xB1, 0xED,
   0x0C, 0x60, 0x47, 0xFE, 0x38, 0x5D, 0xCF, 0x8B,
   0x4D, 0xA9, 0x2E, 0xE5, 0xA4, 0x1B, 0x88, 0x3E,
   0x7D, 0xF8, 0xC0, 0xD5, 0x6D, 0x6C, 0x48, 0xAC,
   0x9B, 0x51, 0x7E, 0x6E, 0x50, 0x0D, 0x9A, 0xB3,
   0xEE, 0x07, 0x4F, 0x69, 0x9C, 0x03, 0xD9, 0xD4,
   0xB4, 0xD2, 0xAE, 0x4E, 0x55, 0xB7, 0xC9, 0x41,
   0x39, 0x6A, 0xC8, 0xA0, 0xB2, 0xC1, 0x84, 0xFC,
   0xAB, 0x64, 0xE0, 0xBE, 0xDA, 0xBD, 0x96, 0x94 };

unsigned char table_54[32] = {
   0x01, 0x02, 0x1D, 0x10, 0x0E, 0x11, 0x08, 0x14,
   0x12, 0x09, 0x15, 0x17, 0x16, 0x04, 0x06, 0x1B,
   0x07, 0x1A, 0x18, 0x13, 0x0A, 0x1E, 0x1C, 0x1F,
   0x0C, 0x0B, 0x0D, 0x05, 0x0F, 0x00, 0x19, 0x03 };

unsigned char table_55[32] = {
   0x01, 0x12, 0x13, 0x09, 0x0B, 0x19, 0x03, 0x0E,
   0x02, 0x1F, 0x1D, 0x1B, 0x1E, 0x11, 0x06, 0x05,
   0x00, 0x16, 0x07, 0x0C, 0x15, 0x0D, 0x1A, 0x08,
   0x18, 0x10, 0x0F, 0x17, 0x1C, 0x0A, 0x04, 0x14 };

unsigned char table_56[256] = {
   0xEF, 0x06, 0x5F, 0x11, 0x4B, 0x60, 0x13, 0xBB,
   0x79, 0xD7, 0xE4, 0x6D, 0x22, 0xB4, 0x15, 0x50,
   0x29, 0x17, 0xD2, 0xE3, 0x37, 0x8C, 0x46, 0x7C,
   0xA2, 0xF5, 0x65, 0x16, 0xCB, 0x04, 0x3E, 0xDF,
   0x8E, 0xDE, 0x53, 0xF1, 0xF4, 0xD1, 0x3B, 0xEE,
   0x9A, 0x09, 0x9B, 0x6C, 0xF6, 0xCC, 0xFB, 0x40,
   0xE0, 0xFD, 0x2B, 0x1D, 0x73, 0x18, 0xCD, 0x31,
   0x3F, 0x9E, 0xAD, 0xC9, 0x43, 0x4E, 0x99, 0x3A,
   0x8F, 0x92, 0x85, 0xFC, 0x12, 0x41, 0x20, 0xE8,
   0x2A, 0xC0, 0x1C, 0x38, 0x74, 0x0B, 0xF3, 0x05,
   0x0D, 0x1F, 0x94, 0x9C, 0xAC, 0x00, 0x59, 0x0C,
   0xB3, 0x8D, 0xA8, 0x75, 0xB7, 0x68, 0x2F, 0x27,
   0x6F, 0x69, 0x76, 0xD8, 0xEC, 0xA5, 0xB2, 0x6A,
   0x19, 0x72, 0x1A, 0xB6, 0xE5, 0x77, 0xC6, 0x44,
   0x9D, 0xCA, 0x82, 0x35, 0x36, 0x5E, 0xA9, 0x25,
   0xFA, 0x5C, 0x24, 0x30, 0x39, 0x0E, 0x2C, 0x7D,
   0xE6, 0x88, 0xA0, 0x63, 0xB8, 0x6B, 0x01, 0xDD,
   0xDA, 0x9F, 0x45, 0x83, 0xE2, 0x7F, 0x1B, 0x56,
   0xAF, 0x14, 0xC3, 0x49, 0xBF, 0x78, 0x70, 0x58,
   0x23, 0xA3, 0xBD, 0x34, 0x47, 0x2D, 0x0A, 0xD4,
   0x33, 0x03, 0x1E, 0xC1, 0x87, 0xAE, 0x3C, 0x95,
   0xB0, 0x42, 0x91, 0xB9, 0x5A, 0x61, 0xAA, 0xCF,
   0xF2, 0x51, 0xA6, 0xF8, 0xDC, 0x71, 0xAB, 0x48,
   0x66, 0x90, 0x97, 0xC4, 0x08, 0xF9, 0xD0, 0x7B,
   0xDB, 0xBA, 0x8B, 0xC2, 0xC5, 0x2E, 0xF7, 0x5B,
   0xFF, 0x21, 0x81, 0x54, 0xD3, 0x62, 0x57, 0x4C,
   0x6E, 0x02, 0x98, 0xFE, 0x7E, 0xE7, 0xBC, 0x07,
   0x28, 0x5D, 0x86, 0xCE, 0xEA, 0x84, 0xF0, 0xE1,
   0x93, 0x80, 0xE9, 0xC7, 0x4A, 0xED, 0xB1, 0x26,
   0x89, 0x3D, 0x4F, 0xA7, 0xA1, 0xD6, 0xB5, 0x4D,
   0x67, 0xA4, 0x55, 0x10, 0x0F, 0xD9, 0x52, 0x32,
   0x96, 0xD5, 0xEB, 0x64, 0x8A, 0xC8, 0x7A, 0xBE };

unsigned char table_57[256] = {
   0xD1, 0x9B, 0x15, 0x06, 0xB4, 0xF6, 0x97, 0xF0,
   0xC6, 0x5B, 0x88, 0x12, 0x25, 0xFA, 0x7B, 0x79,
   0xD6, 0xAB, 0xDC, 0x47, 0x85, 0x61, 0x67, 0x0B,
   0xF3, 0x20, 0x44, 0x53, 0x2A, 0x3B, 0x2D, 0xE8,
   0x17, 0x71, 0xC3, 0xB7, 0x7F, 0x35, 0xEB, 0x10,
   0x03, 0x0D, 0x60, 0x96, 0x27, 0xBB, 0x39, 0x50,
   0x95, 0x55, 0xCC, 0xD4, 0x2F, 0x51, 0xB3, 0x05,
   0xA5, 0xAD, 0xBC, 0x18, 0xE2, 0xAE, 0x07, 0x87,
   0xC4, 0x8D, 0xBE, 0x77, 0xC2, 0x16, 0xFC, 0x33,
   0x4C, 0x4F, 0xE6, 0xA6, 0x57, 0x9F, 0x37, 0x91,
   0xED, 0x4A, 0xF7, 0xB5, 0x52, 0x7C, 0xBD, 0x30,
   0xA0, 0x2C, 0x8C, 0xB0, 0x0C, 0xDA, 0x6F, 0x9E,
   0xEE, 0x43, 0x40, 0x8F, 0x8B, 0x76, 0xA4, 0x68,
   0xFF, 0x6D, 0x58, 0xC9, 0xF9, 0x6E, 0x3F, 0x56,
   0xCA, 0x49, 0xC8, 0x5D, 0xCD, 0xC7, 0x99, 0xEC,
   0x72, 0x38, 0x0A, 0xA9, 0xC5, 0x04, 0x64, 0xBF,
   0xB6, 0x29, 0x80, 0x2E, 0x19, 0x0E, 0x82, 0x45,
   0xBA, 0xD7, 0x1E, 0x86, 0xA8, 0xD8, 0x24, 0xDB,
   0xCF, 0xE1, 0x54, 0xB2, 0x3E, 0x4D, 0x90, 0x42,
   0x5F, 0x59, 0x0F, 0xCE, 0x8E, 0xA2, 0xA7, 0x1D,
   0x22, 0xFD, 0x81, 0x63, 0xE5, 0x6A, 0xE7, 0x93,
   0x41, 0x46, 0x66, 0x89, 0x13, 0xEA, 0x69, 0x1C,
   0x83, 0xF2, 0x08, 0xB8, 0x01, 0x23, 0x26, 0xFB,
   0x78, 0xAA, 0x31, 0x11, 0x1B, 0x98, 0xDD, 0xAC,
   0xB9, 0xFE, 0x94, 0x74, 0xAF, 0x32, 0xD0, 0x5A,
   0xA1, 0xF4, 0x6B, 0x8A, 0xE3, 0x65, 0xDE, 0xCB,
   0x73, 0x3D, 0xA3, 0x7E, 0xDF, 0xD2, 0x6C, 0x7A,
   0x36, 0xD9, 0x62, 0x4B, 0xEF, 0xC1, 0x1F, 0x00,
   0x34, 0xB1, 0xF8, 0xE4, 0xD5, 0x09, 0x1A, 0x9A,
   0x70, 0x48, 0x9D, 0xF1, 0xE0, 0x9C, 0xD3, 0x5C,
   0x75, 0x02, 0x2B, 0x92, 0x21, 0x7D, 0xF5, 0x5E,
   0x4E, 0x3C, 0x84, 0x14, 0x28, 0x3A, 0xE9, 0xC0 };

unsigned char table_58[256] = {
   0xE9, 0x81, 0x60, 0xA7, 0x18, 0xA0, 0x0F, 0x55,
   0x2B, 0x52, 0xE0, 0x8B, 0x9D, 0x85, 0xD2, 0xA3,
   0x3F, 0x6E, 0xB1, 0xAF, 0xE3, 0x36, 0xE2, 0x19,
   0x56, 0xB0, 0x09, 0xB5, 0x79, 0x43, 0xE1, 0x06,
   0x45, 0xB6, 0xC0, 0x22, 0xEE, 0x41, 0xEC, 0x01,
   0x66, 0x2D, 0x87, 0x38, 0x16, 0x37, 0xFA, 0x29,
   0x96, 0xA4, 0xC3, 0x23, 0x59, 0x7E, 0x92, 0x78,
   0x10, 0x2A, 0x4C, 0x0E, 0x9B, 0x4A, 0x35, 0xF4,
   0x42, 0x0C, 0xD8, 0xD7, 0x24, 0x2C, 0xDD, 0x8E,
   0x5B, 0xF5, 0x33, 0x48, 0xEF, 0xDE, 0x4B, 0xBC,
   0x51, 0xAB, 0x7C, 0xE4, 0x63, 0x70, 0x9A, 0xAC,
   0x54, 0x1D, 0x25, 0xC5, 0xEA, 0xB3, 0x05, 0xF7,
   0xC1, 0x1F, 0xE8, 0x97, 0xBB, 0x32, 0x6D, 0xC7,
   0x28, 0x61, 0xDB, 0x4D, 0x77, 0x72, 0x65, 0x8C,
   0x80, 0x3A, 0x76, 0x47, 0xA8, 0x03, 0x04, 0x12,
   0xCE, 0xA9, 0x75, 0x3C, 0x49, 0xF8, 0x64, 0xDF,
   0x57, 0xA2, 0x69, 0x44, 0xAD, 0x3E, 0x4F, 0x0B,
   0x74, 0x67, 0xC9, 0x1A, 0x17, 0xAA, 0x02, 0x6F,
   0xDA, 0xF2, 0xC6, 0x27, 0x53, 0xD6, 0xFD, 0xCA,
   0x8D, 0x93, 0x89, 0xD5, 0x6B, 0x4E, 0x90, 0x82,
   0x30, 0xE7, 0xC4, 0xD9, 0x8A, 0x7F, 0xB4, 0xFC,
   0xCF, 0xA1, 0xAE, 0x1C, 0x39, 0x1B, 0x7B, 0x5E,
   0x88, 0x7D, 0xD3, 0x71, 0x2E, 0x98, 0x13, 0x8F,
   0xCC, 0x84, 0x73, 0xCD, 0x21, 0x0D, 0x5C, 0xA5,
   0x3D, 0x9E, 0x99, 0xC2, 0xF3, 0x34, 0x14, 0x62,
   0x46, 0x0A, 0x07, 0x08, 0xFF, 0xFB, 0xB7, 0xBF,
   0x5D, 0x91, 0xB8, 0x83, 0xBE, 0x94, 0xBA, 0xF9,
   0xEB, 0xE5, 0xCB, 0x95, 0x40, 0x31, 0xE6, 0x86,
   0xD4, 0xFE, 0xD0, 0x7A, 0x26, 0xB9, 0xDC, 0x2F,
   0xBD, 0xF0, 0x5F, 0x00, 0x9C, 0x6A, 0x5A, 0x3B,
   0xF1, 0xC8, 0x9F, 0xED, 0x50, 0x20, 0x15, 0x11,
   0x68, 0x1E, 0xF6, 0xA6, 0x6C, 0xB2, 0xD1, 0x58 };

unsigned char table_59[256] = {
   0x4C, 0x85, 0x2B, 0x14, 0xCC, 0x4D, 0x5F, 0xD7,
   0xCE, 0x28, 0xC5, 0x0B, 0xA1, 0x99, 0x08, 0xDE,
   0x42, 0xD1, 0x82, 0x5C, 0xC9, 0x8F, 0x72, 0x12,
   0xCB, 0x0D, 0x04, 0xFA, 0xCD, 0xE5, 0x9A, 0x6F,
   0xCF, 0x92, 0xB5, 0x88, 0x87, 0xBF, 0x90, 0x7C,
   0xAC, 0xBE, 0x36, 0x21, 0x7D, 0x7F, 0xC7, 0x9F,
   0x75, 0xBB, 0x61, 0x16, 0x17, 0x63, 0xAE, 0xC4,
   0x23, 0x89, 0xE0, 0x37, 0x91, 0x5E, 0xC8, 0xE4,
   0xFD, 0xD5, 0xA2, 0xC6, 0x5A, 0xEF, 0x9B, 0xD6,
   0x27, 0xEE, 0x60, 0x1C, 0xDF, 0xDA, 0xF1, 0xD2,
   0x1E, 0x01, 0x9D, 0x44, 0x03, 0xD8, 0x11, 0x53,
   0x4F, 0x6C, 0x8B, 0xB7, 0x40, 0xF2, 0x79, 0x20,
   0x74, 0x97, 0x3E, 0x3D, 0x05, 0xD4, 0x70, 0x30,
   0x54, 0x59, 0xE7, 0x15, 0xE1, 0xEB, 0x71, 0x83,
   0xFE, 0x66, 0xB1, 0xA6, 0xF7, 0x8E, 0x6A, 0xEA,
   0x65, 0x7E, 0xA3, 0xCA, 0x2D, 0x4B, 0xB8, 0x9C,
   0x35, 0xC3, 0xB6, 0x49, 0x32, 0x25, 0xB3, 0xB0,
   0x76, 0xC0, 0xF5, 0x00, 0x8A, 0xAF, 0x19, 0xDB,
   0xDD, 0x47, 0xDC, 0x07, 0xB2, 0x4A, 0x55, 0xE6,
   0x69, 0xEC, 0xED, 0x06, 0x94, 0xB9, 0xA7, 0x56,
   0x2C, 0xAA, 0xE3, 0x22, 0x3B, 0x98, 0x77, 0x52,
   0x3C, 0x64, 0xF8, 0x13, 0x78, 0xFC, 0xFB, 0xF3,
   0xD3, 0xF9, 0x29, 0x45, 0x51, 0x8C, 0xA0, 0x38,
   0xD9, 0xA5, 0x62, 0x3A, 0x6E, 0xD0, 0xE8, 0x7A,
   0x33, 0x1D, 0xB4, 0x73, 0x02, 0xFF, 0x10, 0x80,
   0x6B, 0xF0, 0xA4, 0xBA, 0xF6, 0xC2, 0x0E, 0xE2,
   0x81, 0x43, 0x84, 0x86, 0x1F, 0x31, 0x2F, 0xA9,
   0x1B, 0x2A, 0x4E, 0xF4, 0x95, 0x5B, 0x3F, 0x34,
   0x39, 0x7B, 0x0A, 0x26, 0x6D, 0x57, 0x50, 0x09,
   0x9E, 0xA8, 0xBC, 0x24, 0x93, 0x67, 0x41, 0x96,
   0x0C, 0x46, 0xBD, 0xE9, 0x68, 0x18, 0xAB, 0x2E,
   0x5D, 0x1A, 0x8D, 0xC1, 0x58, 0x48, 0xAD, 0x0F };

unsigned char table_60[32] = {
   0x1C, 0x06, 0x1E, 0x10, 0x1D, 0x05, 0x00, 0x0E,
   0x0C, 0x02, 0x11, 0x19, 0x15, 0x18, 0x16, 0x07,
   0x1F, 0x0B, 0x14, 0x01, 0x0F, 0x09, 0x0D, 0x13,
   0x03, 0x08, 0x12, 0x04, 0x1B, 0x0A, 0x17, 0x1A };

unsigned char table_61[256] = {
   0xC5, 0xA6, 0xF2, 0x6B, 0x4B, 0x58, 0xE0, 0x41,
   0xC6, 0x2F, 0x13, 0xFE, 0xC1, 0x34, 0x3F, 0x24,
   0x10, 0xBF, 0x8B, 0xC9, 0x26, 0x2E, 0x68, 0xBE,
   0x28, 0x54, 0x93, 0x11, 0x21, 0x03, 0xFF, 0x50,
   0x31, 0x71, 0x2C, 0x6C, 0x91, 0x8F, 0x3B, 0x40,
   0x3E, 0xE5, 0xA5, 0x80, 0xEA, 0x7C, 0x9D, 0x18,
   0x84, 0x5A, 0x73, 0x3A, 0x33, 0x43, 0xA1, 0x47,
   0xB1, 0xEE, 0xFB, 0x79, 0x5E, 0xAF, 0xB9, 0x48,
   0x0F, 0x88, 0x65, 0x67, 0x6F, 0xDB, 0x25, 0xE4,
   0xB0, 0x87, 0xD0, 0x46, 0xB5, 0xB7, 0x53, 0xD4,
   0x1E, 0x76, 0xB4, 0x90, 0xDD, 0xA3, 0xF7, 0x57,
   0xD2, 0xCC, 0x5D, 0xE3, 0xB3, 0xD8, 0x5F, 0x2B,
   0x69, 0x4A, 0x9B, 0x39, 0x1A, 0x8D, 0x05, 0x8A,
   0x44, 0x15, 0xAE, 0xF3, 0xA8, 0x92, 0x02, 0xAB,
   0xB8, 0xDA, 0x0A, 0x0C, 0xED, 0xD7, 0x77, 0x98,
   0x3D, 0x19, 0x95, 0x36, 0xE7, 0x7F, 0x66, 0xEF,
   0x86, 0xDC, 0xCB, 0x9C, 0x63, 0xE6, 0x1D, 0x14,
   0x9A, 0x22, 0xBD, 0xD6, 0x89, 0x2D, 0xD1, 0xF9,
   0xA2, 0xDE, 0xF5, 0x5C, 0x8E, 0x2A, 0x29, 0xCA,
   0x7A, 0x8C, 0x38, 0x9F, 0xBB, 0xDF, 0xEC, 0x30,
   0x00, 0xFC, 0xAC, 0x81, 0xB2, 0xE8, 0xC0, 0xA7,
   0x7B, 0x07, 0x52, 0x74, 0x70, 0x0E, 0x51, 0x6A,
   0x62, 0x0D, 0x85, 0x1B, 0x4F, 0x96, 0x55, 0x1C,
   0x32, 0x6E, 0x01, 0xF6, 0x08, 0xFD, 0x17, 0x35,
   0xF0, 0x16, 0xC8, 0x23, 0xE9, 0x59, 0x3C, 0x37,
   0x5B, 0x42, 0xD3, 0x49, 0x7D, 0x83, 0x78, 0xAD,
   0x94, 0x9E, 0x56, 0xB6, 0xF1, 0xC3, 0x75, 0xF8,
   0xFA, 0x09, 0x4C, 0xD9, 0x97, 0xF4, 0x7E, 0x6D,
   0xBC, 0x4D, 0x64, 0xCD, 0x12, 0x99, 0x45, 0xCE,
   0x61, 0x20, 0x0B, 0xA0, 0x82, 0xD5, 0xE1, 0x72,
   0xA9, 0x1F, 0x06, 0x27, 0xC7, 0x04, 0xE2, 0xBA,
   0xCF, 0x60, 0xAA, 0xA4, 0xEB, 0xC4, 0x4E, 0xC2 };

unsigned char table_62[256] = {
   0x01, 0x59, 0xEC, 0xFC, 0x51, 0xD2, 0xE4, 0x9D,
   0xAA, 0x61, 0xD5, 0xCA, 0x63, 0x5D, 0xCE, 0x36,
   0xB9, 0x49, 0x76, 0xA9, 0x14, 0x4C, 0x90, 0x28,
   0x66, 0x17, 0x4F, 0x1E, 0x1A, 0x47, 0x30, 0xE8,
   0xFD, 0x86, 0x2E, 0x7B, 0x7E, 0xCC, 0x34, 0x13,
   0x94, 0x45, 0x38, 0x74, 0x29, 0xB0, 0x37, 0xC3,
   0x26, 0x6C, 0x39, 0xA3, 0x89, 0xEB, 0xA2, 0x20,
   0x00, 0xE0, 0x73, 0xE7, 0xB5, 0xCB, 0xED, 0x3E,
   0x79, 0x09, 0xFA, 0x32, 0x54, 0xBA, 0x05, 0x96,
   0xDE, 0x23, 0xD0, 0xA1, 0xAB, 0xFE, 0xF2, 0x22,
   0xB2, 0x9B, 0x7D, 0x44, 0x12, 0x3D, 0x40, 0x82,
   0xA0, 0xA8, 0x33, 0xDC, 0xF7, 0xFB, 0xAC, 0x41,
   0x8A, 0x9C, 0x60, 0x11, 0xC8, 0xF0, 0xEA, 0x57,
   0x3A, 0x42, 0xCD, 0x1D, 0x3C, 0xC6, 0x97, 0x62,
   0x55, 0x9F, 0xF3, 0x93, 0x91, 0xDA, 0x6A, 0xE5,
   0x27, 0x8E, 0x4E, 0xFF, 0xA4, 0x80, 0x04, 0xE1,
   0x2B, 0x5E, 0xC0, 0x64, 0xC2, 0xD8, 0x46, 0x8C,
   0xD4, 0x0F, 0xC4, 0x43, 0xD9, 0x9E, 0x4B, 0x5C,
   0x0A, 0x8B, 0xBF, 0xD7, 0x7A, 0x81, 0x3B, 0x4A,
   0x58, 0xB6, 0x21, 0x1F, 0xC1, 0xBD, 0xB1, 0x77,
   0x72, 0x1C, 0x4D, 0xBC, 0xA5, 0x65, 0xC7, 0xF5,
   0xB4, 0x2D, 0x69, 0x71, 0xE6, 0x8F, 0xBB, 0x03,
   0xAF, 0xD6, 0x08, 0x75, 0xB7, 0x31, 0xF4, 0x2A,
   0x48, 0x70, 0x0C, 0x8D, 0xD1, 0x87, 0x2F, 0x16,
   0x5A, 0x5B, 0x98, 0xA6, 0xC5, 0x99, 0x50, 0x07,
   0xDD, 0x92, 0x25, 0x68, 0x0D, 0xBE, 0x78, 0x0B,
   0xAD, 0x84, 0x6B, 0x19, 0x52, 0x7C, 0xF6, 0xB3,
   0x56, 0x83, 0x88, 0xEE, 0x2C, 0x1B, 0x6E, 0x53,
   0x67, 0xE2, 0x6F, 0x15, 0x06, 0x10, 0x18, 0x85,
   0xF1, 0x6D, 0xF9, 0xC9, 0xAE, 0x3F, 0xB8, 0x95,
   0x35, 0xDF, 0xEF, 0xA7, 0x7F, 0x24, 0xF8, 0xE3,
   0xCF, 0xE9, 0xDB, 0xD3, 0x02, 0x9A, 0x0E, 0x5F };

unsigned char table_63[256] = {
   0x0C, 0x02, 0xEE, 0x94, 0x2D, 0x76, 0x96, 0x75,
   0x21, 0xDC, 0x37, 0x03, 0xC0, 0xF7, 0xDF, 0xEF,
   0xB1, 0x1D, 0xCF, 0x15, 0x5A, 0xB4, 0xCC, 0x81,
   0x89, 0x6B, 0xA5, 0x2E, 0x6D, 0xD4, 0x08, 0x44,
   0x2A, 0x60, 0x50, 0xBF, 0x40, 0x7D, 0x5F, 0x64,
   0x93, 0x70, 0xA4, 0x7F, 0xC9, 0xEB, 0x0A, 0xF8,
   0x9F, 0xA8, 0xBC, 0x25, 0xE5, 0xF3, 0x1B, 0xD7,
   0x29, 0x13, 0x0D, 0x69, 0x20, 0x5C, 0x0F, 0x91,
   0x4F, 0x62, 0x06, 0x26, 0x41, 0xED, 0xDA, 0x53,
   0x65, 0xFF, 0xCD, 0x3F, 0xF6, 0x01, 0xCE, 0xA2,
   0x04, 0xDE, 0x27, 0x87, 0xBA, 0x86, 0x24, 0x78,
   0xAF, 0xE1, 0x3D, 0xD0, 0xC8, 0x1F, 0x4A, 0x2C,
   0x9A, 0xF0, 0xCB, 0xAD, 0x0B, 0x59, 0xC5, 0x58,
   0xEA, 0x8A, 0xA1, 0x45, 0xB7, 0x5D, 0xB5, 0x77,
   0x2B, 0x47, 0x05, 0x00, 0xAC, 0x61, 0xFA, 0x33,
   0x74, 0x31, 0xCA, 0x22, 0x42, 0x8B, 0xFE, 0x09,
   0xB2, 0x6E, 0x1A, 0xBE, 0xAA, 0x7B, 0xEC, 0xF4,
   0x51, 0x66, 0x28, 0x12, 0xFC, 0x5E, 0x67, 0xF5,
   0xB9, 0x82, 0x90, 0x8E, 0x8D, 0x17, 0xE7, 0xE8,
   0xB0, 0xC3, 0x16, 0xA0, 0x4B, 0xB6, 0xFB, 0x7E,
   0xC4, 0x85, 0x4C, 0x1E, 0xC7, 0x39, 0x4E, 0xA9,
   0xE3, 0x4D, 0x32, 0x72, 0x35, 0x80, 0xE0, 0x34,
   0xB8, 0x73, 0x98, 0x49, 0x92, 0x30, 0xD5, 0xD2,
   0xA3, 0x54, 0x7A, 0x84, 0x8F, 0x6C, 0xFD, 0x43,
   0x3A, 0x36, 0x3B, 0xD9, 0x48, 0x6A, 0x14, 0x79,
   0xD1, 0x57, 0x88, 0xDB, 0xE4, 0x9B, 0xF9, 0x99,
   0x10, 0x71, 0xC1, 0x68, 0x9E, 0x11, 0xAB, 0xBD,
   0x7C, 0x3E, 0x3C, 0x18, 0x9D, 0x97, 0xF2, 0xE6,
   0xA6, 0xF1, 0x46, 0xC2, 0x19, 0xBB, 0x52, 0xD8,
   0x95, 0xD3, 0x23, 0xAE, 0x07, 0x2F, 0xE9, 0x63,
   0x1C, 0x55, 0x6F, 0x9C, 0x56, 0x38, 0xC6, 0x5B,
   0x8C, 0xE2, 0x83, 0xA7, 0xD6, 0x0E, 0xB3, 0xDD };

unsigned char table_64[32] = {
   0x03, 0x05, 0x0D, 0x09, 0x1A, 0x16, 0x08, 0x10,
   0x06, 0x1E, 0x1C, 0x15, 0x02, 0x04, 0x17, 0x0C,
   0x18, 0x0B, 0x19, 0x11, 0x1B, 0x14, 0x13, 0x0A,
   0x0E, 0x00, 0x1D, 0x1F, 0x01, 0x0F, 0x07, 0x12 };

unsigned char table_65[32] = {
   0x01, 0x0A, 0x1E, 0x14, 0x10, 0x1D, 0x0D, 0x17,
   0x0E, 0x0C, 0x0F, 0x12, 0x04, 0x1A, 0x05, 0x02,
   0x08, 0x1C, 0x09, 0x1F, 0x0B, 0x13, 0x19, 0x1B,
   0x11, 0x00, 0x16, 0x06, 0x03, 0x18, 0x15, 0x07 };

unsigned char table_66[32] = {
   0x1C, 0x18, 0x0C, 0x09, 0x05, 0x03, 0x15, 0x12,
   0x0D, 0x02, 0x08, 0x0E, 0x19, 0x07, 0x13, 0x17,
   0x1E, 0x1D, 0x1F, 0x11, 0x06, 0x0A, 0x0B, 0x14,
   0x0F, 0x10, 0x01, 0x1B, 0x00, 0x04, 0x1A, 0x16 };

unsigned char table_67[256] = {
   0x6B, 0x49, 0xC8, 0x86, 0xFF, 0xC0, 0x5D, 0xEF,
   0xF7, 0x06, 0xE0, 0x98, 0xA9, 0x72, 0x71, 0xD5,
   0xBA, 0x7F, 0x10, 0xD1, 0xBE, 0x41, 0x9C, 0x40,
   0x28, 0x8E, 0xE5, 0x74, 0x47, 0x9E, 0x3E, 0x7C,
   0xB5, 0xCD, 0x3F, 0x20, 0xF2, 0xA6, 0xDC, 0x97,
   0x32, 0x6D, 0x52, 0xF5, 0x16, 0x05, 0xFE, 0x04,
   0x3D, 0x53, 0x50, 0x23, 0x39, 0x77, 0x08, 0x60,
   0x75, 0x18, 0x4A, 0xC6, 0xBB, 0xE7, 0xF1, 0xAB,
   0xEB, 0x88, 0xB6, 0x82, 0x6E, 0x91, 0xF3, 0x34,
   0x3A, 0x42, 0x1A, 0xDF, 0xA1, 0xB3, 0x92, 0xBF,
   0xB7, 0x00, 0xD4, 0xDE, 0x31, 0xF0, 0x1C, 0xDA,
   0x4F, 0x61, 0x67, 0x2C, 0x07, 0xF9, 0x15, 0xA4,
   0x7A, 0x26, 0x45, 0x2A, 0x12, 0x9F, 0xF4, 0x14,
   0x8C, 0x90, 0xFC, 0xC5, 0x4B, 0x87, 0xE2, 0xC7,
   0xD0, 0x8A, 0xE8, 0xDD, 0xEE, 0x3C, 0x2F, 0x22,
   0x6A, 0x54, 0x37, 0x9B, 0x84, 0x25, 0x8F, 0xE3,
   0xD7, 0xD8, 0x4E, 0xAD, 0x0F, 0x4C, 0x56, 0xA2,
   0xD3, 0xB0, 0x73, 0x0B, 0xAE, 0xEA, 0x1D, 0x01,
   0x36, 0xB4, 0x2D, 0xC4, 0x19, 0x58, 0x1E, 0x62,
   0xE9, 0xB2, 0x5B, 0x5A, 0xBD, 0xD6, 0x65, 0x94,
   0x9A, 0x55, 0xCC, 0x99, 0x1B, 0x85, 0x2B, 0xBC,
   0x8D, 0x46, 0x81, 0xB8, 0xA3, 0x29, 0x5F, 0x35,
   0x5C, 0xB1, 0x1F, 0x13, 0x17, 0xCB, 0x51, 0x02,
   0x09, 0x7E, 0xA7, 0x69, 0x6F, 0x95, 0x30, 0x7B,
   0xCA, 0x48, 0xAF, 0xAA, 0x0E, 0x44, 0x38, 0xB9,
   0x0D, 0x11, 0xA0, 0xD9, 0x0C, 0xDB, 0xF8, 0x68,
   0x33, 0x79, 0x59, 0x66, 0x4D, 0x03, 0xE1, 0x89,
   0xE4, 0x3B, 0x78, 0xC2, 0x64, 0x6C, 0x27, 0xC9,
   0xCF, 0xAC, 0xED, 0xFA, 0x5E, 0x2E, 0x76, 0x57,
   0x93, 0xEC, 0x80, 0xA8, 0xE6, 0xCE, 0xC1, 0xA5,
   0x9D, 0xD2, 0xC3, 0x0A, 0x7D, 0x70, 0xF6, 0x63,
   0x24, 0x43, 0x21, 0x83, 0xFB, 0xFD, 0x8B, 0x96 };

unsigned char table_68[256] = {
   0x93, 0xFF, 0x83, 0x70, 0x12, 0x2D, 0x1C, 0xD6,
   0xF9, 0xEE, 0xCF, 0x94, 0x7B, 0xB5, 0xA4, 0x84,
   0x99, 0xF7, 0x67, 0x32, 0xFC, 0x8A, 0xE3, 0xE4,
   0xCE, 0xC6, 0x77, 0x7E, 0xDA, 0x42, 0x85, 0xF0,
   0x7D, 0x48, 0x28, 0x79, 0xDE, 0x5B, 0xE2, 0x0F,
   0x75, 0xC5, 0x2C, 0x4F, 0xF3, 0xEC, 0x14, 0x10,
   0x9C, 0x6E, 0x59, 0x4A, 0x20, 0x34, 0xA3, 0x89,
   0xE0, 0x4E, 0x52, 0x88, 0x81, 0x5F, 0x6F, 0x71,
   0x17, 0x3B, 0x21, 0xB4, 0xCB, 0x9B, 0x18, 0x13,
   0xE8, 0xE1, 0x02, 0x2E, 0xED, 0x00, 0xA7, 0x1B,
   0x06, 0xF4, 0x27, 0xDC, 0x35, 0x2F, 0x08, 0x9D,
   0x7C, 0xC0, 0x36, 0xA6, 0x6B, 0xDF, 0x4C, 0xBC,
   0xFE, 0xDB, 0xA5, 0xA8, 0x8D, 0x73, 0x7F, 0xC7,
   0x8E, 0x60, 0x31, 0x61, 0x4B, 0x29, 0xD7, 0xE9,
   0xBD, 0xAB, 0xCC, 0xFA, 0xD9, 0xEF, 0xC2, 0xD4,
   0x19, 0x11, 0x15, 0xC9, 0xB1, 0xD5, 0x64, 0x97,
   0xE7, 0x8F, 0x05, 0x44, 0xF8, 0xF1, 0x58, 0x47,
   0x2A, 0x03, 0x1F, 0xAF, 0x0D, 0x04, 0x23, 0xB8,
   0x24, 0x51, 0xB2, 0x54, 0x41, 0x53, 0x5C, 0xAE,
   0xB7, 0xB3, 0xB6, 0x3D, 0x37, 0x39, 0x55, 0xBF,
   0x0B, 0x7A, 0x57, 0x3C, 0x0E, 0x40, 0x6A, 0xF5,
   0x72, 0xDD, 0xBB, 0x8B, 0xAA, 0x46, 0xA0, 0x30,
   0x56, 0x78, 0x38, 0xBA, 0x9E, 0x92, 0x87, 0xFB,
   0x66, 0x90, 0x1E, 0xB9, 0x96, 0x65, 0xA2, 0x50,
   0x1D, 0xC3, 0x26, 0x22, 0xD0, 0x0A, 0x43, 0xF2,
   0xB0, 0xEB, 0xAC, 0x62, 0x98, 0x3F, 0xD3, 0x69,
   0xA1, 0x9F, 0x16, 0x95, 0xE6, 0xF6, 0x2B, 0x25,
   0x1A, 0xD2, 0xBE, 0x09, 0x5D, 0x45, 0xC4, 0xFD,
   0x5A, 0x07, 0x0C, 0x82, 0x3E, 0x49, 0x74, 0x6C,
   0x68, 0x5E, 0xCA, 0xEA, 0xCD, 0x9A, 0xAD, 0xD1,
   0x33, 0x86, 0x76, 0x80, 0xE5, 0xC8, 0xD8, 0xA9,
   0x8C, 0x6D, 0x91, 0x63, 0x3A, 0x4D, 0xC1, 0x01 };

unsigned char table_69[256] = {
   0x21, 0x6B, 0x9B, 0xAE, 0x11, 0x5A, 0x91, 0xC2,
   0x47, 0x8E, 0x87, 0x86, 0x4F, 0xFC, 0x8F, 0x66,
   0x97, 0x2F, 0x61, 0x9C, 0x5B, 0x4C, 0xB3, 0x14,
   0x77, 0x48, 0x62, 0xE1, 0x54, 0x64, 0xDD, 0xCD,
   0x30, 0xB7, 0x2D, 0xD2, 0xC3, 0xC0, 0x0B, 0xD8,
   0x53, 0x98, 0x16, 0x56, 0x7A, 0x35, 0x50, 0xD9,
   0xE8, 0x2C, 0x32, 0x55, 0x17, 0x5D, 0x79, 0xEB,
   0xC8, 0x75, 0x67, 0xE2, 0x4B, 0xBA, 0xFE, 0x57,
   0x10, 0xF4, 0x70, 0x2A, 0xBB, 0xA6, 0x72, 0x36,
   0xAF, 0x8D, 0xAB, 0x90, 0xE3, 0x2B, 0xB2, 0x26,
   0x93, 0x01, 0xBD, 0x71, 0xF9, 0x05, 0xC7, 0x80,
   0x29, 0xCC, 0x3B, 0x22, 0xF2, 0x12, 0x81, 0x34,
   0xF6, 0x1A, 0x8B, 0xDF, 0x28, 0x46, 0x9E, 0x6A,
   0x23, 0x85, 0x74, 0xE7, 0xE6, 0x52, 0xA0, 0x49,
   0xF0, 0x19, 0x25, 0xAC, 0x78, 0x42, 0xD6, 0xA2,
   0x37, 0x65, 0x4D, 0x94, 0x02, 0x6F, 0xB4, 0xC6,
   0x99, 0xD3, 0x9A, 0x33, 0xB8, 0x00, 0xCA, 0xE4,
   0x45, 0xAD, 0x1B, 0x6C, 0x03, 0xA8, 0x07, 0x8A,
   0x60, 0x69, 0xFF, 0xF7, 0xA7, 0x27, 0x95, 0xF5,
   0x82, 0xCB, 0xEC, 0xED, 0x4E, 0xFB, 0xA4, 0x59,
   0xDA, 0xCF, 0x2E, 0x20, 0xFA, 0x31, 0xD1, 0xEA,
   0x4A, 0xE9, 0x5E, 0xA9, 0xA1, 0x08, 0x1C, 0x96,
   0x38, 0xB9, 0xEE, 0x7F, 0xAA, 0xF1, 0x7D, 0x3A,
   0xA5, 0x43, 0xC5, 0xE0, 0x24, 0x39, 0x0D, 0xDE,
   0xB0, 0xF8, 0xBE, 0x58, 0x7E, 0x51, 0xD4, 0x89,
   0x15, 0x40, 0x3E, 0xB1, 0x1F, 0x5F, 0x68, 0x63,
   0x84, 0x3D, 0x88, 0xBC, 0x41, 0xEF, 0xB5, 0xBF,
   0x06, 0x6E, 0x9D, 0x3F, 0x0E, 0x76, 0x5C, 0xDC,
   0x13, 0xF3, 0xE5, 0x8C, 0x7C, 0x04, 0x0A, 0xD5,
   0x18, 0xC4, 0x44, 0x09, 0xC9, 0x1D, 0x9F, 0xFD,
   0xD0, 0x0F, 0x6D, 0xD7, 0x92, 0x7B, 0x0C, 0xA3,
   0x73, 0xDB, 0xB6, 0x83, 0xCE, 0x1E, 0xC1, 0x3C };

unsigned char table_70[256] = {
   0x54, 0x23, 0xF1, 0x09, 0x9D, 0xEB, 0x26, 0xD9,
   0x6C, 0xC1, 0xBC, 0x3D, 0x6E, 0xB0, 0x5F, 0xE2,
   0x59, 0x4D, 0x95, 0xFA, 0xD8, 0x29, 0xAA, 0x8E,
   0xF5, 0xEF, 0x43, 0x76, 0xFD, 0x0D, 0x4F, 0xAD,
   0xB7, 0xFC, 0xA8, 0x9F, 0x62, 0xC2, 0x7B, 0x10,
   0x0B, 0xF2, 0x73, 0xA9, 0x46, 0x4C, 0x53, 0xD7,
   0x0A, 0x50, 0x89, 0x63, 0x48, 0xD6, 0xA2, 0x44,
   0xE6, 0x8D, 0x69, 0x2C, 0xF9, 0xC0, 0x35, 0x06,
   0x66, 0x21, 0x9E, 0xD2, 0x98, 0xF7, 0x9B, 0xE7,
   0x12, 0xB8, 0xA5, 0xBA, 0xE0, 0x79, 0x71, 0x7E,
   0x8C, 0x24, 0xED, 0x7C, 0x60, 0x81, 0xC3, 0x5C,
   0x2B, 0xE5, 0xEE, 0xB5, 0xA4, 0x05, 0x03, 0x34,
   0x16, 0x2A, 0xA3, 0x2D, 0x3F, 0xDF, 0x07, 0x5B,
   0xAE, 0x47, 0x61, 0x08, 0x18, 0xDB, 0x6D, 0x3C,
   0x96, 0xD5, 0xAB, 0x78, 0x94, 0x45, 0x20, 0x9A,
   0xE4, 0x13, 0x68, 0xDD, 0xDE, 0x31, 0x14, 0x57,
   0x02, 0x52, 0x56, 0x1C, 0x1B, 0xE9, 0xD0, 0xA1,
   0x22, 0x64, 0xB2, 0x7A, 0xCF, 0x5D, 0x00, 0x0F,
   0xF8, 0x5E, 0x36, 0x58, 0x40, 0xAF, 0x19, 0x32,
   0x2E, 0xB3, 0x72, 0xBE, 0xB9, 0xD3, 0xCD, 0x7D,
   0x4A, 0x1D, 0x33, 0x2F, 0xAC, 0x27, 0x41, 0xE8,
   0x55, 0xCB, 0x0E, 0x5A, 0x77, 0xFB, 0x8B, 0x86,
   0x75, 0x8A, 0x51, 0xEC, 0xDA, 0xC6, 0xA6, 0xCC,
   0x91, 0x4B, 0x11, 0xF6, 0xEA, 0xD1, 0xB6, 0x4E,
   0x82, 0x04, 0x92, 0x30, 0xF4, 0x25, 0x88, 0x1E,
   0x9C, 0xA0, 0xC8, 0x6A, 0x93, 0x87, 0x1F, 0xB4,
   0xB1, 0x8F, 0x65, 0xCA, 0xFE, 0xFF, 0x97, 0x15,
   0x99, 0x28, 0x80, 0x42, 0x70, 0x85, 0x0C, 0x3B,
   0xBD, 0xE1, 0xA7, 0x17, 0xC9, 0x3A, 0xBB, 0x6B,
   0x37, 0xF0, 0xC5, 0x39, 0x6F, 0x01, 0x83, 0x67,
   0x74, 0xCE, 0xDC, 0x90, 0x3E, 0xF3, 0x7F, 0xC4,
   0x49, 0x84, 0x38, 0xC7, 0xE3, 0xD4, 0x1A, 0xBF };

unsigned char table_71[32] = {
   0x17, 0x13, 0x0E, 0x1A, 0x0D, 0x18, 0x19, 0x10,
   0x14, 0x11, 0x16, 0x05, 0x04, 0x00, 0x12, 0x0A,
   0x02, 0x07, 0x03, 0x0B, 0x09, 0x1F, 0x1C, 0x0F,
   0x0C, 0x06, 0x1B, 0x08, 0x1D, 0x01, 0x15, 0x1E };

unsigned char table_72[256] = {
   0xC9, 0xA7, 0x1B, 0xEC, 0x2B, 0x8B, 0xB0, 0xEB,
   0x7F, 0x39, 0x25, 0xD9, 0x1D, 0xD5, 0x67, 0xA0,
   0xB3, 0xAC, 0x3B, 0xC8, 0x82, 0xC0, 0xE3, 0x9E,
   0x4C, 0x9B, 0xAF, 0xFD, 0x91, 0x86, 0x5F, 0x92,
   0xB4, 0x42, 0x3C, 0x45, 0x12, 0xC4, 0xE2, 0xE1,
   0x6C, 0x1F, 0xC6, 0x40, 0x93, 0x2A, 0xC2, 0x72,
   0x2E, 0x14, 0x51, 0xA5, 0x70, 0xBD, 0xA2, 0xC7,
   0x7D, 0xF1, 0x9F, 0x64, 0xC1, 0xF7, 0x80, 0xFF,
   0x50, 0x49, 0x8C, 0x66, 0x13, 0x48, 0x6A, 0x0A,
   0x26, 0x94, 0x83, 0x1E, 0x84, 0xBB, 0x57, 0x27,
   0x44, 0x5B, 0x62, 0xF6, 0x09, 0x4F, 0x77, 0x76,
   0x2D, 0x7E, 0xCD, 0x0B, 0x24, 0xFE, 0x81, 0xB8,
   0x21, 0x85, 0xCF, 0xA8, 0x75, 0x56, 0x37, 0x17,
   0xAA, 0x23, 0xE5, 0xE8, 0x9A, 0x9D, 0x2F, 0x04,
   0x31, 0x4A, 0x7C, 0xFC, 0xD6, 0xE4, 0x29, 0xC3,
   0xFB, 0x36, 0x1C, 0x0C, 0xCE, 0xEE, 0x0D, 0xF3,
   0x46, 0xF8, 0x41, 0x0E, 0x68, 0xAB, 0x2C, 0x69,
   0x96, 0x90, 0x28, 0xED, 0x02, 0x63, 0x07, 0xAD,
   0xB2, 0xDC, 0x05, 0xE6, 0x78, 0x03, 0xA4, 0x7A,
   0x5C, 0x52, 0x95, 0x5D, 0x88, 0x01, 0xDF, 0x35,
   0x5E, 0xB6, 0x06, 0x4D, 0x15, 0x89, 0x59, 0x3F,
   0xF0, 0xA1, 0xA3, 0x99, 0x19, 0xEA, 0xDB, 0xE0,
   0x6B, 0x71, 0x6E, 0xB7, 0x65, 0x54, 0x9C, 0xBC,
   0x98, 0xDD, 0x4B, 0x60, 0x3D, 0xBF, 0xF5, 0xD1,
   0xD7, 0xF9, 0x55, 0x61, 0xA9, 0xB1, 0x6D, 0xDE,
   0x79, 0xAE, 0x1A, 0x34, 0x3A, 0x4E, 0xCB, 0x38,
   0xBA, 0x97, 0x00, 0x74, 0xEF, 0xD8, 0x18, 0x33,
   0x7B, 0xFA, 0x22, 0x32, 0x20, 0xCA, 0x8A, 0xBE,
   0xA6, 0x43, 0x11, 0x10, 0xD0, 0xD3, 0x87, 0x73,
   0x6F, 0xF4, 0x8D, 0xCC, 0x30, 0x0F, 0x16, 0xDA,
   0xB5, 0xC5, 0xD4, 0x47, 0x8E, 0xE7, 0x58, 0x8F,
   0x08, 0x53, 0xF2, 0xB9, 0x5A, 0x3E, 0xE9, 0xD2 };

unsigned char table_73[256] = {
   0x36, 0x37, 0xED, 0xD8, 0xBF, 0xD7, 0x12, 0xB7,
   0x40, 0x32, 0x19, 0x4A, 0x44, 0x2A, 0xCE, 0xA5,
   0x29, 0x13, 0x43, 0x51, 0x5C, 0xD0, 0x76, 0x6E,
   0x41, 0xD6, 0xE2, 0x4F, 0xB8, 0x27, 0x2E, 0xCF,
   0xD9, 0xE0, 0x69, 0xC0, 0x59, 0x77, 0x62, 0x6F,
   0x53, 0xE7, 0x93, 0xD4, 0xAD, 0xC8, 0x4C, 0xC2,
   0x2C, 0xBE, 0xAA, 0xA0, 0x22, 0x78, 0x14, 0xB3,
   0xB0, 0xEA, 0xBA, 0x9A, 0x33, 0x1B, 0x31, 0x6C,
   0xFC, 0x0A, 0x0B, 0xA1, 0xE4, 0x75, 0x7C, 0xE3,
   0x65, 0x21, 0xA9, 0xA4, 0x4E, 0x3C, 0x5F, 0x39,
   0x74, 0xA2, 0x9E, 0x03, 0x70, 0xD2, 0xFD, 0x1D,
   0x25, 0x72, 0x73, 0x8E, 0x7B, 0xB2, 0x6A, 0x92,
   0x81, 0xF3, 0xF0, 0x46, 0x08, 0x85, 0xE6, 0x30,
   0x05, 0x7E, 0xEC, 0x0D, 0xDD, 0x42, 0x2F, 0x5B,
   0xB9, 0xCB, 0x84, 0x0C, 0x16, 0xC7, 0x24, 0xFA,
   0xF9, 0x8F, 0x20, 0xAC, 0x10, 0x55, 0xC3, 0x1A,
   0x8B, 0x94, 0x3D, 0xDB, 0xC9, 0x04, 0xB5, 0xCC,
   0xC6, 0x98, 0xB6, 0x8D, 0x0F, 0x3A, 0x06, 0x4B,
   0xEF, 0x35, 0x68, 0x3F, 0xEE, 0xE5, 0x63, 0xC5,
   0x60, 0x88, 0x52, 0x2D, 0x6D, 0xAB, 0xCD, 0xC4,
   0x1F, 0xF4, 0xCA, 0x67, 0x7D, 0x1C, 0xDA, 0x34,
   0xDE, 0x86, 0xAE, 0xF1, 0x61, 0x09, 0xF5, 0xF6,
   0x49, 0xE9, 0xF2, 0x48, 0x1E, 0xD3, 0x56, 0x18,
   0x9B, 0xB1, 0x57, 0x9D, 0xBB, 0x5E, 0xAF, 0x87,
   0x9F, 0x8A, 0xC1, 0x79, 0xA7, 0xA8, 0xFB, 0xDC,
   0x47, 0x3E, 0x97, 0x80, 0x91, 0xA6, 0x7A, 0xA3,
   0x9C, 0x11, 0x02, 0x2B, 0x58, 0xD1, 0xF7, 0x00,
   0x83, 0x01, 0xE8, 0xFE, 0x50, 0x23, 0x66, 0x4D,
   0xD5, 0x82, 0x89, 0x3B, 0xEB, 0xE1, 0xF8, 0x5A,
   0x15, 0x7F, 0x8C, 0x17, 0x96, 0x28, 0x5D, 0x64,
   0x26, 0x38, 0x71, 0x0E, 0x45, 0xDF, 0xB4, 0x99,
   0xFF, 0x90, 0x6B, 0xBC, 0x54, 0x95, 0xBD, 0x07 };

unsigned char table_74[256] = {
   0xA7, 0xCF, 0x99, 0x1A, 0x13, 0xC7, 0xE9, 0xC4,
   0xB6, 0x0E, 0x15, 0x09, 0xFF, 0xDF, 0xBE, 0x03,
   0xAD, 0xF1, 0xB0, 0x3C, 0x4A, 0x9B, 0xF5, 0x12,
   0xA1, 0x2C, 0xDB, 0x51, 0x5E, 0x6F, 0xE6, 0x49,
   0x27, 0xBB, 0xAE, 0x56, 0xC0, 0x0C, 0x77, 0x60,
   0x5B, 0x69, 0xA2, 0xF0, 0x24, 0x8E, 0xE1, 0xA4,
   0xBC, 0x9F, 0x50, 0xD4, 0x61, 0x19, 0x67, 0x00,
   0x7B, 0xAB, 0xDD, 0x26, 0xCD, 0x6C, 0xE8, 0xA8,
   0x7A, 0x93, 0xEF, 0x20, 0x52, 0x1F, 0x1B, 0x46,
   0x25, 0x3B, 0x1E, 0x65, 0xC2, 0xF9, 0x10, 0xB2,
   0xB3, 0xD9, 0x21, 0xD2, 0x11, 0x94, 0xE2, 0xFC,
   0x38, 0x9E, 0x36, 0x87, 0xAA, 0x53, 0x45, 0x68,
   0x2B, 0xE7, 0x07, 0xFA, 0xD3, 0x8D, 0x3F, 0x17,
   0xC1, 0x06, 0x72, 0x62, 0x8C, 0x55, 0x73, 0x8A,
   0xC9, 0x2E, 0x5A, 0x7D, 0x02, 0x6D, 0xF8, 0x4B,
   0xE4, 0xBF, 0xEC, 0xB7, 0x31, 0xDC, 0xF4, 0xB8,
   0x47, 0x64, 0x0A, 0x33, 0x48, 0xAC, 0xFB, 0x05,
   0x3E, 0x34, 0x1C, 0x97, 0x1D, 0x63, 0x37, 0x2D,
   0xB1, 0x92, 0xED, 0x9D, 0x4C, 0xD5, 0x4E, 0x9A,
   0x0D, 0x79, 0x0F, 0xBD, 0x95, 0xBA, 0x08, 0x2A,
   0xC6, 0x7E, 0x88, 0xCB, 0xA6, 0x29, 0x70, 0x35,
   0x66, 0xCA, 0x89, 0x75, 0x6A, 0x4F, 0xB5, 0x6B,
   0x74, 0xDE, 0x01, 0x04, 0x81, 0x91, 0x90, 0x18,
   0x32, 0x0B, 0x7F, 0x44, 0xB4, 0xAF, 0xF2, 0xEB,
   0x22, 0xFD, 0x14, 0xA0, 0xFE, 0x8B, 0xB9, 0x16,
   0x86, 0xE3, 0xD7, 0xDA, 0xC5, 0x3A, 0x41, 0x83,
   0xD1, 0x28, 0x54, 0x30, 0xE0, 0x40, 0xA5, 0x57,
   0x8F, 0x84, 0xD6, 0x96, 0x39, 0xE5, 0x42, 0x80,
   0xA9, 0x58, 0xCE, 0x5D, 0xEE, 0x5F, 0xA3, 0xD0,
   0xC8, 0x59, 0x43, 0x4D, 0x5C, 0xF7, 0xCC, 0x76,
   0x6E, 0xF3, 0x23, 0x3D, 0x85, 0x82, 0x78, 0xF6,
   0x2F, 0xD8, 0xC3, 0x7C, 0x9C, 0x98, 0xEA, 0x71 };

unsigned char table_75[256] = {
   0xE7, 0xA5, 0x30, 0xE1, 0x9D, 0x81, 0xBE, 0x83,
   0xB2, 0x1E, 0xE4, 0x69, 0x2F, 0x2B, 0x0D, 0xEB,
   0x7C, 0x59, 0x2D, 0xAA, 0x01, 0x0C, 0xDB, 0xED,
   0xC4, 0xEE, 0x5D, 0x38, 0x72, 0xD8, 0x70, 0xCE,
   0x0B, 0xF6, 0x7F, 0x48, 0x26, 0x9E, 0xA3, 0x44,
   0xD6, 0xCF, 0x0F, 0x6B, 0xFD, 0x23, 0x98, 0xAB,
   0x11, 0xD4, 0x92, 0x91, 0x5E, 0x08, 0x4D, 0xC6,
   0xF0, 0xA8, 0x7E, 0x8A, 0x1D, 0xA1, 0x97, 0x76,
   0x3E, 0x64, 0x07, 0x24, 0xDE, 0x75, 0xA4, 0xCC,
   0x1A, 0x04, 0x4B, 0x6C, 0xFA, 0xB0, 0xC7, 0x35,
   0xE2, 0x56, 0x61, 0xA0, 0xE9, 0x27, 0xDF, 0xC3,
   0xE5, 0xF4, 0x8D, 0xB4, 0xD3, 0x52, 0xD7, 0x49,
   0xCD, 0x31, 0x6E, 0x3F, 0x4E, 0x6A, 0x5B, 0x65,
   0xCA, 0x14, 0x71, 0x53, 0xD9, 0x47, 0x28, 0x7D,
   0x17, 0x06, 0x5C, 0xFE, 0xBA, 0xB8, 0xAC, 0x15,
   0xE8, 0xE0, 0x9A, 0xDD, 0x1F, 0xBC, 0x95, 0x42,
   0xCB, 0x58, 0x00, 0x85, 0xD5, 0x62, 0xC9, 0xB6,
   0x05, 0x80, 0x4C, 0x3C, 0x1C, 0xF5, 0x03, 0xF8,
   0x96, 0x77, 0x02, 0x19, 0xF2, 0xFB, 0x5F, 0xC2,
   0xAE, 0x60, 0x1B, 0xAD, 0x8F, 0xC1, 0x33, 0xA6,
   0x20, 0xBF, 0xA7, 0xC8, 0x74, 0x18, 0x90, 0xE3,
   0x68, 0x09, 0x7A, 0x79, 0xB5, 0xDA, 0xF3, 0x0E,
   0x66, 0x84, 0xB3, 0xBB, 0xE6, 0xF7, 0xB7, 0x7B,
   0x39, 0x4A, 0x12, 0x4F, 0xC5, 0x41, 0x54, 0xD0,
   0xFF, 0x87, 0x63, 0x40, 0x99, 0x21, 0x29, 0xD2,
   0x3D, 0x37, 0x3A, 0x93, 0xFC, 0x25, 0xF1, 0xD1,
   0x2C, 0x6D, 0x8C, 0x5A, 0x8E, 0x9B, 0xBD, 0xAF,
   0x10, 0x55, 0xF9, 0x9F, 0x43, 0x0A, 0x50, 0x16,
   0x57, 0xB1, 0xC0, 0x73, 0x82, 0xEF, 0x88, 0x6F,
   0xEA, 0x2A, 0xEC, 0x2E, 0x86, 0x45, 0x51, 0x22,
   0xA9, 0x34, 0x94, 0x3B, 0xB9, 0x9C, 0xA2, 0x13,
   0x89, 0x46, 0x78, 0xDC, 0x32, 0x8B, 0x67, 0x36 };

unsigned char table_76[256] = {
   0x3D, 0x66, 0x40, 0xC5, 0x1D, 0xF5, 0xE7, 0xB7,
   0x2C, 0x23, 0x09, 0xC2, 0x68, 0xE6, 0xD3, 0x8D,
   0x35, 0x94, 0x93, 0xF0, 0x43, 0x97, 0x2B, 0x4B,
   0x1A, 0xEB, 0x00, 0x4C, 0x6F, 0xE4, 0x92, 0xEA,
   0xB8, 0xA3, 0xA6, 0xEC, 0x11, 0x5E, 0x61, 0x81,
   0xE1, 0x48, 0xC9, 0xCB, 0xDB, 0x2E, 0x3B, 0xED,
   0x36, 0x52, 0x3A, 0xD2, 0x4F, 0x4E, 0x22, 0x96,
   0x57, 0x2D, 0x62, 0x53, 0xCF, 0xD9, 0x5B, 0x9F,
   0x8E, 0x78, 0xC6, 0x07, 0x7D, 0xA1, 0x02, 0xB4,
   0xF4, 0xB6, 0x34, 0x98, 0xDA, 0xA9, 0xD4, 0x54,
   0x99, 0x82, 0x0A, 0xD8, 0x88, 0x5D, 0x3C, 0xD0,
   0xAB, 0x31, 0xFB, 0x03, 0x17, 0x46, 0xE8, 0xE2,
   0xA4, 0xFF, 0xB0, 0xAA, 0xAD, 0x7C, 0x55, 0x49,
   0x75, 0x6B, 0x10, 0x24, 0xC0, 0x04, 0xB1, 0xBF,
   0x6A, 0xF6, 0x15, 0xEF, 0x5C, 0x60, 0x27, 0x3E,
   0x38, 0x63, 0xC1, 0x76, 0xFD, 0x84, 0xE0, 0xCD,
   0xFE, 0x30, 0xCE, 0xBB, 0xDC, 0x1E, 0x1B, 0xBC,
   0xB5, 0xE9, 0x9E, 0x8F, 0x0D, 0x3F, 0x91, 0x19,
   0x28, 0x37, 0x26, 0x42, 0x08, 0x9A, 0x0C, 0x83,
   0x90, 0x6D, 0x74, 0x65, 0xF2, 0x4A, 0xDE, 0x8B,
   0x67, 0x0E, 0x8C, 0x5F, 0xF9, 0x7F, 0x5A, 0x86,
   0x69, 0x45, 0x44, 0xD5, 0xF7, 0xE5, 0x8A, 0xA8,
   0xC8, 0x7E, 0x05, 0x64, 0xEE, 0x79, 0xBE, 0x7A,
   0x14, 0xD6, 0x50, 0x18, 0x25, 0xBD, 0x85, 0xE3,
   0xA2, 0x70, 0xCC, 0x59, 0x71, 0x77, 0xFA, 0x47,
   0x9B, 0x1F, 0x9D, 0xBA, 0x29, 0x4D, 0xF8, 0xDF,
   0xC4, 0x72, 0x2F, 0xAE, 0x06, 0x51, 0x41, 0xAF,
   0xF3, 0xDD, 0x87, 0xB2, 0x9C, 0xC7, 0x12, 0x16,
   0x20, 0xA7, 0x21, 0x73, 0xF1, 0x58, 0xD7, 0x7B,
   0xB9, 0xB3, 0x32, 0x01, 0x80, 0x1C, 0x39, 0x0B,
   0x13, 0x56, 0x6C, 0x89, 0x33, 0x6E, 0x2A, 0xA5,
   0xD1, 0x95, 0xC3, 0xA0, 0x0F, 0xCA, 0xAC, 0xFC };

unsigned char table_77[32] = {
   0x1C, 0x0D, 0x1E, 0x01, 0x06, 0x16, 0x18, 0x17,
   0x0B, 0x1F, 0x04, 0x0F, 0x00, 0x19, 0x08, 0x0A,
   0x11, 0x03, 0x05, 0x07, 0x09, 0x0C, 0x15, 0x14,
   0x1A, 0x12, 0x13, 0x0E, 0x1D, 0x10, 0x02, 0x1B };

unsigned char table_78[32] = {
   0x0E, 0x02, 0x17, 0x12, 0x1E, 0x09, 0x15, 0x03,
   0x01, 0x0B, 0x0F, 0x11, 0x10, 0x0A, 0x16, 0x06,
   0x07, 0x00, 0x1C, 0x1D, 0x1F, 0x0C, 0x18, 0x04,
   0x13, 0x0D, 0x1B, 0x08, 0x19, 0x14, 0x05, 0x1A };

unsigned char table_79[32] = {
   0x12, 0x0B, 0x11, 0x01, 0x07, 0x0E, 0x1A, 0x0D,
   0x1E, 0x18, 0x14, 0x1F, 0x0A, 0x17, 0x19, 0x1B,
   0x00, 0x10, 0x0C, 0x08, 0x13, 0x02, 0x0F, 0x1D,
   0x09, 0x06, 0x04, 0x16, 0x15, 0x1C, 0x05, 0x03 };

unsigned char table_80[256] = {
   0x14, 0xE7, 0x31, 0x0F, 0xD1, 0x5F, 0xED, 0x1E,
   0xA6, 0x77, 0x20, 0x57, 0x34, 0x64, 0x33, 0x0B,
   0x5A, 0xB4, 0x83, 0x62, 0xFD, 0x8E, 0xE4, 0xF3,
   0xBD, 0xA5, 0xC8, 0x6D, 0x3E, 0x4F, 0x01, 0x7A,
   0xD3, 0x45, 0x3C, 0xF2, 0x68, 0xFF, 0xE6, 0x84,
   0xC2, 0xC1, 0x53, 0x72, 0x8C, 0xA1, 0xC7, 0x00,
   0x89, 0x97, 0x69, 0xA4, 0xF8, 0xAA, 0xAD, 0x8F,
   0x24, 0xC6, 0x9A, 0xAC, 0xE5, 0xAB, 0x6B, 0x79,
   0x99, 0x60, 0x28, 0x2B, 0x3B, 0xAF, 0x1C, 0x80,
   0xA3, 0x8A, 0x1A, 0xB5, 0xE1, 0x9F, 0xDA, 0x78,
   0xD7, 0xC4, 0x87, 0x5D, 0xE9, 0x27, 0xFB, 0x18,
   0x94, 0x3A, 0xCE, 0x3F, 0xF6, 0x12, 0x75, 0x37,
   0x6E, 0x9E, 0x29, 0x6C, 0xF7, 0x7D, 0x92, 0x08,
   0x42, 0xB2, 0xBF, 0x0C, 0xB6, 0x25, 0xE0, 0x49,
   0x43, 0x91, 0x98, 0xBB, 0xDC, 0x63, 0xEA, 0xA8,
   0x74, 0x38, 0x35, 0xCD, 0x07, 0x70, 0x81, 0x41,
   0xC9, 0x51, 0xBC, 0xA9, 0x59, 0xD4, 0xB8, 0x2C,
   0x7C, 0x2D, 0xB3, 0x6F, 0x11, 0x86, 0x9D, 0x46,
   0xF0, 0x65, 0x76, 0x04, 0x0E, 0xCA, 0xBE, 0x5C,
   0xF9, 0x71, 0x9C, 0x21, 0x4C, 0x02, 0xFE, 0x8D,
   0xD5, 0x26, 0x40, 0xC3, 0x32, 0x9B, 0xB0, 0x5E,
   0x48, 0xC5, 0x85, 0x4B, 0x0A, 0xCC, 0x58, 0x52,
   0x61, 0x13, 0xEF, 0x4A, 0xEE, 0x03, 0xD9, 0xDE,
   0xA7, 0x19, 0x09, 0x7F, 0x5B, 0x96, 0xBA, 0x0D,
   0xCF, 0xD2, 0x06, 0x1F, 0xD8, 0xDB, 0xEC, 0xA0,
   0xDD, 0x66, 0x10, 0xA2, 0xDF, 0x30, 0xF4, 0x88,
   0xCB, 0x36, 0x82, 0xE3, 0x73, 0x17, 0x55, 0x15,
   0xF5, 0xB7, 0x23, 0xB1, 0xD6, 0xE2, 0x47, 0x7E,
   0x67, 0xE8, 0x1D, 0x16, 0x8B, 0xEB, 0xD0, 0x3D,
   0x6A, 0x54, 0x2A, 0x4E, 0x93, 0xFA, 0x44, 0x05,
   0x2F, 0x50, 0x2E, 0x95, 0xAE, 0x1B, 0x56, 0x7B,
   0x39, 0xB9, 0xC0, 0x22, 0xF1, 0x4D, 0x90, 0xFC };

unsigned char table_81[32] = {
   0x03, 0x02, 0x1D, 0x0E, 0x09, 0x1A, 0x0C, 0x11,
   0x1C, 0x0D, 0x08, 0x12, 0x19, 0x10, 0x04, 0x17,
   0x15, 0x05, 0x0A, 0x00, 0x13, 0x16, 0x1B, 0x18,
   0x1E, 0x0B, 0x0F, 0x01, 0x07, 0x14, 0x1F, 0x06 };

unsigned char table_82[256] = {
   0x53, 0xD3, 0x64, 0x89, 0x7D, 0xA5, 0x66, 0xA4,
   0x09, 0x46, 0x17, 0x2C, 0xAF, 0x8C, 0x21, 0x5F,
   0x3B, 0x22, 0xE3, 0x05, 0x07, 0x28, 0x2F, 0xAB,
   0xF4, 0x8E, 0x51, 0x31, 0x02, 0xC7, 0x48, 0x13,
   0x24, 0x12, 0xB8, 0xE5, 0xBD, 0xAE, 0x7E, 0xCC,
   0xC9, 0x98, 0x08, 0xEE, 0xDB, 0x1B, 0xE8, 0x3D,
   0x8F, 0xF2, 0xFB, 0x36, 0x4D, 0x94, 0x9C, 0x16,
   0xF7, 0x42, 0x9B, 0x2B, 0xFD, 0x7B, 0x77, 0x3F,
   0xC3, 0xFC, 0x23, 0x93, 0x50, 0x0C, 0x79, 0x18,
   0x47, 0xE1, 0xCB, 0xA7, 0xB6, 0x85, 0xE6, 0x61,
   0x2D, 0xD8, 0x9F, 0x80, 0xE9, 0x14, 0x0B, 0x1C,
   0x40, 0x76, 0x2A, 0x25, 0x0E, 0x99, 0xAC, 0xC4,
   0xEB, 0x29, 0x41, 0x8A, 0x73, 0x06, 0x57, 0xC6,
   0x8D, 0xFA, 0x5A, 0xCD, 0x67, 0xB2, 0xD9, 0x0A,
   0x1E, 0xEF, 0x3E, 0xA0, 0x45, 0x03, 0x27, 0xF1,
   0x38, 0x54, 0xC1, 0x7A, 0xFE, 0x52, 0x75, 0xD4,
   0x74, 0x7C, 0xD2, 0x68, 0xEA, 0x4C, 0x97, 0xF9,
   0xF5, 0x8B, 0x0F, 0x84, 0xA8, 0x6E, 0x9E, 0x11,
   0x6B, 0xBC, 0x4B, 0x6C, 0x9A, 0xF0, 0xA3, 0x1F,
   0x92, 0x19, 0xA2, 0x3A, 0x15, 0x04, 0xC5, 0x62,
   0xD5, 0x96, 0x90, 0x32, 0xAA, 0xD6, 0xCF, 0x35,
   0xB4, 0x81, 0x2E, 0x01, 0x10, 0x49, 0x70, 0xDE,
   0xDD, 0x88, 0xB9, 0x6D, 0x60, 0xBB, 0x44, 0xF8,
   0x3C, 0xEC, 0x34, 0x82, 0x95, 0x72, 0x58, 0x4E,
   0xE4, 0x0D, 0xBE, 0xDA, 0x83, 0x4A, 0x00, 0xBF,
   0xD0, 0xC8, 0x26, 0xB3, 0x65, 0x1A, 0x69, 0xCA,
   0xF3, 0xD7, 0x6F, 0x55, 0xE2, 0xFF, 0x5D, 0xDC,
   0x20, 0xF6, 0x63, 0xED, 0xE0, 0x59, 0x9D, 0xB1,
   0x1D, 0xAD, 0x91, 0xA1, 0xB7, 0xA9, 0xDF, 0xC0,
   0x39, 0xD1, 0x43, 0xCE, 0x4F, 0x5C, 0xE7, 0x37,
   0x5E, 0x33, 0x5B, 0xA6, 0xC2, 0xB0, 0xBA, 0x30,
   0x6A, 0x78, 0xB5, 0x71, 0x56, 0x87, 0x7F, 0x86 };

unsigned char table_83[32] = {
   0x1B, 0x0A, 0x1F, 0x01, 0x10, 0x08, 0x0E, 0x18,
   0x06, 0x04, 0x00, 0x1C, 0x0C, 0x19, 0x0D, 0x16,
   0x02, 0x03, 0x09, 0x07, 0x13, 0x0F, 0x05, 0x12,
   0x17, 0x1E, 0x1A, 0x1D, 0x0B, 0x11, 0x14, 0x15 };

unsigned char table_84[32] = {
   0x02, 0x1A, 0x0D, 0x15, 0x01, 0x16, 0x1E, 0x00,
   0x08, 0x1B, 0x04, 0x10, 0x1C, 0x18, 0x19, 0x14,
   0x0C, 0x11, 0x0B, 0x0E, 0x03, 0x0A, 0x07, 0x12,
   0x1D, 0x17, 0x13, 0x06, 0x0F, 0x05, 0x09, 0x1F };

unsigned char table_85[256] = {
   0xC6, 0x7C, 0xCE, 0xBD, 0x84, 0x3E, 0x0B, 0xD8,
   0xFE, 0xCC, 0x46, 0x50, 0xD1, 0xFB, 0xA0, 0x6D,
   0xEA, 0xE2, 0x40, 0x51, 0x13, 0xB0, 0xD6, 0xB1,
   0xA8, 0xDF, 0x61, 0xA4, 0x80, 0x21, 0xB3, 0x33,
   0x06, 0x6B, 0xE3, 0x8C, 0xA1, 0x18, 0xBA, 0x03,
   0xD7, 0x8D, 0x54, 0x12, 0x4C, 0xEE, 0x9E, 0xCF,
   0x04, 0x2A, 0x08, 0xBB, 0xC2, 0xD4, 0xC3, 0x4A,
   0xD5, 0xFA, 0x36, 0x2F, 0x14, 0x3F, 0xED, 0x05,
   0x17, 0x28, 0x75, 0xFC, 0xA2, 0x1F, 0x4B, 0x6F,
   0x91, 0x7E, 0x4E, 0x96, 0x3B, 0xF3, 0x1D, 0x78,
   0xEB, 0x68, 0xF1, 0xA7, 0x9F, 0xC7, 0x59, 0x6C,
   0x92, 0xE6, 0x66, 0x07, 0x8A, 0x25, 0x26, 0x72,
   0x30, 0x5A, 0x81, 0x2C, 0x58, 0x32, 0xCB, 0xE0,
   0xF9, 0x48, 0x83, 0x9B, 0xA5, 0xE1, 0xA6, 0x64,
   0xFF, 0xC9, 0x8F, 0x53, 0x3D, 0x24, 0xC8, 0xDE,
   0x02, 0x7D, 0x09, 0xB4, 0x0A, 0x95, 0x0F, 0xE4,
   0xDB, 0xB7, 0x71, 0x4D, 0x1C, 0xAC, 0x35, 0xCD,
   0x29, 0xDD, 0xC1, 0xF2, 0xF4, 0xC0, 0x5C, 0x74,
   0xDC, 0x87, 0xFD, 0x4F, 0x11, 0x0E, 0x5D, 0x3C,
   0x01, 0x73, 0xE9, 0xD9, 0x10, 0x9A, 0x5B, 0xC5,
   0x98, 0x34, 0x15, 0xAE, 0xF7, 0xAA, 0x67, 0x23,
   0xBC, 0x8B, 0x7B, 0x65, 0xA9, 0xB6, 0x77, 0x00,
   0x19, 0x0C, 0x5E, 0x99, 0xF0, 0x55, 0x86, 0x97,
   0x69, 0xDA, 0x38, 0x9C, 0x16, 0xE8, 0x27, 0xAF,
   0x2E, 0x47, 0x6A, 0xD0, 0x79, 0x44, 0x45, 0x2B,
   0x5F, 0x85, 0xF5, 0x62, 0x70, 0x22, 0x7F, 0xF6,
   0x88, 0x93, 0x60, 0x42, 0x3A, 0x39, 0x49, 0x6E,
   0x89, 0x52, 0x20, 0xF8, 0xCA, 0xD2, 0x76, 0xB9,
   0xAB, 0x7A, 0x9D, 0xD3, 0xBE, 0x1A, 0xAD, 0x41,
   0x56, 0x31, 0x90, 0xB5, 0xB2, 0xEC, 0xA3, 0xE5,
   0x8E, 0x1B, 0xEF, 0xBF, 0x94, 0xC4, 0x0D, 0xB8,
   0x2D, 0x57, 0xE7, 0x82, 0x1E, 0x37, 0x63, 0x43 };

unsigned char table_86[32] = {
   0x11, 0x07, 0x0F, 0x0A, 0x19, 0x1D, 0x0B, 0x09,
   0x1C, 0x1E, 0x14, 0x06, 0x0C, 0x16, 0x13, 0x04,
   0x15, 0x18, 0x00, 0x0D, 0x12, 0x05, 0x08, 0x02,
   0x10, 0x1A, 0x1F, 0x01, 0x17, 0x0E, 0x03, 0x1B };

unsigned char table_87[32] = {
   0x17, 0x0E, 0x1D, 0x13, 0x0B, 0x19, 0x03, 0x06,
   0x09, 0x01, 0x0D, 0x15, 0x1C, 0x16, 0x18, 0x1B,
   0x11, 0x10, 0x00, 0x1E, 0x1F, 0x08, 0x12, 0x0F,
   0x02, 0x04, 0x07, 0x1A, 0x14, 0x0A, 0x0C, 0x05 };

unsigned char table_88[32] = {
   0x09, 0x08, 0x17, 0x10, 0x0A, 0x07, 0x1C, 0x1F,
   0x04, 0x0E, 0x01, 0x0C, 0x0D, 0x1B, 0x03, 0x15,
   0x02, 0x1E, 0x18, 0x19, 0x0F, 0x06, 0x1A, 0x0B,
   0x05, 0x11, 0x14, 0x00, 0x16, 0x1D, 0x12, 0x13 };

unsigned char table_89[32] = {
   0x15, 0x1C, 0x1D, 0x14, 0x0F, 0x1A, 0x05, 0x02,
   0x07, 0x09, 0x06, 0x08, 0x1F, 0x00, 0x10, 0x13,
   0x0D, 0x03, 0x0C, 0x18, 0x0E, 0x16, 0x1B, 0x1E,
   0x12, 0x04, 0x11, 0x0A, 0x01, 0x0B, 0x17, 0x19 };

unsigned char table_90[256] = {
   0x62, 0x36, 0x64, 0x0E, 0x4C, 0x6C, 0xBE, 0xCF,
   0x25, 0x5A, 0x3D, 0x12, 0x54, 0x9F, 0xE7, 0xA5,
   0xDE, 0xD7, 0xB2, 0x60, 0x18, 0x8D, 0x89, 0x70,
   0x48, 0x66, 0x1C, 0xA6, 0x17, 0x9B, 0xDF, 0x9A,
   0x82, 0xB9, 0x2E, 0xFA, 0x83, 0x5B, 0x7A, 0x61,
   0xFC, 0x6B, 0x8B, 0x4E, 0x0F, 0xAD, 0x78, 0xE1,
   0xE8, 0x15, 0x1A, 0xF7, 0xA3, 0x3A, 0x04, 0xE3,
   0x30, 0x8C, 0x06, 0xC4, 0x05, 0x32, 0x1F, 0x6A,
   0xB8, 0x37, 0x58, 0xF5, 0x74, 0x63, 0xD4, 0xAC,
   0xA4, 0xF3, 0xEC, 0xBB, 0x8E, 0x65, 0xA0, 0xEE,
   0x6D, 0x11, 0xDD, 0xEA, 0x68, 0x2B, 0xDA, 0x0B,
   0xEF, 0xC3, 0x8F, 0x03, 0x77, 0x1B, 0xFB, 0x1E,
   0x5C, 0xD9, 0xCB, 0x33, 0x55, 0xF1, 0xA1, 0xF9,
   0x7C, 0x38, 0x95, 0x00, 0x6E, 0x85, 0xC2, 0x7F,
   0xBF, 0x84, 0x2A, 0x13, 0x72, 0x81, 0xE9, 0x59,
   0x41, 0x69, 0x3B, 0x0C, 0x90, 0xB4, 0x51, 0x2F,
   0xA2, 0xFE, 0xF8, 0x49, 0x57, 0xE5, 0x96, 0xFF,
   0xCD, 0xD5, 0xCE, 0xAA, 0x40, 0xB0, 0x4D, 0xBA,
   0xDB, 0xC7, 0x46, 0x86, 0xD1, 0xCA, 0xC0, 0x67,
   0x9C, 0x21, 0xAE, 0xB3, 0x7B, 0x87, 0xE2, 0x71,
   0xE6, 0x39, 0xA8, 0x22, 0x07, 0x2C, 0x44, 0x52,
   0xA7, 0xF0, 0x4A, 0x92, 0x56, 0x28, 0x43, 0x8A,
   0x5E, 0x53, 0x93, 0x47, 0x97, 0x88, 0x76, 0x79,
   0x91, 0x26, 0xC1, 0x3F, 0xB7, 0xF6, 0x3E, 0x80,
   0xA9, 0xC6, 0x01, 0xD2, 0xEB, 0x9E, 0x4B, 0xBC,
   0xC8, 0xB5, 0x02, 0x5F, 0x98, 0x9D, 0x5D, 0x35,
   0xD0, 0x16, 0xB1, 0x23, 0x7D, 0xAF, 0x10, 0x3C,
   0xAB, 0x14, 0x09, 0x2D, 0x0D, 0xC5, 0x1D, 0xD6,
   0x42, 0xF2, 0x34, 0x73, 0xF4, 0xFD, 0xE0, 0x24,
   0x6F, 0xD3, 0x75, 0xD8, 0xCC, 0xB6, 0x99, 0x4F,
   0x29, 0x0A, 0x08, 0xE4, 0x27, 0x19, 0x31, 0xC9,
   0x20, 0x94, 0x45, 0xED, 0xDC, 0xBD, 0x7E, 0x50 };

unsigned char table_91[32] = {
   0x03, 0x04, 0x0C, 0x18, 0x10, 0x0D, 0x13, 0x1B,
   0x1F, 0x07, 0x11, 0x17, 0x1C, 0x1D, 0x05, 0x06,
   0x0A, 0x12, 0x02, 0x1A, 0x0B, 0x01, 0x0E, 0x08,
   0x14, 0x16, 0x00, 0x15, 0x19, 0x09, 0x0F, 0x1E };

unsigned char table_92[32] = {
   0x1E, 0x10, 0x01, 0x07, 0x11, 0x16, 0x15, 0x17,
   0x1F, 0x14, 0x0C, 0x1C, 0x06, 0x03, 0x00, 0x18,
   0x08, 0x0E, 0x02, 0x1B, 0x09, 0x0D, 0x19, 0x05,
   0x0F, 0x12, 0x0B, 0x13, 0x0A, 0x04, 0x1D, 0x1A };

unsigned char table_93[256] = {
   0x76, 0x78, 0xA2, 0x94, 0x0E, 0x7F, 0xDF, 0xC1,
   0xB9, 0xE1, 0x3D, 0x59, 0x6F, 0x1E, 0x53, 0x99,
   0x80, 0xE3, 0x21, 0xF8, 0x65, 0xB8, 0x08, 0xBC,
   0x29, 0x17, 0xFD, 0x33, 0x35, 0xF2, 0x70, 0xC7,
   0x25, 0xD0, 0xCD, 0x7A, 0xB7, 0x9B, 0xA5, 0xC3,
   0x00, 0x90, 0xDC, 0xB1, 0x0C, 0x20, 0x67, 0x8D,
   0x43, 0x49, 0xF3, 0x96, 0x14, 0x1A, 0xC8, 0x19,
   0x72, 0xD7, 0x8A, 0x38, 0x66, 0xDA, 0xDD, 0x2E,
   0xBE, 0xD5, 0x91, 0x7C, 0x3A, 0x92, 0x8E, 0xE7,
   0x51, 0xB5, 0xA8, 0xD9, 0x0B, 0x2A, 0xBA, 0x81,
   0x41, 0x0F, 0xBD, 0x4E, 0x31, 0x23, 0x9C, 0x8B,
   0x2B, 0x1D, 0x04, 0x3E, 0x8C, 0xF0, 0x45, 0xA0,
   0x1C, 0x44, 0x55, 0x5E, 0xF1, 0x98, 0x54, 0x5D,
   0x9D, 0x84, 0xAE, 0x09, 0xA9, 0xC5, 0x83, 0x60,
   0x86, 0x95, 0xB4, 0xFA, 0x6B, 0xA7, 0x9A, 0xCA,
   0x8F, 0x4F, 0x0A, 0x7B, 0xB0, 0x02, 0xEA, 0xA4,
   0x18, 0xDB, 0xD3, 0x64, 0xEB, 0xFC, 0xC4, 0xC9,
   0xF5, 0xD6, 0xCC, 0x75, 0x0D, 0x5C, 0x93, 0x4A,
   0x6D, 0xC0, 0x1F, 0x50, 0xE6, 0x16, 0xEE, 0x07,
   0xFB, 0x74, 0x56, 0x58, 0x52, 0x89, 0x79, 0x68,
   0xB6, 0xFE, 0x01, 0xD4, 0x7E, 0x06, 0xBF, 0xCB,
   0x5B, 0xC2, 0xC6, 0x32, 0xAC, 0x26, 0x22, 0xD2,
   0x82, 0x46, 0x69, 0x15, 0x2C, 0xF7, 0xAD, 0x13,
   0x4D, 0xA3, 0xF6, 0x2D, 0x48, 0x71, 0x57, 0x11,
   0x63, 0x05, 0x5F, 0x9E, 0x4B, 0xAB, 0xA6, 0x61,
   0xBB, 0xA1, 0x3C, 0x97, 0xF9, 0x03, 0x40, 0x12,
   0xCF, 0x37, 0xE4, 0x10, 0x6A, 0xED, 0xFF, 0x62,
   0x42, 0x4C, 0xAF, 0x9F, 0xE5, 0xE8, 0xD8, 0xD1,
   0x28, 0x3F, 0x1B, 0xE9, 0xCE, 0x6C, 0x27, 0x88,
   0xEF, 0x2F, 0xE0, 0x30, 0x87, 0x5A, 0x73, 0xB3,
   0x6E, 0x3B, 0x7D, 0x77, 0x36, 0xAA, 0x39, 0xDE,
   0x24, 0x34, 0xE2, 0xEC, 0x85, 0x47, 0xF4, 0xB2 };

unsigned char table_94[32] = {
   0x1C, 0x07, 0x05, 0x1A, 0x10, 0x1D, 0x14, 0x12,
   0x08, 0x0F, 0x0C, 0x01, 0x04, 0x1B, 0x16, 0x0A,
   0x11, 0x02, 0x1F, 0x13, 0x0D, 0x1E, 0x17, 0x06,
   0x0E, 0x09, 0x15, 0x19, 0x03, 0x18, 0x00, 0x0B };

unsigned char table_95[32] = {
   0x12, 0x10, 0x11, 0x15, 0x03, 0x0A, 0x14, 0x05,
   0x1D, 0x07, 0x17, 0x0D, 0x09, 0x08, 0x1B, 0x1F,
   0x0B, 0x06, 0x19, 0x0E, 0x18, 0x04, 0x00, 0x02,
   0x1E, 0x1C, 0x01, 0x0C, 0x1A, 0x0F, 0x13, 0x16 };

unsigned char table_96[256] = {
   0x1C, 0x6E, 0xCD, 0xB4, 0xB3, 0x93, 0xA8, 0x2E,
   0x4F, 0x09, 0xE3, 0x72, 0x64, 0x13, 0x21, 0xF5,
   0x89, 0xB2, 0xD2, 0x22, 0x5D, 0x63, 0x90, 0xC4,
   0x42, 0x9B, 0x07, 0xCA, 0x16, 0x19, 0x5C, 0x2B,
   0x3D, 0xA0, 0x69, 0x5F, 0x52, 0x41, 0x66, 0xC0,
   0x55, 0xDA, 0x82, 0x40, 0x25, 0x02, 0x3C, 0xDD,
   0xAE, 0xD7, 0xD6, 0xDB, 0x04, 0x78, 0x05, 0x4A,
   0x4C, 0x81, 0x00, 0xBE, 0x45, 0xC5, 0x30, 0xB0,
   0x65, 0x5A, 0xA9, 0x38, 0x75, 0x26, 0x85, 0x4E,
   0xF0, 0xA2, 0x91, 0x8A, 0x54, 0xD0, 0x3E, 0x0D,
   0xFE, 0xF2, 0x0A, 0x23, 0x24, 0x37, 0x32, 0x0B,
   0xCB, 0xB5, 0x28, 0x6A, 0x95, 0x49, 0x53, 0x9A,
   0xEE, 0x2C, 0x9D, 0xD4, 0x1D, 0x46, 0xC9, 0x79,
   0xCC, 0xDF, 0x17, 0xE8, 0x6D, 0x29, 0x0E, 0x80,
   0xE0, 0x62, 0xA1, 0xFA, 0x10, 0xF6, 0x03, 0xC1,
   0x15, 0x14, 0x1F, 0x99, 0x97, 0xD5, 0x9E, 0x3F,
   0x7B, 0x2F, 0xEF, 0x2A, 0x68, 0x83, 0xE2, 0x1B,
   0xC8, 0x87, 0x12, 0x70, 0xC7, 0x36, 0xD3, 0x73,
   0x8B, 0x7D, 0x47, 0x9F, 0xD9, 0xFB, 0x6C, 0x5B,
   0xFC, 0xAA, 0xB9, 0xB1, 0x0C, 0x31, 0x8E, 0xF3,
   0x92, 0xA3, 0x4B, 0xF1, 0xC2, 0x3A, 0x67, 0xEA,
   0x77, 0x11, 0xB6, 0xE4, 0x1A, 0x33, 0xD1, 0xBA,
   0xF9, 0xAC, 0x43, 0xE5, 0xC3, 0xC6, 0xFD, 0xF4,
   0x44, 0x6F, 0xB7, 0x88, 0xA7, 0xF8, 0x34, 0x94,
   0x6B, 0x27, 0xDE, 0x1E, 0xDC, 0x01, 0x61, 0x50,
   0xAD, 0x74, 0x4D, 0x86, 0xF7, 0x8D, 0x9C, 0x0F,
   0x5E, 0xBD, 0x08, 0x84, 0x18, 0xED, 0xA5, 0x39,
   0xAB, 0x98, 0x48, 0xE6, 0x2D, 0x96, 0xCF, 0x7F,
   0xFF, 0xBB, 0x8F, 0xEC, 0xBF, 0xE7, 0x56, 0xA4,
   0x35, 0x76, 0xA6, 0xAF, 0xBC, 0x71, 0xE9, 0xB8,
   0x7E, 0x7C, 0x06, 0x3B, 0xEB, 0x60, 0x7A, 0x8C,
   0x59, 0xCE, 0xE1, 0x57, 0x20, 0x58, 0x51, 0xD8 };

unsigned char table_97[256] = {
   0x15, 0x2D, 0xAF, 0x36, 0xCF, 0xD3, 0xD0, 0xED,
   0xB2, 0x1B, 0xFE, 0x92, 0xBD, 0xAD, 0x58, 0x0F,
   0x76, 0x3C, 0x47, 0x03, 0x2E, 0x4C, 0x40, 0xF7,
   0x39, 0xA7, 0x72, 0x22, 0x95, 0xF3, 0x8C, 0xE0,
   0x79, 0xB6, 0x75, 0x82, 0x94, 0x8F, 0x44, 0xFC,
   0xB0, 0x05, 0xE9, 0x10, 0x68, 0xE7, 0xF1, 0xA5,
   0xA8, 0xE2, 0x6F, 0xBE, 0xE5, 0x54, 0xA2, 0xC6,
   0xDB, 0x1C, 0x9E, 0x6D, 0x14, 0xA1, 0x26, 0x34,
   0x1E, 0x1A, 0x06, 0x53, 0xEE, 0x67, 0xA9, 0x73,
   0xD5, 0x59, 0x2F, 0x61, 0xE6, 0x74, 0xD6, 0x97,
   0xC0, 0x0C, 0xB1, 0x6E, 0x6C, 0x33, 0xC8, 0x77,
   0x8B, 0x49, 0x43, 0xE3, 0xB5, 0xDE, 0x6A, 0xA0,
   0x78, 0x2A, 0xC9, 0xF9, 0x9A, 0xDC, 0x90, 0x55,
   0xF4, 0x16, 0x5E, 0x3F, 0xC5, 0x7C, 0xFA, 0x09,
   0x8E, 0x87, 0xF2, 0x9D, 0x70, 0x27, 0x9B, 0xC4,
   0xCD, 0x91, 0x4B, 0xB4, 0x18, 0xE1, 0x3D, 0x5D,
   0x7A, 0xEA, 0xF0, 0x65, 0xB9, 0xF6, 0xC3, 0x66,
   0x21, 0x96, 0xD1, 0xB8, 0x56, 0x62, 0x48, 0x28,
   0x3A, 0x86, 0x63, 0xD4, 0xD7, 0x41, 0x8D, 0x20,
   0xC2, 0x98, 0x37, 0xD8, 0x85, 0x42, 0x0D, 0x31,
   0x84, 0x4E, 0x11, 0x46, 0x2B, 0x19, 0xCC, 0xB7,
   0x69, 0x13, 0x6B, 0x29, 0x38, 0x7E, 0x0E, 0xD2,
   0x3B, 0x60, 0x89, 0x7F, 0xEF, 0x07, 0x08, 0xCA,
   0xBF, 0x3E, 0xA3, 0xAA, 0x52, 0x4A, 0x45, 0x00,
   0xC7, 0xF8, 0x57, 0xEB, 0x93, 0x9C, 0x4D, 0x7B,
   0x2C, 0xBB, 0xFB, 0xFF, 0x35, 0x4F, 0x32, 0xA6,
   0x23, 0x8A, 0xDD, 0x12, 0xA4, 0x81, 0x17, 0x1D,
   0x1F, 0xCB, 0x0A, 0x71, 0x02, 0xAC, 0xDF, 0x24,
   0xAB, 0x7D, 0x30, 0x5C, 0x01, 0x5A, 0xBA, 0xEC,
   0x51, 0xF5, 0x0B, 0x64, 0xCE, 0xAE, 0x5B, 0x50,
   0x80, 0x88, 0xE8, 0x5F, 0x04, 0xDA, 0xE4, 0xBC,
   0x83, 0x25, 0x9F, 0xD9, 0x99, 0xC1, 0xFD, 0xB3 };

unsigned char table_98[256] = {
   0xC8, 0xE6, 0x38, 0x93, 0xE5, 0x03, 0x18, 0x1F,
   0xE9, 0x5A, 0xB6, 0xAF, 0xC3, 0x95, 0x00, 0x51,
   0xC0, 0xFD, 0x32, 0xE8, 0x96, 0x57, 0xF0, 0xAA,
   0xDC, 0x71, 0xF8, 0x01, 0x40, 0x0A, 0x4F, 0xB0,
   0x1B, 0x9D, 0x16, 0x92, 0xF3, 0x5E, 0xA9, 0x3C,
   0xBE, 0x6A, 0xA7, 0xE3, 0x35, 0x0D, 0xAD, 0xDB,
   0x48, 0xE0, 0x7E, 0xC6, 0xB4, 0x6D, 0x17, 0x41,
   0x3E, 0xE2, 0x87, 0x12, 0xE1, 0x53, 0xD9, 0x8A,
   0xAC, 0xA6, 0xD8, 0xFA, 0x36, 0x0B, 0x06, 0xDF,
   0x6C, 0x4E, 0xA4, 0xBC, 0xC9, 0xEE, 0x44, 0x26,
   0xF2, 0xE4, 0x9E, 0x34, 0xEF, 0x05, 0x0F, 0x7F,
   0xD1, 0xCD, 0x67, 0x28, 0xC1, 0x8E, 0x7D, 0x90,
   0x8F, 0x60, 0x1E, 0x19, 0xBD, 0x77, 0xB8, 0xD5,
   0x3D, 0x8C, 0x31, 0x99, 0x08, 0xDD, 0x04, 0x30,
   0x61, 0xFB, 0xEB, 0x98, 0x15, 0xFC, 0x10, 0xDE,
   0x20, 0xBA, 0xA1, 0xB3, 0xD4, 0x91, 0x6F, 0x9F,
   0x94, 0x5B, 0x42, 0xCB, 0x75, 0x1C, 0xBB, 0x5C,
   0x5D, 0xD6, 0x66, 0x50, 0xB9, 0xF1, 0x82, 0x7B,
   0x33, 0x23, 0x4A, 0xA5, 0x55, 0x97, 0xEA, 0x37,
   0xF4, 0x64, 0x6E, 0xBF, 0x8B, 0xB1, 0x07, 0x9A,
   0x43, 0x11, 0x65, 0xC2, 0x02, 0xDA, 0x9B, 0x25,
   0xCA, 0x3B, 0x7A, 0xCE, 0xA8, 0xCF, 0xF7, 0x56,
   0x6B, 0xF9, 0x47, 0x2A, 0x2E, 0x1D, 0x2D, 0xE7,
   0x46, 0xD0, 0x62, 0x4C, 0x80, 0x4B, 0x2B, 0xF5,
   0x69, 0x9C, 0x45, 0xED, 0x83, 0xAB, 0x74, 0x39,
   0xA3, 0x85, 0xD7, 0x5F, 0xB2, 0x86, 0x22, 0x29,
   0x89, 0x49, 0x1A, 0xC4, 0x52, 0xEC, 0x8D, 0x73,
   0xD3, 0x7C, 0x79, 0xD2, 0x14, 0x4D, 0x84, 0xA2,
   0x0E, 0x70, 0x78, 0x72, 0xB7, 0xA0, 0xC5, 0x81,
   0x58, 0x0C, 0x68, 0x27, 0xFF, 0xF6, 0xAE, 0xCC,
   0x88, 0xFE, 0x24, 0x2F, 0x76, 0x3F, 0x59, 0x21,
   0x54, 0x3A, 0x13, 0x09, 0x2C, 0xB5, 0xC7, 0x63 };

unsigned char table_99[32] = {
   0x19, 0x00, 0x10, 0x18, 0x09, 0x11, 0x13, 0x1D,
   0x08, 0x1A, 0x02, 0x05, 0x03, 0x17, 0x12, 0x01,
   0x1F, 0x14, 0x06, 0x07, 0x15, 0x0D, 0x0F, 0x0B,
   0x0E, 0x16, 0x1E, 0x04, 0x1B, 0x0A, 0x0C, 0x1C };

unsigned char table_100[256] = {
   0x9B, 0x3A, 0xAE, 0x60, 0x27, 0x67, 0x1E, 0x4E,
   0x91, 0xDA, 0x85, 0x43, 0x5C, 0xCC, 0x89, 0x55,
   0x75, 0x56, 0xF2, 0x86, 0xEB, 0xC4, 0x0D, 0xE6,
   0x63, 0x88, 0x38, 0x59, 0x68, 0xD0, 0x18, 0xF0,
   0xBA, 0x28, 0xF5, 0x80, 0x02, 0x5B, 0xE1, 0xA4,
   0x7A, 0x4B, 0x8E, 0xF7, 0x9E, 0x99, 0x70, 0xEF,
   0x66, 0x50, 0xB1, 0xCD, 0x9A, 0xAF, 0x5F, 0x21,
   0xE5, 0x5D, 0x14, 0xD4, 0x34, 0x22, 0xC3, 0x0F,
   0x44, 0xB6, 0x92, 0xCE, 0xB4, 0x6E, 0xB0, 0x00,
   0xF9, 0xB5, 0x10, 0xEA, 0x45, 0x2F, 0x2B, 0xF4,
   0xF6, 0xFE, 0xCB, 0x0A, 0x42, 0xF8, 0xE7, 0xFD,
   0xC8, 0xC2, 0x6C, 0x9C, 0x57, 0xA1, 0x46, 0x04,
   0xE9, 0x97, 0x40, 0x32, 0x19, 0xFA, 0x51, 0xD1,
   0x6D, 0x4C, 0x2A, 0xD9, 0x95, 0x26, 0x72, 0x1B,
   0x83, 0x93, 0x5A, 0x15, 0x33, 0xC5, 0x77, 0x13,
   0xE0, 0x36, 0x37, 0xDB, 0xA7, 0xC7, 0x81, 0x62,
   0xC1, 0x47, 0x64, 0x74, 0x1D, 0x84, 0x29, 0x39,
   0x41, 0x35, 0x09, 0x90, 0x20, 0x9F, 0x8C, 0x7D,
   0x3E, 0x07, 0xB9, 0x76, 0x06, 0xA3, 0x31, 0x7F,
   0x49, 0x6F, 0x3D, 0xD5, 0x25, 0xAC, 0xDF, 0x0B,
   0x3C, 0x79, 0x01, 0x8F, 0x82, 0x2E, 0xFC, 0x98,
   0xA5, 0x58, 0xA0, 0x4A, 0x7C, 0x24, 0xDD, 0x05,
   0x4D, 0x12, 0xBC, 0xAA, 0xE2, 0xAB, 0xD3, 0xBF,
   0x94, 0x2D, 0x54, 0xBB, 0xAD, 0xB7, 0x6A, 0xE3,
   0xBD, 0x5E, 0x8D, 0x08, 0x3B, 0xB8, 0x73, 0x8A,
   0x16, 0xD2, 0x69, 0xE8, 0xEE, 0x53, 0xD8, 0xDC,
   0x48, 0xCF, 0xC6, 0xA9, 0x1A, 0xCA, 0x17, 0x11,
   0xED, 0xC0, 0xA6, 0x1F, 0x96, 0x8B, 0xFF, 0x78,
   0x03, 0x61, 0x1C, 0xA8, 0x3F, 0x9D, 0x0E, 0xC9,
   0xE4, 0xA2, 0x52, 0xEC, 0x4F, 0xD6, 0xF3, 0x6B,
   0x87, 0xB3, 0x7E, 0xDE, 0xD7, 0x71, 0x65, 0xF1,
   0x30, 0x0C, 0xB2, 0x7B, 0xBE, 0xFB, 0x23, 0x2C };

unsigned char table_101[32] = {
   0x18, 0x08, 0x14, 0x17, 0x03, 0x10, 0x19, 0x04,
   0x0D, 0x1C, 0x06, 0x1D, 0x1E, 0x12, 0x11, 0x0B,
   0x0F, 0x02, 0x0E, 0x1B, 0x13, 0x05, 0x07, 0x16,
   0x15, 0x0A, 0x0C, 0x1A, 0x00, 0x01, 0x1F, 0x09 };

unsigned char table_102[32] = {
   0x17, 0x1F, 0x0E, 0x05, 0x13, 0x0C, 0x14, 0x1A,
   0x0F, 0x01, 0x12, 0x1C, 0x00, 0x07, 0x0D, 0x02,
   0x10, 0x16, 0x04, 0x11, 0x1D, 0x03, 0x1E, 0x18,
   0x06, 0x15, 0x0A, 0x19, 0x09, 0x08, 0x1B, 0x0B };

unsigned char table_103[32] = {
   0x0F, 0x09, 0x1E, 0x11, 0x0D, 0x08, 0x10, 0x00,
   0x01, 0x1F, 0x1D, 0x1C, 0x12, 0x04, 0x07, 0x05,
   0x19, 0x14, 0x1B, 0x02, 0x1A, 0x15, 0x17, 0x16,
   0x18, 0x0B, 0x0A, 0x13, 0x0C, 0x0E, 0x03, 0x06 };

unsigned char table_104[256] = {
   0xA4, 0x9F, 0x78, 0x39, 0x3D, 0x81, 0x51, 0x24,
   0x46, 0x2A, 0x56, 0xE8, 0xDF, 0x73, 0xA8, 0xA2,
   0x0D, 0xDC, 0xA5, 0x4F, 0xF0, 0x93, 0xC0, 0x76,
   0x38, 0x70, 0xB0, 0x30, 0x98, 0x13, 0x8B, 0x14,
   0x26, 0x45, 0x0F, 0x7D, 0x34, 0x72, 0x6B, 0x89,
   0x43, 0xE2, 0x96, 0x5B, 0xEF, 0x2B, 0xF9, 0xDE,
   0x82, 0xB5, 0x61, 0x4A, 0x17, 0xC2, 0x5A, 0xCB,
   0xB2, 0x8D, 0xE4, 0xEC, 0xD9, 0x80, 0xBC, 0x62,
   0x67, 0x11, 0xA9, 0x3A, 0xE1, 0xC4, 0xEA, 0xD2,
   0x71, 0xD0, 0xDB, 0xE5, 0x7B, 0x08, 0x77, 0xD6,
   0x10, 0x19, 0x48, 0xEB, 0xAA, 0x2C, 0x0C, 0x59,
   0xBE, 0xF6, 0x28, 0x50, 0x90, 0x87, 0xCD, 0x04,
   0x1F, 0x79, 0x99, 0x5C, 0x49, 0x06, 0x8A, 0x3E,
   0x5F, 0x5E, 0x15, 0x23, 0x2D, 0xB6, 0xA6, 0x7A,
   0x03, 0x20, 0xDA, 0xFB, 0x35, 0x75, 0xC7, 0x47,
   0xB9, 0x7C, 0xA1, 0xCE, 0xC5, 0xDD, 0xFD, 0x6C,
   0x05, 0xAC, 0x09, 0xB4, 0x95, 0xD1, 0xB1, 0x63,
   0xFF, 0xAE, 0xD5, 0x25, 0x1E, 0x6E, 0x57, 0x18,
   0x74, 0xE6, 0x2F, 0x9A, 0xE7, 0x42, 0x65, 0xF5,
   0x58, 0x27, 0x33, 0x9C, 0xCF, 0xB7, 0xC3, 0xF1,
   0x12, 0x1D, 0xB8, 0xF4, 0x64, 0x4D, 0xD4, 0xBD,
   0xE3, 0xAB, 0x44, 0x60, 0xAF, 0xCC, 0x0A, 0xFC,
   0xD3, 0x21, 0x0B, 0x1A, 0x6D, 0x83, 0xA7, 0x8E,
   0x3C, 0xC1, 0xED, 0xF3, 0x2E, 0x86, 0xC9, 0x41,
   0x02, 0xF7, 0xC8, 0x40, 0x1B, 0xF8, 0xF2, 0x07,
   0x5D, 0x4E, 0xC6, 0x29, 0xD7, 0x4B, 0x7E, 0x31,
   0x94, 0x32, 0x01, 0x92, 0xE9, 0x36, 0x0E, 0x7F,
   0x85, 0x16, 0xFA, 0x00, 0x88, 0x3F, 0x68, 0x4C,
   0x22, 0x55, 0xBF, 0x9D, 0xE0, 0x6A, 0xAD, 0xBA,
   0x91, 0xCA, 0xA3, 0x1C, 0xEE, 0xD8, 0x3B, 0x66,
   0x69, 0x9B, 0x84, 0xA0, 0xB3, 0x6F, 0xFE, 0x52,
   0x97, 0xBB, 0x37, 0x8C, 0x54, 0x53, 0x9E, 0x8F };

unsigned char table_105[256] = {
   0x7B, 0x35, 0x11, 0x79, 0x07, 0x2F, 0xF6, 0x82,
   0x8E, 0xB4, 0x6E, 0xD2, 0x6D, 0xC5, 0x8C, 0x1C,
   0xE0, 0xD6, 0x34, 0xF0, 0x4F, 0x25, 0x59, 0xE8,
   0xDF, 0x1D, 0xEB, 0x32, 0x86, 0x51, 0xA4, 0xF2,
   0x5C, 0xD1, 0xC8, 0x41, 0xEC, 0x9D, 0x62, 0xAC,
   0xDD, 0x3E, 0xB8, 0x65, 0x75, 0x89, 0x12, 0x6C,
   0x40, 0x4E, 0xC7, 0x27, 0xE1, 0x37, 0xCF, 0x09,
   0x16, 0x78, 0xAA, 0x58, 0x0D, 0xE6, 0x54, 0xFE,
   0x8F, 0xFD, 0xF9, 0x61, 0x26, 0x3F, 0x2E, 0xCD,
   0x2C, 0x04, 0xB2, 0x80, 0x0F, 0x14, 0x6F, 0xC6,
   0xAB, 0xFB, 0x13, 0xDB, 0x9A, 0x21, 0xB3, 0xC0,
   0xA9, 0x19, 0x70, 0xF3, 0x2B, 0xAE, 0x9B, 0x49,
   0xB7, 0xA8, 0x24, 0x1B, 0x48, 0xEA, 0xED, 0xD9,
   0x47, 0x9E, 0x9C, 0x69, 0x3C, 0x66, 0xBB, 0x06,
   0x46, 0x38, 0x17, 0xB5, 0xCB, 0x05, 0x4A, 0x5E,
   0x15, 0x20, 0xB9, 0xB6, 0x33, 0x4C, 0x7D, 0xA3,
   0xD7, 0xB1, 0x23, 0x72, 0xC3, 0x4B, 0x63, 0xBE,
   0xF7, 0x5B, 0x74, 0x64, 0x77, 0xCC, 0xD3, 0x85,
   0xDE, 0x1A, 0x31, 0x97, 0xA2, 0x8B, 0xFC, 0x10,
   0x5F, 0xDC, 0xD5, 0xB0, 0xBD, 0x55, 0xC1, 0xE7,
   0x0C, 0x50, 0x43, 0x39, 0x71, 0x52, 0xE5, 0xAF,
   0x8A, 0x60, 0x92, 0x2D, 0xD8, 0x03, 0xF5, 0x28,
   0xCA, 0xEF, 0xD0, 0xC2, 0x53, 0x91, 0xA6, 0x73,
   0x56, 0xA5, 0xF1, 0x57, 0x42, 0xF4, 0xD4, 0x36,
   0x8D, 0xBC, 0xE9, 0x7E, 0x02, 0x76, 0x18, 0x0B,
   0x84, 0x5A, 0xE2, 0xBF, 0x68, 0x95, 0x29, 0x98,
   0xAD, 0x88, 0x1F, 0x81, 0x67, 0xA1, 0x3A, 0xA7,
   0x22, 0xF8, 0x01, 0xA0, 0xCE, 0x7A, 0xDA, 0x30,
   0xC4, 0xE4, 0xEE, 0x7C, 0x3B, 0x4D, 0x3D, 0xE3,
   0xFA, 0x6A, 0x7F, 0x99, 0x00, 0x93, 0x0E, 0xFF,
   0x90, 0x0A, 0x2A, 0x5D, 0x96, 0x08, 0x6B, 0x83,
   0xBA, 0x1E, 0x44, 0x87, 0x45, 0x9F, 0xC9, 0x94 };

unsigned char table_106[32] = {
   0x03, 0x11, 0x07, 0x1B, 0x0F, 0x14, 0x0C, 0x01,
   0x04, 0x02, 0x09, 0x0A, 0x05, 0x12, 0x06, 0x1F,
   0x1C, 0x0E, 0x0D, 0x15, 0x18, 0x08, 0x00, 0x10,
   0x1E, 0x1D, 0x17, 0x19, 0x13, 0x16, 0x0B, 0x1A };

unsigned char table_107[32] = {
   0x13, 0x1B, 0x06, 0x11, 0x1C, 0x07, 0x08, 0x0E,
   0x10, 0x05, 0x09, 0x18, 0x04, 0x15, 0x1E, 0x0F,
   0x1F, 0x12, 0x02, 0x00, 0x17, 0x19, 0x1A, 0x0D,
   0x03, 0x0C, 0x0A, 0x1D, 0x14, 0x01, 0x16, 0x0B };

unsigned char table_108[256] = {
   0x99, 0xA3, 0x48, 0xE8, 0x5A, 0x7D, 0x97, 0xCA,
   0x7F, 0x06, 0x9B, 0x04, 0xE0, 0xF3, 0x18, 0xAE,
   0x59, 0xA0, 0x2B, 0x15, 0x85, 0x3E, 0x12, 0x93,
   0x3D, 0x28, 0x32, 0xF5, 0x20, 0x5D, 0x86, 0x00,
   0x1B, 0x2E, 0x36, 0x10, 0x5E, 0x6C, 0xD8, 0x29,
   0xB6, 0x3F, 0x05, 0x1C, 0xCE, 0xC2, 0x34, 0x5F,
   0x5C, 0x79, 0xD1, 0x1F, 0xA2, 0xEE, 0x8A, 0x69,
   0xB5, 0x87, 0x96, 0x6D, 0x4D, 0xC1, 0x61, 0x2C,
   0x11, 0xE7, 0x8E, 0xBF, 0x1E, 0x53, 0xD0, 0x58,
   0x76, 0xA4, 0x60, 0xA9, 0xB0, 0xF9, 0xEA, 0x3C,
   0x52, 0x9A, 0x24, 0xF1, 0x9F, 0xD3, 0x40, 0x0A,
   0x63, 0x78, 0x6A, 0x8B, 0x08, 0x22, 0x16, 0x83,
   0x6B, 0xD2, 0x49, 0x19, 0xBD, 0xFD, 0x62, 0x72,
   0xA8, 0x55, 0xAB, 0x0C, 0xB9, 0x13, 0xD5, 0xF0,
   0xF2, 0x84, 0xAF, 0x2F, 0x7B, 0x2A, 0x21, 0x0F,
   0xDA, 0x30, 0x71, 0xD6, 0x81, 0xE6, 0xEC, 0x41,
   0x90, 0x50, 0x66, 0x0E, 0xA7, 0xB8, 0xF7, 0x3A,
   0xB2, 0xCF, 0x3B, 0xFC, 0x56, 0x6F, 0xC3, 0xA6,
   0xC9, 0xA1, 0x8D, 0xBB, 0x9D, 0x75, 0xF6, 0xAA,
   0x7E, 0xF8, 0x33, 0xEF, 0xBC, 0x7C, 0x23, 0x1A,
   0x92, 0x6E, 0x2D, 0x8F, 0xED, 0xB7, 0xB1, 0x1D,
   0x67, 0x39, 0xAC, 0x0D, 0x74, 0xDB, 0x7A, 0x94,
   0x07, 0x09, 0xC0, 0xD7, 0xAD, 0xFE, 0x54, 0x91,
   0xDE, 0x45, 0xA5, 0x77, 0xCB, 0x37, 0xC6, 0x38,
   0x89, 0x88, 0x17, 0xD9, 0x4F, 0xDF, 0x25, 0xFB,
   0xFA, 0x4C, 0x80, 0x35, 0x82, 0xF4, 0x95, 0xC8,
   0xFF, 0xE9, 0x31, 0x01, 0x14, 0xB3, 0x02, 0x9E,
   0x4E, 0x43, 0x46, 0xC7, 0xEB, 0x51, 0xE5, 0x47,
   0xB4, 0xE3, 0xDC, 0x57, 0xC4, 0x98, 0x03, 0xE1,
   0xBA, 0x68, 0xCD, 0x27, 0xC5, 0x0B, 0xD4, 0x64,
   0x4B, 0x9C, 0x70, 0x65, 0x4A, 0xE4, 0x42, 0xDD,
   0xCC, 0xE2, 0x44, 0x73, 0xBE, 0x26, 0x8C, 0x5B };

unsigned char table_109[256] = {
   0xE3, 0x95, 0xDB, 0x09, 0x82, 0x0A, 0x8F, 0x9E,
   0xC9, 0xDC, 0x28, 0x35, 0x0F, 0x8B, 0xA8, 0xA5,
   0x7F, 0x3D, 0x8C, 0xD1, 0x93, 0x57, 0x04, 0xAA,
   0x6A, 0x98, 0x81, 0xDD, 0x16, 0x67, 0x2E, 0xDF,
   0xED, 0xF7, 0xB2, 0xBD, 0x14, 0xB6, 0x76, 0xC8,
   0x75, 0x9F, 0x48, 0xAE, 0xBB, 0xB0, 0xF3, 0xE2,
   0xD4, 0x59, 0xD8, 0x9C, 0x64, 0xC1, 0x73, 0x21,
   0x6D, 0x96, 0x7B, 0x62, 0x56, 0x55, 0xCC, 0xFD,
   0xCE, 0x41, 0xA3, 0x43, 0x33, 0xAF, 0x23, 0x9D,
   0x6F, 0x65, 0x19, 0x52, 0xAD, 0xC6, 0xD3, 0x3F,
   0x66, 0xFF, 0xD0, 0x30, 0x6C, 0xC0, 0xEB, 0xCF,
   0x51, 0x88, 0x38, 0x72, 0x69, 0x77, 0x3B, 0xFA,
   0xBA, 0xB7, 0xA1, 0x91, 0xE0, 0x89, 0xAB, 0x44,
   0x1B, 0x05, 0x5B, 0xB9, 0x71, 0x47, 0x7E, 0xFB,
   0x02, 0xC7, 0x99, 0x6E, 0x42, 0x20, 0x90, 0x1F,
   0x4A, 0x85, 0x1A, 0xEA, 0x0C, 0x0D, 0xB3, 0xDA,
   0xE7, 0x13, 0xE6, 0xD7, 0x6B, 0x12, 0x46, 0x53,
   0xB5, 0xF8, 0x1D, 0x83, 0x54, 0x49, 0x8A, 0x26,
   0x4D, 0xDE, 0xF6, 0x03, 0xA2, 0x7D, 0x0E, 0xA0,
   0x68, 0x79, 0xCA, 0x0B, 0x5D, 0x40, 0x4F, 0x80,
   0xC2, 0xD6, 0x87, 0x70, 0xF0, 0xD2, 0x92, 0xEE,
   0xBE, 0x74, 0x5F, 0xBC, 0xA4, 0x4B, 0xFE, 0x37,
   0x60, 0xA9, 0x06, 0xA7, 0xE1, 0xF5, 0x2B, 0x10,
   0xEF, 0x2C, 0x07, 0x86, 0x7A, 0x27, 0xE9, 0xC5,
   0xAC, 0x32, 0x22, 0xF2, 0xE5, 0x8D, 0x31, 0x01,
   0x34, 0xA6, 0xB8, 0xC3, 0x3C, 0xE4, 0x08, 0x94,
   0x15, 0x4E, 0xB4, 0x39, 0x58, 0x00, 0x3E, 0x29,
   0x45, 0x3A, 0x84, 0x36, 0xF1, 0x2A, 0x50, 0x11,
   0xC4, 0x5A, 0xFC, 0xBF, 0xD9, 0xF9, 0x17, 0x9B,
   0x8E, 0x18, 0x63, 0x4C, 0x2F, 0x78, 0x2D, 0x5E,
   0x9A, 0xCD, 0x24, 0xEC, 0x7C, 0x97, 0x61, 0xCB,
   0x1E, 0xF4, 0xD5, 0xB1, 0x5C, 0x25, 0xE8, 0x1C };

unsigned char table_110[256] = {
   0xC3, 0x06, 0x3C, 0xCB, 0xD2, 0x44, 0x9D, 0x48,
   0x28, 0xAA, 0xA9, 0xD0, 0x64, 0x25, 0x56, 0xCA,
   0xC2, 0xF8, 0x5C, 0xAE, 0x4E, 0x63, 0xB2, 0xE9,
   0x35, 0x11, 0xA8, 0x1A, 0x76, 0x15, 0xE0, 0x26,
   0x97, 0x99, 0xD4, 0x43, 0x80, 0xEE, 0xC1, 0x69,
   0xA6, 0x1E, 0x7A, 0x42, 0x55, 0x38, 0xBF, 0x75,
   0x0E, 0x29, 0xF5, 0xF3, 0x36, 0x7D, 0x51, 0xE8,
   0xE5, 0xEB, 0x68, 0x60, 0x0C, 0x70, 0xFD, 0xCC,
   0xE3, 0x23, 0x09, 0x6D, 0x2D, 0x6C, 0x5E, 0xB6,
   0x98, 0x8B, 0x1F, 0x50, 0x34, 0x8D, 0x10, 0x92,
   0x82, 0x85, 0xD5, 0x79, 0x02, 0xA4, 0x0A, 0xBC,
   0x40, 0xC6, 0xA3, 0x72, 0x8F, 0xC4, 0xA5, 0xE4,
   0x49, 0xD6, 0xCE, 0xA1, 0x12, 0x4F, 0x30, 0x31,
   0xDE, 0x2A, 0xF7, 0x95, 0xB5, 0x96, 0x14, 0x08,
   0xE6, 0x3D, 0x86, 0xF2, 0x47, 0x74, 0xB8, 0x5D,
   0x1D, 0x2B, 0x3A, 0x93, 0x7C, 0x6A, 0x01, 0xA0,
   0x9A, 0x4D, 0xB7, 0x71, 0xA7, 0x41, 0xC5, 0x65,
   0xC8, 0x89, 0xD1, 0x3E, 0x0D, 0xD8, 0xFF, 0x6F,
   0x7F, 0xA2, 0xFE, 0xD9, 0xF0, 0x4A, 0x07, 0x1C,
   0x0F, 0x6E, 0x03, 0x81, 0x1B, 0x05, 0xDF, 0x52,
   0xF1, 0x8A, 0xF9, 0xDD, 0x91, 0x3B, 0xD7, 0xE1,
   0x54, 0xAD, 0x90, 0x5A, 0x7B, 0xC7, 0x32, 0x62,
   0x16, 0x27, 0xB9, 0x66, 0x21, 0x88, 0xBD, 0x18,
   0x77, 0x8E, 0x94, 0x8C, 0x9B, 0x46, 0x9C, 0xB1,
   0xD3, 0x53, 0xB0, 0xBE, 0xAC, 0xAF, 0x73, 0x24,
   0xDA, 0x58, 0xE2, 0xFC, 0x78, 0xEA, 0xCD, 0xFA,
   0x37, 0xED, 0x13, 0x19, 0xC0, 0x59, 0x83, 0xBA,
   0x3F, 0x57, 0x00, 0x7E, 0xC9, 0x2E, 0x17, 0x5B,
   0x84, 0xF6, 0xE7, 0x22, 0xFB, 0x5F, 0x4C, 0x2C,
   0x61, 0x9F, 0x45, 0x39, 0xB3, 0xEC, 0x04, 0x87,
   0x67, 0xDC, 0x0B, 0xF4, 0x20, 0xAB, 0x6B, 0x9E,
   0x4B, 0xCF, 0xB4, 0x2F, 0xBB, 0xEF, 0xDB, 0x33 };

unsigned char table_111[32] = {
   0x09, 0x0F, 0x00, 0x15, 0x12, 0x17, 0x1A, 0x0D,
   0x1C, 0x0B, 0x01, 0x0A, 0x05, 0x1E, 0x1D, 0x0C,
   0x1B, 0x08, 0x19, 0x18, 0x14, 0x07, 0x0E, 0x03,
   0x10, 0x16, 0x11, 0x1F, 0x04, 0x06, 0x02, 0x13 };

unsigned char table_112[256] = {
   0xF9, 0x7D, 0xBE, 0xD5, 0x9F, 0xB8, 0x95, 0x43,
   0xDB, 0xAE, 0x7E, 0xEC, 0x5B, 0x58, 0x18, 0x49,
   0x4B, 0x9D, 0x1C, 0x3E, 0x61, 0xD1, 0xF6, 0x2F,
   0x41, 0x82, 0x51, 0x37, 0x72, 0x79, 0x05, 0x2A,
   0xC2, 0xB0, 0xE2, 0xE7, 0xB2, 0xF3, 0x1B, 0x92,
   0x86, 0xBB, 0xDC, 0x90, 0x1A, 0x19, 0xD7, 0xBA,
   0x2C, 0x7B, 0xEF, 0xC7, 0x8A, 0x81, 0xEB, 0xDE,
   0x73, 0x4E, 0xB7, 0x97, 0xCA, 0x29, 0x85, 0xC1,
   0xA5, 0x7F, 0xFE, 0x56, 0xE9, 0x9E, 0x21, 0x76,
   0x3A, 0x88, 0x70, 0xC6, 0xD3, 0x8C, 0x47, 0xC8,
   0x83, 0x48, 0xC3, 0x6A, 0x9C, 0x80, 0x53, 0xBD,
   0xFD, 0x54, 0x09, 0x91, 0x94, 0xAA, 0x7A, 0x59,
   0x71, 0xDD, 0xA8, 0x07, 0xCB, 0x0F, 0xE0, 0x9A,
   0x36, 0x4C, 0x4D, 0x0D, 0xA4, 0x96, 0x6F, 0x14,
   0x22, 0x38, 0xAD, 0x02, 0xF4, 0x0B, 0xEA, 0x93,
   0x20, 0x04, 0xBC, 0xE8, 0x6C, 0xFB, 0x10, 0x6B,
   0x40, 0xB6, 0x24, 0x17, 0x06, 0x31, 0xD9, 0x33,
   0xF5, 0x99, 0x57, 0xCD, 0xAB, 0x67, 0x5C, 0x30,
   0x1E, 0x34, 0xB4, 0x3F, 0x16, 0x42, 0xA2, 0x68,
   0x27, 0xB3, 0x1D, 0xED, 0x5F, 0x52, 0xF7, 0x3C,
   0x65, 0x5D, 0xE5, 0x23, 0x0C, 0x6D, 0x84, 0x6E,
   0xDA, 0x77, 0xF8, 0x15, 0xFA, 0x69, 0xD0, 0xA7,
   0x11, 0xAC, 0xA6, 0xA3, 0x1F, 0x2E, 0xBF, 0x4A,
   0x8F, 0xFC, 0xEE, 0xC9, 0x26, 0x12, 0xC0, 0xB1,
   0x45, 0x0E, 0x3D, 0x7C, 0xCE, 0x13, 0x8E, 0x98,
   0x46, 0x2B, 0xC5, 0x66, 0x28, 0x32, 0xD2, 0x03,
   0xE3, 0xC4, 0x9B, 0x89, 0x5E, 0xF0, 0xCF, 0x3B,
   0x2D, 0x50, 0xB5, 0x00, 0x0A, 0xD6, 0x55, 0xE1,
   0x62, 0x63, 0x64, 0x87, 0xAF, 0x78, 0xB9, 0xF2,
   0x25, 0x44, 0xFF, 0x39, 0xF1, 0x08, 0x4F, 0x74,
   0xA9, 0x8B, 0x75, 0x01, 0xA0, 0xE4, 0x35, 0x8D,
   0xA1, 0xCC, 0xDF, 0x60, 0xD8, 0x5A, 0xE6, 0xD4 };

unsigned char table_113[256] = {
   0x46, 0x9D, 0x39, 0xB2, 0x8D, 0x3B, 0x59, 0x5A,
   0xD0, 0x9C, 0xE4, 0x04, 0x01, 0xE2, 0xB3, 0xD2,
   0xD7, 0x18, 0x40, 0xD8, 0xF1, 0xEF, 0x3A, 0x1D,
   0x8E, 0xE5, 0xD9, 0xD3, 0xCB, 0x49, 0x4C, 0xCF,
   0xC0, 0xD6, 0xB5, 0x73, 0x77, 0x82, 0x54, 0xA2,
   0xB1, 0xB0, 0x84, 0x5D, 0xC7, 0xDE, 0x31, 0x2F,
   0x50, 0x78, 0xBE, 0x94, 0x64, 0x44, 0x60, 0x7A,
   0x1A, 0x6E, 0x09, 0x6F, 0xBF, 0x76, 0x81, 0x38,
   0x22, 0xC3, 0xEE, 0x8F, 0xFB, 0x32, 0xED, 0x92,
   0xAE, 0xE6, 0x5F, 0xAA, 0xAC, 0x0D, 0xA3, 0x47,
   0x1F, 0x11, 0xC1, 0x29, 0xAF, 0xFD, 0x1C, 0xDB,
   0x00, 0x23, 0xB9, 0xB8, 0x91, 0x41, 0x27, 0x37,
   0x43, 0x02, 0x26, 0xF6, 0x7D, 0x0A, 0x85, 0x93,
   0x97, 0x2E, 0x20, 0x55, 0x13, 0x4B, 0x6C, 0xE7,
   0xFC, 0x25, 0xFA, 0x9E, 0x5B, 0xA1, 0xDF, 0x2C,
   0x3E, 0xBC, 0xEA, 0x42, 0x7C, 0x36, 0x30, 0xEB,
   0xBD, 0x8B, 0x87, 0x16, 0x3D, 0x5C, 0x07, 0xBA,
   0xB4, 0x1B, 0xC2, 0xE3, 0x71, 0x9A, 0x5E, 0x4D,
   0xF2, 0xCC, 0x0E, 0xE1, 0x34, 0x75, 0x58, 0x89,
   0x17, 0xD4, 0x68, 0x80, 0x2B, 0x74, 0x70, 0x8A,
   0x63, 0xE8, 0x56, 0x24, 0xD1, 0x57, 0x35, 0x6D,
   0x3C, 0xA6, 0xC8, 0x7E, 0xA8, 0x4E, 0xC4, 0x33,
   0xA9, 0x62, 0x61, 0x7F, 0x21, 0x98, 0x2A, 0xAD,
   0xB6, 0xA7, 0xF5, 0x3F, 0x15, 0x45, 0xF8, 0xA4,
   0x95, 0x88, 0xDC, 0x96, 0x90, 0x08, 0x9B, 0xF9,
   0x06, 0x14, 0x05, 0xF0, 0xF7, 0xA0, 0xE0, 0x65,
   0xCA, 0xA5, 0x9F, 0x79, 0xCD, 0x4F, 0x72, 0xB7,
   0x4A, 0x0F, 0x66, 0xC5, 0x0C, 0x52, 0xF3, 0x69,
   0x83, 0x03, 0x99, 0x1E, 0x2D, 0xDA, 0x8C, 0x53,
   0x28, 0xDD, 0xE9, 0x0B, 0xC9, 0xF4, 0x48, 0x12,
   0x6A, 0x19, 0xCE, 0xAB, 0x51, 0xD5, 0x6B, 0xBB,
   0xFE, 0x7B, 0x67, 0xFF, 0x10, 0xEC, 0xC6, 0x86 };

unsigned char table_114[32] = {
   0x11, 0x10, 0x04, 0x1D, 0x08, 0x15, 0x1A, 0x1B,
   0x14, 0x18, 0x0F, 0x17, 0x16, 0x07, 0x1E, 0x0E,
   0x12, 0x0A, 0x13, 0x0B, 0x0C, 0x00, 0x06, 0x02,
   0x1F, 0x19, 0x09, 0x1C, 0x01, 0x0D, 0x03, 0x05 };

unsigned char table_115[256] = {
   0xB7, 0xBB, 0x63, 0x0D, 0xF0, 0x33, 0x5A, 0x05,
   0xF2, 0x7F, 0x64, 0xDB, 0x51, 0xC9, 0x2C, 0x85,
   0x4F, 0x41, 0xA4, 0x42, 0xCF, 0xA6, 0x52, 0x2F,
   0x26, 0xEF, 0xFB, 0x29, 0x40, 0x16, 0xF7, 0xED,
   0x23, 0x69, 0x8A, 0xDF, 0x77, 0x28, 0x93, 0x14,
   0x82, 0x0C, 0xBE, 0x3D, 0x20, 0xB4, 0x79, 0x94,
   0x54, 0xF8, 0x07, 0xB1, 0xE1, 0x66, 0x73, 0xD3,
   0x19, 0x15, 0xFF, 0x03, 0x6A, 0x9A, 0xDC, 0x1C,
   0xB3, 0x5D, 0x76, 0x68, 0x47, 0x6C, 0xF9, 0xFD,
   0xE9, 0xDD, 0x01, 0x65, 0xBD, 0x80, 0x0E, 0x7A,
   0x8D, 0x99, 0x13, 0x7C, 0xA5, 0xA7, 0x1A, 0xCC,
   0xB8, 0xE6, 0x2B, 0xB2, 0xB6, 0xD0, 0x62, 0x2D,
   0x4D, 0xD2, 0xB9, 0x04, 0x46, 0xAE, 0xAA, 0x44,
   0xDA, 0x92, 0x4B, 0x4E, 0xC4, 0xE2, 0xFE, 0xA2,
   0x75, 0x7B, 0xC3, 0xFA, 0x9F, 0x37, 0x9D, 0x1E,
   0x72, 0xD4, 0x1F, 0x4A, 0x9B, 0xE5, 0x6D, 0xEC,
   0x5C, 0x7D, 0x98, 0xE8, 0xEE, 0x86, 0xD1, 0xC8,
   0xEA, 0x55, 0xBF, 0xAF, 0xDE, 0x32, 0x09, 0x3A,
   0x8F, 0x57, 0x83, 0x43, 0x61, 0xC6, 0x8E, 0x96,
   0x22, 0xA3, 0x97, 0x91, 0x5F, 0x11, 0x3B, 0x5B,
   0x1B, 0x34, 0x49, 0x95, 0xF1, 0x6F, 0x89, 0xA8,
   0xC0, 0x36, 0x0A, 0x3F, 0x60, 0x50, 0xE7, 0x08,
   0xCE, 0x25, 0xC1, 0x71, 0xF6, 0x59, 0x58, 0x56,
   0x4C, 0xAB, 0x27, 0xAC, 0x06, 0xCB, 0x00, 0x30,
   0x84, 0x3E, 0xC2, 0x1D, 0x02, 0xE0, 0xC5, 0xD6,
   0x18, 0x70, 0xA9, 0x88, 0xD9, 0x39, 0x8B, 0x6E,
   0xF4, 0x24, 0xA0, 0x48, 0x45, 0x21, 0x87, 0x78,
   0x38, 0x90, 0xE3, 0xCA, 0xF5, 0xD7, 0x2A, 0x53,
   0x9C, 0xCD, 0x31, 0x35, 0xAD, 0x74, 0xD8, 0x12,
   0xBC, 0x9E, 0x6B, 0x67, 0xB0, 0xBA, 0xE4, 0x10,
   0x5E, 0xFC, 0xC7, 0x0F, 0x2E, 0x81, 0x7E, 0xA1,
   0x8C, 0x17, 0xB5, 0xEB, 0xD5, 0xF3, 0x0B, 0x3C };

unsigned char table_116[32] = {
   0x00, 0x05, 0x10, 0x1C, 0x0C, 0x1A, 0x04, 0x1B,
   0x0A, 0x0D, 0x14, 0x0B, 0x07, 0x03, 0x12, 0x1E,
   0x06, 0x11, 0x01, 0x08, 0x15, 0x09, 0x1F, 0x0F,
   0x19, 0x18, 0x16, 0x02, 0x13, 0x0E, 0x17, 0x1D };

unsigned char table_117[256] = {
   0xD0, 0x9A, 0xAB, 0xA8, 0xA7, 0xDF, 0x28, 0xCE,
   0x3E, 0x51, 0xBF, 0x76, 0x03, 0xA0, 0x53, 0x3F,
   0x90, 0x93, 0x87, 0x67, 0x98, 0x3D, 0xEA, 0x8B,
   0x55, 0xCF, 0x10, 0xF3, 0x25, 0xFC, 0x9F, 0x41,
   0x6B, 0x54, 0x6E, 0x0B, 0x83, 0x35, 0x69, 0x7D,
   0xE0, 0x88, 0x4B, 0xE9, 0x1E, 0x96, 0x91, 0x57,
   0xBD, 0x72, 0x21, 0x3C, 0xA6, 0x99, 0x6C, 0xF6,
   0x13, 0xFA, 0x29, 0xED, 0xDB, 0x16, 0x4D, 0x07,
   0x45, 0xA5, 0xE3, 0x0E, 0x31, 0xBC, 0x56, 0x5C,
   0xB2, 0x23, 0xDA, 0x74, 0xFF, 0x02, 0x8F, 0xF4,
   0x2A, 0xC9, 0x89, 0xAA, 0x05, 0xB1, 0xD1, 0x1F,
   0x4F, 0xB0, 0x7A, 0x2C, 0x14, 0xD9, 0xE7, 0x66,
   0x62, 0x1A, 0x4C, 0xC0, 0xC6, 0x63, 0x7F, 0xB4,
   0xF1, 0x43, 0xFE, 0x61, 0xA3, 0xCC, 0xE8, 0x6D,
   0xBA, 0x65, 0x42, 0x2B, 0xCA, 0xD5, 0x52, 0x3A,
   0xCD, 0x1D, 0x24, 0xD7, 0x47, 0xDE, 0x9E, 0x95,
   0x85, 0x48, 0x86, 0xE1, 0xC5, 0xD2, 0x34, 0xAF,
   0x40, 0xFB, 0xE6, 0x4E, 0xC8, 0xF5, 0x7B, 0x5A,
   0xCB, 0xD4, 0x97, 0x6F, 0x0C, 0x79, 0x9C, 0x20,
   0x59, 0x19, 0x68, 0x2E, 0x09, 0x64, 0x73, 0x50,
   0xC2, 0x2F, 0x0D, 0xEF, 0x9D, 0x94, 0x00, 0x81,
   0xE2, 0x46, 0x5F, 0xB8, 0x0A, 0x12, 0x75, 0x1C,
   0x8C, 0xB6, 0x71, 0xAC, 0x04, 0x60, 0xA9, 0x5B,
   0xF8, 0x30, 0x49, 0x44, 0x4A, 0xBE, 0x6A, 0xEB,
   0xD3, 0xD8, 0x36, 0xB3, 0x3B, 0x17, 0x80, 0xA4,
   0xEC, 0x26, 0x82, 0xB5, 0x37, 0x5D, 0x1B, 0x2D,
   0xE5, 0xA2, 0x0F, 0xB7, 0xC4, 0xF2, 0x70, 0x39,
   0xF9, 0xC7, 0xBB, 0x8A, 0x32, 0x78, 0xC3, 0x5E,
   0xD6, 0xE4, 0x22, 0x9B, 0x18, 0x8E, 0xEE, 0x27,
   0x8D, 0x33, 0x11, 0x77, 0x01, 0x06, 0x38, 0xF0,
   0x7E, 0x08, 0x15, 0xB9, 0x7C, 0xAD, 0x84, 0xDD,
   0xC1, 0xFD, 0x92, 0xA1, 0xF7, 0xAE, 0xDC, 0x58 };

unsigned char table_118[256] = {
   0x38, 0xA0, 0xA6, 0xFC, 0x7C, 0x5A, 0x97, 0x1D,
   0xFD, 0x00, 0x20, 0xA2, 0x72, 0x10, 0x1F, 0x48,
   0x98, 0x7E, 0xDF, 0x2D, 0x80, 0x0A, 0x27, 0xDC,
   0xCF, 0xBF, 0x92, 0x94, 0x53, 0xCC, 0x0E, 0x74,
   0xA7, 0x60, 0x08, 0x15, 0x87, 0x6F, 0xB3, 0xA3,
   0xED, 0x59, 0x09, 0x4F, 0x9E, 0x9A, 0xEE, 0x83,
   0x56, 0x32, 0x34, 0xC7, 0x24, 0xE7, 0x96, 0x4D,
   0xAE, 0xE3, 0xBD, 0xE2, 0x36, 0x4A, 0xB6, 0x8B,
   0xF2, 0xC1, 0xD7, 0x40, 0x31, 0x4B, 0xDA, 0xF1,
   0xB1, 0x70, 0xA8, 0xC3, 0xC6, 0x8A, 0xE6, 0x77,
   0x21, 0x7D, 0xD5, 0x0C, 0x43, 0xC4, 0xF0, 0x1B,
   0x18, 0xA1, 0x85, 0xE1, 0xFF, 0x8D, 0xE5, 0x6E,
   0x9B, 0x51, 0x1C, 0xA4, 0x5C, 0x8E, 0x69, 0x49,
   0x23, 0xCD, 0x52, 0xF8, 0x3E, 0x91, 0x5E, 0x1E,
   0x25, 0xB4, 0x93, 0xCB, 0xE0, 0x47, 0xBC, 0x4E,
   0x33, 0xB7, 0x75, 0x1A, 0x11, 0x9C, 0x3F, 0xEC,
   0xD1, 0x46, 0xDD, 0xAA, 0xB8, 0x99, 0x86, 0x67,
   0x58, 0xF9, 0x16, 0x17, 0x6D, 0x5F, 0x2B, 0xA5,
   0xD3, 0x8F, 0x55, 0x71, 0xD2, 0xBA, 0x5B, 0x3C,
   0x82, 0xB5, 0x41, 0xE4, 0x90, 0x45, 0x6C, 0xF6,
   0xDE, 0xA9, 0x84, 0x62, 0x19, 0x3B, 0xB9, 0xC8,
   0x2C, 0xB0, 0x76, 0x57, 0xD8, 0x26, 0x9D, 0x89,
   0xC9, 0x54, 0xFB, 0x07, 0xCE, 0x22, 0x5D, 0x64,
   0x65, 0xAD, 0x01, 0xDB, 0x14, 0x4C, 0x37, 0x03,
   0x6B, 0xAF, 0xD0, 0x7F, 0x9F, 0xBB, 0xEB, 0xC0,
   0x50, 0x66, 0x68, 0x0B, 0x42, 0x2A, 0xD4, 0xF5,
   0x61, 0x63, 0xF3, 0x39, 0xBE, 0xC5, 0xEF, 0x28,
   0x3A, 0xAB, 0x79, 0x05, 0xE9, 0x12, 0x73, 0x3D,
   0xB2, 0x8C, 0xCA, 0x29, 0x0F, 0xF4, 0x7B, 0x13,
   0x88, 0x44, 0xC2, 0x2E, 0xFA, 0xFE, 0x04, 0x35,
   0xE8, 0x06, 0x7A, 0x78, 0x0D, 0x81, 0xF7, 0xEA,
   0xD9, 0x2F, 0x02, 0xAC, 0x30, 0x6A, 0xD6, 0x95 };

unsigned char table_119[32] = {
   0x14, 0x0A, 0x1C, 0x00, 0x0C, 0x1F, 0x1E, 0x0B,
   0x12, 0x1D, 0x17, 0x08, 0x07, 0x04, 0x09, 0x10,
   0x03, 0x1B, 0x0E, 0x1A, 0x05, 0x0D, 0x11, 0x15,
   0x18, 0x02, 0x06, 0x01, 0x19, 0x16, 0x13, 0x0F };

unsigned char table_120[256] = {
   0xCE, 0x89, 0xB2, 0x72, 0x04, 0x77, 0x64, 0xAE,
   0x80, 0x99, 0xB5, 0x00, 0x7B, 0x50, 0x9D, 0xE3,
   0x87, 0x37, 0x6D, 0x3D, 0x32, 0xBA, 0x20, 0xF0,
   0xDC, 0xBD, 0x61, 0x26, 0xD4, 0xA6, 0x70, 0x54,
   0xC1, 0x7D, 0x82, 0xFF, 0x81, 0x83, 0x2F, 0xF5,
   0x3B, 0x42, 0x08, 0x5C, 0x30, 0x59, 0xBB, 0xC2,
   0x33, 0x5D, 0xEE, 0xB7, 0xF7, 0x2B, 0x76, 0xD0,
   0x43, 0x1C, 0x48, 0xFC, 0x01, 0xCD, 0x27, 0x1D,
   0x5A, 0x96, 0x95, 0x03, 0xC6, 0x1F, 0x09, 0xCB,
   0xF6, 0x47, 0xA9, 0x93, 0xA7, 0xD2, 0xDB, 0x51,
   0xB0, 0x7A, 0xE6, 0x62, 0x0F, 0x12, 0x57, 0xF4,
   0x35, 0xFE, 0xA4, 0xDF, 0x5B, 0xF3, 0x67, 0x85,
   0x98, 0xE4, 0xAB, 0x75, 0x4C, 0xE2, 0x25, 0x74,
   0x3A, 0x45, 0xDE, 0xEF, 0x4A, 0x97, 0x86, 0x24,
   0xE9, 0x8F, 0xD8, 0xD7, 0x60, 0xAD, 0x36, 0x8E,
   0x1E, 0xB9, 0x4F, 0x6B, 0x8C, 0x06, 0x23, 0x94,
   0x0E, 0xD3, 0x49, 0x14, 0x90, 0xAF, 0x65, 0xEC,
   0xF9, 0x0D, 0xED, 0x6C, 0xBE, 0x7F, 0xA5, 0xC5,
   0xEA, 0x78, 0x2E, 0xBC, 0xD5, 0xDA, 0x18, 0xE1,
   0x10, 0x2D, 0xB4, 0x16, 0x4B, 0xE8, 0xC4, 0x8D,
   0x19, 0x1B, 0x02, 0x66, 0xB6, 0xE7, 0x9C, 0x7C,
   0xC9, 0xA0, 0x2A, 0x53, 0x13, 0xDD, 0xF8, 0xA8,
   0x0A, 0x6E, 0xCF, 0x6F, 0x7E, 0xE0, 0x3E, 0xE5,
   0x07, 0xCC, 0x38, 0xD1, 0xF2, 0x2C, 0x9A, 0xAC,
   0x88, 0x79, 0xB8, 0xC8, 0xBF, 0x63, 0x71, 0x69,
   0x52, 0x39, 0x9F, 0x22, 0x3F, 0x9E, 0x44, 0xFA,
   0x73, 0x6A, 0x8B, 0xA2, 0xD6, 0x1A, 0x9B, 0xB1,
   0x8A, 0x4D, 0x58, 0xA1, 0x46, 0x5F, 0x55, 0x56,
   0x21, 0x05, 0x15, 0x92, 0xAA, 0xEB, 0x31, 0x68,
   0xFB, 0x41, 0xC3, 0x4E, 0xB3, 0x40, 0x34, 0x17,
   0xD9, 0x29, 0x3C, 0x0C, 0xF1, 0x0B, 0x28, 0x84,
   0x5E, 0xCA, 0xFD, 0x11, 0xA3, 0xC7, 0xC0, 0x91 };

unsigned char table_121[32] = {
   0x1E, 0x12, 0x06, 0x1D, 0x15, 0x1F, 0x13, 0x0B,
   0x10, 0x0D, 0x1C, 0x01, 0x0A, 0x0E, 0x02, 0x19,
   0x04, 0x1A, 0x03, 0x11, 0x00, 0x16, 0x0C, 0x17,
   0x14, 0x08, 0x18, 0x05, 0x09, 0x0F, 0x1B, 0x07 };

unsigned char table_122[256] = {
   0x85, 0xDF, 0x7F, 0x7C, 0x56, 0xF0, 0x0C, 0x7D,
   0x76, 0xA8, 0x58, 0x31, 0x25, 0x8A, 0x0D, 0x23,
   0x05, 0x0F, 0x12, 0x64, 0x8E, 0x5D, 0xF4, 0x2C,
   0x18, 0xFA, 0x4B, 0xFE, 0x91, 0xBF, 0x95, 0x0B,
   0xF1, 0x88, 0x10, 0xD8, 0x3E, 0x53, 0x96, 0xB5,
   0x75, 0x24, 0x8F, 0xD6, 0x68, 0x5C, 0x93, 0x1F,
   0x6B, 0xC2, 0xAB, 0xED, 0x1E, 0xC0, 0xBC, 0x47,
   0xE9, 0xD1, 0xDE, 0xCA, 0xF6, 0x62, 0x43, 0xEB,
   0xA2, 0xB4, 0x08, 0xE6, 0x74, 0x0E, 0xA1, 0x72,
   0x66, 0x61, 0x21, 0x2E, 0x32, 0x63, 0x29, 0xD7,
   0x1C, 0x22, 0xAC, 0xE7, 0x54, 0xF3, 0x65, 0x17,
   0x9F, 0x78, 0x79, 0x4C, 0xDD, 0x27, 0x90, 0x36,
   0x19, 0x44, 0x03, 0xD9, 0x4A, 0x5A, 0x34, 0xF9,
   0x97, 0xA6, 0x70, 0x39, 0x28, 0x77, 0x6E, 0xB7,
   0x8C, 0x02, 0x5E, 0x9B, 0x8D, 0x59, 0x6F, 0xA5,
   0x07, 0xE2, 0x41, 0x51, 0xC9, 0x3C, 0xE8, 0xE1,
   0xB3, 0x16, 0x50, 0x04, 0xE3, 0x1D, 0x3B, 0xD2,
   0x4D, 0x35, 0x71, 0xDA, 0x9E, 0xA7, 0xE4, 0xE0,
   0xB6, 0x2B, 0xEA, 0x84, 0x55, 0xF8, 0x57, 0x3D,
   0x73, 0x42, 0xC6, 0x0A, 0x92, 0x6A, 0xAE, 0xF5,
   0xFC, 0xD5, 0x15, 0x52, 0x7E, 0x14, 0x81, 0x13,
   0xE5, 0x49, 0x38, 0x2A, 0x94, 0x5B, 0xA3, 0x11,
   0x8B, 0x80, 0xBB, 0x01, 0x9C, 0xA4, 0xDB, 0xF7,
   0xA9, 0x20, 0xF2, 0x1A, 0xDC, 0x33, 0x3A, 0xEF,
   0xD3, 0xFD, 0x30, 0xB0, 0x1B, 0xC4, 0x06, 0xD4,
   0x6D, 0x87, 0x2F, 0x60, 0x5F, 0xC5, 0x09, 0x37,
   0xAF, 0x00, 0xCB, 0x9D, 0xA0, 0xB9, 0x45, 0x86,
   0x4F, 0x6C, 0x67, 0xFB, 0x40, 0x3F, 0xCC, 0xB8,
   0xC8, 0x82, 0x98, 0x99, 0x7B, 0xB1, 0xCD, 0xD0,
   0xBD, 0x48, 0xAD, 0x26, 0x7A, 0x9A, 0x46, 0xFF,
   0x89, 0xC7, 0xC1, 0xCF, 0xBE, 0xAA, 0xEC, 0xBA,
   0xCE, 0x2D, 0x4E, 0x83, 0xC3, 0x69, 0xEE, 0xB2 };

unsigned char table_123[256] = {
   0x9D, 0xFB, 0x3C, 0x81, 0xAA, 0x05, 0xB2, 0xBE,
   0xD1, 0x5F, 0x4C, 0xE0, 0xA3, 0xF4, 0xDE, 0x35,
   0xFE, 0x1B, 0x37, 0x99, 0x94, 0x7A, 0x10, 0xAB,
   0xC0, 0xA4, 0xB5, 0xFF, 0x8F, 0x3B, 0xB4, 0x51,
   0x04, 0xE9, 0xB9, 0xC1, 0x98, 0xC5, 0x82, 0x38,
   0x4D, 0x71, 0xFC, 0x33, 0xC4, 0x50, 0x5D, 0x88,
   0xB8, 0x5C, 0x32, 0xE2, 0xBB, 0xCD, 0x60, 0x2C,
   0xD4, 0x7E, 0x27, 0x59, 0x2B, 0x1F, 0x53, 0xF6,
   0x25, 0x86, 0xAE, 0x21, 0xFA, 0x31, 0xD7, 0x0F,
   0x17, 0xDA, 0x7F, 0xC9, 0x46, 0x19, 0x08, 0xA8,
   0xCF, 0x13, 0xCC, 0x03, 0x3F, 0x22, 0x6E, 0xEB,
   0x4A, 0x63, 0x73, 0xBD, 0x36, 0xED, 0x30, 0x57,
   0x65, 0xF8, 0x41, 0x61, 0x1E, 0xA0, 0xC6, 0x45,
   0x3E, 0x75, 0x28, 0x87, 0xCB, 0xD6, 0x16, 0xD8,
   0xDF, 0xEF, 0xEA, 0xA7, 0x58, 0xB0, 0x1D, 0xE6,
   0x47, 0x76, 0xD9, 0x96, 0xE7, 0xDC, 0x00, 0x80,
   0xDD, 0xB7, 0x9A, 0xE1, 0xF5, 0x9C, 0x4B, 0xE3,
   0xBC, 0x8D, 0xF2, 0x2F, 0x9F, 0x6C, 0x93, 0xAF,
   0xA9, 0xC2, 0x5E, 0x24, 0x15, 0xD2, 0x09, 0x0D,
   0xDB, 0x4F, 0x91, 0x0E, 0x64, 0x34, 0x4E, 0xAD,
   0x62, 0x44, 0x23, 0x85, 0xB6, 0xAC, 0xC7, 0xCA,
   0x84, 0xF9, 0x8C, 0xBF, 0x14, 0x7C, 0x8E, 0x92,
   0xF0, 0x0B, 0xCE, 0x90, 0x7D, 0x70, 0x9E, 0x54,
   0x39, 0x5B, 0x6D, 0x52, 0xEE, 0xA2, 0x6F, 0x78,
   0x2D, 0x95, 0x8B, 0x02, 0x3D, 0x7B, 0x69, 0xC3,
   0x49, 0xA5, 0x1A, 0x26, 0xD5, 0x6B, 0xE8, 0xFD,
   0xB3, 0xD3, 0x20, 0x55, 0x18, 0x06, 0xF3, 0xB1,
   0x0C, 0xC8, 0x07, 0x12, 0xF7, 0x01, 0x2E, 0x72,
   0x97, 0xA6, 0x11, 0x89, 0x56, 0x5A, 0x29, 0xBA,
   0x67, 0x42, 0x83, 0x6A, 0x2A, 0xF1, 0xA1, 0x9B,
   0xE5, 0xE4, 0x74, 0x66, 0x1C, 0x68, 0xEC, 0x40,
   0x48, 0x77, 0xD0, 0x0A, 0x8A, 0x3A, 0x43, 0x79 };

unsigned char table_124[256] = {
   0x6C, 0xC3, 0x28, 0x2F, 0x42, 0x4B, 0x7C, 0x3C,
   0xCE, 0x24, 0xC8, 0x51, 0x25, 0x3F, 0x49, 0x8D,
   0x1E, 0x5C, 0x89, 0x3A, 0x98, 0x47, 0x0B, 0x12,
   0xA9, 0xB1, 0xD7, 0xB6, 0x5D, 0xF9, 0x5A, 0xBC,
   0xFA, 0x06, 0x7D, 0x08, 0xFC, 0x37, 0x54, 0x4F,
   0xD4, 0xCD, 0xA7, 0x5E, 0xE0, 0x92, 0x82, 0x56,
   0xF1, 0x2B, 0xC4, 0xE2, 0x29, 0xEA, 0x35, 0x57,
   0x33, 0x4E, 0x1A, 0x17, 0x8B, 0x85, 0xBF, 0xD5,
   0x18, 0xB3, 0x0D, 0x71, 0x45, 0x81, 0xB4, 0x27,
   0xD1, 0xE1, 0xFF, 0x44, 0x9E, 0xA4, 0x15, 0x9A,
   0x90, 0xC7, 0x79, 0xE3, 0x4C, 0xE9, 0x3D, 0x6B,
   0xF5, 0xF4, 0xEE, 0xAA, 0xDB, 0x07, 0x09, 0xCF,
   0x7B, 0x95, 0xA0, 0x53, 0x8F, 0xA1, 0x9D, 0xBE,
   0x6F, 0xAE, 0x96, 0x46, 0x59, 0x01, 0x84, 0xCC,
   0x3B, 0x8E, 0xF7, 0x4D, 0x6E, 0xDC, 0xE8, 0x36,
   0x7A, 0xE5, 0xBD, 0xE7, 0x9F, 0x2C, 0x52, 0xAB,
   0x55, 0x13, 0x1D, 0xFB, 0x58, 0x9C, 0xDF, 0xC0,
   0x30, 0x73, 0x67, 0x39, 0x74, 0xD3, 0x11, 0xD2,
   0x0E, 0x20, 0xB7, 0x02, 0xB9, 0x1C, 0x86, 0x76,
   0x10, 0x68, 0x9B, 0x63, 0x48, 0x8A, 0xB2, 0xB8,
   0xAF, 0x26, 0x99, 0x04, 0xB0, 0xE4, 0xEF, 0xEB,
   0xEC, 0x6D, 0x61, 0xC1, 0xD0, 0x38, 0xC9, 0x19,
   0x60, 0xA8, 0xA6, 0xF8, 0x80, 0xC5, 0x03, 0x0F,
   0x22, 0x2D, 0x88, 0x32, 0x77, 0x70, 0xFE, 0x0C,
   0x31, 0x40, 0x5F, 0xED, 0xA5, 0x93, 0x43, 0xF0,
   0x8C, 0xE6, 0x34, 0x21, 0xD9, 0xC2, 0xD8, 0xC6,
   0x6A, 0xD6, 0xCB, 0xAC, 0x75, 0xB5, 0x78, 0x0A,
   0xA3, 0x69, 0x16, 0xBA, 0x50, 0x2A, 0x41, 0x83,
   0xF6, 0x64, 0x00, 0x65, 0x7E, 0xDD, 0x5B, 0xDA,
   0x14, 0xFD, 0x3E, 0x7F, 0xCA, 0x66, 0x4A, 0x1F,
   0xA2, 0xAD, 0xF2, 0x23, 0xBB, 0x72, 0xF3, 0x94,
   0x62, 0x1B, 0xDE, 0x91, 0x87, 0x97, 0x05, 0x2E };

unsigned char table_125[32] = {
   0x1A, 0x18, 0x12, 0x15, 0x00, 0x1C, 0x01, 0x0B,
   0x19, 0x1B, 0x1F, 0x11, 0x07, 0x10, 0x1E, 0x06,
   0x17, 0x04, 0x0A, 0x0E, 0x0D, 0x0C, 0x16, 0x08,
   0x02, 0x03, 0x13, 0x14, 0x09, 0x1D, 0x05, 0x0F };

unsigned char table_126[32] = {
   0x1C, 0x1D, 0x07, 0x12, 0x18, 0x1A, 0x19, 0x09,
   0x0F, 0x14, 0x1F, 0x0B, 0x13, 0x04, 0x0E, 0x1E,
   0x0C, 0x0D, 0x01, 0x17, 0x1B, 0x16, 0x0A, 0x05,
   0x15, 0x10, 0x11, 0x08, 0x00, 0x03, 0x06, 0x02 };

unsigned char table_127[256] = {
   0xA0, 0x66, 0xD8, 0x08, 0xEA, 0x39, 0x78, 0xAB,
   0x61, 0x4E, 0xC7, 0xD1, 0xA3, 0x1C, 0x9F, 0xCB,
   0x19, 0x51, 0x15, 0x92, 0x23, 0xFD, 0x7D, 0x1D,
   0x95, 0xAE, 0x0E, 0x8B, 0xE6, 0x7F, 0x86, 0x6D,
   0x06, 0xBD, 0x20, 0x1F, 0x3A, 0xE4, 0x54, 0x91,
   0x69, 0xD3, 0xE3, 0x3D, 0x4D, 0x31, 0x49, 0xA4,
   0x41, 0xF3, 0xE0, 0x11, 0x14, 0x9B, 0x96, 0x5A,
   0xC4, 0x8E, 0x34, 0xDB, 0xBA, 0x83, 0xD9, 0x81,
   0xAF, 0x58, 0x8A, 0x79, 0x13, 0xBC, 0x85, 0x37,
   0x9E, 0x6C, 0x57, 0x71, 0x8D, 0x97, 0x5F, 0x6F,
   0x1E, 0x74, 0x27, 0xFC, 0x5C, 0x7A, 0x64, 0x87,
   0xF5, 0xC6, 0xF2, 0x4F, 0xDE, 0x80, 0xAA, 0x84,
   0x2E, 0xDC, 0xE7, 0x40, 0x75, 0xC5, 0xB3, 0xC8,
   0xCE, 0x21, 0x02, 0x67, 0xB7, 0x10, 0x47, 0x6A,
   0xEE, 0x53, 0x2C, 0x16, 0x05, 0xC0, 0x63, 0x4C,
   0x0D, 0xBB, 0xC3, 0x38, 0x46, 0x68, 0x7E, 0xF9,
   0xB8, 0xB4, 0x3E, 0x36, 0xD5, 0xEC, 0x0B, 0xF6,
   0x33, 0x0A, 0x0F, 0x5B, 0xFB, 0x45, 0xEB, 0xA9,
   0x6E, 0x6B, 0xCF, 0x55, 0x99, 0xAC, 0x22, 0xBE,
   0xB1, 0xA2, 0x3F, 0x25, 0x77, 0x8F, 0x7C, 0xF1,
   0xD4, 0x59, 0xA8, 0xE5, 0xD7, 0xCA, 0xA1, 0x93,
   0xE9, 0xAD, 0xF7, 0x94, 0xEF, 0xED, 0x3C, 0x2A,
   0x88, 0xB5, 0x35, 0x9D, 0x9C, 0x32, 0x5E, 0xB6,
   0x48, 0x9A, 0x7B, 0x26, 0x50, 0x90, 0x04, 0xA7,
   0xDD, 0x09, 0xB9, 0x98, 0xB2, 0xFE, 0xDF, 0x44,
   0x89, 0x29, 0x5D, 0xE2, 0x72, 0xC9, 0x28, 0x03,
   0x43, 0x8C, 0x52, 0x18, 0xC1, 0x56, 0x1B, 0x1A,
   0x01, 0x65, 0xDA, 0xBF, 0x07, 0xFF, 0x76, 0xE8,
   0x30, 0xA5, 0x4A, 0xA6, 0x12, 0x62, 0x24, 0x60,
   0x4B, 0x73, 0x0C, 0xF0, 0xFA, 0x42, 0xF4, 0x00,
   0xD2, 0xD0, 0xD6, 0x3B, 0xC2, 0x2F, 0xE1, 0x2B,
   0x70, 0xF8, 0x17, 0xCD, 0xB0, 0xCC, 0x82, 0x2D };

unsigned char table_128[32] = {
   0x1A, 0x1C, 0x09, 0x17, 0x1B, 0x0B, 0x16, 0x1E,
   0x14, 0x0C, 0x12, 0x0E, 0x05, 0x03, 0x1F, 0x15,
   0x19, 0x0D, 0x10, 0x13, 0x0A, 0x01, 0x00, 0x11,
   0x02, 0x08, 0x0F, 0x18, 0x07, 0x04, 0x1D, 0x06 };

unsigned char table_129[256] = {
   0x9D, 0x5F, 0xE8, 0x99, 0x57, 0x07, 0x16, 0xA6,
   0x9F, 0xB6, 0xDE, 0xED, 0x2D, 0xB3, 0xC0, 0x8E,
   0xCC, 0x49, 0xCE, 0xB0, 0x1B, 0xB1, 0x7A, 0xE0,
   0xEB, 0x28, 0xDB, 0x7D, 0x88, 0xC8, 0x06, 0x6C,
   0x02, 0xD0, 0x85, 0x7E, 0xDF, 0xF5, 0x78, 0xE5,
   0xA9, 0x71, 0xD9, 0xDD, 0xDC, 0xEE, 0x8C, 0x54,
   0xA0, 0x86, 0xFE, 0x0E, 0x55, 0xF7, 0x41, 0x47,
   0x1D, 0x15, 0xD6, 0xA4, 0xFF, 0x1F, 0x25, 0xF8,
   0x12, 0xE9, 0x74, 0x7B, 0x04, 0xE6, 0x4C, 0x31,
   0xA2, 0xBE, 0x0C, 0xB9, 0x17, 0xBD, 0x3D, 0xF0,
   0x9E, 0x4D, 0x4E, 0xB2, 0xE7, 0x40, 0xC9, 0x8A,
   0x67, 0x5E, 0x19, 0x0F, 0xB7, 0x22, 0x8D, 0xBA,
   0xFC, 0x93, 0x14, 0xEA, 0xFD, 0x0D, 0xD5, 0x38,
   0xA1, 0x84, 0x1C, 0x35, 0x60, 0x37, 0x43, 0x9C,
   0xCF, 0xEF, 0x3A, 0x72, 0xF2, 0x61, 0x75, 0x6A,
   0x42, 0xAC, 0xD3, 0x48, 0x77, 0xC5, 0x29, 0xF6,
   0x58, 0x79, 0xFA, 0x5D, 0xC7, 0x70, 0x53, 0x9A,
   0x6F, 0xC1, 0x0A, 0x90, 0x8F, 0x3E, 0x3B, 0x8B,
   0xEC, 0xBC, 0x20, 0x27, 0xC3, 0x66, 0x3F, 0x33,
   0xA5, 0x44, 0x2E, 0x32, 0x65, 0x18, 0xFB, 0x59,
   0x52, 0x50, 0xE2, 0x63, 0x2B, 0xCD, 0x64, 0xCB,
   0xD2, 0x68, 0x10, 0xA7, 0xAE, 0x11, 0xA8, 0x96,
   0x69, 0xAF, 0xC2, 0x34, 0x5C, 0x56, 0xE3, 0xF9,
   0xDA, 0x51, 0x81, 0x4A, 0x05, 0x00, 0xB8, 0x7C,
   0x30, 0x2F, 0x46, 0xB4, 0xC6, 0x87, 0x4B, 0x94,
   0x80, 0xF4, 0x7F, 0x3C, 0x26, 0xF1, 0x5B, 0xAB,
   0x91, 0x6E, 0x08, 0x76, 0x98, 0xD1, 0xE1, 0x36,
   0x21, 0xCA, 0xD8, 0x24, 0x9B, 0x39, 0xBB, 0xAD,
   0x13, 0x62, 0x97, 0x1A, 0x6D, 0x2C, 0x5A, 0xC4,
   0xD4, 0xA3, 0x03, 0xBF, 0x1E, 0xE4, 0xF3, 0x95,
   0x23, 0x73, 0x92, 0xB5, 0x01, 0x83, 0x82, 0xAA,
   0x09, 0x45, 0x6B, 0xD7, 0x0B, 0x89, 0x4F, 0x2A };

unsigned char table_130[32] = {
   0x07, 0x03, 0x15, 0x0B, 0x02, 0x11, 0x17, 0x14,
   0x05, 0x10, 0x0A, 0x0F, 0x01, 0x1C, 0x1D, 0x0E,
   0x12, 0x06, 0x18, 0x16, 0x1A, 0x09, 0x13, 0x19,
   0x1B, 0x00, 0x08, 0x0D, 0x0C, 0x1E, 0x04, 0x1F };

unsigned char table_131[32] = {
   0x1D, 0x13, 0x1B, 0x10, 0x07, 0x03, 0x0A, 0x02,
   0x00, 0x0C, 0x0E, 0x0B, 0x0D, 0x18, 0x12, 0x1F,
   0x1A, 0x04, 0x15, 0x11, 0x1E, 0x08, 0x1C, 0x14,
   0x19, 0x05, 0x0F, 0x17, 0x06, 0x01, 0x09, 0x16 };

unsigned char table_132[256] = {
   0x33, 0x8D, 0x45, 0x6F, 0xFF, 0xF5, 0xB6, 0x53,
   0x3B, 0xF3, 0x07, 0xA4, 0x97, 0xEB, 0x6B, 0xA5,
   0xD3, 0xDC, 0x7B, 0x79, 0x93, 0xE7, 0xF7, 0x67,
   0x9C, 0x4F, 0x88, 0xF9, 0x3A, 0x2B, 0x27, 0x48,
   0x47, 0x18, 0xF4, 0xAD, 0xB4, 0x8F, 0x2A, 0x76,
   0x17, 0xE9, 0x1F, 0x40, 0x0C, 0x59, 0xD1, 0x4C,
   0x20, 0x31, 0x73, 0x54, 0xCD, 0x68, 0x08, 0x52,
   0x10, 0x62, 0x3D, 0xD2, 0x77, 0xF2, 0xD7, 0x30,
   0xCA, 0x16, 0x01, 0x50, 0x9F, 0x3F, 0x75, 0xED,
   0x90, 0x6A, 0x34, 0xCE, 0x05, 0x78, 0x5E, 0xD6,
   0x85, 0xCC, 0x29, 0xB8, 0xC1, 0x0D, 0xCB, 0x80,
   0x2E, 0x04, 0x00, 0x44, 0x32, 0x95, 0xBF, 0xFE,
   0x6E, 0x7C, 0xFD, 0xA7, 0x3C, 0x5C, 0xF0, 0xEC,
   0xAC, 0xF8, 0xB9, 0xC0, 0x1B, 0x3E, 0xE8, 0x66,
   0x5D, 0xDE, 0x49, 0x71, 0xAA, 0xAF, 0x21, 0x64,
   0x28, 0x8A, 0x4E, 0x98, 0x58, 0xA2, 0x23, 0xCF,
   0x9E, 0x63, 0x61, 0x91, 0x12, 0xC6, 0x8C, 0x19,
   0xA8, 0xD4, 0xC7, 0xDD, 0xFC, 0xBD, 0x38, 0xDF,
   0xEA, 0x2D, 0x7E, 0x7D, 0xE3, 0xE0, 0xC3, 0xD9,
   0x8B, 0x11, 0xF1, 0x4D, 0xC8, 0xB5, 0x55, 0xAE,
   0xE1, 0x89, 0xE5, 0xB3, 0xBC, 0x69, 0x9D, 0xA6,
   0x09, 0x9A, 0x74, 0x35, 0x1A, 0xFB, 0x24, 0xB7,
   0x13, 0x14, 0x94, 0x0A, 0x86, 0x0F, 0x60, 0x51,
   0xB0, 0x84, 0x22, 0x5B, 0x87, 0x43, 0x57, 0x0B,
   0x2F, 0x5F, 0x02, 0xD0, 0xBB, 0xA3, 0xC9, 0x7A,
   0xBE, 0xC2, 0x26, 0x46, 0xDB, 0x1E, 0x1D, 0x92,
   0xE2, 0xB2, 0x37, 0x6D, 0xD5, 0x4A, 0x0E, 0x4B,
   0x8E, 0xC5, 0x42, 0x99, 0xEE, 0xE4, 0xB1, 0x06,
   0xAB, 0x5A, 0x56, 0x41, 0x65, 0xBA, 0xFA, 0x83,
   0x15, 0xDA, 0x72, 0xA1, 0x81, 0x1C, 0xA9, 0x36,
   0x25, 0x96, 0x6C, 0x39, 0x82, 0xE6, 0x2C, 0x9B,
   0xC4, 0x7F, 0xA0, 0xD8, 0xEF, 0x03, 0x70, 0xF6 };

unsigned char table_133[256] = {
   0x02, 0xF0, 0xED, 0xC4, 0xE4, 0x67, 0x60, 0x8B,
   0xF3, 0x77, 0x92, 0xE0, 0x85, 0x93, 0x1E, 0x8E,
   0x9A, 0x38, 0x61, 0x20, 0xB7, 0x68, 0xE1, 0x5E,
   0xD5, 0x63, 0xA9, 0xA5, 0xBE, 0x36, 0x12, 0x4D,
   0x86, 0x16, 0xD6, 0xB1, 0x23, 0x64, 0x4F, 0x62,
   0xFC, 0xA3, 0xD3, 0x04, 0x7D, 0x8C, 0xE2, 0xFF,
   0x5D, 0x30, 0xF5, 0x95, 0x1B, 0x5F, 0x73, 0xAA,
   0xE8, 0x07, 0x87, 0xDC, 0x54, 0x7C, 0xEE, 0x00,
   0xB8, 0xDE, 0x55, 0xBA, 0xD0, 0x50, 0xBB, 0x89,
   0x1C, 0xCC, 0x0E, 0xC0, 0x42, 0x11, 0xD8, 0xA2,
   0x2E, 0x33, 0xFE, 0x26, 0xD4, 0x10, 0xDA, 0xC5,
   0xFB, 0xAF, 0x98, 0x78, 0xB5, 0xBD, 0xC8, 0x8D,
   0x46, 0xA0, 0xD1, 0x7B, 0xBC, 0x75, 0xAB, 0x25,
   0xB2, 0x43, 0x57, 0xB6, 0xEC, 0xF4, 0x66, 0x05,
   0x9C, 0x08, 0x53, 0x80, 0xEA, 0x21, 0x2C, 0x6C,
   0x17, 0x71, 0xD2, 0x70, 0x76, 0x9E, 0x6B, 0x7A,
   0x58, 0xA7, 0xBF, 0x29, 0x03, 0x1F, 0x06, 0xC1,
   0xDD, 0x2F, 0x5C, 0x0B, 0x0D, 0x8A, 0x0A, 0xCB,
   0xCA, 0x6F, 0x19, 0x6A, 0xFA, 0xF7, 0xA8, 0xA1,
   0xEB, 0x88, 0x44, 0xAC, 0x01, 0x4E, 0x59, 0x94,
   0x72, 0x2B, 0xE9, 0x0F, 0x22, 0x9B, 0x27, 0x37,
   0x41, 0xF9, 0xF2, 0xE3, 0xEF, 0xB3, 0xD9, 0x2A,
   0x31, 0xC2, 0x0C, 0x15, 0x90, 0x14, 0xF6, 0x83,
   0xFD, 0x96, 0x9D, 0x7F, 0xA4, 0x39, 0xE7, 0x3F,
   0xE6, 0xC7, 0xCD, 0x1A, 0xCF, 0x48, 0x3C, 0x51,
   0x6D, 0x5B, 0x74, 0xC3, 0xC9, 0x09, 0x3D, 0x9F,
   0xDB, 0x32, 0x40, 0x18, 0xD7, 0xCE, 0x69, 0x49,
   0x3A, 0xF1, 0xB9, 0x56, 0x91, 0x99, 0x84, 0x24,
   0x7E, 0x34, 0x4B, 0xA6, 0x47, 0xB4, 0x6E, 0xDF,
   0x65, 0x3B, 0xAD, 0x45, 0x13, 0xC6, 0x81, 0xF8,
   0x4A, 0x2D, 0x8F, 0x4C, 0x97, 0x28, 0x3E, 0xE5,
   0x5A, 0x35, 0xB0, 0xAE, 0x82, 0x79, 0x1D, 0x52 };

unsigned char table_134[32] = {
   0x09, 0x0F, 0x10, 0x0C, 0x03, 0x15, 0x07, 0x17,
   0x0E, 0x0B, 0x1D, 0x08, 0x19, 0x11, 0x00, 0x0A,
   0x01, 0x06, 0x18, 0x16, 0x0D, 0x13, 0x14, 0x12,
   0x02, 0x1B, 0x1A, 0x04, 0x05, 0x1F, 0x1C, 0x1E };

unsigned char table_135[256] = {
   0x14, 0x34, 0xEA, 0x02, 0x2B, 0x5A, 0x10, 0x51,
   0xF3, 0x8F, 0x28, 0xB2, 0x50, 0x8B, 0x01, 0xCC,
   0x80, 0x15, 0x29, 0x42, 0xF4, 0x1D, 0xFB, 0xBB,
   0x1F, 0x43, 0x8C, 0x17, 0x1E, 0x81, 0x04, 0x98,
   0x46, 0xD8, 0xD5, 0x65, 0x4C, 0x1C, 0xDB, 0x40,
   0x5F, 0x1A, 0x31, 0x74, 0xF1, 0x64, 0x19, 0x05,
   0xFC, 0xF0, 0x73, 0xB6, 0x23, 0x77, 0x9C, 0xCE,
   0x70, 0xEF, 0xDA, 0xE0, 0xA2, 0x78, 0x84, 0xEB,
   0x9E, 0xC5, 0x95, 0xA3, 0xF6, 0xCA, 0xAD, 0x52,
   0xD0, 0x3F, 0x54, 0xA7, 0x33, 0xA9, 0x09, 0x6A,
   0x89, 0x7E, 0x75, 0xA8, 0xD6, 0x79, 0x9F, 0xAB,
   0x8E, 0x11, 0x0E, 0x3B, 0xAA, 0xE6, 0x85, 0x53,
   0x0A, 0x59, 0xEC, 0x94, 0xD7, 0x41, 0x86, 0x7D,
   0x2F, 0xC7, 0xDE, 0x06, 0xCB, 0x13, 0xBA, 0x58,
   0xC8, 0xC9, 0x07, 0x67, 0x7F, 0xA5, 0xB4, 0x2C,
   0x48, 0x6C, 0xB8, 0xD1, 0x30, 0xD3, 0x35, 0x4F,
   0x88, 0x26, 0x93, 0x32, 0x71, 0x3E, 0x3D, 0xF7,
   0x6D, 0x03, 0xED, 0x8A, 0x36, 0x55, 0x9B, 0x66,
   0x8D, 0x27, 0x7C, 0xF9, 0xA6, 0xC3, 0x20, 0x69,
   0x4A, 0xE3, 0x99, 0x5C, 0xBC, 0x45, 0x16, 0x6B,
   0xB9, 0x49, 0x82, 0xFF, 0xBD, 0xDD, 0xE9, 0x0C,
   0xD4, 0x44, 0xFD, 0x22, 0xE5, 0xAC, 0x61, 0xC4,
   0x90, 0x47, 0x37, 0x72, 0xA4, 0x7A, 0x24, 0x4D,
   0x5B, 0x12, 0x38, 0x92, 0x87, 0x1B, 0xE1, 0xA0,
   0x91, 0x3C, 0xEE, 0x6F, 0xC1, 0x0F, 0x56, 0xC2,
   0x9A, 0xF8, 0x18, 0xE8, 0xD2, 0xDC, 0x4B, 0xCF,
   0x39, 0xF5, 0xFE, 0x2A, 0x2D, 0x9D, 0xA1, 0xFA,
   0xE7, 0xBF, 0x6E, 0xE4, 0x2E, 0xB3, 0xCD, 0xE2,
   0xAF, 0x7B, 0xC0, 0x68, 0x97, 0xB5, 0x5D, 0xB7,
   0x21, 0x57, 0x83, 0x76, 0xB1, 0xAE, 0x5E, 0x0D,
   0x96, 0x4E, 0x08, 0xC6, 0x0B, 0xDF, 0x3A, 0xB0,
   0x00, 0x63, 0xD9, 0xBE, 0xF2, 0x60, 0x25, 0x62 };

unsigned char table_136[256] = {
   0xD3, 0x1A, 0x00, 0xED, 0x59, 0x24, 0xA3, 0xF2,
   0xBA, 0x58, 0x4C, 0x5C, 0x75, 0x48, 0x98, 0xB0,
   0xCF, 0xC3, 0xF7, 0x88, 0x70, 0xB3, 0x3D, 0x3E,
   0x03, 0xF9, 0xC9, 0xFD, 0x80, 0x44, 0x7F, 0x3B,
   0x95, 0x5F, 0x31, 0x47, 0x15, 0x07, 0xB8, 0x08,
   0xCE, 0xDA, 0x71, 0x9F, 0x83, 0xB1, 0x55, 0x16,
   0xE6, 0xB2, 0xC7, 0xBE, 0x54, 0xE7, 0x2E, 0x8D,
   0x12, 0x21, 0x41, 0x69, 0xFE, 0x28, 0x11, 0x56,
   0x5A, 0xDD, 0xB6, 0x87, 0x78, 0x82, 0x4D, 0x7B,
   0x50, 0x9A, 0x9E, 0x62, 0xF8, 0x0A, 0x64, 0xF1,
   0x4E, 0x33, 0xAD, 0xBB, 0x79, 0x76, 0xD8, 0xCD,
   0x86, 0x34, 0x29, 0xD5, 0x7D, 0x72, 0xC5, 0xC1,
   0xDF, 0x09, 0x4A, 0xB4, 0xD2, 0x7A, 0xF0, 0xCC,
   0x0F, 0xA7, 0xD6, 0x2B, 0x20, 0x26, 0xEF, 0xAB,
   0x74, 0x1E, 0xE3, 0x77, 0xCB, 0x7C, 0x73, 0x5E,
   0x6B, 0x0D, 0x65, 0xA6, 0x30, 0xFB, 0xD0, 0xB7,
   0xAA, 0x94, 0x9D, 0x85, 0x13, 0x18, 0xA8, 0xF3,
   0xE0, 0xBC, 0x45, 0xCA, 0xC8, 0xDC, 0xE2, 0x3C,
   0x23, 0xE5, 0xB9, 0x90, 0x49, 0xA5, 0xE4, 0x36,
   0xFC, 0x53, 0xF6, 0xE8, 0xC6, 0x2C, 0x02, 0x25,
   0xC0, 0x8F, 0x61, 0xA4, 0x39, 0x8C, 0x5D, 0xAE,
   0x22, 0x1C, 0x2F, 0xD4, 0x6C, 0xD1, 0x51, 0xEA,
   0x4F, 0x7E, 0xA0, 0xF5, 0x6A, 0x32, 0xA2, 0x01,
   0xB5, 0x10, 0x2A, 0xAC, 0xA9, 0x06, 0xC4, 0x91,
   0x68, 0xE1, 0xBD, 0x14, 0x38, 0xFA, 0x6E, 0x3F,
   0x37, 0x66, 0xDB, 0x57, 0x43, 0x1B, 0x67, 0xAF,
   0x1F, 0x0B, 0x6D, 0x2D, 0x89, 0x04, 0x4B, 0x52,
   0xC2, 0xBF, 0xA1, 0x92, 0x99, 0x6F, 0x63, 0x81,
   0x27, 0x05, 0x96, 0x3A, 0xEC, 0x0E, 0x97, 0xD9,
   0xDE, 0x46, 0x35, 0x8B, 0x8E, 0x8A, 0xF4, 0xFF,
   0x60, 0xD7, 0xE9, 0x17, 0xEB, 0x9C, 0x84, 0x0C,
   0x93, 0x1D, 0x9B, 0x5B, 0x40, 0xEE, 0x42, 0x19 };

unsigned char table_137[32] = {
   0x0F, 0x09, 0x02, 0x06, 0x18, 0x0B, 0x1E, 0x05,
   0x11, 0x1D, 0x16, 0x01, 0x13, 0x10, 0x0E, 0x1A,
   0x1B, 0x00, 0x0D, 0x08, 0x15, 0x14, 0x19, 0x17,
   0x03, 0x1F, 0x0A, 0x12, 0x0C, 0x07, 0x04, 0x1C };

unsigned char table_138[32] = {
   0x0D, 0x1C, 0x1F, 0x15, 0x0F, 0x14, 0x1B, 0x12,
   0x09, 0x0B, 0x19, 0x07, 0x11, 0x16, 0x0C, 0x04,
   0x13, 0x05, 0x1D, 0x03, 0x0E, 0x0A, 0x08, 0x1E,
   0x01, 0x06, 0x18, 0x17, 0x10, 0x1A, 0x02, 0x00 };

unsigned char table_139[32] = {
   0x05, 0x15, 0x1D, 0x02, 0x0F, 0x03, 0x17, 0x1A,
   0x0A, 0x00, 0x1F, 0x12, 0x0E, 0x11, 0x1B, 0x13,
   0x0B, 0x0D, 0x09, 0x18, 0x1E, 0x08, 0x14, 0x07,
   0x0C, 0x04, 0x16, 0x19, 0x1C, 0x06, 0x10, 0x01 };

unsigned char table_140[32] = {
   0x06, 0x1E, 0x0C, 0x11, 0x13, 0x08, 0x15, 0x01,
   0x1D, 0x03, 0x0F, 0x19, 0x18, 0x04, 0x00, 0x14,
   0x12, 0x1A, 0x0B, 0x0E, 0x02, 0x1B, 0x07, 0x05,
   0x1F, 0x17, 0x09, 0x0A, 0x0D, 0x16, 0x10, 0x1C };

unsigned char table_141[256] = {
   0xE1, 0x0A, 0x28, 0xCD, 0x8A, 0x1E, 0x26, 0x10,
   0xC0, 0x6F, 0x06, 0x2C, 0xF8, 0x51, 0x6C, 0x8F,
   0xA8, 0x8C, 0x41, 0xF4, 0xED, 0x36, 0xAC, 0x89,
   0xBD, 0x9D, 0x42, 0x50, 0x95, 0x07, 0x2A, 0x9B,
   0x7E, 0xA3, 0x6B, 0x30, 0x72, 0x4E, 0xBE, 0xD8,
   0x8B, 0x5B, 0x1A, 0x56, 0x05, 0xEF, 0xEE, 0x64,
   0xFF, 0xFD, 0x93, 0xB5, 0xD6, 0x04, 0x57, 0xAE,
   0x4D, 0x6D, 0x2F, 0xBA, 0x40, 0xE0, 0xDB, 0xF2,
   0xCC, 0x08, 0x35, 0x02, 0xC4, 0x65, 0x66, 0x76,
   0xA1, 0x97, 0x9F, 0x6A, 0x90, 0xA7, 0x34, 0x1B,
   0x18, 0xB9, 0xA2, 0xDE, 0x23, 0x1F, 0xCB, 0xE6,
   0xAB, 0xCF, 0xAD, 0x4A, 0xF7, 0x24, 0xD0, 0xE8,
   0x8D, 0x49, 0xEA, 0x0F, 0x94, 0x22, 0xD3, 0x74,
   0x71, 0x0D, 0x21, 0x14, 0x39, 0x4B, 0x16, 0x25,
   0x5A, 0xB7, 0x17, 0x67, 0x59, 0x47, 0x27, 0x4F,
   0x32, 0x3B, 0x63, 0x0C, 0xF0, 0xF3, 0x7B, 0xC7,
   0xCA, 0x3A, 0x9A, 0xE2, 0xD5, 0xFA, 0x91, 0xFC,
   0x86, 0x81, 0x99, 0xB4, 0xBC, 0x7C, 0xC5, 0xBF,
   0xC1, 0xF5, 0x77, 0xA4, 0x79, 0x11, 0x8E, 0x75,
   0x55, 0x3D, 0x78, 0x20, 0x37, 0x3E, 0x85, 0xE4,
   0x2E, 0x82, 0xA9, 0x7A, 0x31, 0xC9, 0xB3, 0xFE,
   0x4C, 0x7D, 0xC3, 0xA0, 0x0E, 0x96, 0x5C, 0xC6,
   0x1C, 0x5F, 0xD7, 0xDD, 0x83, 0xC8, 0x9E, 0xEC,
   0x3F, 0xAF, 0x38, 0x9C, 0xD9, 0xB6, 0xDA, 0xD4,
   0x61, 0x44, 0x43, 0xAA, 0xB1, 0xCE, 0xE7, 0x84,
   0x00, 0x0B, 0xFB, 0x68, 0xC2, 0x3C, 0x58, 0xB2,
   0x69, 0x7F, 0x33, 0x2B, 0x80, 0x03, 0xE9, 0x88,
   0x29, 0x12, 0x01, 0x6E, 0x62, 0xF1, 0xA6, 0xF9,
   0x5D, 0xD2, 0xE3, 0x53, 0x09, 0x2D, 0xBB, 0x15,
   0xEB, 0x13, 0xA5, 0xF6, 0x73, 0x19, 0x60, 0xB0,
   0xD1, 0x48, 0x92, 0x1D, 0x52, 0x5E, 0x45, 0x70,
   0x98, 0x54, 0xB8, 0xDC, 0x46, 0xDF, 0x87, 0xE5 };

unsigned char table_142[256] = {
   0x90, 0x94, 0xBE, 0x14, 0x99, 0xEB, 0x45, 0x0F,
   0x34, 0x4A, 0xE3, 0x79, 0xD2, 0x64, 0x4D, 0x69,
   0x91, 0xDE, 0xB9, 0x1C, 0x59, 0x20, 0x6C, 0x0B,
   0x16, 0xC7, 0x1D, 0x18, 0x02, 0x7D, 0x13, 0xB2,
   0x7B, 0x81, 0xCF, 0x61, 0xA3, 0x33, 0x00, 0x73,
   0x5A, 0x8A, 0xA1, 0xA8, 0x31, 0xAC, 0xF0, 0x67,
   0xAE, 0xA5, 0x2A, 0x96, 0x58, 0xF4, 0xB7, 0x0E,
   0xE1, 0x54, 0x27, 0x83, 0x09, 0x85, 0xF8, 0x84,
   0xEA, 0xAD, 0x06, 0xED, 0x43, 0xFF, 0xA2, 0x6E,
   0x68, 0x46, 0x74, 0x47, 0x3C, 0xAA, 0xBC, 0x55,
   0xA7, 0xC3, 0x82, 0xDC, 0xBF, 0x38, 0x80, 0x15,
   0xF6, 0xB3, 0x92, 0x7C, 0x93, 0x3F, 0xE9, 0x4C,
   0x35, 0x30, 0x32, 0xF3, 0x88, 0xC0, 0x49, 0x6D,
   0xCE, 0x42, 0xDF, 0xFD, 0x78, 0x6A, 0x24, 0xCA,
   0xB8, 0xFC, 0xA6, 0x5F, 0x29, 0xFE, 0x0C, 0x5C,
   0x0D, 0x23, 0x8B, 0x9D, 0xD4, 0x03, 0x2C, 0x9C,
   0x77, 0xD8, 0x39, 0x8C, 0x57, 0xD5, 0xE0, 0x8F,
   0xC6, 0xB0, 0xCD, 0x48, 0xC9, 0xA0, 0xDA, 0xC8,
   0xD1, 0x5B, 0xAB, 0x37, 0x5D, 0x63, 0xAF, 0xF9,
   0x17, 0x1B, 0xE5, 0xF1, 0x36, 0xC1, 0x04, 0x26,
   0x6F, 0x9E, 0xD9, 0x2F, 0x7F, 0xB5, 0x3A, 0xD6,
   0xE6, 0x40, 0x07, 0xCB, 0x7E, 0x3E, 0xC5, 0x22,
   0xEC, 0xE2, 0xD3, 0x4E, 0x65, 0x2D, 0x70, 0xE7,
   0x10, 0x19, 0xD0, 0xEF, 0xBD, 0xC2, 0x44, 0xB4,
   0xF7, 0xA4, 0x53, 0x9F, 0x86, 0xFA, 0xE8, 0x4B,
   0x28, 0x3D, 0x9B, 0x56, 0x89, 0x6B, 0x25, 0x71,
   0x60, 0x11, 0x9A, 0x5E, 0x1A, 0x52, 0x08, 0x4F,
   0xB1, 0xDD, 0xBB, 0x98, 0xFB, 0x12, 0x3B, 0x0A,
   0x2E, 0xDB, 0x62, 0x8D, 0xC4, 0x75, 0xA9, 0x2B,
   0xE4, 0x97, 0x72, 0xF5, 0xEE, 0xF2, 0xB6, 0x21,
   0xBA, 0x7A, 0x76, 0x41, 0x50, 0x66, 0x05, 0x8E,
   0xCC, 0x1E, 0x87, 0xD7, 0x01, 0x1F, 0x51, 0x95 };

unsigned char table_143[32] = {
   0x0E, 0x16, 0x18, 0x11, 0x0C, 0x01, 0x12, 0x1F,
   0x08, 0x15, 0x0A, 0x06, 0x1C, 0x1E, 0x02, 0x1A,
   0x17, 0x03, 0x07, 0x13, 0x05, 0x19, 0x10, 0x0F,
   0x0D, 0x14, 0x09, 0x0B, 0x1B, 0x00, 0x1D, 0x04 };

unsigned char table_144[32] = {
   0x00, 0x1B, 0x17, 0x19, 0x1D, 0x11, 0x0D, 0x1A,
   0x13, 0x03, 0x1E, 0x09, 0x10, 0x0E, 0x15, 0x05,
   0x0B, 0x1C, 0x1F, 0x08, 0x0A, 0x06, 0x01, 0x0F,
   0x16, 0x14, 0x02, 0x04, 0x07, 0x18, 0x12, 0x0C };

unsigned char table_145[256] = {
   0xF9, 0x2C, 0x38, 0x74, 0xDA, 0x65, 0x85, 0x0E,
   0xBA, 0x64, 0xDB, 0xE3, 0xB6, 0x8B, 0x0B, 0x5E,
   0x01, 0x0F, 0x12, 0x8C, 0xD4, 0xCC, 0xB1, 0x7B,
   0xE7, 0xBC, 0x2E, 0x87, 0x84, 0x3B, 0xF8, 0x4C,
   0x8E, 0x59, 0x2D, 0xAA, 0xCE, 0x28, 0x1B, 0xEE,
   0x7F, 0x5C, 0xFB, 0x62, 0x05, 0xD9, 0xDD, 0x9D,
   0x49, 0x66, 0x82, 0x71, 0xD2, 0xC7, 0xEB, 0xCF,
   0x5B, 0x41, 0x25, 0xC8, 0x6C, 0xFF, 0x78, 0x97,
   0x0C, 0xA2, 0x50, 0x7A, 0xAF, 0x2F, 0xB0, 0x7E,
   0xBB, 0x73, 0xA0, 0x9B, 0x09, 0xDE, 0x35, 0xE9,
   0x5A, 0x70, 0x56, 0xC5, 0x81, 0x19, 0x55, 0xAB,
   0xC1, 0xB4, 0x2A, 0x30, 0x54, 0x6F, 0x3E, 0x46,
   0x5D, 0x37, 0xF5, 0x57, 0x6B, 0x7C, 0x43, 0xE1,
   0x4A, 0x3F, 0xB2, 0x4B, 0x77, 0xB5, 0x44, 0xD6,
   0x91, 0x11, 0x72, 0xE8, 0xBE, 0xA5, 0xA8, 0xD3,
   0x9A, 0x17, 0x86, 0x88, 0x16, 0x3C, 0x36, 0xD8,
   0x6E, 0x07, 0x8D, 0x5F, 0xFA, 0xF1, 0x24, 0x7D,
   0x20, 0x60, 0x0D, 0x89, 0xC9, 0x29, 0xA7, 0x2B,
   0x4E, 0x10, 0x9F, 0xE5, 0x61, 0x32, 0x3A, 0xBF,
   0x93, 0xE6, 0xF3, 0x52, 0x80, 0xC4, 0x02, 0x22,
   0xA4, 0xBD, 0xF0, 0x48, 0x51, 0xF2, 0xD7, 0x33,
   0x00, 0x53, 0x98, 0xEC, 0x47, 0x39, 0xB9, 0x90,
   0x76, 0x4F, 0x68, 0x3D, 0x9C, 0x92, 0xD5, 0xB8,
   0xAE, 0xD0, 0xF4, 0x67, 0x58, 0xC0, 0x06, 0x08,
   0x14, 0x31, 0xDC, 0xA1, 0x15, 0xDF, 0xCA, 0xE2,
   0x23, 0xFE, 0xE4, 0x8F, 0x0A, 0xFC, 0x8A, 0xA3,
   0xC6, 0xCD, 0x6A, 0x75, 0xFD, 0x42, 0xB7, 0x79,
   0x96, 0x1D, 0x63, 0x18, 0xA9, 0x1C, 0x83, 0x6D,
   0xE0, 0x34, 0x04, 0xA6, 0x13, 0xAC, 0xD1, 0xF7,
   0x26, 0xC3, 0x1F, 0x27, 0x45, 0x95, 0xCB, 0x21,
   0xED, 0x1A, 0x9E, 0x99, 0xEA, 0x40, 0x94, 0x4D,
   0x69, 0xF6, 0xEF, 0xC2, 0xAD, 0x03, 0xB3, 0x1E };

unsigned char table_146[256] = {
   0x1C, 0xF5, 0x16, 0xD2, 0xCC, 0xDC, 0x1E, 0x29,
   0xE3, 0x17, 0x3B, 0x66, 0x6A, 0xF7, 0x03, 0xB2,
   0x92, 0x45, 0x4D, 0xD6, 0x0C, 0x5E, 0xE6, 0x01,
   0xDE, 0xCE, 0x83, 0xFA, 0x35, 0x02, 0x85, 0xC4,
   0x2E, 0x89, 0x8D, 0xE7, 0x30, 0x93, 0xDD, 0x70,
   0x80, 0xD9, 0x6D, 0x81, 0x07, 0x8E, 0xA9, 0xA6,
   0x5F, 0xC9, 0xF3, 0x9D, 0x65, 0xE8, 0x88, 0x0B,
   0x49, 0xAA, 0xB7, 0x6C, 0x11, 0xFC, 0x6F, 0xA3,
   0xF8, 0x52, 0x0E, 0xD4, 0x08, 0x25, 0x27, 0x33,
   0x2F, 0xF0, 0x2B, 0x47, 0xDA, 0x4C, 0x39, 0x54,
   0xB9, 0xC1, 0xEA, 0x7C, 0x44, 0xEB, 0x06, 0xE1,
   0x8C, 0x9B, 0x74, 0x42, 0x4F, 0x0A, 0x69, 0x2A,
   0x2D, 0xA1, 0x19, 0xD5, 0xC3, 0x87, 0x68, 0xFF,
   0xEC, 0xE4, 0x86, 0xCF, 0xF6, 0x79, 0x34, 0xA8,
   0x72, 0xF4, 0x8B, 0xAF, 0xA5, 0x00, 0xBA, 0x5C,
   0x23, 0xB8, 0xC8, 0x59, 0xBF, 0x6E, 0xCB, 0x20,
   0x1F, 0x53, 0x97, 0x4B, 0xD0, 0x55, 0x5B, 0xDF,
   0x8A, 0xED, 0x9A, 0x62, 0xC5, 0xD7, 0x18, 0x82,
   0xC7, 0x12, 0x15, 0x1B, 0xC0, 0x38, 0xCA, 0x26,
   0xDB, 0xAE, 0xF9, 0x90, 0x1A, 0xF2, 0x56, 0x32,
   0x21, 0x3C, 0x43, 0xEE, 0xA4, 0x13, 0x94, 0xA2,
   0x46, 0x77, 0xBC, 0xB6, 0x9C, 0x0D, 0xCD, 0x37,
   0x63, 0x60, 0x6B, 0x3A, 0x3E, 0xA7, 0xD8, 0xFE,
   0xFB, 0xEF, 0x67, 0xFD, 0xAD, 0xF1, 0x09, 0x1D,
   0xE9, 0x51, 0xB4, 0x95, 0x75, 0x0F, 0xB3, 0xD3,
   0xAB, 0x22, 0xBB, 0x61, 0x7F, 0x5A, 0x58, 0x7B,
   0x73, 0xC2, 0x05, 0xE0, 0x14, 0xE2, 0xAC, 0x91,
   0xBE, 0x4E, 0xC6, 0x7A, 0x84, 0x50, 0x28, 0x3F,
   0xB0, 0x04, 0x7E, 0xD1, 0x40, 0xBD, 0xE5, 0x71,
   0xB1, 0x78, 0x41, 0x9E, 0x57, 0x64, 0x8F, 0x24,
   0x4A, 0x9F, 0x3D, 0x31, 0x36, 0x5D, 0xA0, 0x2C,
   0x7D, 0x96, 0x76, 0x99, 0xB5, 0x48, 0x98, 0x10 };

unsigned char table_147[32] = {
   0x17, 0x07, 0x0D, 0x16, 0x00, 0x1B, 0x1F, 0x09,
   0x10, 0x11, 0x14, 0x0A, 0x02, 0x06, 0x13, 0x0C,
   0x08, 0x1E, 0x0F, 0x12, 0x05, 0x15, 0x19, 0x01,
   0x1C, 0x1A, 0x03, 0x18, 0x04, 0x0B, 0x1D, 0x0E };

unsigned char table_148[256] = {
   0xFB, 0x23, 0xBC, 0x5A, 0x8C, 0x02, 0x42, 0x3B,
   0x95, 0x0C, 0x21, 0x0E, 0x14, 0xDF, 0x11, 0xC0,
   0xDB, 0x5E, 0xD3, 0xEA, 0xCE, 0xB4, 0x32, 0x12,
   0x70, 0x68, 0xA3, 0x25, 0x5B, 0x4B, 0x47, 0xA5,
   0x84, 0x9B, 0xFA, 0xD1, 0xE1, 0x3C, 0x20, 0x93,
   0x41, 0x26, 0x81, 0x39, 0x17, 0xA4, 0xCF, 0xB9,
   0xC5, 0x5F, 0x1C, 0xB3, 0x88, 0xC2, 0x92, 0x30,
   0x0A, 0xB8, 0xA0, 0xE2, 0x50, 0x2B, 0x48, 0x1E,
   0xD5, 0x13, 0xC7, 0x46, 0x9E, 0x2A, 0xF7, 0x7E,
   0xE8, 0x82, 0x60, 0x7A, 0x36, 0x97, 0x0F, 0x8F,
   0x8B, 0x80, 0xE0, 0xEB, 0xB1, 0xC6, 0x6E, 0xAE,
   0x90, 0x76, 0xA7, 0x31, 0xBE, 0x9C, 0x18, 0x6D,
   0xAB, 0x6C, 0x7B, 0xFE, 0x62, 0x05, 0xE9, 0x66,
   0x2E, 0x38, 0xB5, 0xB2, 0xFD, 0xFC, 0x7F, 0xE3,
   0xA1, 0xF1, 0x99, 0x4D, 0x79, 0x22, 0xD2, 0x37,
   0x29, 0x01, 0x54, 0x00, 0xBD, 0x51, 0x1B, 0x07,
   0x0B, 0x4A, 0xEE, 0x57, 0xDA, 0x1A, 0x06, 0xCA,
   0xCB, 0x9A, 0xC9, 0x7D, 0xE4, 0xDC, 0xE5, 0x8D,
   0x75, 0x4F, 0xF6, 0xA2, 0x65, 0x7C, 0xD9, 0x9D,
   0x03, 0x27, 0x2D, 0x4C, 0x49, 0xD4, 0x5D, 0x3E,
   0xBA, 0x1D, 0xD8, 0x91, 0x74, 0x10, 0xF8, 0xDE,
   0xEF, 0xF0, 0x6A, 0x04, 0x72, 0x08, 0x78, 0x3A,
   0x53, 0xC4, 0x34, 0xF2, 0x64, 0xAF, 0x86, 0xC3,
   0xF3, 0x73, 0x67, 0xCC, 0x58, 0xF4, 0x96, 0xAC,
   0x3D, 0xE7, 0x15, 0x8E, 0x19, 0x61, 0xF9, 0xB6,
   0xCD, 0x87, 0xAA, 0xB0, 0x1F, 0x6F, 0xAD, 0x28,
   0xC8, 0x69, 0x56, 0xC1, 0x71, 0xED, 0xE6, 0x98,
   0x6B, 0x59, 0xB7, 0xF5, 0x2C, 0xEC, 0xA8, 0x94,
   0x89, 0xBB, 0xA9, 0xD7, 0x2F, 0x8A, 0x4E, 0xD6,
   0x33, 0x16, 0x0D, 0x83, 0x5C, 0x52, 0x85, 0xA6,
   0x40, 0x45, 0x9F, 0x44, 0x63, 0x35, 0x77, 0xFF,
   0x09, 0x43, 0xBF, 0xD0, 0x55, 0xDD, 0x3F, 0x24 };

unsigned char table_149[32] = {
   0x1B, 0x0B, 0x0C, 0x06, 0x1F, 0x17, 0x04, 0x1A,
   0x1E, 0x02, 0x0F, 0x16, 0x0E, 0x09, 0x10, 0x01,
   0x13, 0x19, 0x11, 0x00, 0x0A, 0x05, 0x03, 0x1C,
   0x18, 0x1D, 0x14, 0x0D, 0x07, 0x08, 0x15, 0x12 };

unsigned char table_150[256] = {
   0x57, 0xBC, 0x9D, 0x46, 0x14, 0xD0, 0x94, 0x95,
   0x1B, 0x12, 0xB8, 0xD4, 0x53, 0x73, 0x83, 0xE6,
   0x75, 0xE1, 0xD1, 0x0D, 0xDF, 0x23, 0x13, 0x40,
   0xF1, 0x0C, 0xA0, 0xC1, 0x22, 0xDA, 0xE8, 0xFB,
   0xE5, 0xC4, 0x16, 0x9C, 0x3F, 0xC3, 0x78, 0x3A,
   0x06, 0xC7, 0xA8, 0x79, 0xA4, 0xB3, 0x55, 0x88,
   0xA9, 0x82, 0xE3, 0x68, 0xFC, 0x3B, 0x26, 0x81,
   0xB4, 0x0A, 0x7D, 0x96, 0xDB, 0x2C, 0xE2, 0xCD,
   0x92, 0x5C, 0xED, 0x0E, 0x42, 0x98, 0xBE, 0xB7,
   0x63, 0x25, 0x7B, 0xD9, 0xEF, 0x11, 0xB9, 0xA3,
   0xFA, 0x00, 0x2A, 0x91, 0x71, 0xBF, 0xB2, 0x3D,
   0x20, 0x4C, 0xB0, 0x8C, 0x3C, 0x27, 0xAF, 0x09,
   0x10, 0x5D, 0x2B, 0x1D, 0xBD, 0x4B, 0x54, 0xD3,
   0xAB, 0x1A, 0xE7, 0xF8, 0x56, 0x65, 0xA5, 0xAD,
   0xEC, 0x17, 0x45, 0x28, 0xCA, 0xEA, 0x01, 0xF5,
   0x34, 0x84, 0x43, 0x8B, 0x03, 0x02, 0x90, 0x6B,
   0x60, 0xCE, 0x19, 0x86, 0x4F, 0x08, 0x35, 0x9A,
   0xAE, 0x07, 0xE0, 0xB6, 0xD6, 0x2D, 0xD2, 0x89,
   0x5F, 0xA6, 0x72, 0x05, 0x36, 0xB5, 0xC0, 0x5A,
   0x4D, 0xD7, 0x30, 0x37, 0x87, 0x50, 0xA2, 0x48,
   0x29, 0xAC, 0xDE, 0x93, 0x24, 0x6E, 0x1E, 0xF7,
   0x52, 0x5E, 0x41, 0xC8, 0xEB, 0x31, 0x7E, 0xE9,
   0x67, 0x7A, 0x47, 0x85, 0x8D, 0x74, 0x9E, 0x64,
   0x38, 0x9B, 0xBA, 0xCC, 0x9F, 0x8E, 0xEE, 0x0F,
   0xB1, 0x7C, 0x6A, 0xBB, 0x2E, 0x58, 0x70, 0x7F,
   0x4E, 0x4A, 0x1C, 0x5B, 0xF0, 0xA1, 0x61, 0xF6,
   0x15, 0x33, 0xE4, 0xF9, 0x2F, 0x62, 0x1F, 0x76,
   0x32, 0xCB, 0x49, 0xFE, 0x8F, 0xD5, 0xDC, 0x66,
   0x0B, 0x3E, 0xC5, 0x21, 0xC6, 0x6C, 0x18, 0xC2,
   0x6D, 0xFF, 0x51, 0x99, 0xCF, 0xFD, 0x59, 0xA7,
   0xAA, 0x8A, 0xF2, 0x69, 0x39, 0x6F, 0x77, 0xDD,
   0x97, 0xC9, 0xF3, 0x04, 0xD8, 0xF4, 0x80, 0x44 };

unsigned char table_151[256] = {
   0x78, 0x6C, 0xC5, 0x0C, 0x2D, 0xA7, 0x97, 0x9C,
   0x22, 0x76, 0x3E, 0x81, 0x51, 0x47, 0x59, 0x71,
   0xB1, 0xA2, 0x4A, 0x3C, 0xB5, 0x16, 0x06, 0x95,
   0xB9, 0x01, 0xE6, 0x91, 0x96, 0x1C, 0x1B, 0xAD,
   0x61, 0x64, 0xB2, 0xE7, 0x29, 0x19, 0x52, 0x3B,
   0xFA, 0xAF, 0x30, 0xDB, 0xD4, 0x0B, 0xFE, 0x75,
   0x1F, 0xBE, 0xCB, 0xF6, 0xEA, 0x31, 0xF8, 0xD8,
   0xA3, 0x82, 0x73, 0x1D, 0x99, 0xF0, 0xCC, 0xB6,
   0x46, 0x26, 0xAA, 0x8C, 0x87, 0x90, 0x24, 0x8F,
   0x7A, 0x13, 0xEE, 0xD1, 0xA9, 0x05, 0xB3, 0xF7,
   0x02, 0x7C, 0x4C, 0x1E, 0xFF, 0xE5, 0x77, 0xAB,
   0xD6, 0x98, 0x20, 0x4D, 0xC4, 0x23, 0xF4, 0xA4,
   0x85, 0x9A, 0x8E, 0x1A, 0x0E, 0xF5, 0x15, 0x60,
   0x38, 0x72, 0xE9, 0xF1, 0xC3, 0x68, 0xF2, 0x93,
   0xD3, 0x2A, 0x48, 0x74, 0xC2, 0x57, 0xA1, 0x7D,
   0x94, 0x37, 0x92, 0x5C, 0xE1, 0x41, 0x83, 0xD5,
   0x65, 0x14, 0xA6, 0xDC, 0x44, 0x27, 0xEF, 0xD7,
   0x25, 0x10, 0x2C, 0x7F, 0x40, 0xA5, 0x55, 0xBD,
   0x2B, 0x0D, 0xD0, 0xFC, 0xDF, 0xA0, 0x04, 0x00,
   0x62, 0xB4, 0x5A, 0xEB, 0x6B, 0x84, 0x7E, 0x6A,
   0xDE, 0xED, 0x66, 0x03, 0xFB, 0x2E, 0x4F, 0x4E,
   0xBB, 0x36, 0x5B, 0x18, 0xE3, 0x69, 0x3F, 0xEC,
   0xE4, 0xD2, 0x0A, 0x34, 0x63, 0xCF, 0xA8, 0xF9,
   0x9B, 0x7B, 0x6F, 0xE8, 0x49, 0xC1, 0x09, 0x54,
   0xF3, 0x50, 0x67, 0x79, 0xC0, 0x9F, 0x8D, 0x5F,
   0x17, 0x70, 0x11, 0xC8, 0xBC, 0xC6, 0xE0, 0x35,
   0x39, 0xC7, 0x6E, 0x21, 0xBF, 0xDA, 0x6D, 0x28,
   0x0F, 0xDD, 0x33, 0xAC, 0x8A, 0x12, 0xC9, 0xCD,
   0xB8, 0x45, 0xAE, 0x32, 0xCE, 0xE2, 0x56, 0xFD,
   0x42, 0x89, 0x86, 0xCA, 0x4B, 0x3D, 0x5E, 0xBA,
   0x8B, 0x5D, 0xB0, 0xB7, 0xD9, 0x58, 0x2F, 0x08,
   0x43, 0x3A, 0x53, 0x9E, 0x80, 0x88, 0x07, 0x9D };

unsigned char table_152[32] = {
   0x02, 0x1A, 0x17, 0x1D, 0x01, 0x03, 0x13, 0x1E,
   0x05, 0x18, 0x06, 0x0A, 0x0C, 0x04, 0x1B, 0x00,
   0x1C, 0x09, 0x1F, 0x16, 0x07, 0x0F, 0x0B, 0x0E,
   0x14, 0x12, 0x0D, 0x10, 0x19, 0x11, 0x08, 0x15 };

unsigned char table_153[32] = {
   0x0E, 0x14, 0x12, 0x1E, 0x1C, 0x02, 0x06, 0x16,
   0x18, 0x0D, 0x17, 0x0C, 0x1D, 0x11, 0x08, 0x19,
   0x07, 0x0F, 0x13, 0x04, 0x03, 0x1B, 0x0B, 0x1F,
   0x1A, 0x0A, 0x05, 0x10, 0x00, 0x01, 0x15, 0x09 };

unsigned char table_154[256] = {
   0x27, 0x5A, 0x08, 0x5B, 0xF4, 0x39, 0x13, 0x6F,
   0x67, 0xEA, 0x22, 0xCA, 0x5C, 0xCF, 0x18, 0x7C,
   0x05, 0x87, 0x60, 0xCC, 0x40, 0xC6, 0xE8, 0x6D,
   0xF5, 0x2A, 0x2D, 0xA2, 0x8C, 0x82, 0xE9, 0xDC,
   0xD6, 0x65, 0x74, 0x8E, 0x42, 0x4F, 0x3E, 0x55,
   0xFF, 0xC7, 0x9D, 0x0F, 0x81, 0xE2, 0x4C, 0xE6,
   0xEB, 0x4D, 0x70, 0xD1, 0x49, 0x43, 0x3D, 0x69,
   0x0C, 0x45, 0x28, 0x00, 0x99, 0xAE, 0xEC, 0xB8,
   0xC3, 0x17, 0x93, 0x8D, 0x36, 0x3C, 0x46, 0x2B,
   0x29, 0xC5, 0xB4, 0xB1, 0xD0, 0x0D, 0xAD, 0xFE,
   0xE5, 0xA8, 0x3B, 0x1A, 0x2C, 0xDF, 0x07, 0x86,
   0xB0, 0xD3, 0x7A, 0x59, 0x79, 0x8B, 0xC1, 0x9A,
   0x30, 0xDB, 0x24, 0xF3, 0xD8, 0x04, 0x25, 0xC2,
   0xA3, 0x98, 0x96, 0x7B, 0x71, 0x4E, 0x5E, 0x58,
   0xA5, 0x51, 0x88, 0xDA, 0xF8, 0xC0, 0x7D, 0xF6,
   0x31, 0x5F, 0x09, 0x16, 0x21, 0x62, 0x01, 0x64,
   0x9B, 0x3A, 0x2F, 0x61, 0x19, 0xA1, 0xB7, 0xE0,
   0xB9, 0x12, 0xA0, 0xBA, 0x6E, 0x8A, 0xFB, 0xD9,
   0x38, 0x1B, 0xD5, 0xB3, 0x10, 0xED, 0xE4, 0x6A,
   0x32, 0xBD, 0x75, 0xD4, 0x1C, 0xFD, 0x73, 0x77,
   0x54, 0xC8, 0x97, 0x47, 0x35, 0x94, 0xE3, 0xCD,
   0x6B, 0xBB, 0xF9, 0xAC, 0x11, 0x14, 0xAF, 0x78,
   0x3F, 0xCE, 0x26, 0x44, 0xEE, 0xFC, 0x15, 0x66,
   0x4B, 0xA6, 0x20, 0x23, 0xBE, 0x84, 0x1D, 0x7E,
   0x0B, 0x56, 0x92, 0x0A, 0xFA, 0xF7, 0x48, 0x33,
   0x9E, 0x8F, 0xAB, 0x5D, 0x41, 0x50, 0xA4, 0x7F,
   0x80, 0x4A, 0x68, 0x06, 0x2E, 0x6C, 0xC4, 0x02,
   0x0E, 0x63, 0xF0, 0xC9, 0x91, 0xB2, 0xD2, 0x03,
   0x37, 0xEF, 0x9C, 0x90, 0x83, 0x76, 0x1E, 0xA9,
   0x85, 0xB6, 0x57, 0xD7, 0xF2, 0xF1, 0xE7, 0xDE,
   0xCB, 0xAA, 0xBF, 0x89, 0x1F, 0xA7, 0xBC, 0x9F,
   0x53, 0xE1, 0xDD, 0x72, 0x95, 0x52, 0x34, 0xB5 };

unsigned char table_155[256] = {
   0x75, 0x58, 0xC5, 0xA5, 0x83, 0x16, 0xF3, 0x7F,
   0x94, 0xDE, 0xA0, 0xF6, 0xFD, 0x89, 0xA8, 0x06,
   0x98, 0x01, 0xD9, 0x69, 0xB7, 0x0F, 0xEA, 0x73,
   0x32, 0xF0, 0x49, 0xBF, 0x02, 0xE7, 0x22, 0x3F,
   0xDB, 0x30, 0x5F, 0x20, 0x6A, 0x93, 0x07, 0xBC,
   0x09, 0x0D, 0x37, 0x24, 0x90, 0x15, 0x80, 0xAF,
   0x8F, 0x59, 0x28, 0xFF, 0x6D, 0x1E, 0x52, 0x62,
   0xE2, 0xDD, 0x85, 0x48, 0xB5, 0xAB, 0x68, 0xAC,
   0x7E, 0x26, 0x2C, 0xF9, 0x2A, 0xBE, 0x5B, 0xCE,
   0x87, 0x1D, 0x96, 0xBD, 0xEF, 0x29, 0xA9, 0xC3,
   0x9D, 0x57, 0x79, 0x6B, 0x7A, 0x82, 0x78, 0x0A,
   0x91, 0xF2, 0x7C, 0xC2, 0x25, 0x88, 0xE3, 0x47,
   0x64, 0x46, 0x8D, 0x19, 0xF4, 0xE6, 0xF1, 0x53,
   0x9C, 0x54, 0x23, 0xAD, 0xA3, 0x86, 0x3A, 0x04,
   0x67, 0x1C, 0xF5, 0x43, 0x05, 0x42, 0xD6, 0x4B,
   0xFB, 0xD4, 0x2B, 0x08, 0x45, 0xD8, 0xCD, 0xEB,
   0x31, 0x4A, 0x5A, 0x34, 0x9B, 0xEC, 0x4D, 0xB4,
   0xC6, 0xFE, 0xD5, 0x5E, 0xC1, 0x39, 0x81, 0xCF,
   0x03, 0x6E, 0x95, 0x50, 0xA1, 0x3B, 0xB3, 0xE5,
   0x3D, 0xB1, 0xB2, 0x41, 0x17, 0x2F, 0x2E, 0xE4,
   0x1F, 0xDC, 0xB0, 0xB6, 0x18, 0x6F, 0x44, 0x12,
   0x0B, 0xCC, 0x4E, 0xC0, 0x51, 0x14, 0x76, 0x3C,
   0xB9, 0x9F, 0xA4, 0xD3, 0xA7, 0xE8, 0x13, 0x55,
   0xC8, 0x8C, 0xD2, 0xEE, 0x65, 0xB8, 0xAA, 0x6C,
   0x2D, 0x4F, 0x56, 0xFA, 0x61, 0x4C, 0xE0, 0x5C,
   0xA6, 0x1A, 0xD1, 0x38, 0xD7, 0x72, 0x60, 0x74,
   0xE1, 0xBA, 0x84, 0x3E, 0x40, 0xF8, 0xC7, 0x36,
   0x27, 0x0C, 0x70, 0x97, 0x9A, 0x7D, 0x35, 0x71,
   0xCA, 0x1B, 0x99, 0x8E, 0xAE, 0x66, 0x63, 0xE9,
   0xC9, 0x11, 0x8A, 0x21, 0x92, 0x5D, 0x77, 0x10,
   0xD0, 0xC4, 0xF7, 0x7B, 0x9E, 0xCB, 0xED, 0x0E,
   0x8B, 0x33, 0xFC, 0xBB, 0x00, 0xA2, 0xDF, 0xDA };

unsigned char table_156[256] = {
   0x31, 0x25, 0xB1, 0xD3, 0xAF, 0xAE, 0x84, 0x2C,
   0x71, 0x5E, 0xD8, 0x80, 0x6F, 0x3E, 0x48, 0x86,
   0xED, 0x54, 0x6A, 0xC3, 0xBC, 0xBF, 0x0E, 0xEA,
   0x10, 0xA2, 0x9D, 0x91, 0x32, 0xE2, 0x7E, 0x1B,
   0x49, 0x27, 0xFF, 0xDD, 0x8A, 0x2F, 0x8D, 0x38,
   0xFA, 0x3C, 0x03, 0x14, 0x0F, 0x89, 0xCC, 0x07,
   0x1A, 0xA0, 0x97, 0x37, 0xA6, 0xD6, 0x63, 0x87,
   0xA1, 0xC2, 0x4B, 0x39, 0xCB, 0xCF, 0x69, 0x4E,
   0xC9, 0x28, 0x1C, 0xBB, 0x42, 0x2B, 0xA9, 0x78,
   0x5B, 0xF6, 0xE0, 0xD0, 0x5F, 0x46, 0x98, 0xCE,
   0x1F, 0x7A, 0x34, 0x8B, 0xFD, 0x9B, 0xEF, 0x74,
   0x05, 0xF2, 0x02, 0xC6, 0xDF, 0x73, 0x5C, 0x8E,
   0xDE, 0x88, 0x57, 0x3B, 0x85, 0xBD, 0xC0, 0x3A,
   0x45, 0x4D, 0x2D, 0x72, 0x0C, 0x60, 0xCA, 0x5D,
   0x06, 0x04, 0x3D, 0x51, 0x15, 0xAD, 0xE8, 0x67,
   0xBA, 0x43, 0x7D, 0xF8, 0xB2, 0xE6, 0xAB, 0xF4,
   0x23, 0x6E, 0xF0, 0x6B, 0x0B, 0x2E, 0xC8, 0xC4,
   0x4F, 0xA8, 0x6D, 0x26, 0xE9, 0x9C, 0x22, 0xB7,
   0x00, 0xB3, 0x0A, 0x7C, 0x44, 0x55, 0x75, 0xD5,
   0xAA, 0x66, 0x56, 0x24, 0x83, 0x90, 0xA4, 0xF5,
   0xCD, 0xEC, 0x18, 0xDC, 0xFE, 0x96, 0xA3, 0xF7,
   0xD2, 0xFB, 0xD1, 0x65, 0xC5, 0x08, 0x7B, 0x70,
   0x16, 0x9A, 0x20, 0x09, 0x29, 0xDA, 0x52, 0x5A,
   0x59, 0xB4, 0x77, 0x62, 0x9E, 0x19, 0x7F, 0x82,
   0x4C, 0xB6, 0x0D, 0x58, 0xEE, 0x1D, 0xB9, 0x93,
   0x50, 0xD9, 0x30, 0xE4, 0x13, 0x01, 0x36, 0x8F,
   0x53, 0x3F, 0x64, 0xA5, 0xB5, 0xD7, 0x81, 0x41,
   0x17, 0xE5, 0x94, 0xE3, 0xF9, 0x61, 0x76, 0xE1,
   0x9F, 0xFC, 0x1E, 0x12, 0xDB, 0x21, 0x79, 0x2A,
   0xAC, 0xF3, 0x6C, 0xC1, 0x95, 0x92, 0xEB, 0xA7,
   0x11, 0xC7, 0xB8, 0x4A, 0x33, 0xB0, 0x99, 0xE7,
   0xF1, 0x68, 0xBE, 0x35, 0x40, 0x8C, 0xD4, 0x47 };

unsigned char table_157[32] = {
   0x00, 0x0D, 0x03, 0x02, 0x11, 0x04, 0x18, 0x0B,
   0x14, 0x1D, 0x1C, 0x13, 0x1B, 0x17, 0x10, 0x15,
   0x01, 0x19, 0x07, 0x09, 0x1A, 0x16, 0x12, 0x1E,
   0x08, 0x06, 0x0C, 0x0E, 0x1F, 0x0F, 0x0A, 0x05 };

unsigned char table_158[256] = {
   0x68, 0x26, 0x80, 0x0B, 0xB8, 0xD5, 0x8C, 0xB7,
   0x65, 0xEF, 0xBC, 0x94, 0x28, 0xB9, 0xB2, 0xD2,
   0x92, 0xA4, 0x55, 0x27, 0xE0, 0x40, 0x6C, 0x41,
   0x25, 0xBD, 0xAF, 0xEA, 0xB1, 0x19, 0xA5, 0xC9,
   0x0E, 0xED, 0xB4, 0xF9, 0x8B, 0x6A, 0xAE, 0xD8,
   0x64, 0x83, 0xC1, 0xD3, 0x04, 0xF4, 0xFA, 0xC3,
   0x46, 0x2C, 0xA8, 0xBB, 0x3A, 0x47, 0x33, 0x8F,
   0x52, 0x86, 0x08, 0x9D, 0x1D, 0x59, 0x8E, 0x91,
   0x32, 0xCF, 0x6B, 0x75, 0xB0, 0x7F, 0xC7, 0x24,
   0x05, 0x6F, 0x00, 0x1C, 0x2D, 0xAC, 0xDA, 0x45,
   0x73, 0xB3, 0x3E, 0xD6, 0x54, 0x61, 0x03, 0x77,
   0xF8, 0xD9, 0xE2, 0x4B, 0xFF, 0xF2, 0x0C, 0x4F,
   0x93, 0x71, 0xA7, 0x3D, 0x66, 0x88, 0x98, 0xF1,
   0xB6, 0x7A, 0x2B, 0xCD, 0x44, 0x3C, 0x37, 0x5A,
   0x96, 0x23, 0x9F, 0xBF, 0x7D, 0x5E, 0x2A, 0x35,
   0x72, 0x79, 0xE1, 0xA3, 0x84, 0x99, 0x38, 0x49,
   0xC8, 0xDB, 0x30, 0xDC, 0xAD, 0x3F, 0xF6, 0x09,
   0x69, 0x95, 0xE5, 0x67, 0xA1, 0xFD, 0xF7, 0x1B,
   0xEC, 0x17, 0xD4, 0xEB, 0x29, 0x36, 0x3B, 0x15,
   0xDE, 0x2E, 0xC5, 0x70, 0x6D, 0x53, 0x56, 0xAB,
   0xC0, 0x43, 0xC2, 0xE7, 0x31, 0xE6, 0xA6, 0x78,
   0x5C, 0x7C, 0x48, 0x10, 0x87, 0xCC, 0x9E, 0x7E,
   0x5F, 0xE9, 0x07, 0x5B, 0xF5, 0xEE, 0xB5, 0xCA,
   0x62, 0x18, 0xBE, 0x20, 0x16, 0xDF, 0x13, 0x4E,
   0x7B, 0x02, 0x11, 0x4C, 0x51, 0x85, 0x0D, 0x22,
   0xF3, 0x14, 0x63, 0x76, 0xD0, 0x0F, 0xE4, 0xCB,
   0xCE, 0xA0, 0x82, 0xE3, 0x01, 0xAA, 0x5D, 0x4A,
   0x4D, 0xFB, 0x39, 0x8A, 0x2F, 0xDD, 0xE8, 0x06,
   0x1A, 0x90, 0x81, 0x50, 0x8D, 0x89, 0x97, 0x1E,
   0xFC, 0x60, 0x12, 0x42, 0x9C, 0xF0, 0x34, 0xD7,
   0xD1, 0x1F, 0x0A, 0x21, 0xA9, 0x6E, 0xC4, 0xBA,
   0x9A, 0x57, 0xA2, 0x74, 0xC6, 0xFE, 0x9B, 0x58 };

unsigned char table_159[256] = {
   0xE5, 0xBF, 0x84, 0x56, 0xD6, 0x43, 0x3E, 0xA5,
   0x64, 0x87, 0x44, 0x63, 0x4A, 0x4C, 0x8D, 0x24,
   0x1C, 0xDA, 0x89, 0x52, 0x80, 0x4F, 0xE4, 0xBC,
   0xC5, 0xF4, 0x27, 0x75, 0x9C, 0xF0, 0xE1, 0x06,
   0x99, 0x48, 0xF2, 0x57, 0x34, 0x9A, 0xA8, 0x62,
   0xC9, 0xD5, 0x16, 0x6D, 0x55, 0xFA, 0x37, 0x5A,
   0x2A, 0xC6, 0x45, 0xDD, 0x1B, 0x76, 0x50, 0xE2,
   0x69, 0x41, 0x6C, 0xC4, 0x3C, 0x47, 0xA9, 0x92,
   0x00, 0x3D, 0x6F, 0xE7, 0x7A, 0x3A, 0x33, 0x53,
   0xF7, 0x03, 0xA7, 0xB1, 0x15, 0x78, 0x0B, 0x67,
   0x2E, 0x21, 0xF1, 0xD4, 0xB3, 0x98, 0x60, 0x58,
   0xBB, 0x82, 0x1E, 0x70, 0x0A, 0xA2, 0x02, 0x17,
   0xFF, 0x9F, 0xD2, 0xAF, 0xC7, 0xDC, 0x68, 0x83,
   0x42, 0xCA, 0x08, 0x39, 0x20, 0xEC, 0x77, 0x96,
   0x5B, 0xAD, 0x09, 0x6B, 0x40, 0xC2, 0x91, 0x51,
   0x10, 0xD9, 0xF9, 0xC1, 0xB5, 0xDF, 0xDB, 0xC0,
   0x7D, 0xAB, 0xAE, 0x54, 0x35, 0xF3, 0xA1, 0xE6,
   0xEA, 0x14, 0xBA, 0xFC, 0xE8, 0xEB, 0xF6, 0xBD,
   0x8C, 0x72, 0x1F, 0xE9, 0xFB, 0x7C, 0xCF, 0x49,
   0xE3, 0xA3, 0x22, 0x9D, 0x46, 0x71, 0x94, 0x31,
   0x2D, 0x65, 0x2B, 0x32, 0x18, 0xB6, 0x90, 0xF8,
   0x11, 0x5F, 0xA0, 0xEF, 0xED, 0x1A, 0x25, 0x2C,
   0x3B, 0xFD, 0x2F, 0x73, 0xB9, 0x7E, 0xDE, 0xB4,
   0x97, 0x0F, 0x7F, 0x86, 0x93, 0x07, 0x19, 0xCE,
   0xE0, 0xB7, 0xEE, 0x26, 0xD1, 0x01, 0x59, 0x5C,
   0xC3, 0x79, 0x8B, 0xD3, 0x4B, 0x04, 0xD0, 0x29,
   0x0D, 0x3F, 0xB2, 0x30, 0xCC, 0x36, 0xFE, 0xB0,
   0xF5, 0x8E, 0xA6, 0x8A, 0xC8, 0xD8, 0x05, 0xB8,
   0x12, 0xBE, 0x81, 0x4D, 0x38, 0xAC, 0x1D, 0x9E,
   0x66, 0x5E, 0x7B, 0x6E, 0x0C, 0xCD, 0x6A, 0x88,
   0xAA, 0x0E, 0x61, 0x5D, 0x95, 0x4E, 0xD7, 0x74,
   0xCB, 0x9B, 0x13, 0x8F, 0xA4, 0x28, 0x23, 0x85 };

unsigned char table_160[256] = {
   0x35, 0x44, 0x0E, 0x92, 0x75, 0x83, 0x9D, 0x53,
   0xA5, 0x90, 0xF8, 0xF7, 0x54, 0x74, 0xDF, 0x3D,
   0x5A, 0xAA, 0xC6, 0x26, 0x7A, 0xFC, 0x79, 0x6C,
   0x56, 0xB3, 0x32, 0xE3, 0x1C, 0xF9, 0xDC, 0xE6,
   0xA2, 0x93, 0x71, 0xFF, 0x1D, 0xEB, 0xB2, 0x04,
   0x96, 0x46, 0x0C, 0x2B, 0x17, 0xEE, 0x28, 0x25,
   0xD9, 0xAE, 0x11, 0xA7, 0x40, 0x45, 0xFB, 0x80,
   0x18, 0xF1, 0xCB, 0x2E, 0x24, 0xF3, 0xEC, 0x4F,
   0xAB, 0xD7, 0xD4, 0xC4, 0xFD, 0x4B, 0xAD, 0xC9,
   0x4C, 0x08, 0xAC, 0xF4, 0xCD, 0xB7, 0xF2, 0x15,
   0x02, 0x2F, 0x16, 0x34, 0x65, 0x8A, 0x87, 0xCC,
   0x50, 0x0F, 0x9B, 0xC2, 0xC8, 0x7B, 0xEA, 0x8E,
   0xE4, 0xD6, 0x97, 0x30, 0xA8, 0xA0, 0x94, 0xC5,
   0xE8, 0x12, 0x27, 0xCE, 0x84, 0xDD, 0xB1, 0x47,
   0x7E, 0xE7, 0xE1, 0x3A, 0x37, 0x21, 0x2D, 0x3B,
   0x20, 0x60, 0x1E, 0x1B, 0x82, 0xBE, 0xA3, 0x70,
   0x98, 0xBF, 0xA6, 0x4D, 0x76, 0x86, 0x42, 0x9F,
   0xCF, 0xE0, 0x14, 0x4A, 0x0B, 0xB4, 0x36, 0xF5,
   0x85, 0xB8, 0xC0, 0x6A, 0xE9, 0x7D, 0xBD, 0x4E,
   0x8F, 0x51, 0x0D, 0x5B, 0x6B, 0x58, 0x5F, 0x03,
   0x6F, 0xBC, 0x5D, 0x1F, 0x7F, 0xDB, 0x00, 0xC1,
   0x13, 0xF0, 0xD1, 0xFA, 0xDA, 0x05, 0x39, 0xD3,
   0x38, 0xD2, 0x89, 0xE2, 0x88, 0x5E, 0x5C, 0x6D,
   0xCA, 0xB0, 0x01, 0x63, 0x8B, 0x59, 0xA4, 0xD0,
   0x78, 0x19, 0xB5, 0x62, 0x1A, 0x69, 0x8D, 0x9C,
   0x22, 0x3F, 0x9E, 0x33, 0x72, 0x2A, 0x41, 0x29,
   0xFE, 0xF6, 0x64, 0x7C, 0x66, 0xB6, 0xAF, 0x23,
   0x8C, 0x68, 0x6E, 0x49, 0x07, 0x99, 0x77, 0x3E,
   0x9A, 0x73, 0xD8, 0x55, 0x0A, 0x3C, 0xBA, 0xA9,
   0x52, 0xED, 0x91, 0x09, 0x95, 0xC7, 0x43, 0xD5,
   0x57, 0x61, 0x81, 0xEF, 0x06, 0xDE, 0x48, 0x31,
   0xBB, 0x2C, 0xE5, 0xC3, 0x67, 0xA1, 0x10, 0xB9 };

unsigned char table_161[256] = {
   0x8F, 0x1A, 0x81, 0xA2, 0x2C, 0x56, 0x6D, 0xCD,
   0x4A, 0x33, 0x50, 0xE9, 0xE0, 0x12, 0x5A, 0x43,
   0x2D, 0x4F, 0xEA, 0x95, 0xFD, 0x49, 0xAB, 0xA3,
   0x79, 0x42, 0x0B, 0xB8, 0x89, 0x40, 0x71, 0x14,
   0x80, 0x55, 0xAF, 0xCF, 0x3E, 0x64, 0x8B, 0x74,
   0xBF, 0x9C, 0x24, 0x97, 0xD1, 0xBA, 0x48, 0xD2,
   0x08, 0x1F, 0xDD, 0xA7, 0xDC, 0x92, 0x30, 0x75,
   0x31, 0x37, 0x67, 0x06, 0x68, 0x72, 0x6F, 0x05,
   0x8A, 0x7C, 0x4C, 0x3C, 0x19, 0x28, 0x86, 0x3D,
   0x93, 0xDA, 0xF4, 0xC7, 0x17, 0x85, 0xAC, 0x02,
   0x78, 0x04, 0xAD, 0x03, 0x8D, 0x11, 0xC5, 0x9D,
   0x3A, 0x73, 0x82, 0x59, 0x51, 0x9F, 0x27, 0x47,
   0xE7, 0xED, 0x1E, 0xFF, 0x34, 0x01, 0x5B, 0x4B,
   0xCA, 0x6C, 0x69, 0xBB, 0x3B, 0xC4, 0x5F, 0xDF,
   0x09, 0x6B, 0x7D, 0xC9, 0x88, 0x45, 0x57, 0xD3,
   0x2A, 0x4E, 0xF1, 0xC2, 0xA9, 0xB6, 0x18, 0xD4,
   0xA0, 0x1C, 0x4D, 0x0E, 0xE5, 0xE1, 0xD7, 0xB2,
   0x0C, 0x3F, 0x00, 0x61, 0x16, 0x0D, 0x32, 0x62,
   0x58, 0x63, 0xEE, 0xEF, 0x2F, 0x5D, 0xB0, 0x20,
   0x7A, 0x10, 0xE6, 0xA1, 0xF9, 0xD8, 0x6E, 0xCB,
   0xF0, 0x9B, 0x84, 0x8E, 0xF2, 0xFE, 0xC8, 0x7F,
   0xBD, 0xF8, 0x07, 0xC6, 0x39, 0xBC, 0xCC, 0x22,
   0x54, 0x15, 0x9A, 0xA4, 0xC1, 0x2B, 0x1B, 0x25,
   0xDE, 0x6A, 0xDB, 0x90, 0xEB, 0xB7, 0xD0, 0x44,
   0xA6, 0xB9, 0xB1, 0x23, 0x9E, 0x65, 0x83, 0xFA,
   0x96, 0xB5, 0x0F, 0xF6, 0xD6, 0xE8, 0x53, 0x13,
   0x76, 0xD5, 0x35, 0x87, 0xE3, 0x38, 0xF5, 0xAE,
   0xB3, 0xCE, 0xE2, 0x70, 0xD9, 0x66, 0x5C, 0x26,
   0xC3, 0xFC, 0xF7, 0x94, 0xF3, 0xEC, 0xFB, 0x99,
   0x91, 0x77, 0xB4, 0x46, 0xA5, 0x98, 0x7B, 0x1D,
   0x52, 0x2E, 0xA8, 0x60, 0x5E, 0x29, 0x21, 0x7E,
   0xBE, 0x0A, 0x36, 0x41, 0xC0, 0x8C, 0xE4, 0xAA };

unsigned char table_162[256] = {
   0xF7, 0x1B, 0xC0, 0x31, 0x5A, 0x23, 0xEA, 0xE9,
   0xFB, 0x14, 0x6A, 0xE8, 0x04, 0x65, 0x5B, 0x2C,
   0x41, 0xD9, 0xEB, 0xE4, 0x8D, 0x1D, 0xCA, 0x8F,
   0x5E, 0x43, 0xAF, 0x46, 0x0A, 0x01, 0x0C, 0xB4,
   0x95, 0x52, 0x92, 0xE0, 0x10, 0x57, 0x0F, 0x71,
   0xB1, 0x26, 0xD8, 0x05, 0x69, 0x3C, 0x54, 0xDF,
   0xFF, 0x9D, 0x51, 0xA0, 0xA1, 0x0B, 0xC1, 0x20,
   0x6D, 0xFA, 0x47, 0x15, 0x09, 0xD3, 0xE1, 0xA9,
   0x66, 0x12, 0x5C, 0x49, 0x1E, 0x3B, 0xD0, 0x8B,
   0x62, 0xBD, 0x06, 0xE5, 0x00, 0x98, 0x4E, 0x32,
   0xB0, 0x2D, 0x2A, 0x7F, 0x03, 0xD5, 0x99, 0x7E,
   0xAB, 0x22, 0xC6, 0xC3, 0x2F, 0x4C, 0x33, 0x45,
   0xE3, 0x3F, 0xF9, 0xB2, 0xFE, 0x36, 0xE7, 0xF8,
   0x55, 0x0D, 0x56, 0x1F, 0x4B, 0xE6, 0x50, 0x81,
   0xCE, 0x80, 0xCD, 0x67, 0x6B, 0xCF, 0x2E, 0x9B,
   0xBC, 0xBE, 0x11, 0x75, 0x4D, 0xAC, 0x59, 0x40,
   0x85, 0x0E, 0xC9, 0x17, 0xA3, 0x60, 0xED, 0x16,
   0xA4, 0xDD, 0xEE, 0x96, 0x77, 0x83, 0x34, 0xD2,
   0xCB, 0xFC, 0x6C, 0x08, 0xEC, 0x35, 0xF2, 0x6F,
   0x3A, 0x7B, 0x21, 0x4A, 0x70, 0xEF, 0xAD, 0xDE,
   0x90, 0x9E, 0x7D, 0x64, 0x2B, 0x79, 0xF5, 0xF3,
   0x13, 0x1C, 0x7A, 0x07, 0x4F, 0x78, 0x89, 0xB6,
   0x97, 0xF1, 0xD7, 0x7C, 0x48, 0xAE, 0x39, 0xA8,
   0xA6, 0x86, 0x3E, 0x27, 0x87, 0x73, 0x82, 0x24,
   0x30, 0x74, 0x5F, 0xD1, 0x9F, 0x9C, 0x1A, 0x8C,
   0x42, 0x6E, 0x28, 0xB9, 0xF0, 0xC4, 0x68, 0x25,
   0xC5, 0xDC, 0xB8, 0x29, 0xD6, 0x84, 0x3D, 0xBB,
   0x88, 0x76, 0xFD, 0x61, 0x94, 0x91, 0xDA, 0xB7,
   0x72, 0xBA, 0xC2, 0xDB, 0xB5, 0xA5, 0xE2, 0x18,
   0xF6, 0xAA, 0x8A, 0x19, 0x63, 0x9A, 0xA7, 0xC8,
   0xD4, 0x02, 0x8E, 0x37, 0xF4, 0xB3, 0xA2, 0x53,
   0x38, 0xCC, 0x58, 0x44, 0xBF, 0x93, 0x5D, 0xC7 };

unsigned char table_163[32] = {
   0x1B, 0x14, 0x12, 0x15, 0x11, 0x1D, 0x17, 0x19,
   0x10, 0x09, 0x08, 0x06, 0x1A, 0x16, 0x07, 0x13,
   0x1F, 0x0B, 0x1C, 0x05, 0x0E, 0x00, 0x18, 0x0A,
   0x04, 0x01, 0x03, 0x0C, 0x0D, 0x1E, 0x02, 0x0F };

unsigned char table_164[32] = {
   0x15, 0x00, 0x10, 0x0B, 0x1D, 0x0A, 0x06, 0x1C,
   0x0D, 0x1F, 0x17, 0x0F, 0x03, 0x14, 0x13, 0x12,
   0x1B, 0x18, 0x08, 0x1E, 0x16, 0x09, 0x1A, 0x04,
   0x02, 0x0C, 0x0E, 0x01, 0x07, 0x19, 0x11, 0x05 };

unsigned char table_165[256] = {
   0x98, 0xF5, 0x1D, 0xFB, 0x13, 0x20, 0x41, 0xA3,
   0xE3, 0x76, 0x49, 0x7E, 0x60, 0xD8, 0x68, 0x30,
   0x88, 0x45, 0xD5, 0x77, 0x00, 0xC3, 0x09, 0x31,
   0x44, 0x18, 0xD4, 0x14, 0xC8, 0x1B, 0x8B, 0x38,
   0x08, 0x52, 0xD1, 0xF3, 0x69, 0x9F, 0xDA, 0x61,
   0x16, 0x1C, 0xE4, 0x7D, 0xEE, 0xD9, 0x5E, 0x4C,
   0xA7, 0xAA, 0xA6, 0xF6, 0xCF, 0xA0, 0xBA, 0x10,
   0xE2, 0xDE, 0x0F, 0xEA, 0xBC, 0x32, 0x63, 0xC0,
   0x54, 0xC5, 0xBE, 0x71, 0x80, 0x56, 0x5C, 0xA4,
   0xAD, 0x15, 0x9D, 0x11, 0x43, 0x67, 0x95, 0xAE,
   0xC6, 0xC4, 0x91, 0x9C, 0xE5, 0x37, 0xE1, 0x7A,
   0xDB, 0xEF, 0x03, 0x65, 0x86, 0x66, 0x2A, 0xB5,
   0xBF, 0xB4, 0x0D, 0xB3, 0xD7, 0x2D, 0x01, 0xEB,
   0x8C, 0xF2, 0x5A, 0x2E, 0x64, 0x25, 0x02, 0xCB,
   0x4A, 0xB0, 0xCE, 0x35, 0xA8, 0x47, 0x85, 0x33,
   0x34, 0x24, 0x23, 0x7B, 0xB6, 0x48, 0x83, 0x40,
   0x87, 0x57, 0x3C, 0xD6, 0xCD, 0x2C, 0x6D, 0xE7,
   0xBB, 0xED, 0x81, 0x5D, 0x55, 0x46, 0xDD, 0xD3,
   0x70, 0xBD, 0xB8, 0x75, 0x53, 0x6E, 0xD0, 0x99,
   0xCA, 0x58, 0xC7, 0x4B, 0x3D, 0xA5, 0x50, 0x7C,
   0x93, 0x51, 0xB7, 0xFD, 0x05, 0x3A, 0xE8, 0x8F,
   0x28, 0x74, 0x39, 0xF0, 0x7F, 0x4F, 0x06, 0x36,
   0xB2, 0x19, 0x2F, 0x1F, 0x8D, 0x0C, 0xB9, 0xFC,
   0x89, 0x21, 0x12, 0xF7, 0x3F, 0x94, 0x6F, 0xDC,
   0x3E, 0x4E, 0x3B, 0xC9, 0x07, 0x9B, 0x17, 0x9A,
   0x73, 0x6A, 0x5B, 0xA1, 0x1E, 0x8A, 0x04, 0x72,
   0x6C, 0xA2, 0xEC, 0x96, 0xFE, 0xF8, 0x84, 0xC1,
   0x79, 0x0E, 0x62, 0x90, 0x8E, 0xF4, 0x42, 0x29,
   0x92, 0x9E, 0xAC, 0x82, 0x4D, 0xAF, 0x2B, 0x6B,
   0xA9, 0xFF, 0x0A, 0xAB, 0x22, 0x5F, 0xDF, 0xD2,
   0x0B, 0x78, 0xF1, 0xE6, 0x59, 0x27, 0xC2, 0xE0,
   0x1A, 0x26, 0xCC, 0xB1, 0xF9, 0xFA, 0x97, 0xE9 };

unsigned char table_166[256] = {
   0xCB, 0xEA, 0x2A, 0x36, 0x6D, 0x93, 0x4E, 0xD5,
   0xBC, 0x6A, 0xD4, 0x68, 0xF7, 0x18, 0xAB, 0x8B,
   0x66, 0x95, 0x94, 0x64, 0xB7, 0x00, 0x4D, 0x97,
   0x38, 0xB3, 0xFC, 0xE1, 0xBB, 0x63, 0xF3, 0x1F,
   0x6B, 0x2C, 0x2F, 0x5E, 0xA4, 0x7E, 0xFB, 0xF4,
   0xA8, 0x8A, 0x65, 0x53, 0x90, 0x58, 0x40, 0x60,
   0x28, 0x8E, 0x35, 0x49, 0xED, 0xBD, 0x1B, 0x0B,
   0xBA, 0xB8, 0x61, 0x50, 0xE9, 0x39, 0xEF, 0xC3,
   0x74, 0xB6, 0x46, 0x8D, 0xD9, 0x32, 0x92, 0x9A,
   0x30, 0x01, 0xF2, 0x41, 0xB9, 0xE7, 0x3A, 0xB0,
   0x80, 0x15, 0xDE, 0x7D, 0x7F, 0x09, 0xC2, 0x76,
   0xF8, 0x12, 0x59, 0xDD, 0x1D, 0xE6, 0x75, 0xBE,
   0xA3, 0x04, 0xCA, 0x78, 0x7B, 0xAC, 0xD8, 0x70,
   0xD3, 0xC1, 0x25, 0x6F, 0x03, 0x6C, 0x14, 0x45,
   0xE5, 0x2B, 0x87, 0x83, 0xAA, 0x77, 0x5F, 0x4A,
   0x9C, 0x27, 0x0C, 0x10, 0xAE, 0x56, 0x85, 0x0D,
   0xE3, 0xFA, 0x71, 0xEE, 0x9F, 0x21, 0xC0, 0xCD,
   0xFD, 0xDC, 0x5B, 0x11, 0x02, 0x0F, 0x96, 0x3D,
   0x3C, 0x26, 0xEB, 0x08, 0x7A, 0x82, 0xA7, 0x19,
   0xD7, 0xC5, 0xF6, 0x52, 0x57, 0x88, 0xFF, 0x47,
   0x8F, 0xC6, 0x33, 0xB5, 0x2E, 0x8C, 0x81, 0x91,
   0x44, 0xA6, 0x17, 0xF0, 0x4B, 0x9D, 0x34, 0x73,
   0x72, 0x67, 0xD2, 0x0E, 0xA0, 0x99, 0xA5, 0xAF,
   0xFE, 0x9E, 0x6E, 0xDA, 0x3B, 0xE2, 0x23, 0xD6,
   0xD0, 0x13, 0x89, 0x5A, 0x42, 0x98, 0x5C, 0xD1,
   0x86, 0x24, 0xDF, 0x37, 0xF9, 0xCC, 0xF5, 0xA9,
   0x2D, 0xBF, 0x5D, 0xF1, 0x69, 0xE8, 0xA2, 0x06,
   0x48, 0xC7, 0xDB, 0x29, 0xE4, 0xAD, 0x3E, 0xA1,
   0xC9, 0x4C, 0x1A, 0xCE, 0x62, 0x4F, 0x7C, 0xC8,
   0x05, 0xC4, 0xB1, 0x1E, 0x79, 0x55, 0x84, 0xB2,
   0x20, 0x31, 0x9B, 0xEC, 0xB4, 0xCF, 0x54, 0x22,
   0x1C, 0xE0, 0x51, 0x16, 0x43, 0x07, 0x0A, 0x3F };

unsigned char table_167[256] = {
   0x91, 0xEA, 0x4F, 0x6A, 0x6E, 0x2D, 0x27, 0x22,
   0x44, 0xA5, 0x6D, 0xE3, 0x45, 0x06, 0xE2, 0x87,
   0x9A, 0xC9, 0x2C, 0x4A, 0x93, 0x6F, 0x00, 0xEB,
   0x7C, 0x7F, 0xA2, 0xFE, 0x40, 0x3C, 0x3F, 0xC0,
   0xC7, 0xFB, 0x8B, 0xDF, 0xA3, 0x28, 0x78, 0x48,
   0x46, 0xD5, 0x70, 0x5C, 0x35, 0x4E, 0xD7, 0x3A,
   0x42, 0x47, 0x5B, 0x26, 0x8E, 0xE0, 0x21, 0xB1,
   0x77, 0x1E, 0x53, 0x4B, 0xCC, 0xE5, 0x65, 0xF6,
   0x66, 0x2A, 0xA0, 0x5E, 0x3E, 0xAD, 0xA8, 0x95,
   0x1B, 0x0D, 0x8A, 0x05, 0x68, 0x59, 0x0C, 0x38,
   0x18, 0xC3, 0x81, 0xA4, 0xFD, 0x13, 0x50, 0xCA,
   0xE8, 0xDD, 0xD9, 0x76, 0x8C, 0xC5, 0xF4, 0x17,
   0xB4, 0x3D, 0xEC, 0x0B, 0x67, 0xC6, 0x8D, 0xE1,
   0xBB, 0x7E, 0xCB, 0x10, 0x99, 0xE9, 0x39, 0xF3,
   0x75, 0xFA, 0xAC, 0x16, 0x54, 0x51, 0xBC, 0x24,
   0x58, 0x08, 0xA7, 0x0F, 0x5D, 0xBF, 0xBA, 0xE7,
   0x9D, 0x2B, 0xB5, 0x29, 0xE4, 0xCD, 0x37, 0x30,
   0x55, 0xAE, 0x1D, 0x4D, 0x94, 0x34, 0x92, 0x1C,
   0x6B, 0xBE, 0x52, 0x7B, 0x33, 0xB0, 0x0A, 0x5A,
   0x03, 0x23, 0x41, 0x49, 0x61, 0x64, 0x73, 0x97,
   0xC2, 0x9F, 0x5F, 0x07, 0x04, 0xF8, 0xC1, 0xFC,
   0x74, 0x02, 0x0E, 0x60, 0x9E, 0xD4, 0x85, 0x88,
   0xC4, 0xF5, 0x90, 0x31, 0xF7, 0xEE, 0x9B, 0xB9,
   0x20, 0xE6, 0xA6, 0x63, 0x79, 0x56, 0x62, 0xF0,
   0x2F, 0xD8, 0x4C, 0x83, 0xF9, 0x36, 0x3B, 0x84,
   0xDE, 0x57, 0xB8, 0xB7, 0x11, 0xF2, 0xC8, 0xD3,
   0xD1, 0x96, 0x19, 0x2E, 0x72, 0x9C, 0xDB, 0xB3,
   0xA1, 0xAA, 0xCE, 0x09, 0x98, 0xED, 0xA9, 0xDA,
   0xAF, 0x86, 0xD0, 0x12, 0xFF, 0xDC, 0x1F, 0xD6,
   0x01, 0xF1, 0xD2, 0x80, 0x43, 0x7A, 0x71, 0x82,
   0xB6, 0xAB, 0x89, 0xBD, 0x8F, 0xEF, 0x7D, 0xB2,
   0x14, 0x15, 0x25, 0x32, 0x6C, 0x69, 0x1A, 0xCF };

unsigned char table_168[256] = {
   0x28, 0xEE, 0xB1, 0xFD, 0xB3, 0xEF, 0x36, 0x8E,
   0x85, 0x5D, 0x1C, 0x53, 0x1E, 0xDA, 0xBA, 0x3C,
   0xA8, 0x90, 0x99, 0x49, 0x45, 0xE0, 0x27, 0x8D,
   0x22, 0xE4, 0x51, 0x3E, 0xAB, 0xE8, 0x70, 0xF5,
   0x81, 0xE6, 0x34, 0x29, 0xF3, 0x11, 0x46, 0x5F,
   0x5C, 0xA0, 0xD1, 0xE3, 0x15, 0x68, 0x3A, 0x01,
   0xE9, 0xD7, 0x24, 0x5A, 0x18, 0x16, 0x88, 0x3B,
   0x64, 0xA1, 0xDB, 0xBF, 0xAA, 0x43, 0xEA, 0x19,
   0xA2, 0xD5, 0x7B, 0xBD, 0x2A, 0x0E, 0x4F, 0xB5,
   0x4B, 0xB7, 0x5B, 0x73, 0xC9, 0xAC, 0x1B, 0x67,
   0xC7, 0xB4, 0x69, 0x00, 0xBC, 0x6D, 0xC1, 0x04,
   0xF4, 0x74, 0xD6, 0xD0, 0x60, 0xAE, 0x17, 0xFE,
   0x63, 0xB6, 0x89, 0x41, 0x7C, 0x44, 0x8B, 0xDC,
   0x50, 0xE5, 0x79, 0x77, 0x47, 0x9F, 0xA6, 0x3D,
   0x09, 0x8A, 0x2F, 0xC0, 0x0F, 0xCD, 0x2B, 0x4D,
   0x0D, 0xC2, 0x5E, 0xB0, 0x57, 0x62, 0xAF, 0x1A,
   0x21, 0x82, 0x48, 0x9E, 0x38, 0xB9, 0xB8, 0xF2,
   0x37, 0x07, 0xCA, 0xC5, 0x84, 0xDF, 0xF9, 0xEC,
   0x42, 0x6B, 0x8F, 0x6C, 0x3F, 0xC4, 0x94, 0xED,
   0x7A, 0x2D, 0xA3, 0x83, 0xD9, 0x55, 0x02, 0x9A,
   0xA9, 0x75, 0x10, 0x2C, 0xCB, 0x95, 0xBB, 0x6E,
   0x23, 0x65, 0x35, 0x97, 0x56, 0xAD, 0xCE, 0xF8,
   0xF0, 0x0C, 0xE2, 0x52, 0x05, 0x91, 0xCC, 0xC8,
   0x78, 0x06, 0x96, 0x4E, 0x03, 0xD3, 0x98, 0xA7,
   0x13, 0x58, 0x93, 0xD4, 0xDD, 0xC6, 0xFC, 0x25,
   0x9C, 0x86, 0x1F, 0xCF, 0x76, 0xA4, 0x6A, 0xFA,
   0x0B, 0x4A, 0x54, 0x40, 0x59, 0xD8, 0x61, 0xFF,
   0x7F, 0x80, 0x6F, 0x7D, 0xF1, 0x8C, 0x92, 0xDE,
   0x9D, 0xC3, 0xB2, 0xE7, 0xFB, 0x20, 0x31, 0x72,
   0x12, 0xBE, 0x1D, 0xF6, 0x9B, 0x14, 0x26, 0x0A,
   0xEB, 0xF7, 0x71, 0x39, 0x30, 0xA5, 0x87, 0xD2,
   0x66, 0x2E, 0x08, 0x32, 0x4C, 0x33, 0x7E, 0xE1 };

unsigned char table_169[256] = {
   0xA4, 0x31, 0xA9, 0x3F, 0x13, 0x4D, 0x1B, 0x29,
   0x73, 0x43, 0xF1, 0xE7, 0x9C, 0xC2, 0xF6, 0xCD,
   0xA1, 0x94, 0x0D, 0x27, 0xFE, 0x7B, 0x9B, 0x0B,
   0x89, 0xBA, 0x23, 0xEC, 0x76, 0xC3, 0x6C, 0xD8,
   0x8D, 0xF8, 0xF9, 0x7D, 0x68, 0x5B, 0x61, 0x87,
   0x28, 0x14, 0x55, 0x0C, 0xFC, 0xD9, 0x07, 0xE8,
   0x36, 0x88, 0x67, 0x4C, 0xEA, 0xBD, 0xF5, 0x9D,
   0xB6, 0xC6, 0x24, 0x32, 0x93, 0x03, 0x79, 0x8C,
   0x12, 0x84, 0xFF, 0x7E, 0x42, 0xE4, 0x3C, 0xF2,
   0x50, 0xEB, 0x1F, 0x47, 0xB0, 0xA5, 0xB1, 0x71,
   0x30, 0x5F, 0x5C, 0x53, 0xF7, 0x10, 0xC5, 0x6E,
   0xE0, 0xDE, 0xC8, 0x58, 0xB7, 0x90, 0xA6, 0x95,
   0x70, 0x8F, 0xFD, 0xC1, 0x48, 0xB5, 0x19, 0x92,
   0xBC, 0x15, 0x4E, 0xE6, 0x11, 0xDD, 0x81, 0x0E,
   0xBB, 0x75, 0x5D, 0x4A, 0xAB, 0x2D, 0x02, 0x54,
   0x4B, 0x66, 0xD6, 0x2B, 0x2A, 0xE5, 0x26, 0xE1,
   0xEE, 0xE9, 0x8B, 0x6A, 0x7A, 0xF4, 0x51, 0x39,
   0x1C, 0xC9, 0xCF, 0x77, 0x00, 0xF3, 0x25, 0xCC,
   0x08, 0xFB, 0x0F, 0x3E, 0xCE, 0xED, 0x3D, 0x56,
   0xEF, 0x1D, 0x85, 0x96, 0x52, 0xA8, 0xD3, 0xCB,
   0xE3, 0x33, 0x06, 0x7C, 0xAE, 0x72, 0x09, 0x04,
   0x91, 0xC4, 0x5A, 0x69, 0x98, 0xB4, 0x40, 0xDF,
   0x7F, 0x9F, 0xAA, 0x83, 0xE2, 0x78, 0x74, 0x20,
   0xAD, 0x6D, 0xDC, 0xD4, 0xCA, 0x60, 0xF0, 0x35,
   0x37, 0xD0, 0x18, 0x1A, 0x64, 0x3A, 0x99, 0xDB,
   0x62, 0x44, 0x2C, 0x82, 0x8E, 0xD7, 0xD1, 0xFA,
   0x16, 0xD5, 0x46, 0xBF, 0xA7, 0xC0, 0x2E, 0x3B,
   0x01, 0x63, 0xB2, 0x1E, 0x05, 0x21, 0xB8, 0x17,
   0x22, 0x97, 0xAF, 0x4F, 0x86, 0x34, 0xDA, 0xC7,
   0xA3, 0xA0, 0xB3, 0x2F, 0xAC, 0x49, 0xD2, 0x57,
   0x6F, 0x9A, 0x65, 0xB9, 0x41, 0xBE, 0x8A, 0xA2,
   0x6B, 0x0A, 0x59, 0x9E, 0x5E, 0x38, 0x45, 0x80 };

unsigned char table_170[256] = {
   0xE3, 0x00, 0x99, 0x03, 0xF6, 0xDD, 0xD1, 0x41,
   0x58, 0x7E, 0xD9, 0x46, 0x04, 0xAF, 0x5C, 0x43,
   0xDE, 0x5E, 0xFC, 0x97, 0x3D, 0x68, 0xC8, 0x37,
   0x3C, 0xFB, 0x0F, 0x5A, 0xBE, 0xFA, 0x4C, 0x82,
   0x0C, 0xA0, 0x0A, 0xD4, 0x9D, 0xCE, 0x78, 0xA8,
   0x55, 0x56, 0x60, 0xAA, 0xC9, 0x96, 0x62, 0xEA,
   0x0D, 0xB8, 0xE2, 0x84, 0x17, 0xAE, 0x2B, 0x2C,
   0x91, 0x57, 0x38, 0x01, 0xA9, 0xCD, 0x34, 0xBA,
   0x8D, 0xC0, 0xD6, 0xFF, 0xF2, 0xD3, 0x5F, 0x26,
   0xCA, 0x9B, 0x21, 0x75, 0x4E, 0x49, 0x20, 0x59,
   0x39, 0xBF, 0x90, 0x6C, 0xFE, 0x8F, 0x2F, 0x18,
   0x36, 0xD7, 0xB4, 0xAC, 0xBD, 0xF3, 0x1D, 0x4F,
   0xA3, 0x74, 0x5B, 0x44, 0x05, 0x9C, 0x6D, 0x6B,
   0x1E, 0xE8, 0x25, 0x16, 0x80, 0xCC, 0x29, 0xC7,
   0x94, 0x4A, 0xF5, 0xF4, 0x27, 0x85, 0xBB, 0x24,
   0xDA, 0xB5, 0x76, 0x69, 0xA5, 0x54, 0x23, 0x31,
   0x11, 0xA4, 0x09, 0xE4, 0x64, 0x10, 0xC5, 0xC1,
   0x7D, 0xE7, 0x92, 0xF8, 0x9E, 0x6A, 0x15, 0x8B,
   0x98, 0x42, 0x52, 0x66, 0x0B, 0xA1, 0x35, 0x1A,
   0x14, 0x7C, 0xE1, 0x9F, 0x28, 0xF1, 0x1B, 0xA6,
   0x71, 0x73, 0x81, 0xAB, 0xE6, 0x95, 0x06, 0x1F,
   0xC6, 0xB0, 0x51, 0x0E, 0xEE, 0x77, 0xF0, 0xD8,
   0xC2, 0x89, 0x7B, 0x07, 0xA2, 0xB7, 0x19, 0x67,
   0x2E, 0x8E, 0x47, 0xA7, 0xEF, 0x32, 0xD2, 0x93,
   0xDC, 0x9A, 0xB2, 0xED, 0x45, 0xC4, 0x50, 0x3F,
   0xE5, 0xCF, 0x88, 0x1C, 0x7A, 0x79, 0xEB, 0x70,
   0x2A, 0x7F, 0xBC, 0xDB, 0xD0, 0xB1, 0xCB, 0x08,
   0x86, 0x5D, 0x53, 0x72, 0xB6, 0x4B, 0xB3, 0x22,
   0xC3, 0x6F, 0xB9, 0xD5, 0x3B, 0x13, 0x2D, 0xAD,
   0x33, 0xFD, 0x02, 0x40, 0x8A, 0x3A, 0xF7, 0xE0,
   0x8C, 0x3E, 0x61, 0x6E, 0xE9, 0x63, 0xF9, 0xEC,
   0x48, 0x30, 0x87, 0x83, 0x12, 0x4D, 0x65, 0xDF };

unsigned char table_171[32] = {
   0x07, 0x06, 0x11, 0x08, 0x0C, 0x1F, 0x19, 0x02,
   0x14, 0x04, 0x0D, 0x18, 0x1A, 0x05, 0x17, 0x13,
   0x1C, 0x1B, 0x15, 0x03, 0x01, 0x0F, 0x16, 0x1E,
   0x1D, 0x10, 0x00, 0x12, 0x0B, 0x0E, 0x09, 0x0A };

unsigned char table_172[32] = {
   0x11, 0x01, 0x1F, 0x06, 0x1A, 0x04, 0x02, 0x09,
   0x05, 0x0D, 0x0B, 0x18, 0x0E, 0x12, 0x1B, 0x17,
   0x07, 0x08, 0x1D, 0x1E, 0x14, 0x19, 0x16, 0x15,
   0x03, 0x0C, 0x00, 0x10, 0x0A, 0x1C, 0x0F, 0x13 };

unsigned char table_173[32] = {
   0x1F, 0x0B, 0x13, 0x00, 0x16, 0x15, 0x14, 0x0A,
   0x1D, 0x05, 0x1E, 0x1A, 0x0F, 0x04, 0x0E, 0x01,
   0x19, 0x07, 0x02, 0x12, 0x0C, 0x17, 0x08, 0x09,
   0x03, 0x11, 0x18, 0x10, 0x1C, 0x1B, 0x06, 0x0D };

unsigned char table_174[32] = {
   0x02, 0x1B, 0x0C, 0x17, 0x1F, 0x05, 0x15, 0x1E,
   0x16, 0x09, 0x1A, 0x12, 0x0F, 0x1C, 0x18, 0x0A,
   0x19, 0x10, 0x0D, 0x13, 0x04, 0x11, 0x08, 0x14,
   0x1D, 0x0E, 0x06, 0x00, 0x01, 0x07, 0x0B, 0x03 };

unsigned char table_175[32] = {
   0x00, 0x06, 0x0B, 0x08, 0x0C, 0x04, 0x1A, 0x1C,
   0x05, 0x1E, 0x14, 0x03, 0x0A, 0x18, 0x12, 0x1D,
   0x16, 0x1F, 0x07, 0x09, 0x0F, 0x0E, 0x17, 0x13,
   0x11, 0x19, 0x10, 0x0D, 0x1B, 0x02, 0x01, 0x15 };

unsigned char table_176[32] = {
   0x12, 0x03, 0x1A, 0x15, 0x04, 0x19, 0x0B, 0x1B,
   0x17, 0x1E, 0x0D, 0x05, 0x11, 0x14, 0x1C, 0x00,
   0x18, 0x10, 0x0A, 0x06, 0x0E, 0x08, 0x02, 0x07,
   0x13, 0x09, 0x16, 0x1D, 0x0F, 0x0C, 0x01, 0x1F };

unsigned char table_177[256] = {
   0x5E, 0x4D, 0x76, 0xFE, 0xB5, 0x50, 0x83, 0x23,
   0x72, 0xDD, 0x93, 0x08, 0x69, 0xAD, 0xEC, 0x3B,
   0x0B, 0x9A, 0x36, 0xC9, 0xCA, 0xBE, 0xF7, 0x30,
   0x19, 0x39, 0x2C, 0xAB, 0xE3, 0x7B, 0xBC, 0x32,
   0xA0, 0xE4, 0xA6, 0xB6, 0xCB, 0xC8, 0x37, 0x07,
   0xD2, 0xA1, 0xD9, 0xF6, 0xBF, 0xF5, 0x88, 0x01,
   0x95, 0x0F, 0x03, 0xFD, 0xE6, 0x68, 0x90, 0x61,
   0x21, 0x6D, 0x3C, 0x62, 0x34, 0x2B, 0x71, 0x4B,
   0x44, 0x64, 0x75, 0xA2, 0x6A, 0xFF, 0x29, 0xBD,
   0x35, 0x15, 0xF9, 0xC1, 0x09, 0x45, 0xB2, 0xF2,
   0x3F, 0xCE, 0xB0, 0xC0, 0xB8, 0x00, 0x05, 0xD7,
   0x11, 0xC6, 0x78, 0x53, 0x9E, 0xB3, 0xED, 0x56,
   0x22, 0x5C, 0x9D, 0x6C, 0x99, 0x43, 0x2F, 0xAE,
   0xEB, 0x40, 0x8C, 0x1F, 0xC2, 0xDF, 0x92, 0x65,
   0x6F, 0x79, 0x5D, 0x5B, 0xAA, 0xDB, 0xF1, 0x96,
   0xD4, 0xF4, 0x8B, 0x51, 0xD5, 0xE2, 0xBB, 0x80,
   0x17, 0x7C, 0x2A, 0x6E, 0xDE, 0xEA, 0x94, 0x31,
   0xA4, 0x2D, 0xC3, 0x8D, 0x55, 0x14, 0x9B, 0x0E,
   0x7D, 0xC4, 0x06, 0x33, 0x73, 0xE9, 0x7A, 0x38,
   0x5F, 0x89, 0x84, 0xD6, 0xA8, 0x13, 0xE8, 0xCF,
   0x46, 0xD0, 0x7F, 0x24, 0x8F, 0xF8, 0x87, 0x1B,
   0x47, 0x02, 0x0C, 0x97, 0x52, 0xFB, 0x8E, 0x20,
   0x70, 0x3E, 0x7E, 0xD1, 0xE5, 0xEE, 0xCC, 0x91,
   0x74, 0xCD, 0x42, 0x04, 0x8A, 0xEF, 0xE1, 0x10,
   0x4F, 0x1C, 0x28, 0x9F, 0xD8, 0x0A, 0x18, 0x49,
   0x9C, 0x16, 0xF3, 0x82, 0x57, 0x1D, 0x26, 0x66,
   0x27, 0x86, 0xE7, 0x59, 0xFA, 0x25, 0x54, 0x0D,
   0x98, 0xDC, 0xF0, 0x3D, 0x63, 0x1E, 0x77, 0x3A,
   0xDA, 0xB7, 0x6B, 0x2E, 0x48, 0x4C, 0xBA, 0xC7,
   0x60, 0xAC, 0x1A, 0xB9, 0xFC, 0xA3, 0xA7, 0xA5,
   0xB4, 0x67, 0xA9, 0x81, 0xB1, 0x12, 0xD3, 0x85,
   0x5A, 0xC5, 0xE0, 0x58, 0x41, 0x4E, 0x4A, 0xAF };

unsigned char table_178[256] = {
   0x33, 0xBA, 0x98, 0xDA, 0x07, 0x2C, 0x22, 0x9B,
   0xE0, 0xED, 0xB7, 0xA1, 0x93, 0xEB, 0xDC, 0x49,
   0xDF, 0xE1, 0x6C, 0xC2, 0x64, 0x52, 0xD0, 0x8F,
   0xA2, 0x48, 0x26, 0x21, 0x6E, 0x5E, 0x0B, 0x7C,
   0x0D, 0x90, 0xA4, 0xCE, 0xF5, 0x5F, 0xF9, 0x1D,
   0x55, 0x83, 0x8D, 0xFB, 0x38, 0xB3, 0xF2, 0x67,
   0xDE, 0x0A, 0xBE, 0xEC, 0x5B, 0x35, 0x08, 0x50,
   0xE7, 0x56, 0x4A, 0x02, 0xBC, 0x5A, 0xBD, 0x43,
   0x6F, 0x79, 0xB2, 0xF7, 0x60, 0xE9, 0xA0, 0x1B,
   0xC8, 0xDD, 0x9D, 0xA3, 0x5C, 0x61, 0x77, 0x72,
   0x9C, 0x31, 0x0E, 0x05, 0x1E, 0x12, 0xF1, 0xC9,
   0x78, 0x4E, 0x15, 0x7D, 0x54, 0xCB, 0x73, 0xEA,
   0xC5, 0x2B, 0x0F, 0x7E, 0x42, 0x96, 0xC6, 0x74,
   0x09, 0x65, 0x34, 0xE6, 0x63, 0xA6, 0x70, 0xD3,
   0x27, 0x87, 0x3A, 0x16, 0x7B, 0x13, 0x06, 0x40,
   0x46, 0x69, 0xAD, 0x88, 0x81, 0xC0, 0x37, 0x58,
   0xD1, 0x8A, 0x8E, 0x9A, 0x5D, 0x6D, 0xC7, 0xC3,
   0xD2, 0xF4, 0x3F, 0x57, 0x3C, 0x4F, 0xA9, 0x6A,
   0x92, 0xA5, 0x97, 0x0C, 0x2A, 0x36, 0x47, 0xDB,
   0x8C, 0xEE, 0x03, 0x89, 0x7F, 0x91, 0x24, 0x80,
   0x2F, 0x62, 0xE4, 0xAF, 0x17, 0x99, 0xD6, 0xCD,
   0xFE, 0x76, 0x1C, 0xD4, 0x3E, 0xFF, 0xD8, 0xC4,
   0x39, 0x32, 0xCF, 0xE2, 0xE3, 0x53, 0xD7, 0xCC,
   0xD9, 0x11, 0xAA, 0x1F, 0x01, 0x3B, 0x51, 0xB5,
   0x94, 0x4B, 0x28, 0xF0, 0xAC, 0x44, 0x14, 0x4C,
   0xB9, 0xA7, 0xB8, 0x1A, 0xD5, 0xCA, 0xE8, 0x82,
   0x9F, 0x2D, 0xAB, 0x2E, 0x29, 0xFD, 0x68, 0xB1,
   0x66, 0xC1, 0x7A, 0xFA, 0x71, 0x04, 0xA8, 0xB0,
   0x59, 0x18, 0xAE, 0x25, 0x3D, 0xE5, 0xF6, 0x41,
   0x86, 0x75, 0x6B, 0xBB, 0xFC, 0x84, 0x8B, 0x85,
   0x10, 0x23, 0xB6, 0xF3, 0x19, 0x30, 0x20, 0x4D,
   0x95, 0x9E, 0xBF, 0xEF, 0xF8, 0x45, 0x00, 0xB4 };

unsigned char table_179[256] = {
   0x50, 0x3D, 0x41, 0x42, 0x06, 0x5B, 0xD6, 0x34,
   0x9D, 0x3C, 0x7B, 0x14, 0xE2, 0x9B, 0x80, 0x15,
   0x51, 0x01, 0x6A, 0x30, 0xD7, 0xFC, 0x61, 0x4B,
   0x8A, 0xEC, 0x38, 0x71, 0x70, 0x2E, 0x1C, 0x72,
   0x79, 0x26, 0x4C, 0x48, 0xED, 0xAD, 0x25, 0x53,
   0x03, 0xD9, 0xB5, 0x0D, 0x8E, 0x19, 0xCC, 0xBE,
   0xE1, 0x91, 0x64, 0xA6, 0x21, 0xCE, 0x76, 0xAB,
   0x9F, 0xD1, 0xB6, 0x23, 0x6D, 0xB0, 0x90, 0xBD,
   0x09, 0x3A, 0x5E, 0xD0, 0x73, 0x10, 0x44, 0x08,
   0xFF, 0xB8, 0x24, 0x58, 0xDB, 0x65, 0x95, 0xAA,
   0xE9, 0xC4, 0x32, 0x2B, 0x84, 0xC9, 0xC7, 0xB1,
   0x4F, 0x0C, 0xCB, 0x11, 0x4E, 0x22, 0x4A, 0x16,
   0xDE, 0xBC, 0xEE, 0x68, 0x13, 0xFA, 0xC3, 0x98,
   0xEB, 0x29, 0x43, 0x9A, 0xA1, 0xE0, 0xF0, 0x3F,
   0x2F, 0x1B, 0xC2, 0x66, 0x35, 0xF5, 0xC8, 0xD8,
   0x5A, 0xE5, 0x87, 0x47, 0xD3, 0x7A, 0xE6, 0x39,
   0x77, 0x81, 0xF2, 0x0E, 0x83, 0x7E, 0x17, 0x6C,
   0xB3, 0x5C, 0xE8, 0xD2, 0xC0, 0xA4, 0xF9, 0x86,
   0xCD, 0xFB, 0x54, 0x7C, 0xBF, 0x2D, 0x82, 0xDA,
   0x96, 0x74, 0x97, 0xC5, 0x7D, 0x27, 0x57, 0x56,
   0xDC, 0xBA, 0x69, 0x8C, 0x9C, 0x88, 0xB4, 0x8D,
   0x37, 0xEA, 0x3B, 0x33, 0x2C, 0xB2, 0x45, 0xF7,
   0xC1, 0x1E, 0x46, 0x02, 0x6B, 0x3E, 0xA7, 0xD5,
   0x05, 0x0A, 0xA9, 0x1D, 0xA3, 0x4D, 0xAE, 0x6F,
   0x49, 0xDD, 0x8F, 0xEF, 0xBB, 0x67, 0x0B, 0x40,
   0x9E, 0xF1, 0x78, 0x28, 0xDF, 0x52, 0xF4, 0x92,
   0x94, 0x0F, 0xB9, 0x93, 0xF6, 0x1F, 0xAF, 0xA8,
   0xCA, 0xE4, 0x59, 0x7F, 0x85, 0x75, 0xC6, 0xFD,
   0x00, 0xB7, 0x55, 0xFE, 0x8B, 0x62, 0x5F, 0x12,
   0xF8, 0xD4, 0x89, 0xA0, 0x20, 0xE7, 0xCF, 0x60,
   0x5D, 0xAC, 0x1A, 0x36, 0x63, 0x99, 0x31, 0xF3,
   0x2A, 0x04, 0x18, 0xA5, 0xA2, 0x6E, 0x07, 0xE3 };

unsigned char table_180[256] = {
   0xDA, 0xCC, 0x72, 0xA6, 0xE7, 0x07, 0xFD, 0x25,
   0x92, 0x39, 0x49, 0x02, 0xD6, 0x09, 0xA8, 0x65,
   0x2E, 0x6C, 0xA1, 0x19, 0xBF, 0x21, 0x11, 0xC7,
   0x3F, 0x9F, 0xF4, 0x51, 0xAF, 0x8C, 0xFE, 0xCD,
   0x7A, 0xEB, 0x5A, 0xF7, 0x18, 0x69, 0xB9, 0xED,
   0x37, 0x45, 0x13, 0xB4, 0xAA, 0x75, 0x47, 0x42,
   0xA3, 0x81, 0x88, 0x70, 0xC1, 0x36, 0x73, 0x1D,
   0x3B, 0x22, 0xB6, 0x35, 0xE9, 0x31, 0x56, 0x23,
   0xE1, 0xF5, 0xAD, 0x46, 0x99, 0x32, 0xE4, 0x40,
   0x00, 0x0F, 0x05, 0xC6, 0x33, 0x84, 0x7B, 0x4D,
   0x4B, 0x7D, 0x91, 0x3D, 0xCE, 0x64, 0x77, 0x55,
   0xD7, 0x2B, 0x2F, 0x2C, 0xB8, 0xD3, 0x85, 0xD1,
   0xB5, 0x6A, 0xF9, 0x41, 0x08, 0xBB, 0x87, 0xEC,
   0x78, 0xE0, 0xEE, 0x8D, 0x01, 0x58, 0x15, 0x8F,
   0x06, 0xF0, 0x8B, 0x27, 0x0D, 0x0B, 0x6D, 0xBD,
   0xCA, 0x2A, 0xA2, 0xE6, 0xDD, 0xBC, 0x4E, 0x5D,
   0x74, 0x04, 0x3A, 0x96, 0x66, 0x12, 0x1E, 0xF2,
   0xF6, 0xC4, 0xAE, 0x3C, 0x0C, 0x90, 0x68, 0xD8,
   0x24, 0x5E, 0x79, 0x10, 0xAC, 0xDF, 0x9B, 0xC5,
   0x44, 0xC3, 0x50, 0x5C, 0xA5, 0x89, 0x60, 0x5F,
   0x48, 0x17, 0x34, 0xA7, 0xE2, 0xF3, 0xD9, 0x3E,
   0x9C, 0xB7, 0x7C, 0x1F, 0xA9, 0xD4, 0xA4, 0x0E,
   0x8E, 0x4C, 0xDC, 0xF8, 0xF1, 0x98, 0xDE, 0x2D,
   0x61, 0xCB, 0xD5, 0x43, 0x86, 0x26, 0xB0, 0x7F,
   0x7E, 0xFF, 0xAB, 0x83, 0x14, 0x9A, 0x80, 0x16,
   0x30, 0xA0, 0x53, 0x97, 0x52, 0x9E, 0xB1, 0x1B,
   0xD0, 0x1A, 0xC8, 0x57, 0xBA, 0x6E, 0xFA, 0x94,
   0xE8, 0x63, 0x5B, 0x29, 0xEF, 0x71, 0x8A, 0x03,
   0xB3, 0x76, 0xC9, 0xD2, 0xBE, 0xE5, 0x82, 0x1C,
   0x95, 0x9D, 0x4A, 0x28, 0xEA, 0x0A, 0xC0, 0xE3,
   0x6F, 0x20, 0x54, 0xFB, 0x93, 0xFC, 0x6B, 0x38,
   0x62, 0x4F, 0xCF, 0xB2, 0xC2, 0x59, 0xDB, 0x67 };

unsigned char table_181[256] = {
   0x2B, 0xED, 0x14, 0x05, 0x80, 0xCC, 0x5A, 0xF8,
   0x43, 0xB7, 0x86, 0xC6, 0xEE, 0xA6, 0xD7, 0xD6,
   0xA0, 0xC4, 0x21, 0x34, 0xB1, 0x8C, 0xF9, 0xF4,
   0x7C, 0x53, 0x06, 0xD4, 0x6B, 0x3F, 0xE1, 0x12,
   0x6A, 0xCE, 0xCF, 0xBF, 0x74, 0x3E, 0xD5, 0xCB,
   0x97, 0x01, 0xA2, 0x2D, 0xAE, 0xF7, 0x17, 0x29,
   0x47, 0x03, 0x0E, 0xE9, 0x82, 0x46, 0x94, 0xAF,
   0x2A, 0x90, 0xFE, 0x4A, 0x7E, 0x0C, 0x71, 0xB6,
   0xA5, 0xF2, 0x67, 0x41, 0xBA, 0xC2, 0x8A, 0x9D,
   0x36, 0xFF, 0x50, 0x2E, 0xC3, 0x91, 0x9C, 0x37,
   0x66, 0xAD, 0xB2, 0x1F, 0xE4, 0xE3, 0x9F, 0xDD,
   0x87, 0xC0, 0xE6, 0xEF, 0x13, 0x70, 0x5B, 0xDE,
   0x5C, 0x75, 0x7F, 0x4F, 0x44, 0xCA, 0x55, 0x57,
   0xF0, 0x26, 0xA7, 0xC7, 0x10, 0x51, 0x00, 0xB3,
   0x5D, 0x99, 0x81, 0x3B, 0xB9, 0x1C, 0x64, 0x7B,
   0xFB, 0xD9, 0x8D, 0x4E, 0xAC, 0x25, 0xBB, 0x69,
   0xDF, 0x02, 0x9E, 0x2C, 0xAB, 0xF3, 0x65, 0x09,
   0xA3, 0x6C, 0xC1, 0x76, 0x52, 0x30, 0xD8, 0x3A,
   0x40, 0x18, 0x59, 0xD0, 0xE5, 0xB4, 0x5F, 0x33,
   0x68, 0x92, 0x2F, 0xB8, 0x93, 0xD1, 0xEB, 0xA4,
   0xFC, 0x77, 0x19, 0x62, 0xC9, 0x49, 0x84, 0x1A,
   0x9A, 0xE7, 0x31, 0xE8, 0xE2, 0x58, 0xF1, 0x4B,
   0x1E, 0x0B, 0x39, 0xFD, 0x42, 0x7A, 0x89, 0x38,
   0x11, 0x98, 0x63, 0x08, 0xE0, 0xEA, 0xBE, 0xB0,
   0x45, 0x1B, 0x4C, 0x54, 0xC8, 0x27, 0x3D, 0x73,
   0x04, 0x8F, 0x79, 0xBC, 0x6F, 0x0D, 0x0F, 0xA1,
   0x60, 0xDC, 0xC5, 0xFA, 0x8E, 0xDA, 0x15, 0x96,
   0xD3, 0x07, 0xF5, 0x3C, 0x88, 0x72, 0x1D, 0x4D,
   0x8B, 0x61, 0x0A, 0xDB, 0xAA, 0x20, 0x23, 0xEC,
   0x6E, 0x22, 0x48, 0x28, 0xBD, 0xA9, 0x56, 0x5E,
   0x85, 0xA8, 0x95, 0x6D, 0x16, 0x78, 0xB5, 0xF6,
   0x32, 0x24, 0x7D, 0x9B, 0xD2, 0x83, 0x35, 0xCD };

unsigned char table_182[256] = {
   0x06, 0x7F, 0x66, 0xB5, 0xBA, 0x1E, 0xFD, 0x51,
   0x81, 0x8D, 0x28, 0xA3, 0x15, 0x37, 0xDC, 0x58,
   0xE6, 0x3D, 0xB4, 0xB9, 0x2E, 0xA0, 0x2F, 0xC4,
   0xCB, 0xB1, 0x25, 0xBF, 0xC1, 0x4E, 0x5A, 0xE4,
   0x0F, 0x10, 0x7C, 0x52, 0xA7, 0x29, 0x76, 0x55,
   0xAA, 0x70, 0x62, 0x54, 0x43, 0x93, 0x3A, 0x7D,
   0x5B, 0x56, 0x33, 0x64, 0x74, 0x2A, 0xD9, 0x9B,
   0x88, 0xC0, 0x3C, 0x63, 0xDE, 0xF4, 0x73, 0xDF,
   0x9E, 0xB2, 0xA8, 0x4F, 0x04, 0x57, 0x47, 0x87,
   0x14, 0xFC, 0x27, 0x53, 0x83, 0xDB, 0xD7, 0x20,
   0x96, 0x31, 0xD0, 0xCF, 0x30, 0x19, 0x69, 0x1A,
   0xAE, 0x3B, 0x11, 0x0C, 0xA6, 0x95, 0x8A, 0xF2,
   0x1B, 0xCC, 0x78, 0xEF, 0xB3, 0x71, 0x84, 0xA2,
   0xF1, 0x7A, 0x92, 0x61, 0xCA, 0x90, 0x94, 0x89,
   0x68, 0xEE, 0x97, 0x38, 0x0D, 0xF9, 0x1F, 0x8E,
   0xE9, 0x26, 0xBD, 0xC9, 0xFF, 0x4C, 0x44, 0x1D,
   0x98, 0xE5, 0x86, 0xF3, 0x18, 0xB6, 0x09, 0xD2,
   0x7E, 0xC5, 0xE7, 0x2B, 0x8C, 0x8B, 0x60, 0x3F,
   0x2C, 0x6A, 0x08, 0x0E, 0x50, 0x32, 0x9F, 0xF0,
   0x9A, 0xC2, 0x39, 0xBE, 0xEA, 0x12, 0x16, 0xBB,
   0x5E, 0x67, 0xE3, 0xB8, 0x79, 0x46, 0xDA, 0x00,
   0xD3, 0xBC, 0xCE, 0x1C, 0x80, 0xFA, 0xAB, 0x65,
   0x4A, 0xF8, 0xAC, 0x72, 0x01, 0xC6, 0x35, 0x85,
   0x3E, 0x5C, 0xA1, 0x05, 0xA5, 0xA9, 0xE1, 0x40,
   0xEB, 0xE8, 0x5F, 0xF5, 0xC3, 0xD1, 0x34, 0xFB,
   0xEC, 0xF7, 0x9C, 0xC7, 0xDD, 0x6C, 0x36, 0x9D,
   0x42, 0x59, 0x99, 0x5D, 0xD8, 0x82, 0x07, 0x24,
   0x6D, 0xAD, 0x13, 0x48, 0x6B, 0x6E, 0x75, 0x4D,
   0xD5, 0x02, 0xED, 0xFE, 0x91, 0xCD, 0x77, 0xB0,
   0xF6, 0xC8, 0x6F, 0x23, 0xAF, 0xB7, 0x2D, 0xD6,
   0xA4, 0xE2, 0x45, 0x8F, 0x21, 0xE0, 0x49, 0x22,
   0x7B, 0x17, 0x0B, 0x0A, 0x41, 0x03, 0xD4, 0x4B };

unsigned char table_183[32] = {
   0x1E, 0x1B, 0x11, 0x07, 0x08, 0x06, 0x18, 0x17,
   0x0D, 0x0F, 0x12, 0x03, 0x1D, 0x04, 0x0A, 0x1A,
   0x0C, 0x13, 0x14, 0x1F, 0x0B, 0x19, 0x10, 0x01,
   0x16, 0x05, 0x1C, 0x0E, 0x02, 0x00, 0x09, 0x15 };

unsigned char table_184[32] = {
   0x0F, 0x1D, 0x17, 0x16, 0x0D, 0x05, 0x13, 0x1F,
   0x1B, 0x09, 0x1C, 0x1E, 0x15, 0x01, 0x06, 0x08,
   0x0C, 0x10, 0x0B, 0x02, 0x04, 0x0A, 0x07, 0x1A,
   0x18, 0x0E, 0x03, 0x11, 0x12, 0x14, 0x19, 0x00 };

unsigned char table_185[256] = {
   0xA5, 0xEE, 0x2E, 0x28, 0xA7, 0xAC, 0xD9, 0xB2,
   0x6E, 0x04, 0xB4, 0x03, 0xE8, 0x92, 0x5F, 0x4D,
   0x73, 0x20, 0x71, 0xE0, 0x43, 0x53, 0x3F, 0xF8,
   0x96, 0xA1, 0x24, 0x97, 0xAD, 0x7B, 0xE5, 0xE6,
   0xF2, 0xCE, 0xE3, 0x76, 0x2F, 0xA2, 0x48, 0x0E,
   0x4B, 0x4A, 0x8B, 0x5A, 0x81, 0x2C, 0xBF, 0xD7,
   0xFB, 0x7D, 0x4C, 0x16, 0xF4, 0x00, 0xF5, 0x40,
   0x64, 0x74, 0xA9, 0x37, 0x86, 0xD3, 0x1B, 0xCD,
   0xF1, 0x1A, 0x90, 0x9F, 0x54, 0x79, 0x29, 0xC3,
   0x77, 0x85, 0x02, 0xB1, 0x70, 0xFE, 0x5B, 0xDA,
   0x6B, 0x01, 0x0C, 0x07, 0xB8, 0x58, 0x47, 0x42,
   0x09, 0xE4, 0x27, 0xDD, 0xF3, 0x1E, 0x10, 0x9E,
   0x49, 0x30, 0x05, 0xBE, 0x59, 0xEB, 0xD2, 0xAA,
   0xC8, 0x9D, 0x8C, 0x5E, 0x14, 0x56, 0x8E, 0xF7,
   0x38, 0x55, 0x87, 0xA3, 0x5D, 0x41, 0x4F, 0x1F,
   0xF6, 0x0F, 0x57, 0x91, 0xAE, 0xBA, 0xB3, 0x95,
   0x9B, 0x69, 0xC1, 0x11, 0xD0, 0x25, 0x7F, 0x3B,
   0x62, 0xCF, 0xC0, 0xA0, 0xFC, 0xB6, 0x12, 0x6C,
   0xF0, 0x13, 0x93, 0xAB, 0xC6, 0x78, 0x6D, 0x88,
   0x22, 0x08, 0x2A, 0xE2, 0xB7, 0x65, 0x31, 0x3A,
   0xA6, 0x7C, 0xF9, 0xDC, 0xE7, 0xA4, 0xC9, 0x63,
   0xA8, 0x0B, 0xED, 0x50, 0x36, 0xD8, 0x3E, 0xB0,
   0x6A, 0x5C, 0x45, 0x4E, 0x23, 0x84, 0x34, 0x9A,
   0xCC, 0x3D, 0xB5, 0xEA, 0xDE, 0x75, 0xD6, 0xFF,
   0x6F, 0xC2, 0xDB, 0x8D, 0x7A, 0x1C, 0xE9, 0x61,
   0x0A, 0x1D, 0x32, 0x52, 0x3C, 0x19, 0xFA, 0xD1,
   0xD4, 0x68, 0xC7, 0x0D, 0x99, 0x83, 0xEF, 0x80,
   0x82, 0xBD, 0xD5, 0x7E, 0x39, 0x72, 0x51, 0xAF,
   0x8A, 0x2D, 0xB9, 0x89, 0xC4, 0x67, 0x35, 0xE1,
   0x44, 0x06, 0xEC, 0xCB, 0x8F, 0x17, 0xDF, 0x94,
   0x60, 0xCA, 0x26, 0xFD, 0x33, 0x46, 0x21, 0xBB,
   0x2B, 0xC5, 0x98, 0x18, 0x66, 0x15, 0x9C, 0xBC };

unsigned char table_186[256] = {
   0xB7, 0xFA, 0x03, 0x7C, 0x76, 0x43, 0xA7, 0x15,
   0x4B, 0x4F, 0x04, 0xAA, 0x4E, 0xD2, 0x52, 0xC8,
   0x79, 0x16, 0xF6, 0x61, 0x01, 0x5D, 0xD6, 0x47,
   0xDE, 0xC5, 0x4D, 0x2F, 0xF5, 0x29, 0x21, 0xE6,
   0x97, 0x35, 0xDC, 0x0E, 0x8B, 0xF4, 0x0F, 0xBE,
   0x30, 0x07, 0x1D, 0x46, 0x75, 0xCE, 0x56, 0x42,
   0x28, 0x93, 0x84, 0x20, 0xA5, 0xC2, 0x87, 0x45,
   0x1C, 0x6B, 0x55, 0x06, 0xEB, 0xB0, 0xF9, 0x14,
   0x23, 0xF1, 0xFC, 0xD7, 0x98, 0xD1, 0xA4, 0xED,
   0x5B, 0xB1, 0x12, 0x7A, 0xD5, 0x5F, 0x53, 0x88,
   0x95, 0x71, 0xE7, 0x5C, 0xF8, 0x83, 0xC7, 0x49,
   0xDD, 0xDA, 0x0B, 0xC1, 0x70, 0xEC, 0x67, 0xE2,
   0xEA, 0x72, 0x4C, 0x92, 0xA6, 0xE5, 0x59, 0xA9,
   0x3C, 0xFE, 0x0A, 0x65, 0x6E, 0xF3, 0xA3, 0x22,
   0x24, 0x81, 0xF2, 0xCC, 0xD3, 0xA0, 0xDF, 0xDB,
   0xAB, 0x09, 0x13, 0x96, 0x36, 0x9C, 0xEE, 0xD4,
   0x33, 0x5E, 0x26, 0xAE, 0x48, 0x38, 0xFF, 0x08,
   0x1F, 0x6D, 0x02, 0xEF, 0x7E, 0x57, 0x2A, 0x8A,
   0xBA, 0x90, 0xAF, 0xA8, 0x37, 0x8E, 0x9B, 0xC0,
   0x69, 0x32, 0x86, 0xBD, 0x73, 0x6C, 0xB9, 0x31,
   0x66, 0xBF, 0x1B, 0x44, 0x9E, 0xB2, 0xD0, 0xE0,
   0xF0, 0x2C, 0x3F, 0xE1, 0x91, 0x18, 0x19, 0x50,
   0xCA, 0x8F, 0x54, 0xB5, 0x8D, 0x0C, 0x17, 0x39,
   0x8C, 0x00, 0x7F, 0x41, 0xE3, 0x2E, 0x1A, 0x9D,
   0x27, 0xA1, 0x10, 0x34, 0x1E, 0x3A, 0x60, 0x77,
   0xBB, 0xB6, 0x0D, 0x4A, 0x3E, 0x6A, 0xB4, 0xA2,
   0xB3, 0xFD, 0xCD, 0x80, 0x51, 0xAD, 0xCF, 0xBC,
   0x40, 0x74, 0x6F, 0x68, 0x2B, 0xC3, 0xF7, 0x63,
   0xB8, 0x25, 0xC4, 0x62, 0xE9, 0xFB, 0x58, 0x85,
   0x78, 0xCB, 0x9A, 0x3D, 0xE4, 0xC9, 0x89, 0x2D,
   0x64, 0x82, 0xC6, 0x05, 0xD8, 0xAC, 0x99, 0x9F,
   0x11, 0x3B, 0x94, 0xE8, 0x7D, 0x7B, 0xD9, 0x5A };

unsigned char table_187[32] = {
   0x0F, 0x04, 0x1D, 0x1B, 0x15, 0x10, 0x01, 0x0B,
   0x00, 0x17, 0x13, 0x07, 0x1E, 0x1F, 0x08, 0x0A,
   0x19, 0x09, 0x05, 0x06, 0x0C, 0x1A, 0x14, 0x16,
   0x0E, 0x18, 0x03, 0x1C, 0x12, 0x11, 0x0D, 0x02 };

struct yahoo_fn yahoo_fntable[5][96] = 
   {{{ IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 },
     { IDENT, 0, 0 }},
    {{ MULADD, 0x36056CD7, 0x4387 },
     { LOOKUP, (int)table_0, 0 },
     { LOOKUP, (int)table_1, 0 },
     { BITFLD, (int)table_2, 0 },
     { LOOKUP, (int)table_3, 0 },
     { BITFLD, (int)table_4, 0 },
     { MULADD, 0x4ABB534D, 0x3769 },
     { XOR, 0x1D242DA5, 0 },
     { MULADD, 0x3C23132D, 0x339B },
     { XOR, 0x0191265C, 0 },
     { XOR, 0x3DB979DB, 0 },
     { LOOKUP, (int)table_5, 0 },
     { XOR, 0x1A550E1E, 0 },
     { XOR, 0x2F140A2D, 0 },
     { MULADD, 0x7C466A4B, 0x29BF },
     { XOR, 0x2D3F30D3, 0 },
     { MULADD, 0x7E823B21, 0x6BB3 },
     { BITFLD, (int)table_6, 0 },
     { LOOKUP, (int)table_7, 0 },
     { BITFLD, (int)table_8, 0 },
     { LOOKUP, (int)table_9, 0 },
     { BITFLD, (int)table_10, 0 },
     { LOOKUP, (int)table_11, 0 },
     { BITFLD, (int)table_12, 0 },
     { LOOKUP, (int)table_13, 0 },
     { BITFLD, (int)table_14, 0 },
     { MULADD, 0x5B756AB9, 0x7E9B },
     { LOOKUP, (int)table_15, 0 },
     { XOR, 0x1D1C4911, 0 },
     { LOOKUP, (int)table_16, 0 },
     { LOOKUP, (int)table_17, 0 },
     { XOR, 0x46BD7771, 0 },
     { XOR, 0x51AE2B42, 0 },
     { MULADD, 0x2417591B, 0x177B },
     { MULADD, 0x57F27C5F, 0x2433 },
     { LOOKUP, (int)table_18, 0 },
     { LOOKUP, (int)table_19, 0 },
     { XOR, 0x71422261, 0 },
     { BITFLD, (int)table_20, 0 },
     { MULADD, 0x58E937F9, 0x1075 },
     { LOOKUP, (int)table_21, 0 },
     { BITFLD, (int)table_22, 0 },
     { LOOKUP, (int)table_23, 0 },
     { LOOKUP, (int)table_24, 0 },
     { MULADD, 0x0B4C3D13, 0x1597 },
     { BITFLD, (int)table_25, 0 },
     { XOR, 0x0FE07D38, 0 },
     { MULADD, 0x689B4017, 0x3CFB },
     { BITFLD, (int)table_26, 0 },
     { LOOKUP, (int)table_27, 0 },
     { XOR, 0x35413DF3, 0 },
     { MULADD, 0x05B611AB, 0x570B },
     { MULADD, 0x0DA5334F, 0x3AC7 },
     { XOR, 0x47706008, 0 },
     { BITFLD, (int)table_28, 0 },
     { LOOKUP, (int)table_29, 0 },
     { BITFLD, (int)table_30, 0 },
     { XOR, 0x57611B36, 0 },
     { MULADD, 0x314C2CD1, 0x2B5B },
     { XOR, 0x1EF33946, 0 },
     { MULADD, 0x28EA041F, 0x638F },
     { LOOKUP, (int)table_31, 0 },
     { LOOKUP, (int)table_32, 0 },
     { LOOKUP, (int)table_33, 0 },
     { MULADD, 0x511537CB, 0x7135 },
     { MULADD, 0x1CF71007, 0x5E17 },
     { XOR, 0x583D4BCF, 0 },
     { LOOKUP, (int)table_34, 0 },
     { XOR, 0x373E6856, 0 },
     { MULADD, 0x4D595519, 0x1A7D },
     { LOOKUP, (int)table_35, 0 },
     { LOOKUP, (int)table_36, 0 },
     { XOR, 0x0E2A36A7, 0 },
     { LOOKUP, (int)table_37, 0 },
     { LOOKUP, (int)table_38, 0 },
     { BITFLD, (int)table_39, 0 },
     { BITFLD, (int)table_40, 0 },
     { XOR, 0x53F3604F, 0 },
     { BITFLD, (int)table_41, 0 },
     { BITFLD, (int)table_42, 0 },
     { MULADD, 0x1EDC0BA3, 0x7531 },
     { LOOKUP, (int)table_43, 0 },
     { XOR, 0x10DF1038, 0 },
     { BITFLD, (int)table_44, 0 },
     { LOOKUP, (int)table_45, 0 },
     { XOR, 0x4EDE0CAC, 0 },
     { MULADD, 0x2F076EEB, 0x5BCF },
     { XOR, 0x6D86030F, 0 },
     { XOR, 0x3F331713, 0 },
     { LOOKUP, (int)table_46, 0 },
     { MULADD, 0x41CD726F, 0x3F79 },
     { BITFLD, (int)table_47, 0 },
     { XOR, 0x0ECE0054, 0 },
     { MULADD, 0x19B32B03, 0x4AD1 },
     { BITFLD, (int)table_48, 0 },
     { BITFLD, (int)table_49, 0 }},
    {{ MULADD, 0x39731111, 0x419B },
     { XOR, 0x54F7757A, 0 },
     { BITFLD, (int)table_50, 0 },
     { BITFLD, (int)table_51, 0 },
     { LOOKUP, (int)table_52, 0 },
     { LOOKUP, (int)table_53, 0 },
     { MULADD, 0x3CC0256B, 0x7CE7 },
     { XOR, 0x79991847, 0 },
     { MULADD, 0x228F7FB5, 0x472D },
     { MULADD, 0x32DA290B, 0x7745 },
     { XOR, 0x7A28180D, 0 },
     { BITFLD, (int)table_54, 0 },
     { BITFLD, (int)table_55, 0 },
     { MULADD, 0x5C814F8B, 0x227F },
     { LOOKUP, (int)table_56, 0 },
     { MULADD, 0x0B496F6D, 0x412D },
     { XOR, 0x6F4B62DA, 0 },
     { LOOKUP, (int)table_57, 0 },
     { XOR, 0x64973977, 0 },
     { LOOKUP, (int)table_58, 0 },
     { LOOKUP, (int)table_59, 0 },
     { BITFLD, (int)table_60, 0 },
     { LOOKUP, (int)table_61, 0 },
     { LOOKUP, (int)table_62, 0 },
     { XOR, 0x6DD14C92, 0 },
     { LOOKUP, (int)table_63, 0 },
     { BITFLD, (int)table_64, 0 },
     { BITFLD, (int)table_65, 0 },
     { BITFLD, (int)table_66, 0 },
     { LOOKUP, (int)table_67, 0 },
     { XOR, 0x5E6324D8, 0 },
     { LOOKUP, (int)table_68, 0 },
     { LOOKUP, (int)table_69, 0 },
     { LOOKUP, (int)table_70, 0 },
     { BITFLD, (int)table_71, 0 },
     { XOR, 0x62745ED0, 0 },
     { MULADD, 0x102C215B, 0x0581 },
     { LOOKUP, (int)table_72, 0 },
     { LOOKUP, (int)table_73, 0 },
     { LOOKUP, (int)table_74, 0 },
     { MULADD, 0x19511111, 0x12C1 },
     { LOOKUP, (int)table_75, 0 },
     { MULADD, 0x2A6E2953, 0x6977 },
     { LOOKUP, (int)table_76, 0 },
     { XOR, 0x55CD5445, 0 },
     { BITFLD, (int)table_77, 0 },
     { BITFLD, (int)table_78, 0 },
     { MULADD, 0x646C21EB, 0x43E5 },
     { XOR, 0x71DC4898, 0 },
     { XOR, 0x167519CB, 0 },
     { XOR, 0x6D3158F8, 0 },
     { XOR, 0x7EA95BEA, 0 },
     { BITFLD, (int)table_79, 0 },
     { XOR, 0x47377587, 0 },
     { XOR, 0x2D8B6E8F, 0 },
     { MULADD, 0x5E6105DB, 0x1605 },
     { XOR, 0x65B543C8, 0 },
     { LOOKUP, (int)table_80, 0 },
     { BITFLD, (int)table_81, 0 },
     { MULADD, 0x48AF73CB, 0x0A67 },
     { XOR, 0x4FB96154, 0 },
     { LOOKUP, (int)table_82, 0 },
     { BITFLD, (int)table_83, 0 },
     { XOR, 0x622C4954, 0 },
     { BITFLD, (int)table_84, 0 },
     { XOR, 0x20D220F3, 0 },
     { XOR, 0x361D4F0D, 0 },
     { XOR, 0x2B2000D1, 0 },
     { XOR, 0x6FB8593E, 0 },
     { LOOKUP, (int)table_85, 0 },
     { BITFLD, (int)table_86, 0 },
     { XOR, 0x2B7F7DFC, 0 },
     { MULADD, 0x5FC41A57, 0x0693 },
     { MULADD, 0x17154387, 0x2489 },
     { BITFLD, (int)table_87, 0 },
     { BITFLD, (int)table_88, 0 },
     { BITFLD, (int)table_89, 0 },
     { LOOKUP, (int)table_90, 0 },
     { XOR, 0x7E221470, 0 },
     { XOR, 0x7A600061, 0 },
     { BITFLD, (int)table_91, 0 },
     { BITFLD, (int)table_92, 0 },
     { LOOKUP, (int)table_93, 0 },
     { BITFLD, (int)table_94, 0 },
     { MULADD, 0x00E813A5, 0x2CE5 },
     { MULADD, 0x3D707E25, 0x3827 },
     { MULADD, 0x77A53E07, 0x6A5F },
     { BITFLD, (int)table_95, 0 },
     { LOOKUP, (int)table_96, 0 },
     { LOOKUP, (int)table_97, 0 },
     { XOR, 0x43A73788, 0 },
     { LOOKUP, (int)table_98, 0 },
     { BITFLD, (int)table_99, 0 },
     { LOOKUP, (int)table_100, 0 },
     { XOR, 0x55F4606B, 0 },
     { BITFLD, (int)table_101, 0 }},
    {{ BITFLD, (int)table_102, 0 },
     { MULADD, 0x32CA58E3, 0x04F9 },
     { XOR, 0x11756B30, 0 },
     { MULADD, 0x218B2569, 0x5DB1 },
     { XOR, 0x77D64B90, 0 },
     { BITFLD, (int)table_103, 0 },
     { LOOKUP, (int)table_104, 0 },
     { MULADD, 0x7D1428CB, 0x89F6853D },
     { XOR, 0x6F872C49, 0 },
     { XOR, 0x2E484655, 0 },
     { MULADD, 0x1E3349F7, 0x41F5 },
     { LOOKUP, (int)table_105, 0 },
     { BITFLD, (int)table_106, 0 },
     { XOR, 0x61640311, 0 },
     { BITFLD, (int)table_107, 0 },
     { LOOKUP, (int)table_108, 0 },
     { LOOKUP, (int)table_109, 0 },
     { LOOKUP, (int)table_110, 0 },
     { XOR, 0x007044D3, 0 },
     { BITFLD, (int)table_111, 0 },
     { MULADD, 0x5C221625, 0x576F },
     { LOOKUP, (int)table_112, 0 },
     { LOOKUP, (int)table_113, 0 },
     { XOR, 0x2D406BB1, 0 },
     { MULADD, 0x680B1F17, 0x12CD },
     { BITFLD, (int)table_114, 0 },
     { MULADD, 0x12564D55, 0x32B9 },
     { MULADD, 0x21A67897, 0x6BAB },
     { LOOKUP, (int)table_115, 0 },
     { MULADD, 0x06405119, 0x7143 },
     { XOR, 0x351D01ED, 0 },
     { MULADD, 0x46356F6B, 0x0A49 },
     { MULADD, 0x32C77969, 0x72F3 },
     { BITFLD, (int)table_116, 0 },
     { LOOKUP, (int)table_117, 0 },
     { LOOKUP, (int)table_118, 0 },
     { BITFLD, (int)table_119, 0 },
     { LOOKUP, (int)table_120, 0 },
     { BITFLD, (int)table_121, 0 },
     { MULADD, 0x74D52C55, 0x5F43 },
     { XOR, 0x26201CA8, 0 },
     { XOR, 0x7AEB3255, 0 },
     { LOOKUP, (int)table_122, 0 },
     { MULADD, 0x578F1047, 0x640B },
     { LOOKUP, (int)table_123, 0 },
     { LOOKUP, (int)table_124, 0 },
     { BITFLD, (int)table_125, 0 },
     { BITFLD, (int)table_126, 0 },
     { XOR, 0x4A1352CF, 0 },
     { MULADD, 0x4BFB6EF3, 0x704F },
     { MULADD, 0x1B4C7FE7, 0x5637 },
     { MULADD, 0x04091A3B, 0x4917 },
     { XOR, 0x270C2F52, 0 },
     { LOOKUP, (int)table_127, 0 },
     { BITFLD, (int)table_128, 0 },
     { LOOKUP, (int)table_129, 0 },
     { BITFLD, (int)table_130, 0 },
     { MULADD, 0x127549D5, 0x579B },
     { MULADD, 0x0AB54121, 0x7A47 },
     { BITFLD, (int)table_131, 0 },
     { XOR, 0x751E6E49, 0 },
     { LOOKUP, (int)table_132, 0 },
     { LOOKUP, (int)table_133, 0 },
     { XOR, 0x670C3F74, 0 },
     { MULADD, 0x6B080851, 0x7E8B },
     { XOR, 0x71CD789E, 0 },
     { XOR, 0x3EB20B7B, 0 },
     { BITFLD, (int)table_134, 0 },
     { LOOKUP, (int)table_135, 0 },
     { MULADD, 0x58A67753, 0x272B },
     { MULADD, 0x1AB54AD7, 0x4D33 },
     { MULADD, 0x07D30A45, 0x0569 },
     { MULADD, 0x737616BF, 0x70C7 },
     { LOOKUP, (int)table_136, 0 },
     { MULADD, 0x45C4485D, 0x2063 },
     { BITFLD, (int)table_137, 0 },
     { XOR, 0x2598043D, 0 },
     { MULADD, 0x223A4FE3, 0x49A7 },
     { XOR, 0x1EED619F, 0 },
     { BITFLD, (int)table_138, 0 },
     { XOR, 0x6F477561, 0 },
     { BITFLD, (int)table_139, 0 },
     { BITFLD, (int)table_140, 0 },
     { LOOKUP, (int)table_141, 0 },
     { MULADD, 0x4BC13C4F, 0x45C1 },
     { XOR, 0x3B547BFB, 0 },
     { LOOKUP, (int)table_142, 0 },
     { MULADD, 0x71406AB3, 0x7A5F },
     { XOR, 0x2F1467E9, 0 },
     { MULADD, 0x009366D1, 0x22D1 },
     { MULADD, 0x587D1B75, 0x2CA5 },
     { MULADD, 0x213A4BE7, 0x4499 },
     { MULADD, 0x62653E89, 0x2D5D },
     { BITFLD, (int)table_143, 0 },
     { MULADD, 0x4F5F3257, 0x444F },
     { MULADD, 0x4C0E2B2B, 0x19D3 }},
    {{ MULADD, 0x3F867B35, 0x7B3B },
     { MULADD, 0x32D25CB1, 0x3D6D },
     { BITFLD, (int)table_144, 0 },
     { MULADD, 0x50FA1C51, 0x5F4F },
     { LOOKUP, (int)table_145, 0 },
     { XOR, 0x05FE7AF1, 0 },
     { MULADD, 0x14067C29, 0x10C5 },
     { LOOKUP, (int)table_146, 0 },
     { MULADD, 0x4A5558C5, 0x271F },
     { XOR, 0x3C0861B1, 0 },
     { BITFLD, (int)table_147, 0 },
     { LOOKUP, (int)table_148, 0 },
     { MULADD, 0x18837C9D, 0x6335 },
     { BITFLD, (int)table_149, 0 },
     { XOR, 0x7DAB5033, 0 },
     { LOOKUP, (int)table_150, 0 },
     { MULADD, 0x03B87321, 0x7225 },
     { XOR, 0x7F906745, 0 },
     { LOOKUP, (int)table_151, 0 },
     { BITFLD, (int)table_152, 0 },
     { XOR, 0x21C46C2C, 0 },
     { MULADD, 0x2B36757D, 0x028D },
     { BITFLD, (int)table_153, 0 },
     { LOOKUP, (int)table_154, 0 },
     { XOR, 0x106B4A85, 0 },
     { XOR, 0x17640F11, 0 },
     { LOOKUP, (int)table_155, 0 },
     { XOR, 0x69E60486, 0 },
     { LOOKUP, (int)table_156, 0 },
     { MULADD, 0x3782017D, 0x05BF },
     { BITFLD, (int)table_157, 0 },
     { LOOKUP, (int)table_158, 0 },
     { XOR, 0x6BCA53B0, 0 },
     { LOOKUP, (int)table_159, 0 },
     { LOOKUP, (int)table_160, 0 },
     { LOOKUP, (int)table_161, 0 },
     { LOOKUP, (int)table_162, 0 },
     { XOR, 0x0B8236E3, 0 },
     { BITFLD, (int)table_163, 0 },
     { MULADD, 0x5EE51C43, 0x4553 },
     { BITFLD, (int)table_164, 0 },
     { LOOKUP, (int)table_165, 0 },
     { LOOKUP, (int)table_166, 0 },
     { LOOKUP, (int)table_167, 0 },
     { MULADD, 0x42B14C6F, 0x5531 },
     { XOR, 0x4A2548E8, 0 },
     { MULADD, 0x5C071D85, 0x2437 },
     { LOOKUP, (int)table_168, 0 },
     { MULADD, 0x29195861, 0x108B },
     { XOR, 0x24012258, 0 },
     { LOOKUP, (int)table_169, 0 },
     { XOR, 0x63CC2377, 0 },
     { XOR, 0x08D04B59, 0 },
     { MULADD, 0x3FD30CF5, 0x7027 },
     { XOR, 0x7C3E0478, 0 },
     { MULADD, 0x457776B7, 0x24B3 },
     { XOR, 0x086652BC, 0 },
     { MULADD, 0x302F5B13, 0x371D },
     { LOOKUP, (int)table_170, 0 },
     { MULADD, 0x58692D47, 0x0671 },
     { XOR, 0x6601178E, 0 },
     { MULADD, 0x0F195B9B, 0x1369 },
     { XOR, 0x07BA21D8, 0 },
     { BITFLD, (int)table_171, 0 },
     { BITFLD, (int)table_172, 0 },
     { XOR, 0x13AC3D21, 0 },
     { MULADD, 0x5BCF3275, 0x6E1B },
     { MULADD, 0x62725C5B, 0x16B9 },
     { MULADD, 0x5B950FDF, 0x2D35 },
     { BITFLD, (int)table_173, 0 },
     { BITFLD, (int)table_174, 0 },
     { MULADD, 0x73BA5335, 0x1C13 },
     { BITFLD, (int)table_175, 0 },
     { BITFLD, (int)table_176, 0 },
     { XOR, 0x3E144154, 0 },
     { MULADD, 0x4EED7B27, 0x38AB },
     { LOOKUP, (int)table_177, 0 },
     { MULADD, 0x627C7E0F, 0x7F01 },
     { MULADD, 0x5D7E1F73, 0x2C0F },
     { LOOKUP, (int)table_178, 0 },
     { MULADD, 0x55C9525F, 0x4659 },
     { XOR, 0x3765334C, 0 },
     { MULADD, 0x5DF66DDF, 0x7C25 },
     { LOOKUP, (int)table_179, 0 },
     { LOOKUP, (int)table_180, 0 },
     { XOR, 0x16AE5776, 0 },
     { LOOKUP, (int)table_181, 0 },
     { LOOKUP, (int)table_182, 0 },
     { BITFLD, (int)table_183, 0 },
     { BITFLD, (int)table_184, 0 },
     { LOOKUP, (int)table_185, 0 },
     { MULADD, 0x4392327B, 0x7E0D },
     { LOOKUP, (int)table_186, 0 },
     { MULADD, 0x3D8B0CB5, 0x640D },
     { MULADD, 0x32865601, 0x4D43 },
     { BITFLD, (int)table_187, 0 }}};

#define A( x ) (( x ) & 0xFF )
#define B( x ) (( x ) >> 8 & 0xFF )
#define C( x ) (( x ) >> 16 & 0xFF )
#define D( x ) (( x ) >> 24 & 0xFF )

int yahoo_xfrm( int table, int depth, int seed )
{
   struct yahoo_fn *xfrm;
   int i, j, z;
   unsigned int n = seed;
   unsigned char *arg;

   for( i = 0; i < depth; i++ )
   {
      xfrm = &yahoo_fntable[table][n % 96];
      switch( xfrm->type )
      {
      case IDENT:
         return seed;
      case XOR:
         seed ^= xfrm->arg1;
         break;
      case MULADD:
         seed = seed * xfrm->arg1 + xfrm->arg2;
         break;
      case LOOKUP:
         arg = (unsigned char *)xfrm->arg1;
         seed = arg[A( seed )] | arg[B( seed )] << 8 | arg[C( seed )] << 16
            | arg[D( seed )] << 24;
         break;
      case BITFLD:
         arg = (unsigned char *)xfrm->arg1;
         for( j = 0, z = 0; j < 32; j++ )
            z = ((( seed >> j ) & 1 ) << arg[j] ) | ( ~( 1 << arg[j] ) & z );
         seed = z;
         break;
      }
      if( depth - i == 1 )
         return seed;
      z = (((((( A( seed ) * 0x9E3779B1 ) ^ B( seed )) * 0x9E3779B1 )
         ^ C( seed )) * 0x9E3779B1 ) ^ D( seed )) * 0x9E3779B1;
      n = (((( z ^ ( z >> 8 )) >> 16 ) ^ z ) ^ ( z >> 8 )) & 0xFF;
      seed *= 0x00010DCD;
   }
   return seed;
}
