.TH "ZIP_FILE_EXTRA_FIELD_SET" "3" "February 20, 2013" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_file_extra_field_set\fR
\- set extra field for file in zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIint\fR
.br
\fBzip_file_extra_field_set\fR(\fIstruct zip *archive\fR,\ \fIzip_uint64_t index\fR,\ \fIzip_uint16_t extra_field_id\fR,\ \fIzip_uint16_t extra_field_index\fR,\ \fIconst zip_uint8_t *extra_field_data\fR,\ \fIzip_uint16_t len\fR,\ \fIzip_flags_t flags\fR);
.SH "DESCRIPTION"
The
\fBzip_file_extra_field_set\fR()
function sets the extra field with ID (two-byte signature)
\fIextra_field_id\fR
and index
\fIextra_field_index\fR
for the file at position
\fIindex\fR
in the zip archive.
The extra field's data will be set to
\fIextra_field_data\fR
and length
\fIlen\fR.
If a new entry shall be appended, set
\fIextra_field_index\fR
to
\fRZIP_EXTRA_FIELD_NEW\fR.
.PP
At least one of the following
\fIflags\fR
must be set:
.RS 6n
.TP 18n
\fRZIP_FL_CENTRAL\fR
Set extra field in the archive's central directory.
.TP 18n
\fRZIP_FL_LOCAL\fR
Set extra field in the local file headers.
.RE
.PP
Please note that the extra field IDs 0x0001 (ZIP64 extension),
0x6375 (Infozip UTF-8 comment), and
0x7075 (Infozip UTF-8 file name) can not be set using
\fBzip_file_extra_field_set\fR()
since they are set by
libzip(3)
automatically when needed.
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error code in
\fIarchive\fR
is set to indicate the error.
.SH "ERRORS"
\fBzip_file_extra_field_set\fR()
fails if:
.TP 19n
[\fRZIP_ER_INVAL\fR]
The extra field size is too large (ID and length need 4 bytes; the
maximum length of all extra fields for one file combined is 65536
bytes).
This error also occurs if
\fIextra_field_index\fR
is too large.
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.TP 19n
[\fRZIP_ER_NOENT\fR]
\fIindex\fR
is not a valid file index in
\fIarchive\fR.
.SH "SEE ALSO"
libzip(3),
zip_file_extra_field_delete(3),
zip_file_extra_field_get(3),
zip_file_extra_fields_count(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
