.TH "ZIP_FILE_SET_COMMENT" "3" "September 19, 2013" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_file_set_comment\fR
\- set comment for file in zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIint\fR
.br
\fBzip_set_file_comment\fR(\fIstruct zip *archive\fR,\ \fIzip_uint64_t index\fR,\ \fIconst char *comment\fR,\ \fIzip_uint16_t len\fR,\ \fIzip_flags_t flags\fR);
.SH "DESCRIPTION"
The
\fBzip_file_set_comment\fR()
function sets the comment for the file at position
\fIindex\fR
in the zip archive to
\fIcomment\fR
of length
\fIlen\fR.
If
\fIcomment\fR
is
\fRNULL\fR
and
\fIlen\fR
is 0, the file comment will be removed.
The
\fIflags\fR
argument can be any of:
.TP 22n
\fRZIP_FL_ENC_GUESS\fR
Guess encoding of
\fIcomment\fR
(default).
.TP 22n
\fRZIP_FL_ENC_UTF_8\fR
Interpret
\fIcomment\fR
as UTF-8.
.TP 22n
\fRZIP_FL_ENC_CP437\fR
Interpret
\fIcomment\fR
as code page 437 (CP-437).
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error information in
\fIarchive\fR
is set to indicate the error.
.SH "ERRORS"
\fBzip_file_set_comment\fR()
fails if:
.TP 19n
[\fRZIP_ER_INVAL\fR]
\fIindex\fR
is not a valid file index in
\fIarchive\fR,
or
\fIlen\fR
is less than 0 or longer than the maximum comment length in a zip file
(65535), or
\fIcomment\fR
is not a valid UTF-8 encoded string.
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.TP 19n
[\fRZIP_ER_RDONLY\fR]
The
\fIarchive\fR
was opened in read-only mode.
.SH "SEE ALSO"
libzip(3),
zip_get_archive_comment(3),
zip_file_get_comment(3),
zip_set_archive_comment(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
