.\" Converted with mdoc2man 0.2
.\" from NiH: zip_stat.mdoc,v 1.12 2006/12/16 10:12:58 wiz Exp 
.\" $NiH: zip_stat.mdoc,v 1.12 2006/12/16 10:12:58 wiz Exp $
.\"
.\" zip_stat.mdoc \-- get information about file
.\" Copyright (C) 2003, 2004, 2005, 2006 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <nih@giga.or.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_STAT 3 "December 16, 2006" NiH
.SH "NAME"
zip_stat , \- .Nm zip_stat_index
get information about file
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
#include <zip.h>
.PP
int
zip_stat(struct zip *archive, const char *fname, int flags, struct zip_stat *sb);
.PP
int
zip_stat_index(struct zip *archive, int index, int flags, struct zip_stat *sb);
.SH "DESCRIPTION"
The
zip_stat
function obtains information about the file named
\fBfname\fR
in
\fBarchive.\fR
The
\fBflags\fR
argument specifies how the name lookup should be done.
Its values are described in
zip_name_locate(3).
Also,
\fBZIP_FL_UNCHANGED\fR
may be
.I or'ed
to it to request information about the original file in the archive,
ignoring any changes made.
.PP
The
zip_stat_index
function obtains information about the file at position
\fBindex.\fR
.PP
The
\fBsb\fR
argument is a pointer to a
.PP
struct zip_stat
(shown below), into which information about the file is placed.
.Bd \-literal
struct zip_stat {
    const char *name;			/* name of the file */
    int index;				/* index within archive */
    unsigned int crc;			/* crc of file data */
    unsigned int size;			/* size of file (uncompressed) */
    time_t mtime;			/* modification time */
    unsigned int comp_size;		/* size of file (compressed) */
    unsigned short comp_method;		/* compression method used */
    unsigned short encryption_method;	/* encryption method used */
};
.Ed
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error information in
\fBarchive\fR
is set to indicate the error.
.SH "ERRORS"
The function
zip_stat
can fail for any of the errors specified for the routine
zip_name_locate(3).
.PP
The function
zip_stat_index
fails and sets the error information to
ZIP_ER_INVAL
if
\fBindex\fR
is invalid.
If
\fBZIP_FL_UNCHANGED\fR
is not set and no information can be obtained from the source
callback, the error information is set to
ZIP_ER_CHANGED.
.SH "SEE ALSO"
libzip(3),
zip_name_locate(3),
zip_stat_init(3)
.SH "AUTHORS"

Dieter Baron <dillo@giga.or.at>
and
Thomas Klausner <tk@giga.or.at>
