/***************************************************************************
 *
 * Copyright (c) 2000,2001,2002 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: cap.h,v 1.4.2.2 2003/09/16 19:40:28 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_CAP_H_INCLUDED
#define ZORP_CAP_H_INCLUDED


#include <zorp/zorplib.h>

#ifdef __cplusplus
extern "C" {
#endif

#if ZORPLIB_ENABLE_CAPS

#if HAVE_SYS_CAPABILITY_H
#include <sys/capability.h>
#endif

extern const gchar *zorp_caps;

gboolean cap_modify(int capability, int onoff);
cap_t cap_save(void);
gboolean cap_restore(cap_t r);

#define cap_enable(cap) cap_modify(cap, TRUE)
#define cap_disable(cap) cap_modify(cap, FALSE)

#else

typedef int cap_t;

#define CAP_NET_ADMIN 0
#define CAP_NET_BIND_SERVICE 0

#define cap_save() 0
#define cap_restore(r)
#define cap_enable(cap)
#define cap_disable(cap)

#endif

#ifdef __cplusplus
}
#endif

#endif

