/***************************************************************************
 *
 * Copyright (c) 2000,2001,2002 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: poll.h,v 1.6.2.1 2003/04/11 19:15:54 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_POLL_H_INCLUDED
#define ZORP_POLL_H_INCLUDED

#include <zorp/zorplib.h>
#include <zorp/stream.h>

#ifdef __cplusplus
extern "C" {
#endif

/*+

  ZPoll interface encapsulates a poll() loop.

  +*/
typedef struct _ZPoll ZPoll;

ZPoll *z_poll_new(void);
void z_poll_ref(ZPoll *);
void z_poll_unref(ZPoll *);

void z_poll_wakeup(ZPoll *s);

void z_poll_add_stream(ZPoll *s, struct _ZStream *channel);

void z_poll_remove_stream(ZPoll *s, ZStream *stream);

#define z_poll_iter(s) z_poll_iter_timeout(s, -1)

guint z_poll_iter_timeout(ZPoll *s, gint timeout);

gboolean z_poll_is_running(ZPoll *s);

void z_poll_quit(ZPoll *s);

GMainContext *z_poll_get_context(ZPoll *s);

#ifdef __cplusplus
}
#endif

#endif
