#ifndef ZORPLIB_RANDOM_H_INCLUDED
#define ZORPLIB_RANDOM_H_INCLUDED

#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif

#define Z_RANDOM_STRONG 0
#define Z_RANDOM_BASIC  1
#define Z_RANDOM_WEAK   2

gboolean z_random_sequence_get_bounded(guchar *target,
                                        guint  len,
                                       guchar  min,
                                       guchar  max,
                                        guint  type);

#define z_random_sequence_get(target, len, type) z_random_sequence_get_bounded(target, len, 0, 255, type)

#ifdef __cplusplus
}
#endif

#endif
