/***************************************************************************
 *
 * Copyright (c) 2000,2001,2002 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: sockaddr.h,v 1.13.2.3 2003/04/11 19:15:54 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_SOCKADDR_H_INCLUDED
#define ZORP_SOCKADDR_H_INCLUDED

#include <zorp/zorplib.h>

#include <sys/types.h>
#ifdef HAVE_UNISTD_H
  #include <unistd.h>
#endif
#include <errno.h>
#include <sys/types.h>

#ifdef G_OS_WIN32
#  include <winsock2.h>
#  define socklen_t int
#else
#  include <sys/socket.h>
#  include <sys/un.h>
#  include <netinet/in.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define MAX_SOCKADDR_STRING	128

/* sockaddr public interface */

#define ZSA_LOCAL		0x0001 /* within host */

typedef struct _ZSockAddrFuncs ZSockAddrFuncs;

typedef struct _ZSockAddr
{
  gint refcnt;
  guint32 flags;
  ZSockAddrFuncs *sa_funcs;
  int salen;
  struct sockaddr sa;
} ZSockAddr;

struct _ZSockAddrFuncs 
{
  GIOStatus (*sa_bind_prepare)   (int sock, ZSockAddr *addr);
  GIOStatus (*sa_bind)		(int sock, ZSockAddr *addr);
  ZSockAddr *(*sa_clone)        (ZSockAddr *addr, gboolean wildcard_clone);
  gchar   *(*sa_format)         (ZSockAddr *addr,   /* format to text form */
  				 gchar *text,
  				 gulong n);
  void     (*freefn)            (ZSockAddr *addr);
};

ZSockAddr *z_sockaddr_new(struct sockaddr *sa, int salen);
ZSockAddr *z_sockaddr_new_copy(struct sockaddr *sa, int salen);
gchar *z_sockaddr_format(ZSockAddr *a, gchar *text, gulong n);
ZSockAddr *z_sockaddr_ref(ZSockAddr *a);
void z_sockaddr_unref(ZSockAddr *a);

ZSockAddr *z_sockaddr_inet_new(const gchar *ip, guint16 port);
ZSockAddr *z_sockaddr_inet_new2(struct sockaddr_in *sin);
ZSockAddr *z_sockaddr_inet_range_new(const gchar *ip, guint16 min_port, guint16 max_port);

guint z_sockaddr_inet_get_address(ZSockAddr *s);
guint z_sockaddr_inet_get_port(ZSockAddr *s);
gboolean z_sockaddr_inet_check(ZSockAddr *s);

#if ZORPLIB_ENABLE_IPOPTIONS
void z_sockaddr_inet_get_options(ZSockAddr *s, gpointer *options, guint *options_length);
void z_sockaddr_inet_set_options(ZSockAddr *s, gpointer options, guint options_length);
#endif

#ifndef G_OS_WIN32
ZSockAddr *z_sockaddr_unix_new(const gchar *name);
ZSockAddr *z_sockaddr_unix_new2(struct sockaddr_un *s_un, int sunlen);
#endif

static inline ZSockAddr *
z_sockaddr_clone(ZSockAddr *addr, gboolean wildcard_clone)
{
  return addr->sa_funcs->sa_clone(addr, wildcard_clone);
}

gchar *z_inet_ntoa(char *buf, size_t bufsize, struct in_addr a);
gboolean z_inet_aton(const char *buf, struct in_addr *a);

#ifdef __cplusplus
}
#endif

#endif
