/***************************************************************************
 *
 * Copyright (c) 2000,2001,2002 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: zorplib.h,v 1.9.2.1 2003/04/11 19:15:54 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORPLIB_H_INCLUDED
#define ZORPLIB_H_INCLUDED


#include <glib.h>

#ifdef G_OS_WIN32
#  ifdef COMPILING_LIBZORPLL
#    define LIBZORPLL_DLLIMPEX __declspec(dllexport)
#  else
#    define LIBZORPLL_DLLIMPEX __declspec(dllimport)
#  endif
#else
#  define LIBZORPLL_DLLIMPEX
#endif

#include <zorp/zorplibconfig.h>
#include <zorp/misc.h>

#include <zorp/memtrace.h>

#ifdef __cplusplus
extern "C" {
#endif

#define CORE_DEBUG      "core.debug"
#define CORE_ERROR      "core.error"
#define CORE_LICENSE    "core.license"
#define CORE_TRACE      "core.trace"
#define CORE_ACCOUNTING "core.accounting"
#define CORE_INFO       "core.info"
#define CORE_STDERR     "core.stderr"
#define CORE_AUTH       "core.auth"
#define CORE_DUMP       "core.dump"
#define CORE_CAPS       "core.caps"
#define CORE_SESSION    "core.session"

#ifdef __cplusplus
}
#endif

#endif
