/***************************************************************************
 *
 * This file is covered by a dual licence. You can choose whether you
 * want to use it according to the terms of the GNU GPL version 2, or
 * under the terms of Zorp Professional Firewall System EULA located
 * on the Zorp installation CD.
 *
 * $Id: misc.h,v 1.20 2004/06/21 14:10:47 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_MISC_H_INCLUDED
#define ZORP_MISC_H_INCLUDED

#include <sys/types.h>
#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif

#define MAX_REF 512*1024

typedef struct _ZCharSet
{
  guint32 enable_mask[256 / 32];
} ZCharSet;

void z_charset_init(ZCharSet *self);
gboolean z_charset_parse(ZCharSet *self, gchar *spec);
gboolean z_charset_is_string_valid(ZCharSet *self, gchar *str, gint len);

static inline void 
z_charset_enable(ZCharSet *self, char chr)
{
  guint ndx = ((guchar) chr) >> 5;
  guint bit = 1 << (((guchar) chr) & 0x1F);
  
  self->enable_mask[ndx] |= bit;
}

static inline gboolean
z_charset_is_enabled(ZCharSet *self, char chr)
{
  guint ndx = ((guchar) chr) >> 5;
  guint bit = 1 << (((guchar) chr) & 0x1F);
  
  return !!(self->enable_mask[ndx] & bit);
}

void z_data_dump(char *session_id, const char *buf, guint len);

GString *g_string_assign_len(GString *s, gchar *val, gint len);

gchar *z_str_escape(const gchar *s, gint len);
gchar *z_str_compress(const gchar *s, gint len);

gboolean z_port_enabled(gchar *port_range, guint port);

void z_crypt(const char *key, const char *salt, char *result, size_t result_len);

gboolean z_casestr_equal(gconstpointer k1, gconstpointer k2);
guint z_casestr_hash(gconstpointer key);

static inline void
z_incref(guint *ref)
{
  (*ref)++;
  g_assert(*ref < MAX_REF);
}

static inline guint
z_decref(guint *ref)
{
  (*ref)--;
  g_assert(*ref < MAX_REF);
  
  return *ref;
}

gchar *z_zorplib_version_info(void);

#ifdef __cplusplus
}
#endif

#endif
