/***************************************************************************
 *
 * This file is covered by a dual licence. You can choose whether you
 * want to use it according to the terms of the GNU GPL version 2, or
 * under the terms of Zorp Professional Firewall System EULA located
 * on the Zorp installation CD.
 *
 * $Id: process.c,v 1.7 2004/01/09 10:44:31 sasa Exp $
 *
 * Author  : Bazsi, SaSa, Chaoron
 * Auditor :
 * Last audited version:
 * Notes:
 *
 ***************************************************************************/

#include <zorp/zorplib.h>
#include <zorp/process.h>
#include <errno.h>

#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#ifdef HAVE_UNISTD_H
  #include <unistd.h>
#endif
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>


#ifdef G_OS_WIN32
#  include <windows.h>
#endif


#ifdef G_OS_WIN32


typedef DWORD (WINAPI *fp_RegServProc)(DWORD dwProcessId,DWORD dwType);

gboolean
z_process_daemonize(uid_t uid, gid_t gid, const gchar *pidfile)
{
  HMODULE hModule;
  fp_RegServProc regsrvproc=NULL;
  DWORD res;

  res = 0;
  hModule = GetModuleHandle(TEXT("kernel32.dll"));
  if (hModule != NULL)
    {
      regsrvproc = (fp_RegServProc)GetProcAddress(hModule,"RegisterServiceProcess");
      if (regsrvproc != NULL)
        res = (*regsrvproc) (0,1);
      FreeLibrary(hModule);
    }
  return res;

  /* void::FIXME impersonation */
}

#else

static int filedes[2] = {-1, -1};

gboolean
z_process_daemonize(const gchar *progname, uid_t uid, gid_t gid, const gchar *pidfile)
{
  pid_t pid;
  FILE *fd;
  guint ret_num;
  gchar ret_buf[5];
  
  if (pipe(filedes) != 0)
    {
      fprintf(stderr, "%s: Error daemonizing process, cannot open pipe; error='%s'\n", progname, g_strerror(errno));
      return FALSE;
    }
  
  if ((pid = fork()) < 0)
    {
      fprintf(stderr, "%s: Error forking child process; error='%s'\n", progname, g_strerror(errno));
      return FALSE;
    }
  else if (pid != 0)
    {
      close(filedes[1]);
      memset(ret_buf, 0, sizeof(ret_buf));
      if (read(filedes[0], ret_buf, sizeof(ret_buf)) > 0)
        ret_num = atoi(ret_buf);
      else
        ret_num = 1;
      if (ret_num == 0)
        {
          if (pidfile != NULL)
            {
              fd = fopen(pidfile, "w");
              if (fd != NULL)
                {
                  fprintf(fd, "%d\n", (int) pid);
                  fclose(fd);
                }
              else
                {
                  fprintf(stderr, "%s: Error creating pid file; file='%s', error='%s'\n", progname, pidfile, g_strerror(errno));
                }
            }
        }
      exit(ret_num);
    }
  
  close(filedes[0]);
  if (setsid() < 0)
    {
      fprintf(stderr, "%s: Error becoming process group leader; error='%s'\n", progname, g_strerror(errno));
      return FALSE;
    }
    
  chdir("/");
  umask(0);
  
  if (gid != (gid_t) -1)
    {
      if (setgid(gid) < 0)
        {
	  fprintf(stderr, "%s: Error setting group id; gid='%d', error='%s'\n", progname, gid, g_strerror(errno));
          return FALSE;
        }
    }

  if (uid != (uid_t) -1)
    {
      if (setuid(uid) < 0)
        {
	  fprintf(stderr, "%s: Error setting user id; uid='%d', error='%s'\n", progname, uid, g_strerror(errno));
          return FALSE;
        }
    }

  close(STDIN_FILENO);
  
  return TRUE;
}

void
z_process_failed(guint ret_num, gboolean may_exit)
{
  gchar buf[10];
  guint buf_len;
  
  if (filedes[1] != -1)
    {
      buf_len = g_snprintf(buf, sizeof(buf), "%d", ret_num);
      write(filedes[1], buf, buf_len);
    }
  
  if (may_exit)
    exit(ret_num);
}

void
z_process_ok(void)
{
  if (filedes[1] != -1)
    write(filedes[1], "0", 1);
}

#endif
