/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*

   API for double precision versions of Magics++
   

*/
#include <iostream>

extern "C"
{
#include <magics_api.h>


void psetr_(char* name, double* value, int length)
{
	std::string n(name, length);
	mag_setr(n.c_str(), *value);
}

void pset1r_(char* name, double* data, int* dim, int length)
{
	std::string n(name, length);
	mag_set1r(n.c_str(), data, *dim);
}

void pset2r_(char* name, double* data, int *dim, int *dim2, int length)
{    
	std::string n(name, length);
	mag_set2r(n.c_str(), data, *dim, *dim2);
}

void pset3r_(char* name, double* data, int* dim, int *dim2, int* dim3, int length)
{    
	std::string n(name, length);
	mag_set3r(n.c_str(), data, *dim, *dim2, *dim3);
}

void penqr_(char* name, double* value, int length)
{
	std::string n(name, length);
	mag_enqr( n.c_str(), value);
	
}

}
