/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file Visdef.h
    \brief Definition of the Template class Visdef.
    
    Magics Team - ECMWF 2007
    
    Started: Fri 16-Mar-2007
    
    Changes:
    
*/

#ifndef Visdef_H
#define Visdef_H

#include "magics.h"
#include "BasicSceneObject.h"
#include "Data.h"


namespace magics {

class MetaDataVisitor;
class Transformation;
class HistoVisitor;

template <class P>
class Visdef : public MetviewIcon  {

public:
	Visdef() {}
	virtual ~Visdef() {}
	

	virtual void operator()(Data<P>&, BasicGraphicsObjectContainer&) = 0;
	virtual void visit(LegendVisitor&) {}
	virtual void visit(Data<P>&, HistoVisitor&)  
	{ 
		Log::dev() << "Here could build a basic histogram!" << endl; 
	}
    virtual void visit(MetaDataVisitor&) {} 
    virtual void visit(Transformation&, Data<P>&) {}
    virtual void visit(Layer& layer) { MetviewIcon::visit(layer); }
protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream& out) const { 
	 	out << "visdef"; 
	 }
	 
private:
    //! Copy constructor - No copy allowed
	Visdef(const Visdef&);
    //! Overloaded << operator to copy - No copy allowed
	Visdef& operator=(const Visdef&);
    
// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const Visdef<P>& p)
		{ p.print(s); return s; }

};

} // namespace magics

#endif
