/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file Axis.h
    \brief Definition of the Template class Axis.
    
    Magics Team - ECMWF 2004
    
    Started: Fri 7-May-2004
    
    Changes:
    
*/

#ifndef Axis_H
#define Axis_H

#include "magics.h"

#include "BasicSceneObject.h"
#include "AxisAttributes.h"
#include "XmlNode.h"
#include "MagicsEvent.h"
namespace magics {
	
class XmlNode;

class SceneLayer;
class LayoutVisitor;

class Axis: public BasicSceneObject, public AxisAttributes,public MetviewIcon {

public:
	Axis();
	virtual ~Axis();
    
 
    
    void set(const XmlNode& node ) { AxisAttributes::set(node); }
    void set(const map<string, string>& map ) { AxisAttributes::set(map); }
    
    void visit(SceneLayer& layer, vector<LayoutVisitor*>& visitors);

   

protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 
     void ticks(double, double, vector<double>&);
     AxisItems items_;
   
     
private:
    //! Copy constructor - No copy allowed
	Axis(const Axis&);
    //! Overloaded << operator to copy - No copy allowed
	Axis& operator=(const Axis&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const Axis& p)
		{ p.print(s); return s; }

};


class HorizontalAxis : public Axis 
{
public :
    HorizontalAxis();
    ~HorizontalAxis() {}
    
    template <class V> 
    void build(V& visitor) {
    	if ( items_ .empty() )  {   		
    		// here we update the method depending of the transformation...
    		string method = visitor.transformation().xAxisType(); 
    		//this->setMethod(Translator<string, AxisMethod>()(method));
    		method_->updateX(visitor.transformation());
    	    method_->prepare( visitor.transformation().getMinX(),  visitor.transformation().getMaxX(), items_);
    	}
    	(*tick_).horizontal(items_, (*line_).colour(), visitor);
    	(*minor_tick_).horizontal(items_, (*line_).colour(), visitor);
    	(*label_).horizontal(items_, (*line_).colour(), visitor);
    	tip_->horizontal((*line_).colour(), visitor);
    	
    	(*line_).horizontal(visitor);
    	(*title_).horizontal((*line_).colour(), visitor);
    }
    
    void visit(DrawingVisitor& visitor) {
    	if ( items_ .empty() ) {
    		string method = visitor.transformation().xAxisType(); 
    		//this->setMethod(Translator<string, AxisMethod>()(method));
    		method_->updateX(visitor.transformation());
    		method_->prepare( visitor.transformation().getMinX(),  visitor.transformation().getMaxX(), items_);
    	}
    	(*grid_).vertical(items_, visitor);
    }
    
    void visit(TopAxisVisitor& visitor) {
    	if ( magCompare(position_, "top") )
    		build(visitor); 
    }
    void visit(BottomAxisVisitor& visitor) {  
    	if ( magCompare(position_, "bottom") ) 
    		build(visitor); 
    }
    
    void set(const XmlNode& node) { 
    	if ( magCompare(node.name(), "horizontal_axis") ) {
    		XmlNode axis = node;
    		axis.name("axis");    		
    		AxisAttributes::set(axis);
    	} 
    }

  
};

class VerticalAxis : public Axis 
{
public :
    VerticalAxis();
    ~VerticalAxis() {}
    template <class V>
    void build(V& visitor) {
    	if ( items_ .empty() ) {
    		
    			string method = visitor.transformation().yAxisType(); 
    			// do that later! this->setMethod(Translator<string, AxisMethod>()(method));
          		method_->updateX(visitor.transformation());
          		method_->prepare( visitor.transformation().getMinY(),  visitor.transformation().getMaxY(), items_);
       }
       (*tick_).vertical(items_, (*line_).getColour(), visitor);
       (*minor_tick_).vertical(items_, (*line_).getColour(), visitor);
       (*label_).vertical(items_,(*line_).getColour(), visitor);
       tip_->vertical((*line_).colour(), visitor);
       (*grid_).horizontal(items_, visitor);
       (*line_).vertical(visitor);
       (*title_).vertical((*line_).getColour(), visitor);
        
    }
    void visit(DrawingVisitor& visitor) {
      	if ( items_ .empty() ) {
      		string method = visitor.transformation().yAxisType(); 
      		// do that later! this->setMethod(Translator<string, AxisMethod>()(method));
      		method_->updateY(visitor.transformation());
      		method_->prepare( visitor.transformation().getMinY(),  visitor.transformation().getMaxY(), items_);
      	}
      	(*grid_).horizontal(items_, visitor);
      }
    void visit(LeftAxisVisitor& visitor) { 
    	if ( magCompare(position_, "left") )
    		build(visitor); 
    }
    void visit(RightAxisVisitor& visitor) { 	
    	if ( magCompare(position_, "right") )
    		build(visitor); 
    }
    void set(const XmlNode& node) { 
    	if ( magCompare(node.name(), "vertical_axis") ) {
    		XmlNode axis = node;
    		axis.name("axis");    		
    		AxisAttributes::set(axis);
    	} 
    }

};

} // namespace magics
#endif
