/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file Bar.cc
    \brief Implementation of the Template class Bar.
    
    Magics Team - ECMWF 2004
    
    Started: Wed 5-May-2004
    
    Changes:
    
*/



#include "Bar.h"
#include "PointsHandler.h"
#include "LegendVisitor.h"

using namespace magics;

Bar::Bar() 
{}


Bar::~Bar() 
{}

/*!
 Class information are given to the output-stream.
*/		
void Bar::print(ostream& out)  const
{
	out << "Bar[";
	out << "]";
}



void Bar::operator()(Data<UserPoint>& data, BasicGraphicsObjectContainer& out)
{
	vector<double> xpos;
	
	vector<double> ypos;
    
    const Transformation& transformation= out.transformation();


	CustomisedPointsList points; 
	std::set<string> request;
	data.customisedPoints(request, points);
	if (points.empty()) return;
	double previous =  (**points.begin())["x_upper"];
	double next =  (**points.begin())["x_upper"];
	double x, top, bottom, left, right;
	
	if (width_ == int_MAX) {
		if ( points.size() > 1 ) 
			width_ = abs((*points[0])["x_upper"] - (*points[1])["x_upper"])*0.8; 
		else 
			width_ = abs((*points[0])["x_upper"] - (*points[1])["x_upper"]);
			 
	}
	
	
	for (CustomisedPointsList::const_iterator point = points.begin(); point != points.end(); ++point)
	{
		
		x = (**point)["x_upper"];
		next = ((point+1) != points.end() ) ? (**(point+1))["x_upper"] : x;
		bottom = (**point)["y_lower"];
		top = (**point)["y_upper"];
		left = x - width_/2;
		right = x + width_/2;
		previous = x;
		Polyline* box  = new Polyline();
		box->setColour(*line_colour_);
		
		box->setThickness(thickness_);
		box->setLineStyle(style_);
		
		box->push_back(transformation(UserPoint(left, bottom)));
		box->push_back(transformation(UserPoint(left, top)));
		box->push_back(transformation(UserPoint(right, top)));
		box->push_back(transformation(UserPoint(right, bottom)));
		box->push_back(transformation(UserPoint(left, bottom)));
		
		
		(*shade_)(*box);
		
	
		
		out.push_back(box);			
	}


}







void Bar::visit(LegendVisitor& legend)
{
	if ( !legend_) return;
	Polyline* curve  = new Polyline();
	(*curve).setColour(*colour_);
	(*curve).setLineStyle(style_);
	(*curve).setThickness(thickness_);
  
     curve->setFilled(true);
	 
	 shade_->legend(*curve);
		   		
	
    
	LegendEntry * entry = new BoxEntry(legend_text_, curve);

	legend.add(entry);
}
