/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file BoxPlotWhiskerBoxAttributes.cc
    \brief Implemtation of BoxPlotWhiskerBox Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Thu Jun 16 12:02:58 2011
*/    

#include "BoxPlotWhiskerBoxAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


BoxPlotWhiskerBoxAttributes::BoxPlotWhiskerBoxAttributes():
	colour_(Translator<string, Colour>().magics("boxplot_whisker_box_colour")),
	width_(ParameterManager::getDouble("boxplot_whisker_box_width")),
	border_(Translator<string, NoBoxPlotWhiskerBorder>().magics("boxplot_whisker_box_border"))
{
} 



BoxPlotWhiskerBoxAttributes::~BoxPlotWhiskerBoxAttributes()
{
}

    
void BoxPlotWhiskerBoxAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(3);
	prefix[0] = "boxplot_whisker_box";
	prefix[1] = "boxplot_whisker";
	prefix[2] = "boxplot";

	setAttribute(prefix, "boxplot_whisker_box_colour", colour_, params);
	setAttribute(prefix, "boxplot_whisker_box_width", width_, params);
	setMember(prefix, "boxplot_whisker_box_border", border_, params);
}

void BoxPlotWhiskerBoxAttributes::copy(const BoxPlotWhiskerBoxAttributes& other)
{
	setColour(other.colour_->clone());
	width_ = other.width_;
	setBorder(other.border_->clone());
} 


bool BoxPlotWhiskerBoxAttributes::accept(const string& node)
{	
	if ( magCompare(node, "whisker_box")  )
		return true;

	if ( acceptNode(node, border_) )
		return true;
	return false;
}

void BoxPlotWhiskerBoxAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "whisker_box") )
		set(node.attributes());
	else {
		setMember(node.name(), border_, node);
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
		setMember((*elt)->name(), border_, *(*elt)); 
	}
}

void BoxPlotWhiskerBoxAttributes::print(ostream& out)  const
{
	out << "BoxPlotWhiskerBoxAttributes[";
	out << "colour = " << *colour_;
	out << ", width = " << width_;
	out << ", border = " << *border_;
	out << "]" << "\n";
}


void BoxPlotWhiskerBoxAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\tboxplot_whisker_box_colour = \'" << *colour_ << "\'\n";
	out << tab << "\tboxplot_whisker_box_width = \'" << width_ << "\'\n";
	out << tab << ">";

 	border_->toxml(out, tabs+1);

	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<string> boxplot_whisker_box_colour("boxplot_whisker_box_colour", "sky", "");
static MagicsParameter<double> boxplot_whisker_box_width("boxplot_whisker_box_width", 0.25, "");
static MagicsParameter<string> boxplot_whisker_box_border("boxplot_whisker_box_border", "on", "");
#include "BoxPlotItem.h"
#include "BoxPlotBasicItem.h"
static SimpleObjectMaker<BoxPlotWhiskerBorder, NoBoxPlotWhiskerBorder> on_BoxPlotWhiskerBorder("on");
static SimpleObjectMaker<BoxPlotWhiskerBorder, NoBoxPlotWhiskerBorder> border_BoxPlotWhiskerBorder("border");
static SimpleObjectMaker<NoBoxPlotWhiskerBorder, NoBoxPlotWhiskerBorder> off_NoBoxPlotWhiskerBorder("off");
static SimpleObjectMaker<NoBoxPlotWhiskerBorder, NoBoxPlotWhiskerBorder> noborder_NoBoxPlotWhiskerBorder("noborder");
