/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file HiLoMarkerAttributes.h
    \brief Definition of HiLoMarker Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Thu Jun 16 12:02:56 2011
*/
   

#ifndef HiLoMarkerAttributes_H
#define HiLoMarkerAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Colour.h"

namespace magics {

class XmlNode;



class HiLoMarkerAttributes 
{
public:
//  --  constructor
    HiLoMarkerAttributes();
    
//  --  destructor
    virtual ~HiLoMarkerAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const HiLoMarkerAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Height of HILO marker symbol 
    \param height Setting contour_hilo_marker_height - default=0.1
*/
	void setHeight(double height) 
		{ height_ =  height; } 
	double getHeight() const 
		{ return height_; } 
        
/*!
    Magics Information:
    \brief  Table number of marker symbol. See chapter on Plotting Attributes 
    \param index Setting contour_hilo_marker_index - default=3
*/
	void setIndex(int index) 
		{ index_ =  index; } 
	int getIndex() const 
		{ return index_; } 
        
/*!
    Magics Information:
    \brief  Colour of grid point markers(Full choice of colours) 
    \param colour Setting contour_hilo_marker_colour - default=red
*/
	void setColour(Colour* colour) 
		{ auto_ptr<Colour> tmp(colour); colour_ = tmp; } 
	const Colour&  getColour() const 
		{ return *colour_; }
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	double height_;
	int index_;
	auto_ptr<Colour> colour_;

private:
  
	friend ostream& operator<<(ostream& s,const HiLoMarkerAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
